package com.mushiny.metage.util;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

/**
 * @version 1.0
 * @author： Gy
 * @date： 2023-02-31 13:53
 */
@Component
public class ServerStart implements CommandLineRunner {

    @Value("${int.server.pordName}")
    private String portName;
    @Value("${int.server.bitRate}")
    private int bitRate;
    @Value("${int.server.dataBits}")
    private int dataBits;
    @Value("${int.server.stopBit}")
    private int stopBit;
    @Value("${int.server.parityBit}")
    private int parityBit;

    @Override
    public void run(String... args) throws Exception {
        RxtxUtils cRead = new RxtxUtils();
        int i = cRead.startComPort(portName,bitRate,dataBits,stopBit,parityBit);
        if (i == 1) {
            cRead.start();
            System.out.println("打开端口");
        } else {
            System.out.println("端口打开失败!");
        }
    }

}
