package com.mushiny.examplecode.tote;

import com.mushiny.totesdk.config.ClientConfig;
import com.mushiny.totesdk.dto.task.ToteCallRep;
import com.mushiny.totesdk.dto.task.ToteCallReq;
import com.mushiny.totesdk.http.ToteSDKClient;
import com.mushiny.totesdk.http.task.ToteAGVTaskActionType;
import com.mushiny.totesdk.http.task.ToteTaskItem;
import com.mushiny.totesdk.listen.ToteAGVArriveStationListener;
import com.mushiny.totesdk.listen.ToteTaskStatusChangeListener;
import com.mushiny.totesdk.listen.message.TaskStatusChangeMessage;
import com.mushiny.totesdk.listen.message.ToteAGVArriveStationMessage;
import com.mushiny.totesdk.station.BinCellIdType;
import com.mushiny.totesdk.station.RollerStation;

import java.util.ArrayList;
import java.util.List;

public class ToteSDKClentSample {


    public static void main(String[] args) {

        // sectionId
        Integer sectionId = 1;
        //RMS服务器IP
        String toteRMSServerIP = "127.0.0.1";
        //RMS服务端口
        Integer port = 8086;
        //RMS接口访问token
        String token = "";

        ClientConfig clientConfig = new ClientConfig(sectionId, toteRMSServerIP, port, token);
        //获取一个client
        ToteSDKClient toteSDKClient = ToteSDKClient.getInstance(clientConfig);
//        createInBoundPutTote(toteSDKClient);
        createInBoundCallAGVTask(toteSDKClient);

    }

    /**
     * 创建 料箱呼叫车到工作站任务
     * @param toteSDKClient
     */
    public static void createInBoundCallAGVTask(ToteSDKClient toteSDKClient){
        ToteCallReq toteCallReq = new ToteCallReq();
        RollerStation rollerStation = new RollerStation();
        rollerStation.setId("76-70");
        rollerStation.setCellId(70);
        rollerStation.setType(BinCellIdType.OUT);
        rollerStation.setBinDepth(1085);
        rollerStation.setDirection(1);
        rollerStation.setBinHeight(512);
        toteCallReq.setWorkStation(rollerStation);

        //注册到站通知
        toteSDKClient.registerArriveStationListener(new ArriveStationListener());
        //注册任务状态改变通知
        toteSDKClient.registerTaskStatusChangeListener(new TaskStatusChangeListener());

        ToteCallRep toteCallRep = toteSDKClient.createInBoundCallAGVTask(toteCallReq.getWorkStation());
        System.out.println("料箱呼叫车到工作站任务，taskId[{" + toteCallRep.getTaskId() + "}]");
    }
    /**
     * 创建 料箱呼叫车到工作站放料箱任务
     * @param toteSDKClient
     */
    public static void createInBoundPutTote(ToteSDKClient toteSDKClient) {
        //注册到站通知
        toteSDKClient.registerArriveStationListener(new ArriveStationListener());
        //注册任务状态改变通知
        toteSDKClient.registerTaskStatusChangeListener(new TaskStatusChangeListener());
        List<ToteTaskItem> toteTaskItems = new ArrayList<>();
        ToteTaskItem toteTaskItem = new ToteTaskItem();
        toteTaskItem.setToteAGVTaskActionType(ToteAGVTaskActionType.PUT);
        toteTaskItem.setBinCode("1AB002RC01R04000");
        toteTaskItems.add(toteTaskItem);
        ToteCallRep toteCallRep = toteSDKClient.createInBoundPutToteTask(toteTaskItems, "1");
        System.out.println("料箱呼叫车到工作站放料箱任务，toteCallRep[{" + toteCallRep + "}]");
    }

}
    class ArriveStationListener implements ToteAGVArriveStationListener {
        @Override
        public void arriveStation(ToteAGVArriveStationMessage arriveStationMessage) {
            System.out.println("收到任务到站通知, TaskId[{"+ arriveStationMessage.getTaskId() + "}]");
        }
}
class TaskStatusChangeListener implements ToteTaskStatusChangeListener {

    @Override
    public void receiveTaskStatusChangeMessage(TaskStatusChangeMessage taskStatusChangeMessage) {
        System.out.println("收到任务状态改变通知, TaskId[{" + taskStatusChangeMessage.getTaskId() + "}]");
    }
}
