/*
 * Copyright (c) 2020 牧星仓库管理系统 All rights reserved.
 *
 * http://www.mushiny.com
 *
 * 版权所有，侵权必究！
 */

package com.mushiny.redisson.utils;
import lombok.Data;

import java.io.Serializable;

/**
 * 响应数据
 *
 * @author Elen elen.shen@mushiny.comn
 * @since 2.1.0
 */
@Data
public class ResultForLock<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 编码：0表示成功，其他值表示失败
	 */
	private int code = 0;

	/**
	 * 消息内容
	 */
	private String msg = "success";

	/**
	 * 响应数据
	 */
	private T data;

	public ResultForLock<T> ok(T data) {
		this.setData(data);
		return this;
	}

	public boolean success() {
		return code == 0;
	}

	public ResultForLock<T> error() {
		this.code = 500;
		this.msg = "error";
		return this;
	}

	public ResultForLock<T> error(int code) {
		this.code = 500;
		this.msg = "error";
		return this;
	}

	public ResultForLock<T> error(int code, String msg) {
		this.code = code;
		this.msg = msg;
		return this;
	}

	public ResultForLock<T> error(String msg) {
		this.code = 500;
		this.msg = "error";
		return this;
	}

}
