package com.mushiny.task.executor.autoconfig;

import com.mushiny.task.executor.core.TaskPoolFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(value = TaskExecutorProperties.class)
public class TaskExecutorAutoConfiguration {

    @Bean("listLoopThreadPool")
    @ConditionalOnMissingBean(name = { "listLoopThreadPool" } )
    public ThreadPoolExecutor listLoopThreadPool(TaskExecutorProperties taskExecutorProperties) {
        TaskPoolConfig pool = taskExecutorProperties.getPool();
        return new ThreadPoolExecutor(pool.getCorePoolSize(), pool.getMaximumPoolSize(), pool.getKeepAliveTime(), pool.getTimeUnit(), new LinkedBlockingQueue<>());
    }

    @Bean
    @ConditionalOnBean(name = { "listLoopThreadPool" })
    public TaskPoolFactory taskPoolFactory () {
        return new TaskPoolFactory();
    }


}
