package com.mushiny.pubTools.controller;

import com.mushiny.pubTools.enums.LockType;
import com.mushiny.pubTools.utils.RedissonLockUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.Date;

@RestController
@Slf4j
public class PingApiForTestContraller {

    @Autowired
    RedissonLockUtil redissonLockUtil;

    @PostMapping("api/ping")
    public int pingApi(@RequestParam String storageBinCode, @RequestParam Long workStationId, @RequestParam Long warehouseId) {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        redissonLockUtil.getLockByKey(storageBinCode + workStationId + warehouseId, LockType.READ_LOCK.value());
        Boolean getLock = redissonLockUtil.tryLock(null,  storageBinCode + workStationId + warehouseId, LockType.REENTRANT_LOCK.value());
        if (getLock) {
            System.out.println(threadId + "拿锁成功");
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
                Date startDate = new Date();
                System.out.println(threadId + "执行调度ping" + dateFormat.format(startDate));
                Thread.sleep(10000);
                System.out.println("结束时间为" + dateFormat.format(new Date()));
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("拿锁失败");
            return  1;
        }
        return  1;
    }

}
