package com.mushiny.task.executor.autoconfig;

import com.mushiny.task.executor.core.TaskPoolFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(value = TaskExecutorProperties.class)
public class TaskExecutorAutoConfiguration {

    @Bean
    public TaskPoolFactory taskPoolFactory (TaskExecutorProperties taskExecutorProperties) {
        TaskPoolConfig pool = taskExecutorProperties.getPool();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(pool.getCorePoolSize(), pool.getMaximumPoolSize(), pool.getKeepAliveTime(), pool.getTimeUnit(), new LinkedBlockingQueue<>());
        return new TaskPoolFactory(threadPoolExecutor);
    }


}
