package com.mushiny.task.executor.core;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TaskTests {

    private int SLEEP_TIME = 100;

    private List<User> list;

    @Before
    public void init() {
        list = new ArrayList<>();
        for (int i = 0; i < 200; i++) {
            list.add(new User(i, "leehyoo" + i));
        }
    }

    @Test
    public void multiTaskLoopNoArgsTest() {
        TaskPoolFactory taskPoolFactory = new TaskPoolFactory();
        TaskExecutor<User, User, String> executor = taskPoolFactory.createExecutor();
        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, list, new User(30, "leehyoo"));

        boolean result = executor.execute();
        Assert.assertTrue(result);

    }


    @Test
    public void multiTaskLoopWithArgsTest() {
        TaskPoolFactory taskPoolFactory = new TaskPoolFactory();
        TaskExecutor<User, User, String> executor = taskPoolFactory.createExecutor(60L, TimeUnit.SECONDS);

        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, list, new User(30, "leehyoo"));

        boolean result = executor.execute();
        Assert.assertTrue(result);

    }



    @Test
    public void failCaseTest() {
        TaskPoolFactory taskPoolFactory = new TaskPoolFactory();
        TaskExecutor<User, User, String> executor = taskPoolFactory.createExecutor();

        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            context.getAge();
            return "success";
        }, list, null);

        boolean result = executor.execute();
        Assert.assertFalse(result);
    }


    @Test
    public void errorRecordCallbackTest() {
        TaskPoolFactory taskPoolFactory = new TaskPoolFactory();
        TaskExecutor<User, User, String> executor = taskPoolFactory.createExecutor();
        List<User> errors = Collections.synchronizedList(new ArrayList<>());
        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            context.getAge();
            return "success";
        }, list, null, errors::add);

        boolean result = executor.execute();
        System.out.println("========= start ===========");
        errors.forEach(System.out::println);
        System.out.println("=========  end  ===========");
        Assert.assertFalse(result);

    }

    @Test
    public void normalLoopTest() {
        User context = new User(30, "leehyoo");
        list.forEach(data -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        });

    }
}
