package com.mushiny.task.executor.core;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author lihao
 */
public class TaskPoolFactory {

    private ThreadPoolExecutor threadPoolExecutor;
    
    public TaskPoolFactory() {
        int core = Runtime.getRuntime().availableProcessors();
        int poolSize = Math.min(core / 2, 4);
        this.threadPoolExecutor = new ThreadPoolExecutor(poolSize, poolSize + 1, 0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>());
    }

    public TaskPoolFactory(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public <T, U, R> TaskExecutor<T, U, R> createExecutor() {
        return createExecutor(15L, TimeUnit.SECONDS);
    }

    public <T, U, R> TaskExecutor<T, U, R> createExecutor(Long timeOut, TimeUnit timeUnit) {
        return new TaskExecutor<>(this.threadPoolExecutor, timeOut, timeUnit);
    }
}
