package com.mushiny.redisson.controller;

import com.mushiny.redisson.enums.LockType;
import com.mushiny.redisson.utils.RedissonLockUtil;
import com.mushiny.redisson.utils.ResultForLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 描述信息
 *
 * @auther lxy
 * @since 2023/8/10 13:03
 */
@RestController
public class TestController {
    @Autowired
    RedissonLockUtil redissonLockUtil;

    @Autowired
    JdbcTemplate jdbcTemplate;

    public int count = 0;

    @PostMapping ("api/ping")
    public ResultForLock<String> contextLoads() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        redissonLockUtil.getLockByKey("265213225444411", LockType.REENTRANT_LOCK.value());
        Boolean getLock = redissonLockUtil.tryLock(50000L, "265213225444411", LockType.REENTRANT_LOCK.value());
        if (getLock) {
            System.out.println(threadId + "拿锁成功");
            try {
                count++;
                jdbcTemplate.execute("UPDATE descrease a SET a.number =  a.number-1");
//                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
//                Date startDate = new Date();
//                System.out.println(threadId + "执行调度ping" + dateFormat.format(startDate));
                Thread.sleep(2000);
//                System.out.println("结束时间为" + dateFormat.format(new Date()));
                System.out.println("执行数量为"+count);
            } catch (Exception e) {
                e.printStackTrace();
                return  new ResultForLock().error();
            }finally {
                redissonLockUtil.releaseLock("265213225444411", LockType.REENTRANT_LOCK.value());
            }
        } else {
            System.out.println("拿锁失败");
        }
        return  new ResultForLock().ok(threadId);
    }
}
