/**
 * Copyright (c) 2019 人人开源 All rights reserved.
 * <p>
 * https://www.renren.io
 * <p>
 * 版权所有，侵权必究！
 */

package com.mushiny.pubTools.enums;

/**
 * 行政区域  级别枚举
 *
 * @author Elen elen.shen@mushiny.comn
 * @since 2.1.0
 */
public enum LockType {

	 /**
	 * 重入锁
	 */
	REENTRANT_LOCK(1),
	/**
	 * 公平锁
	 */
	FAIR_LOCK(2),
	/**
	 * 红锁
	 */
	READ_LOCK(3),
	/**
	 * 读写锁
	 */
	WRITE_LOCK(4);

	private final int value;

	LockType(Integer value) {
		this.value = value;
	}

	public Integer value() {
		return this.value;
	}
}
