# 项目介绍
多线程处理列表逻辑

# 使用方式
1. 获取任务执行实例

    ```java 
        TaskExecutor<User, User, String> executor = TaskPoolFactory.createExecutor();
    ```
   
2. 初始化执行器
    ```java
    executor.init(
        (data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, // 需要处理的业务逻辑
        list, // 需要处理的业务数据列表
        new User(30, "leehyoo") // 其他公用查询参数
        );
    ```
3. 获取查询结果
    ```java
     boolean result = executor.execute();
    ```

# 注意事项
1. 没有事务处理
2. 尽量避免在循环中查询数据库
3. context内容建议不要修改，只作为逻辑判断、查询等使用
4. 尽量使用自定义的线程池