package com.mushiny.task.executor.core;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author lihao
 */
public class TaskPoolFactory {
    public TaskPoolFactory() {
        // ignore
    }

    public <T, U, R> TaskExecutor<T, U, R> createExecutor() {
        int core = Runtime.getRuntime().availableProcessors();
        int poolSize = Math.min(core / 2, 4);
        return createExecutor(new ThreadPoolExecutor(poolSize, poolSize + 1, 0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>()), 15L, TimeUnit.SECONDS);
    }

    public <T, U, R> TaskExecutor<T, U, R> createExecutor(ThreadPoolExecutor pool) {
        return createExecutor(pool, 15L, TimeUnit.SECONDS);
    }

    public <T, U, R> TaskExecutor<T, U, R> createExecutor(ThreadPoolExecutor pool, Long timeOut, TimeUnit timeUnit) {
        return new TaskExecutor<>(pool, timeOut, timeUnit);
    }
}
