package com.mushiny.task;

import java.util.Collection;
import java.util.function.BiFunction;

/**
 * @author lihao
 */
public class TaskDefinition<T, U, R> {

    /**
     * 处理的业务数据
     */
    private Collection<T> data;

    /**
     * 业务逻辑
     */
    private BiFunction<T, U, R> handler;

    /**
     * 共有变量，推荐只用于查询，不推荐更新数据
     */
    private final U context;

    public TaskDefinition(Collection<T> data, BiFunction<T, U, R> handler, U context) {
        this.data = data;
        this.handler = handler;
        this.context = context;
    }

    public Collection<T> getData() {
        return data;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    public BiFunction<T, U, R> getHandler() {
        return handler;
    }

    public void setHandler(BiFunction<T, U, R> handler) {
        this.handler = handler;
    }

    public U getContext() {
        return context;
    }
}
