package com.mushiny.task;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskTests {

    private int SLEEP_TIME = 1000;

    private List<User> list;

    @Before
    public void init() {
        list = new ArrayList<>();
        for (int i = 0; i < 20; i++) {
            list.add(new User(i, "leehyoo" + i));
        }
    }

    @Test
    public void multiTaskLoopNoArgsTest() {
        TaskExecutor<User, User, String> executor = TaskPoolFactory.createExecutor();
        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, list, new User(30, "leehyoo"));

        boolean result = executor.execute();
        Assert.assertTrue(result);

    }

    @Test
    public void normalLoopTest() {
        User context = new User(30, "leehyoo");
        list.forEach(data -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        });


    }


    @Test
    public void multiTaskLoopWithArgsTest() {
        TaskExecutor<User, User, String> executor = TaskPoolFactory.createExecutor(new ThreadPoolExecutor(5, 6,
                0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<>()));

        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, list, new User(30, "leehyoo"));

        boolean result = executor.execute();
        Assert.assertTrue(result);

    }



    @Test
    public void failCaseTest() {
        TaskExecutor<User, User, String> executor = TaskPoolFactory.createExecutor();

        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            context.getAge();
            return "success";
        }, list, null);

        boolean result = executor.execute();
        Assert.assertFalse(result);
    }


    @Test
    public void errorRecordCallbackTest() {
        TaskExecutor<User, User, String> executor = TaskPoolFactory.createExecutor();
        List<User> errors = new ArrayList<>();
        executor.init((data, context) -> {
            data.setName(data.getName() + "handle");
            try {
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            context.getAge();
            return "success";
        }, list, null, errors::add);

        boolean result = executor.execute();
        System.out.println("========= start ===========");
        errors.forEach(System.out::println);
        System.out.println("=========  end  ===========");
        Assert.assertFalse(result);

    }
}
