package com.mushiny.redisson.config;

import com.mushiny.redisson.utils.RedissonLockUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(value = RedissonProperties.class)
public class RedissonAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(RedissonClient.class)
    public RedissonClient redissonClient(RedissonProperties redissonProperties) {
        Config config = new Config();
        //调用 useSingleServer 方法，选择单机模式，并指定 Redis 服务器的地址
        config.useSingleServer().setAddress("redis://" + redissonProperties.getHost() + ":" + redissonProperties.getPort()).setPassword(redissonProperties.getPassword());
        //调用 setConnectionMinimumIdleSize 方法，设置连接池最小空闲连接数为 10。
        config.useSingleServer().setConnectionMinimumIdleSize(10);
        //调用 Redisson.create 方法，创建一个 RedissonClient 对象
        RedissonClient redissonClient = Redisson.create(config);
        return redissonClient;
    }

    @Bean
    public RedissonLockUtil redissonLockUtil(RedissonClient client) {
        if (ObjectUtils.isEmpty(client)) {
            throw new RuntimeException();
        }
        return new RedissonLockUtil(client);
    }

}
