package pubtools;

import com.mushiny.pubtools.enums.LockType;
import com.mushiny.pubtools.utils.RedissonLockUtil;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.text.SimpleDateFormat;
import java.util.Date;

@SpringBootTest
class MwmsRedissonApplicationTests {

    @Autowired
    RedissonLockUtil redissonLockUtil;

    @Test
    void contextLoads() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        redissonLockUtil.getLockByKey("2652132254444", LockType.READ_LOCK.value());
        Boolean getLock = redissonLockUtil.tryLock(null,  "2652132254444", LockType.REENTRANT_LOCK.value());
        if (getLock) {
            System.out.println(threadId + "拿锁成功");
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
                Date startDate = new Date();
                System.out.println(threadId + "执行调度ping" + dateFormat.format(startDate));
                Thread.sleep(10000);
                System.out.println("结束时间为" + dateFormat.format(new Date()));
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("拿锁失败");
        }
    }

}
