/*
 * Copyright (c) 2020 牧星仓库管理系统 All rights reserved.
 *
 * http://www.mushiny.com
 *
 * 版权所有，侵权必究！
 */

package com.mushiny.pubtools.annotation;

import com.mushiny.pubtools.enums.LockType;

import java.lang.annotation.*;
import java.util.concurrent.TimeUnit;

/**
 * 操作分布式锁
 *
 * @author
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RedissonLock {
    /** 锁类型*/
    LockType lockType() default LockType.FAIR_LOCK;

    /** 获取锁等待时间，默认12秒*/
    long waitTime() default 12000L;

    /** 锁自动释放时间，默认10秒*/
    long leaseTime() default 10000L;

    /** 时间单位（获取锁等待时间和持锁时间都用此单位）*/
    TimeUnit unit() default TimeUnit.MILLISECONDS;

}