package com.mushiny.task;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;

/**
 * @author lihao
 */
public class TaskDefinition<T, U, R> {

    /**
     * 处理的业务数据
     */
    private Collection<T> data;

    /**
     * 业务逻辑
     */
    private BiFunction<T, U, R> handler;

    private Consumer<T> exceptionHandler;

    /**
     * 共有变量，推荐只用于查询，不推荐更新数据
     */
    private final U context;

    public TaskDefinition(Collection<T> data, BiFunction<T, U, R> handler, U context) {
        this.data = data;
        this.handler = handler;
        this.context = context;
    }

    public TaskDefinition(Collection<T> data, BiFunction<T, U, R> handler, U context, Consumer<T> exceptionHandler) {
        this.data = data;
        this.handler = handler;
        this.exceptionHandler = exceptionHandler;
        this.context = context;
    }

    public Collection<T> getData() {
        return data;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    public BiFunction<T, U, R> getHandler() {
        return handler;
    }

    public void setHandler(BiFunction<T, U, R> handler) {
        this.handler = handler;
    }

    public U getContext() {
        return context;
    }

    public Consumer<T> getExceptionHandler() {
        return exceptionHandler;
    }

    public void setExceptionHandler(Consumer<T> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}
