package com.mushiny.redisson.controller;

import com.mushiny.redisson.enums.LockType;
import com.mushiny.redisson.utils.RedissonLockUtil;
import com.mushiny.redisson.utils.ResultForLock;
import jodd.net.HttpStatus;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 描述信息
 *
 * @auther lxy
 * @since 2023/8/10 13:03
 */
@RestController
public class TestController {
    @Autowired
    RedissonLockUtil redissonLockUtil;

    @Autowired
    JdbcTemplate jdbcTemplate;

    public int count = 0;

    public int errCount = 0;

    @PostMapping ("api/reentrant")
    public  ResultForLock<String> reentrant(HttpServletResponse response) {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        redissonLockUtil.getLockByKey("265213225444411", LockType.REENTRANT_LOCK.value());
        Boolean getLock = redissonLockUtil.tryLock(50000L, "265213225444411", LockType.REENTRANT_LOCK.value());
        if (getLock) {
            System.out.println(threadId + "拿锁成功");
            try {
                count++;
                jdbcTemplate.execute("UPDATE descrease a SET a.number =  a.number-1");
//                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
//                Date startDate = new Date();
//                System.out.println(threadId + "执行调度ping" + dateFormat.format(startDate));
                Thread.sleep(2000);
//                System.out.println("结束时间为" + dateFormat.format(new Date()));
                System.out.println("执行数量为"+count);
            } catch (Exception e) {
                e.printStackTrace();
                return  new ResultForLock().error();
            }finally {
                redissonLockUtil.releaseLock("265213225444411", LockType.REENTRANT_LOCK.value());
            }
        } else {
            errCount++;
            System.out.println("拿锁失败"+errCount);
            response.setStatus(500);
            return  new ResultForLock().error();
        }
        return  new ResultForLock().ok(threadId);
    }



    @PostMapping ("api/reentrantWatchDog")
    public ResultForLock<String> reentrantWatchDog(HttpServletResponse response) {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        redissonLockUtil.getLockByKey("265213225444411", LockType.REENTRANT_LOCK.value());
        Boolean getLock = redissonLockUtil.tryLock(1000L,-1L, "265213225444411", LockType.REENTRANT_LOCK.value());
        if (getLock) {
            System.out.println(threadId + "拿锁成功");
            try {
                count++;
                jdbcTemplate.execute("UPDATE descrease a SET a.number =  a.number-1");
//                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
//                Date startDate = new Date();
//                System.out.println(threadId + "执行调度ping" + dateFormat.format(startDate));
                Thread.sleep(2000);
//                System.out.println("结束时间为" + dateFormat.format(new Date()));
                System.out.println("执行数量为"+count);
            } catch (Exception e) {
                e.printStackTrace();
                return  new ResultForLock().error();
            }finally {
                redissonLockUtil.releaseLock("265213225444411", LockType.REENTRANT_LOCK.value());
            }
        } else {
            System.out.println("拿锁失败");
            response.setStatus(500);
            return  new ResultForLock().error();
        }
        return  new ResultForLock().ok(threadId);
    }


    /**
     * 手动加锁和解锁，最常用的方式
     * @return
     */
    @PostMapping ("api/reentrantByManual")
    public ResultForLock<String> reentrantByManual() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        RLock rLock =redissonLockUtil.getLockByKey("265213225444411", LockType.REENTRANT_LOCK.value());
        // 支持过期解锁功能,10秒钟以后自动解锁, 无需调用unlock方法手动解锁
        //lock.lock(10, TimeUnit.SECONDS);
        rLock.lock();//     * 加锁 锁的有效期默认30秒
            try {
                count++;
                jdbcTemplate.execute("UPDATE descrease a SET a.number =  a.number-1");
                Thread.sleep(2000);
                System.out.println("执行数量为"+count);
            } catch (Exception e) {
                e.printStackTrace();
                return  new ResultForLock().error();
            }finally {
                rLock.unlock();
            }
        return  new ResultForLock().ok(threadId);
    }

    /**
     * 使用公平锁，先请求的线程先拿到锁
     * @return
     */
    @PostMapping ("api/fair")
    public ResultForLock<String> fair() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        redissonLockUtil.getLockByKey("265213225444411", LockType.FAIR_LOCK.value());
        Boolean getLock = redissonLockUtil.tryLock(50000L, "265213225444411", LockType.FAIR_LOCK.value());
        if (getLock) {
            System.out.println(threadId + "拿锁成功");
            try {
                count++;
                jdbcTemplate.execute("UPDATE descrease a SET a.number =  a.number-1");
                Thread.sleep(2000);
                System.out.println("执行数量为"+count);
            } catch (Exception e) {
                e.printStackTrace();
                return  new ResultForLock().error();
            }finally {
                redissonLockUtil.releaseLock("265213225444411", LockType.REENTRANT_LOCK.value());
            }
        } else {
            System.out.println("拿锁失败");
            return  new ResultForLock().error();
        }
        return  new ResultForLock().ok(threadId);
    }
}
