package com.mushiny.task;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author lihao
 */
public class TaskPoolFactory {
    TaskPoolFactory() {
        // ignore
    }

    public static <T, U, R> TaskExecutor<T, U, R> createExecutor() {
        return createExecutor(new ThreadPoolExecutor(2, 3, 0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>()), 15L, TimeUnit.SECONDS);
    }

    public static <T, U, R> TaskExecutor<T, U, R> createExecutor(ThreadPoolExecutor pool) {
        return createExecutor(pool, 15L, TimeUnit.SECONDS);
    }

    public static <T, U, R> TaskExecutor<T, U, R> createExecutor(ThreadPoolExecutor pool, Long timeOut, TimeUnit timeUnit) {
        return new TaskExecutor<>(pool, timeOut, timeUnit);
    }
}
