package com.mushiny.task.executor.autoconfig;

import com.alibaba.cloud.nacos.NacosConfigAutoConfiguration;
import com.mushiny.task.executor.core.TaskPoolFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.ThreadPoolExecutor;

@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(value = TaskExecutorProperties.class)
@AutoConfigureAfter(NacosConfigAutoConfiguration.class)
public class TaskExecutorAutoConfiguration {



    @ConditionalOnMissingBean
    public ThreadPoolExecutor listLoopThreadPool() {
        return null;
    }


    @ConditionalOnBean(name={"listLoopThreadPool"})
    public TaskPoolFactory taskPoolFactory () {
        return new TaskPoolFactory();
    }


}
