package com.mushiny.task;

import org.junit.Before;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskTests {


    private List<User> list;

    @Before
    public void init() {
        list = new ArrayList<>();
        for (int i = 0; i < 20; i++) {
            list.add(new User(i, "leehyoo" + i));
        }
    }

    @Test
    public void multiTaskLoopNoArgsTest() {
        long startTime = System.currentTimeMillis();
        TaskExecutor<User, User, String> executor = TaskPoolFactory.createExecutor();

        TaskDefinition<User, User, String> taskDefinition = new TaskDefinition<>(list, (data, context) -> {
            System.out.println("enter bi func, current Thread:" + Thread.currentThread());
            System.out.println(data);
            data.setName(data.getName() + "handle");
            System.out.println(context);
            System.out.println("exit bi func");
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, new User(30, "leehyoo"));

        executor.init((data, context) -> {
            System.out.println("enter bi func, current Thread:" + Thread.currentThread());
            System.out.println(data);
            data.setName(data.getName() + "handle");
            System.out.println(context);
            System.out.println("exit bi func");
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, list, new User(30, "leehyoo"));

        executor.execute();

        System.out.println("finally over. cost: " + (System.currentTimeMillis() - startTime));

    }

    @Test
    public void normalLoopTest() {
        long startTime = System.currentTimeMillis();
        User context = new User(30, "leehyoo");
        list.forEach(data -> {
            System.out.println("enter bi func, current Thread:" + Thread.currentThread());
            System.out.println(data);
            data.setName(data.getName() + "handle");
            System.out.println(context);
            System.out.println("exit bi func");
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        });

        System.out.println("finally over. cost: " + (System.currentTimeMillis() - startTime));

    }


    @Test
    public void multiTaskLoopWithArgsTest() {
        long startTime = System.currentTimeMillis();
        TaskExecutor<User, User, String> executor = TaskPoolFactory.createExecutor(new ThreadPoolExecutor(4, 4,
                0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<>()));

        TaskDefinition<User, User, String> taskDefinition = new TaskDefinition<>(list, (data, context) -> {
            System.out.println("enter bi func, current Thread:" + Thread.currentThread());
            System.out.println(data);
            data.setName(data.getName() + "handle");
            System.out.println(context);
            System.out.println("exit bi func");
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, new User(30, "leehyoo"));

        executor.init((data, context) -> {
            System.out.println("enter bi func, current Thread:" + Thread.currentThread());
            System.out.println(data);
            data.setName(data.getName() + "handle");
            System.out.println(context);
            System.out.println("exit bi func");
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "success";
        }, list, new User(30, "leehyoo"));

        executor.execute();

        System.out.println("finally over. cost: " + (System.currentTimeMillis() - startTime));

    }
}
