package com.mushiny.redisson.config;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 描述信息
 *
 * @auther lxy
 * @since 2023/8/4 13:39
 */
@Configuration
public class RedissonManager {

    @Value("${spring.redis.host:192.168.3.104}")
    private String addresses;

    @Value("${spring.redis.password:q1w2e3r4}")
    private String password;

    @Value("${spring.redis.port:6379}")
    private String port;

    @Bean(destroyMethod = "shutdown")
    public RedissonClient redissonClient() {
        Config config = new Config();
        //调用 useSingleServer 方法，选择单机模式，并指定 Redis 服务器的地址
        config.useSingleServer().setAddress("redis://" + addresses + ":" + port).setPassword(password);
        System.out.println("redis://" + addresses + ":" + port);
        //调用 setConnectionMinimumIdleSize 方法，设置连接池最小空闲连接数为 10。
        config.useSingleServer().setConnectionMinimumIdleSize(10);
        //调用 Redisson.create 方法，创建一个 RedissonClient 对象
        RedissonClient redissonClient = Redisson.create(config);
        return redissonClient;
    }

}
