/*
 Navicat MySQL Data Transfer

 Source Server         : heli
 Source Server Type    : MySQL
 Source Server Version : 50727
 Source Host           : 182.168.100.122:3306
 Source Schema         : wms_heli

 Target Server Type    : MySQL
 Target Server Version : 50727
 File Encoding         : 65001

 Date: 15/01/2020 17:19:36
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for AD_ANDONMASTER
-- ----------------------------
DROP TABLE IF EXISTS `AD_ANDONMASTER`;
CREATE TABLE `AD_ANDONMASTER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '问题容器',
  `PROBLEM_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题名称(扫描枪)',
  `PROBLEM_DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题描述',
  `REPORT_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '报告人',
  `REPORT_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '报告时间',
  `ANDONMASTERTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题类型',
  `ANDONMASTERTYPESOLVE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '解决问题类型方式',
  `SOLVE_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '解决人',
  `SOLVE_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '解决时间',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理状态',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ANDONMASTER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ANDONMASTER_ANDONMASTERTYPE_ID_FK`(`ANDONMASTERTYPE_ID`) USING BTREE,
  INDEX `ANDONMASTER_ANDONMASTERTYPESOLVE_ID_FK`(`ANDONMASTERTYPESOLVE_ID`) USING BTREE,
  INDEX `ANDONMASTER_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  CONSTRAINT `ANDONMASTER_ANDONMASTERTYPESOLVE_ID_FK` FOREIGN KEY (`ANDONMASTERTYPESOLVE_ID`) REFERENCES `AD_ANDONMASTERTYPESOLVE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONMASTER_ANDONMASTERTYPE_ID_FK` FOREIGN KEY (`ANDONMASTERTYPE_ID`) REFERENCES `AD_ANDONMASTERTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONMASTER_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONMASTER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用于报告暗灯和解决暗灯' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for AD_ANDONMASTERTYPE
-- ----------------------------
DROP TABLE IF EXISTS `AD_ANDONMASTERTYPE`;
CREATE TABLE `AD_ANDONMASTERTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ANDONMASTERTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `ANDONMASTERTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ANDONMASTERTYPE_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  CONSTRAINT `ANDONMASTERTYPE_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONMASTERTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '暗灯的类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of AD_ANDONMASTERTYPE
-- ----------------------------
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('022d5d30-f296-11e6-8e32-0242ac110014', '2017-02-14 09:14:37', 'ADMIN', '2017-02-14 09:14:37', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_SKU_HAS_DAMAGE', '货位存在残品', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('1e4ae399-f296-11e6-8e32-0242ac110014', '2017-02-14 09:15:24', 'ADMIN', '2017-02-14 09:15:24', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_SKU_CANT_SCAN', '货位存在条码无法扫描商品', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('56da8b01-f296-11e6-8e32-0242ac110014', '2017-02-14 09:16:59', 'ADMIN', '2017-02-14 09:16:59', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_SKU_SET_WRONG', '套装组套错误', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('5901d872-f295-11e6-8e32-0242ac110014', '2017-02-14 09:09:53', 'ADMIN', '2017-02-14 09:09:53', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_CANT_SCAN', '货位条码无法扫描', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('629c270b-f296-11e6-8e32-0242ac110014', '2017-02-14 09:17:19', 'ADMIN', '2017-02-14 09:17:19', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_SKU_SUIT_INCOMPLETE', '套装被拆/不全', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('8991586f-f296-11e6-8e32-0242ac110014', '2017-02-14 09:18:24', 'ADMIN', '2017-02-14 09:18:24', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_SKU_SIMILAR', '相似商品在相同货位', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('899866de-f296-11e6-8e32-0242ac110014', '2017-02-14 09:18:24', 'ADMIN', '2017-02-14 09:18:24', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_SKU_TOO_FULL', '货位商品太满', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('a7f3516a-f296-11e6-8e32-0242ac110014', '2017-02-14 09:19:15', 'ADMIN', '2017-02-14 09:19:15', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_HIDDEN_DANGER', '货位存在安全隐患', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('a7fba85f-f296-11e6-8e32-0242ac110014', '2017-02-14 09:19:15', 'ADMIN', '2017-02-14 09:19:15', 'ADMIN', '-', 0, 0, 'ANDON_MENU_BIN_NEED_INSPECT', '货位需要检查', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('c7ec5a09-f296-11e6-8e32-0242ac110014', '2017-02-14 09:20:09', 'ADMIN', '2017-02-14 09:20:09', 'ADMIN', '-', 0, 0, 'ANDON_MENU_SCANNER_UNUSUAL', '扫描枪存在问题', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('c7f46642-f296-11e6-8e32-1242ac110015', '2017-02-14 09:20:09', 'ADMIN', '2017-02-14 09:20:09', 'ADMIN', '-', 2, 0, 'ANDON_MENU_BIN_SKU_LOSS', '商品丢失', 'SYSTEM', 'DEFAULT');
INSERT INTO `AD_ANDONMASTERTYPE` VALUES ('eddd48ac-fd7d-11e6-8e32-1242ac110015', '2017-02-28 06:19:31', 'ADMIN', '2017-02-28 06:19:31', 'ADMIN', '-', 2, 0, 'ANDON_MENU_BIN_SKU_NEED_VALID_DATE', '商品需要录入有效期', 'SYSTEM', 'DEFAULT');

-- ----------------------------
-- Table structure for AD_ANDONMASTERTYPESOLVE
-- ----------------------------
DROP TABLE IF EXISTS `AD_ANDONMASTERTYPESOLVE`;
CREATE TABLE `AD_ANDONMASTERTYPESOLVE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `ANDONMASTERTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题类型',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `INDEX` int(11) NULL DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ANDONMASTERTYPESOLVE_ANDONMASTERTYPE_ID_FK`(`ANDONMASTERTYPE_ID`) USING BTREE,
  INDEX `AD_ANDONMASTERTYPESOLVE_ibfk_2`(`CLIENT_ID`) USING BTREE,
  INDEX `AD_ANDONMASTERTYPESOLVE_ibfk_3`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `AD_ANDONMASTERTYPESOLVE_ibfk_1` FOREIGN KEY (`ANDONMASTERTYPE_ID`) REFERENCES `AD_ANDONMASTERTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `AD_ANDONMASTERTYPESOLVE_ibfk_2` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `AD_ANDONMASTERTYPESOLVE_ibfk_3` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of AD_ANDONMASTERTYPESOLVE
-- ----------------------------
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('3ETNTKPK-IWKG-JY3Y-EMA2-HNDCSPYTYGAZ', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', '899866de-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('629c270b-f296-11e6-8e32-0242ac110016', '2017-04-28 15:22:57', 'admin', '2017-04-28 15:23:09', 'admin', NULL, 0, 0, 'ANDON_SOLVE_DAMAGE', '已报残处理', '56da8b01-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 3);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('6SJXNWTP-MX8W-33SQ-IEZG-QFX26RYSPAXZ', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_BIN_PROBLEM_PRINT', '货位条码打印问题-已补打', '5901d872-f295-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 4);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('A8IWRZIZ-NDPJ-EYXI-HDMC-HW7HSHCFN84N', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', 'a7f3516a-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('ATNHBS8W-E5IS-BFXX-HAJM-KA3PPXB8YBCS', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', 'a7fba85f-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('B5EKRSKX-HY5Y-NNMQ-JCAR-AYFTNAMMXDGK', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', '56da8b01-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('BEHS6ZHR-DDKM-SFCB-8WKY-FBIPWCMBRCSZ', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', 'a7fba85f-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('BP82443N-ARDJ-K8TC-T2CJ-WE7P5FWBYDNN', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', '629c270b-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('BXD4NKCK-6DCZ-KSPB-XZBA-D6A6NDNCQYXP', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', 'c7ec5a09-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('CBXDJ7ET-AAF8-H4ZT-FMN4-IB47RJDC8TZJ', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_SUIT_DAMAGE', '套装不全已报残处理', '629c270b-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 2);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('CGA33EX2-2QKK-ZSBR-FFKT-63HYMNT7Y5WE', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_DAMAGE_PRODUCT', '已处理残品', '022d5d30-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 3);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('CWTRC2IR-FPBN-S8PK-DWXK-4MWICAZWYNGF', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', '022d5d30-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('DN6YRFSF-HZBW-CXKR-JBBK-PNDTHY2S4J6A', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_CHECK_BIN_NORMAL', '已检查完毕货位并无任何问题', 'a7fba85f-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 3);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('DYRANJH2-H7MG-ZZKY-TFPK-CFJ3GCJJPPWF', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', '8991586f-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('E6ZX2ZJ2-Y2XX-2BWR-DPTD-SEGWHTKJABYZ', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', '1e4ae399-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('EEKAA7KE-JAPJ-RGN3-IKWJ-ZWBEQCPQC5TT', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_TRANSFER_PRODUCT', '已将相似商品转移', '8991586f-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 3);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('EZNGCKWW-28AX-TNDT-PCHM-CXE2MRA4CR8D', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', '022d5d30-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('FWKNW6NC-M268-6HHP-XED6-YRMD5D7PZTWK', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', '1e4ae399-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('H7EESNBD-6WZP-SHXC-JWFC-NK5EGH8GBFDR', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_BIN_DAMAGE_PRINT', '货位条码外力破损-已补打', '5901d872-f295-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 4);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('HRM8CETH-W6FR-62RX-ZFSD-QRNFI6Y5DE6F', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_SOLVED', '已处理', '899866de-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 3);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('K7FKK7M3-IAX3-RXJZ-WHAN-KRRA7AR7CF4J', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_CHECK_BIN_SOLVED', '已检查完毕货位数量错误已处理', 'a7fba85f-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 3);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('MPPZKAP5-2ZNQ-DJAP-NMFR-DCIWCMIGMKD2', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_CONFIRM_DANGER', '已确认隐患并处理完毕', 'a7f3516a-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 3);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('MQRJWXXA-XJJJ-3RGH-8PQH-YKXFRXHHCQ2N', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', '5901d872-f295-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('N5462NTM-HYKP-EJZ2-Y3CH-NHKHEF6NCZKY', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', '56da8b01-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('PBBZKBXF-SMRT-E8JJ-GZT7-HA7FAXEDWMBH', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', '8991586f-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('PJJCHHSB-JNET-PXDM-ITHM-3GMXFYGW3W2E', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', 'a7f3516a-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('PRQDCETB-RWNK-TE5E-7BJN-67QZSZSG6ECE', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_SUIT_PICK', '套装被拆已重新包装', '629c270b-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 2);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('R3B8JBT5-Q4MY-FXXS-B8ZG-YBYY3ADDFDES', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_CONFIRM_PROBLEM', '确认问题已处理', 'c7ec5a09-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 4);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('R4MWE43A-WBDN-JK7P-IS4J-B3EMND47YBF6', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', 'c7ec5a09-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('T7XQHBPG-X7DH-EJ6J4-BWH-ISTA4R7ZT6NR', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_REPORT_ERROR', '员工上报错误', '5901d872-f295-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 1);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('XAJCFMT2-SZTT-DAE2-YGBK-MMRC2EEZG6EG', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_PROBLEM_OBSERVED', '短暂异常待观察', 'c7ec5a09-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 4);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('XW3A4M8M-HDHE-E57K-TSMN-AFD4YRQ7F3BF', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', '899866de-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('YZFZJW3T-6BAI-Z74P-RPKD-8HNF4XTGM84P', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_OTHER', '其他', '629c270b-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 0);
INSERT INTO `AD_ANDONMASTERTYPESOLVE` VALUES ('ZSDMIAPY-B8XA-SHZP-T88E-2BCYMGA6TAFJ', '2017-05-02 10:04:23', 'admin', '2017-05-02 10:04:31', 'admin', NULL, 0, 0, 'ANDON_SOLVE_PRINT_SKU', '已补打条码', '1e4ae399-f296-11e6-8e32-0242ac110014', 'SYSTEM', 'DEFAULT', 4);

-- ----------------------------
-- Table structure for AD_ANDONSTATION
-- ----------------------------
DROP TABLE IF EXISTS `AD_ANDONSTATION`;
CREATE TABLE `AD_ANDONSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ANDONSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `ANDONSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ANDONSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `ANDONSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `ANDONSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `ANDONSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `AD_ANDONSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'ANDON问题处理工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for AD_ANDONSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `AD_ANDONSTATIONPOSITION`;
CREATE TABLE `AD_ANDONSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ANDONSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `ANDONSTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `ANDONSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `ANDONSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `AD_ANDONSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'ANDON问题处理工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for AD_ANDONSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `AD_ANDONSTATIONTYPE`;
CREATE TABLE `AD_ANDONSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ANDONSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `ANDONSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `ANDONSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'ANDON问题处理工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for AD_ANDONSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `AD_ANDONSTATIONTYPEPOSITION`;
CREATE TABLE `AD_ANDONSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ANDONSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ANDONSTATIONTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `ANDONSTATIONTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `AD_ANDONSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'ANDON问题处理工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for CON_CONSOLIDATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `CON_CONSOLIDATIONTYPE`;
CREATE TABLE `CON_CONSOLIDATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '理货类型名',
  `CONSOLIDATION_WAY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '理货方式',
  `INDEX` int(11) NULL DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of CON_CONSOLIDATIONTYPE
-- ----------------------------
INSERT INTO `CON_CONSOLIDATIONTYPE` VALUES ('1', 'QUICK_SALES_ARRANGEMENT', 'QuickSalesArrangement', 1, '快销品整理', '2018-09-19 09:21:13', 'admin', '2018-09-17 14:08:07', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPE` VALUES ('2', 'UNABLE_SALES_ARRANGEMENT', 'UnableSalesArrangement', 2, '滞销品整理', '2018-09-19 09:21:17', 'admin', '2018-09-17 14:11:10', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPE` VALUES ('3', 'ARRANGEMENT_BY_BIN', 'ArrangementByBin', 3, '按照货位整理', '2018-09-19 09:21:19', 'admin', '2018-09-17 14:15:16', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPE` VALUES ('4', 'ARRANGEMENT_BY_SKU', 'ArrangementBySku', 4, '按照sku整理', '2018-09-19 09:21:22', 'admin', '2018-09-17 14:16:27', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPE` VALUES ('5', 'ARRANGEMENT_BY_SKU_AND_BIN', 'ArrangementBySkuAndBin', 5, '指定sku和货位整理', '2018-09-19 09:21:27', 'admin', '2018-09-17 14:17:52', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPE` VALUES ('6', 'ARRANGEMENT_BY_SIZE_AND_WEIGHT', 'ArrangementBySizeAndWeight', 6, '按照商品尺寸和重量整理', '2018-09-19 09:21:33', 'admin', '2018-09-17 14:19:24', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPE` VALUES ('7', 'SAME_SKU_ARRANGEMENT', 'SameSkuArrangement', 7, '相同sku整理', '2018-09-19 09:21:37', 'admin', '2018-09-17 14:20:29', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for CON_CONSOLIDATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `CON_CONSOLIDATIONTYPEPOSITION`;
CREATE TABLE `CON_CONSOLIDATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'CON_表CONSOLIDATION_RULEKEY中的RULE_KEY字段',
  `RULE_KEY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'CON_表CONSOLIDATION_RULEKEY中的ID',
  `INDEX` int(11) NULL DEFAULT NULL COMMENT '页面显示的上下顺序',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '理货类型ID',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '页面label显示文字',
  `CREATED_DATE` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(2255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `TYPE_ID_FK`(`TYPE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of CON_CONSOLIDATIONTYPEPOSITION
-- ----------------------------
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('1', 'Client', '1', 1, '1', '客户', '2018-10-10 03:02:38', 'admin', '2018-09-17 14:23:22', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('10', 'MinNumberOfUnit', '5', 5, '2', '移货商品最小种类数（个）', '2018-10-10 06:18:04', 'admin', '2018-09-18 18:55:57', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('11', 'BinInfo', '22', 1, '3', '货位信息', '2018-10-10 03:03:03', 'admin', '2018-10-09 14:09:50', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('12', 'Client', '1', 1, '4', '客户', '2018-10-10 03:02:41', 'admin', '2018-10-09 14:47:08', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('13', 'MaxAmountOfSku', '2', 2, '4', '移货商品最大数量（个）', '2018-10-10 06:16:26', 'admin', '2018-10-09 15:13:20', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('14', 'MaxVolumeOfSku', '3', 3, '4', '移货商品最大体积（立方毫米）', '2018-10-15 06:28:57', 'admin', '2018-10-09 15:20:17', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('15', 'MaxUsePercent', '4', 4, '4', '移货货位最大利用率（%）', '2018-10-10 06:16:57', 'admin', '2018-10-09 15:28:21', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('16', 'MinNumberOfUnit', '5', 5, '4', '移货商品最小种类数（个）', '2018-10-10 06:18:06', 'admin', '2018-10-09 15:30:31', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('17', 'SkuNo', '20', 6, '4', '商品编号', '2018-10-10 03:06:15', 'admin', '2018-10-09 15:46:44', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('18', 'Client', '1', 1, '5', '客户', '2018-10-10 03:02:42', 'admin', '2018-10-09 16:00:38', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('19', 'PropertyOfSku', '18', 2, '5', '商品属性', '2018-10-10 03:06:46', 'admin', '2018-10-09 16:10:58', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('2', 'MaxAmountOfSku', '2', 2, '1', '移货商品最大数量（个）', '2018-10-10 06:16:22', 'admin', '2018-09-17 14:30:23', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('20', 'SkuInfo', '21', 3, '5', '商品信息', '2018-10-10 03:06:26', 'admin', '2018-10-09 16:14:55', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('21', 'Client', '1', 1, '6', '客户', '2018-10-10 03:02:44', 'admin', '2018-10-09 16:24:07', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('22', 'MaxAmountOfSku', '2', 2, '6', '移货商品最大数量（个）', '2018-10-10 06:16:28', 'admin', '2018-10-09 16:25:46', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('23', 'MaxVolumeOfSku', '3', 3, '6', '移货商品最大体积（立方毫米）', '2018-10-15 06:29:06', 'admin', '2018-10-09 16:27:01', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('24', 'MaxUsePercent', '4', 4, '6', '移货货位最大利用率（%）', '2018-10-10 06:17:01', 'admin', '2018-10-09 16:28:35', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('25', 'MinNumberOfUnit', '5', 5, '6', '移货商品最小种类数（个）', '2018-10-10 06:18:11', 'admin', '2018-10-09 16:30:52', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('26', 'Client', '1', 1, '7', '客户', '2018-10-10 03:02:49', 'admin', '2018-10-09 16:31:52', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('27', 'MaxAmountOfSku', '2', 2, '7', '移货商品最大数量（个）', '2018-10-10 06:16:35', 'admin', '2018-10-09 16:33:09', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('28', 'MaxVolumeOfSku', '3', 3, '7', '移货商品最大体积（立方毫米）', '2018-10-15 06:29:21', 'admin', '2018-10-09 16:34:48', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('29', 'MaxUsePercent', '4', 4, '7', '移货货位最大利用率（%）', '2018-10-10 06:17:29', 'admin', '2018-10-09 16:35:44', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('3', 'MaxVolumeOfSku', '3', 3, '1', '移货商品最大体积（立方毫米）', '2018-10-15 06:29:25', 'admin', '2018-09-17 14:32:18', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('30', 'MinNumberOfUnit', '5', 5, '7', '移货商品最小种类数（个）', '2018-10-10 06:18:12', 'admin', '2018-10-09 16:37:02', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('31', 'BinInfoButton', '25', 4, '5', '批量导入', '2018-10-10 03:03:17', 'admin', '2018-10-09 16:39:53', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('32', 'ZoneDistribution', '26', 6, '1', '区域分配表格显示', '2018-10-17 01:58:10', 'admin', '2018-10-17 09:54:09', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('33', 'ZoneDistribution', '26', 6, '2', '区域分配表格显示', '2018-10-17 01:58:26', 'admin', '2018-10-17 09:54:09', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('34', 'ZoneDistribution', '26', 6, '6', '区域分配表格显示', '2018-10-17 01:59:12', 'admin', '2018-10-17 09:54:09', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('35', 'ZoneDistribution', '26', 6, '7', '区域分配表格显示', '2018-10-17 02:01:02', 'admin', '2018-10-17 09:54:09', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('36', 'ZoneDistribution', '26', 7, '4', '区域分配表格显示', '2018-10-17 02:01:07', 'admin', '2018-10-17 09:54:09', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('4', 'MaxUsePercent', '4', 4, '1', '移货货位最大利用率（%）', '2018-10-10 06:16:53', 'admin', '2018-09-17 14:33:47', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('5', 'MinNumberOfUnit', '5', 5, '1', '移货商品最小种类数（个）', '2018-10-10 06:18:03', 'admin', '2018-09-17 14:35:58', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('6', 'Client', '1', 1, '2', '客户', '2018-10-10 03:02:40', 'admin', '2018-09-18 18:02:16', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('7', 'MaxAmountOfSku', '2', 2, '2', '移货商品最大数量（个）', '2018-10-10 06:16:24', 'admin', '2018-09-18 18:51:18', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('8', 'MaxVolumeOfSku', '3', 3, '2', '移货商品最大体积（立方毫米）', '2018-10-15 06:29:29', 'admin', '2018-09-18 18:53:28', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATIONTYPEPOSITION` VALUES ('9', 'MaxUsePercent', '4', 4, '2', '移货货位最大利用率（%）', '2018-10-10 06:16:55', 'admin', '2018-09-18 18:55:07', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for CON_CONSOLIDATION_ORDER
-- ----------------------------
DROP TABLE IF EXISTS `CON_CONSOLIDATION_ORDER`;
CREATE TABLE `CON_CONSOLIDATION_ORDER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ORDER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CONSOLIDATION_TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '任务类型,关联类型表',
  `STATE` int(11) NOT NULL COMMENT '当前状态',
  `PICKINGCATEGORY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'PP',
  `COLLATE_STATE` int(11) NOT NULL DEFAULT 0 COMMENT '生成拣货任务状态',
  `COMMENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL COMMENT '数据状态，0正常，2删除',
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `CONSOLIDATION_TYPE_FK`(`CONSOLIDATION_TYPE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for CON_CONSOLIDATION_ORDERPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `CON_CONSOLIDATION_ORDERPOSITION`;
CREATE TABLE `CON_CONSOLIDATION_ORDERPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CONSOLIDATION_ORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATE` int(11) NULL DEFAULT NULL COMMENT '理货明细状态',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品Id',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '对应货位',
  `FROMSTOCKUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '对应库存',
  `AMOUNT` int(11) NULL DEFAULT NULL COMMENT '要拣的数量',
  `POD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'pod的ID',
  `FACE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所在面',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for CON_CONSOLIDATION_ORDER_BIN
-- ----------------------------
DROP TABLE IF EXISTS `CON_CONSOLIDATION_ORDER_BIN`;
CREATE TABLE `CON_CONSOLIDATION_ORDER_BIN`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `POD_START` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货架开始',
  `POD_END` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货架结束',
  `BIN_START` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货位开始',
  `BIN_END` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货位结束',
  `LEVEL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '层数',
  `BIN_TYPE` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '货位类型',
  `CONSOLIDATION_ORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '理货单Id',
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for CON_CONSOLIDATION_ORDER_RULE
-- ----------------------------
DROP TABLE IF EXISTS `CON_CONSOLIDATION_ORDER_RULE`;
CREATE TABLE `CON_CONSOLIDATION_ORDER_RULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CONSOLIDATION_RULE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '条件key',
  `VALUE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '条件值',
  `CONSOLIDATION_ORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '对应的理货单',
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for CON_CONSOLIDATION_RULEKEY
-- ----------------------------
DROP TABLE IF EXISTS `CON_CONSOLIDATION_RULEKEY`;
CREATE TABLE `CON_CONSOLIDATION_RULEKEY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `RULE_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规则定义，唯一',
  `COMPARISON_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '显示类型',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of CON_CONSOLIDATION_RULEKEY
-- ----------------------------
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('1', 'Client', 'SELECT', '客户', '2018-09-19 15:58:15', 'admin', '2018-09-19 15:58:21', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('10', 'MinCube', 'INPUT', '最小体积（mm3）', '2018-09-19 16:14:14', 'admin', '2018-09-19 16:14:20', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('11', 'MaxLength', 'INPUT', '最大长度（mm）', '2018-09-19 16:21:26', 'admin', '2018-09-19 16:21:31', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('12', 'MaxWidth', 'INPUT', '最大宽度（mm）', '2018-09-19 16:43:15', 'admin', '2018-09-19 16:43:19', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('13', 'MaxHeight', 'INPUT', '最大高度（mm）', '2018-09-19 16:44:12', 'admin', '2018-09-19 16:44:22', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('14', 'MaxWeight', 'INPUT', '最大重量（g）', '2018-09-19 16:45:14', 'admin', '2018-09-19 16:45:19', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('15', 'MaxCube', 'INPUT', '最大体积（mm3）', '2018-09-19 16:45:47', 'admin', '2018-09-19 16:45:52', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('16', 'MaxAmountOfSameSku', 'INPUT', '同一商品的最大数量', '2018-09-19 16:46:54', 'admin', '2018-09-19 16:47:00', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('17', 'MinCubeOfSameSku', 'INPUT', '同一商品体积最小值', '2018-09-19 16:47:53', 'admin', '2018-09-19 16:47:58', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('18', 'PropertyOfSku', 'SELECT', '商品属性：正品、过期品等', '2018-09-19 16:49:17', 'admin', '2018-09-19 16:49:23', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('19', 'ItemGroup', 'SELECT', '商品分组范围', '2018-09-19 16:50:23', 'admin', '2018-09-19 16:50:30', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('2', 'MaxAmountOfSku', 'INPUT', '移货商品最大数量（个）', '2018-09-19 15:58:54', 'admin', '2018-09-19 15:59:03', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('20', 'SkuNo', 'TEXTAREA', '商品编号', '2018-09-19 16:59:21', 'admin', '2018-09-19 16:59:29', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('21', 'SkuInfo', 'TEXTAREA', '商品信息：货位 商品 数量', '2018-09-19 17:00:58', 'admin', '2018-09-19 17:01:05', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('22', 'BinInfo', 'TEXTAREA', '货位信息，指定货位移货时', '2018-09-19 17:02:28', 'admin', '2018-09-19 17:02:36', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('23', 'SkuNoButton', 'BUTTON', '商品编号批量导入', '2018-10-09 16:22:59', 'admin', '2018-10-09 16:23:09', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('24', 'SkuInfoButton', 'BUTTON', '商品信息：货位 商品 数量批量导入', '2018-10-09 16:24:29', 'admin', '2018-10-09 16:24:38', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('25', 'BinInfoButton', 'BUTTON', '货位信息，制定货位移货批量导入', '2018-10-09 16:26:00', 'admin', '2018-10-09 16:26:12', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('26', 'ZoneDistribution', 'TABLE', '区域分配表格显示', '2018-10-17 09:49:01', 'admin', '2018-10-17 09:49:15', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('3', 'MaxVolumeOfSku', 'INPUT', '移货商品最大体积（立方毫米）', '2018-09-19 15:59:16', 'admin', '2018-09-19 15:59:21', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('4', 'MaxUsePercent', 'INPUT', '移货货位最大利用率（%）', '2018-09-19 15:59:42', 'admin', '2018-09-19 15:59:48', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('5', 'MinNumberOfUnit', 'INPUT', '移货商品最小种类数（个）', '2018-09-19 16:00:02', 'admin', '2018-09-19 16:00:06', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('6', 'MinLength', 'INPUT', '最小长度（mm）', '2018-09-19 16:07:36', 'admin', '2018-09-19 16:07:40', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('7', 'MinWidth', 'INPUT', '最小宽度（mm）', '2018-09-19 16:10:37', 'admin', '2018-09-19 16:10:45', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('8', 'MinHeight', 'INPUT', '最小高度（mm）', '2018-09-19 16:11:32', 'admin', '2018-09-19 16:11:37', 'admin', NULL, 0, 0);
INSERT INTO `CON_CONSOLIDATION_RULEKEY` VALUES ('9', 'MinWeight', 'INPUT', '最小重量（g）', '2018-09-19 16:12:42', 'admin', '2018-09-19 16:12:46', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for EX_ITEMDATA
-- ----------------------------
DROP TABLE IF EXISTS `EX_ITEMDATA`;
CREATE TABLE `EX_ITEMDATA`  (
  `ID` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEM_NO` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '唯一编码',
  `SKU_NO` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品编码',
  `ITEMDATA_ID` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `NAME` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `REALNAME` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '真实名称',
  `ITEMPICTURE` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片地址',
  `PICTURENAME` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片名称',
  `CLIENT_ID` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `WAREHOUSE_ID` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `CREATED_BY` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(225) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IBP_IBPSTATION
-- ----------------------------
DROP TABLE IF EXISTS `IBP_IBPSTATION`;
CREATE TABLE `IBP_IBPSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `IBPROBLEMSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `IBPROBLEMSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBPROBLEMSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `IBP_IBPSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBPROBLEMSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBPROBLEMSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'INBOUND问题处理工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IBP_IBPSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IBP_IBPSTATIONPOSITION`;
CREATE TABLE `IBP_IBPSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IBPROBLEMSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `IBPROBLEMSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `IBP_IBPSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBPROBLEMSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBPROBLEMSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'INBOUND问题处理工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IBP_IBPSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `IBP_IBPSTATIONTYPE`;
CREATE TABLE `IBP_IBPSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `IBPROBLEMSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `IBPROBLEMSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'INBOUND问题处理工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IBP_IBPSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IBP_IBPSTATIONTYPEPOSITION`;
CREATE TABLE `IBP_IBPSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IBPROBLEMSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `IBPROBLEMSTATIONTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `IBPROBLEMSTATIONTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `IBP_IBPSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBPROBLEMSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'INBOUND问题处理工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IBP_INBOUNDPROBLEM
-- ----------------------------
DROP TABLE IF EXISTS `IBP_INBOUNDPROBLEM`;
CREATE TABLE `IBP_INBOUNDPROBLEM`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `PROBLEM_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '问题类型',
  `AMOUNT` decimal(11, 2) NOT NULL COMMENT '数量',
  `SOLVE_AMOUNT` decimal(11, 2) NOT NULL COMMENT '解决数量',
  `REPORT_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '报告人',
  `REPORT_DATE` timestamp(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '报告时间',
  `SOLVE_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人员',
  `PROBLEM_STORAGELOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题容器',
  `JOB_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '工作类型',
  `SERIAL_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SN',
  `LOT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品',
  `PROBLEM_ITEM_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题商品状态',
  `SKU_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SKU',
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品唯一编码',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `INBOUNDPROBLEM_ITEMDATA_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `INBOUNDPROBLEM_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `INBOUNDPROBLEM_ITEMDATA_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `INBOUNDPROBLEM_WAREHOUSE_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '报告INBOUND问题以及处理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IBP_INBOUNDPROBLEMCHECK
-- ----------------------------
DROP TABLE IF EXISTS `IBP_INBOUNDPROBLEMCHECK`;
CREATE TABLE `IBP_INBOUNDPROBLEMCHECK`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `INBOUNDPROBLEM_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '问题',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '检查容器',
  `AMOUNT` decimal(11, 2) NOT NULL COMMENT '输入数量',
  `PROBLEM_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '问题数量',
  `ITEMDATA_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '实际商品数量',
  `STORAGELOCATION_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '容器所有商品数量',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `CHECK_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '检查人',
  `CHECK_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '检查时间',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IBP_INBOUNDPROBLEMCHECK_STORAGELOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  INDEX `IBP_INBOUNDPROBLEMCHECK_ANDONINBOUND_ID_FK`(`INBOUNDPROBLEM_ID`) USING BTREE,
  INDEX `IBP_INBOUNDPROBLEMCHECK_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `IBP_INBOUNDPROBLEMCHECK_ANDONINBOUND_ID_FK` FOREIGN KEY (`INBOUNDPROBLEM_ID`) REFERENCES `IBP_INBOUNDPROBLEM` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBP_INBOUNDPROBLEMCHECK_STORAGELOCATION_ID_FK` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IBP_INBOUNDPROBLEMCHECK_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'INBOUND问题核实' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IBP_INBOUNDPROBLEMRULE
-- ----------------------------
DROP TABLE IF EXISTS `IBP_INBOUNDPROBLEMRULE`;
CREATE TABLE `IBP_INBOUNDPROBLEMRULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `INBOUNDPROBLEMRULE_NAME_UK`(`ID`) USING BTREE,
  INDEX `INBOUNDPROBLEMRULE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `INBOUNDPROBLEMRULE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'INBOUND问题处理规则' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IBP_INBOUNDPROBLEMRULE
-- ----------------------------
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('56da8b01-f296-11e6-8e32-0242ac110014', '2017-02-14 09:16:00', 'ADMIN', '2017-02-14 09:16:00', 'ADMIN', NULL, 0, 0, 'Less_FindBin', '少货找到货位', 'DEFAULT');
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('5901d872-f295-11e6-8e32-0242ac110014', '2017-02-14 09:09:00', 'ADMIN', '2017-02-14 09:09:00', 'ADMIN', NULL, 0, 0, 'Less_Loss', '少货盘亏', 'DEFAULT');
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('629c270b-f296-11e6-8e32-0242ac110014', '2017-02-14 09:17:00', 'ADMIN', '2017-02-14 09:17:00', 'ADMIN', NULL, 0, 0, 'More_Repeat', '多货重复', 'DEFAULT');
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('8991586f-f296-11e6-8e32-0242ac110014', '2017-02-14 09:18:00', 'ADMIN', '2017-02-14 09:18:00', 'ADMIN', NULL, 0, 0, 'Adjustment', '对应调整', 'DEFAULT');
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('899866de-f296-11e6-8e32-0242ac10014', '2017-02-14 09:18:00', 'ADMIN', '2017-02-14 09:18:00', 'ADMIN', NULL, 0, 0, 'Process', '处理中', 'DEFAULT');
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('899866de-f296-11e6-8e32-0242ac100147', '2017-04-26 14:34:05', 'ADMIN', '2017-04-26 14:33:49', 'ADMIN', NULL, 0, 0, 'More_FindBin', '多货找到货位', 'DEFAULT');
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('899866de-f296-11e6-8e32-0242ac110014', '2017-02-14 09:18:00', 'ADMIN', '2017-02-14 09:18:00', 'ADMIN', NULL, 0, 0, 'Closed', '手动关闭', 'DEFAULT');
INSERT INTO `IBP_INBOUNDPROBLEMRULE` VALUES ('899866de-f296-11e6-8e32-0242ac110023', '2019-04-29 16:00:45', 'ADMIN', '2019-04-29 16:00:52', 'ADMIN', NULL, 0, 0, 'More_Overage', '多货盘盈', 'DEFAULT');

-- ----------------------------
-- Table structure for IBP_INBOUNDPROBLEMSOLVE
-- ----------------------------
DROP TABLE IF EXISTS `IBP_INBOUNDPROBLEMSOLVE`;
CREATE TABLE `IBP_INBOUNDPROBLEMSOLVE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `INBOUNDPROBLEM_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '问题',
  `AMOUNT` decimal(11, 2) NOT NULL COMMENT '处理数量',
  `OPERATE_RULE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理规则',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理问题容器',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `SOLVE_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '解决人员',
  `SOLVE_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '解决时间',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `INBOUNDPROBLEMSOLVE_ANDONINBOUND_ID_FK`(`INBOUNDPROBLEM_ID`) USING BTREE,
  INDEX `INBOUNDPROBLEMSOLVE_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `INBOUNDPROBLEMSOLVE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `INBOUNDPROBLEMSOLVE_OPERATE_CODE`(`OPERATE_RULE`) USING BTREE,
  INDEX `INBOUNDPROBLEMSOLVE_STORAGELOCTION_ID`(`STORAGELOCATION_ID`) USING BTREE,
  CONSTRAINT `ANDONINBOUNDRECORD_ANDONINBOUND_ID` FOREIGN KEY (`INBOUNDPROBLEM_ID`) REFERENCES `IBP_INBOUNDPROBLEM` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONINBOUNDRECORD_CLIENT_ID` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONINBOUNDRECORD_OPERATE_CODE` FOREIGN KEY (`OPERATE_RULE`) REFERENCES `IBP_INBOUNDPROBLEMRULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONINBOUNDRECORD_STORAGELOCTION_ID` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ANDONINBOUNDRECORD_WAREHOUSE_ID` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'INBOUND问题处理记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_ADVICEREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `IB_ADVICEREQUEST`;
CREATE TABLE `IB_ADVICEREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `ADVICE_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'DN号码',
  `ADVICE_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'DN状态',
  `EXPECTED_DELIVERY` timestamp(0) NULL DEFAULT NULL COMMENT '预期交货日期',
  `EXPIRE_BATCH` bit(1) NULL DEFAULT NULL COMMENT '是否为过期的收货单',
  `EXTERNAL_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '外部编码',
  `EXTERNAL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '外部ID',
  `FINISH_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '完成收货时间',
  `PROCESS_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '处理收货单时间',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SIZE` int(11) NULL DEFAULT NULL COMMENT '对应position中dn的数量总和',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ADVICEREQUEST_ADVICE_NO`(`ADVICE_NO`) USING BTREE,
  INDEX `ADVICEREQUEST_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `ADVICEREQUEST_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货单DN' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_ADVICEREQUESTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_ADVICEREQUESTPOSITION`;
CREATE TABLE `IB_ADVICEREQUESTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_NO` int(11) NOT NULL COMMENT '收货单详情编号',
  `NOTIFIED_AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '因收货数量',
  `RECEIPT_AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '实际收货数量',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `ADVICE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'DN编号',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_ADVICE_ID_FK`(`ADVICE_ID`) USING BTREE,
  CONSTRAINT `ADVICEREQUESTPOSITION_ADVICE_ID_FK` FOREIGN KEY (`ADVICE_ID`) REFERENCES `IB_ADVICEREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ADVICEREQUESTPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ADVICEREQUESTPOSITION_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ADVICEREQUESTPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货单DN的明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_ENROUTEPOD
-- ----------------------------
DROP TABLE IF EXISTS `IB_ENROUTEPOD`;
CREATE TABLE `IB_ENROUTEPOD`  (
  `ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `STOW_STATION_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `RECEIVE_STATION_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `POD_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_GOODSRECEIPT
-- ----------------------------
DROP TABLE IF EXISTS `IB_GOODSRECEIPT`;
CREATE TABLE `IB_GOODSRECEIPT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `GR_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货单编码',
  `DELIVERY_NOTE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '收货DN编号',
  `RECEIPT_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '收货时间',
  `RECEIPT_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '收货状态',
  `RELATEDADVICE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'DN',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SIZE` int(11) NULL DEFAULT NULL COMMENT '实际收货总数',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `GOODSRECEIPT_GR_NO_UK`(`GR_NO`) USING BTREE,
  INDEX `GOODSRECEIPT_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `GOODSRECEIPT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `GOODSRECEIPT_RELATEDADVICE_ID_FK`(`RELATEDADVICE_ID`) USING BTREE,
  CONSTRAINT `GOODSRECEIPT_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GOODSRECEIPT_RELATEDADVICE_ID_FK` FOREIGN KEY (`RELATEDADVICE_ID`) REFERENCES `IB_ADVICEREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GOODSRECEIPT_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '激活具体DN时生成' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_GOODSRECEIPTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_GOODSRECEIPTPOSITION`;
CREATE TABLE `IB_GOODSRECEIPTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '数量',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品',
  `LOT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期',
  `RECEIPT_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货类型',
  `RECEIVETOSTOCKUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '货收入的库存',
  `RECEIVESTORAGE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '货放入的容器',
  `RECEIVEUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货放入容器的载具',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货人',
  `GOODSRECEIPT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货单',
  `RECEIVESTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '收货工作站',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `GRPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `GRPOSITION_GOODSRECEIPT_ID_FK`(`GOODSRECEIPT_ID`) USING BTREE,
  INDEX `GRPOSITION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `GRPOSITION_STOCKUNIT_ID_FK`(`RECEIVETOSTOCKUNIT_ID`) USING BTREE,
  INDEX `GRPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `GRPOSITION_RECEIVETOCONTAINER_ID_FK`(`RECEIVESTORAGE_ID`) USING BTREE,
  INDEX `RECEIVESTORAGE_ID`(`RECEIVESTORAGE_ID`) USING BTREE,
  INDEX `RECEIVEUNITLOAD_ID`(`RECEIVEUNITLOAD_ID`) USING BTREE,
  CONSTRAINT `GRPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GRPOSITION_GOODSRECEIPT_ID_FK` FOREIGN KEY (`GOODSRECEIPT_ID`) REFERENCES `IB_GOODSRECEIPT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GRPOSITION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GRPOSITION_RECEIVESTORAGE_ID_FK` FOREIGN KEY (`RECEIVESTORAGE_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GRPOSITION_RECEIVEUNITLOAD_ID_FK` FOREIGN KEY (`RECEIVEUNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GRPOSITION_STOCKUNIT_ID_FK` FOREIGN KEY (`RECEIVETOSTOCKUNIT_ID`) REFERENCES `INV_STOCKUNIT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GRPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '具体收货数据记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_INVENTORYANALYSIS
-- ----------------------------
DROP TABLE IF EXISTS `IB_INVENTORYANALYSIS`;
CREATE TABLE `IB_INVENTORYANALYSIS`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `LEVEL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品等级',
  `ONPOD_AMOUNT` decimal(11, 0) NULL DEFAULT NULL COMMENT '全部库存',
  `AVAILABLE_AMOUNT` decimal(11, 0) NULL DEFAULT NULL COMMENT '可用库存',
  `BUFFERFUD_AMOUNT` decimal(11, 0) NULL DEFAULT NULL,
  `MAX_DOC` decimal(17, 4) NULL DEFAULT NULL,
  `REPLENISH_DOC` decimal(17, 4) NULL DEFAULT NULL,
  `SAFETY_DOC` decimal(17, 4) NULL DEFAULT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `INVENTORYANALYSIS_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `INVENTORYANALYSIS_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `INVENTORYANALYSIS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `INVENTORYANALYSIS_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `INVENTORYANALYSIS_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `INVENTORYANALYSIS_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货直接补货&补货判断 参考表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_ITEMDATETYPEGRADESTATS
-- ----------------------------
DROP TABLE IF EXISTS `IB_ITEMDATETYPEGRADESTATS`;
CREATE TABLE `IB_ITEMDATETYPEGRADESTATS`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `SHIPMENT_DAY` decimal(17, 4) NOT NULL,
  `UNITS_SHIPMENT` decimal(17, 4) NOT NULL,
  `UNITS_DAY` decimal(17, 4) NOT NULL,
  `ADJUST_EXPIRE_DATE` timestamp(0) NULL DEFAULT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SKU_GRADE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品等级',
  `ADJ_SKU_GRADE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品修改等级',
  `ALTER_STATE` int(1) NOT NULL COMMENT '改变状态,用来判断修改等级是否修改过',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ITEMDATETYPEGRADESTATS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ITEMDATETYPEGRADESTATS_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `ITEMDATETYPEGRADESTATS_ITEMDATE_ID_FK`(`ITEMDATA_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_PDA_CALL_POD
-- ----------------------------
DROP TABLE IF EXISTS `IB_PDA_CALL_POD`;
CREATE TABLE `IB_PDA_CALL_POD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `POD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STOW_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TASK_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用于报告暗灯和解决暗灯' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_RECEIVECATEGORY
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVECATEGORY`;
CREATE TABLE `IB_RECEIVECATEGORY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '过滤规则名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '过滤规则描述',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `CATEGORY_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '过滤规则类型',
  `RECEIVEDESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '目的地',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `RECEIVECATEGORY_NAME_UK`(`NAME`, `CLIENT_ID`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `RECEIVEDESTINATION_ID`(`RECEIVEDESTINATION_ID`) USING BTREE,
  INDEX `RECEIVECATEGORY_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `RECEIVECATEGORY_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `RECEIVECATEGORY_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVECATEGORY_RECEIVIEDESTINATION_ID_FK` FOREIGN KEY (`RECEIVEDESTINATION_ID`) REFERENCES `IB_RECEIVEDESTINATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVECATEGORY_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货规则配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_RECEIVECATEGORYPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVECATEGORYPOSITION`;
CREATE TABLE `IB_RECEIVECATEGORYPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_NO` int(11) NOT NULL COMMENT '详情编号',
  `CATEGORY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '过滤规则',
  `RULE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '规则',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作方式方法',
  `COMP_KEY` varchar(4096) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '比较对象的ID',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `RECEIVECATEGORYPOSITION_CATEGORY_ID_FK`(`CATEGORY_ID`) USING BTREE,
  INDEX `RECEIVECATEGORYPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `RECEIVECATEGORYPOSITION_RULE_ID_FK`(`RULE_ID`) USING BTREE,
  INDEX `RECEIVECATEGORYPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `RECEIVECATEGORYPOSITION_CATEGORY_ID_FK` FOREIGN KEY (`CATEGORY_ID`) REFERENCES `IB_RECEIVECATEGORY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVECATEGORYPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVECATEGORYPOSITION_RULE_ID_FK` FOREIGN KEY (`RULE_ID`) REFERENCES `IB_RECEIVECATEGORYRULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVECATEGORYPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货规则配置明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_RECEIVECATEGORYRULE
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVECATEGORYRULE`;
CREATE TABLE `IB_RECEIVECATEGORYRULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作',
  `DECISION_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作KEY',
  `COMPARISON_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作VALUE来自于',
  `COMP_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '比较值',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `RECEIVECATEGORYRULE_NAME_UK`(`NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货规则' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_RECEIVECATEGORYRULE
-- ----------------------------
INSERT INTO `IB_RECEIVECATEGORYRULE` VALUES ('1', '2016-12-17 22:41:11', 'ADMIN', '2016-12-20 23:31:42', 'ADMIN', NULL, 0, 2, 'New SKU', 'NOT_MEASURED', 'NEW_SKU', 'CONSTANT_VALUE', NULL);
INSERT INTO `IB_RECEIVECATEGORYRULE` VALUES ('2', '2016-12-17 22:41:11', 'ADMIN', '2016-12-17 22:41:11', 'ADMIN', NULL, 0, 0, 'Flag', 'MATCH_AT_LEAST_ONE', 'FLAG', 'VALUE_FROM_CONTEXT', NULL);
INSERT INTO `IB_RECEIVECATEGORYRULE` VALUES ('4', '2016-12-17 22:41:11', 'ADMIN', '2016-12-17 22:41:11', 'ADMIN', NULL, 0, 0, 'Zone Type', 'EQUAL', 'ZONE_TYPE', 'VALUE_FROM_CONTEXT', NULL);
INSERT INTO `IB_RECEIVECATEGORYRULE` VALUES ('5', '2016-12-17 22:41:11', 'ADMIN', '2016-12-20 23:31:29', 'ADMIN', NULL, 0, 2, 'Volume', 'EQUAL,GREATER_THAN,GREATER_THAN_OR_EQUAL_TO,LESS_THAN,LESS_THAN_OR_EQUAL_TO', 'VOLUME', 'CONSTANT_VALUE', NULL);
INSERT INTO `IB_RECEIVECATEGORYRULE` VALUES ('6', '2016-12-17 22:41:11', 'ADMIN', '2016-12-17 22:41:11', 'ADMIN', NULL, 0, 0, 'Client', 'EQUAL', 'CLIENT', 'VALUE_FROM_CONTEXT', NULL);
INSERT INTO `IB_RECEIVECATEGORYRULE` VALUES ('7', '2016-12-17 22:41:11', 'ADMIN', '2016-12-17 22:41:11', 'ADMIN', NULL, 0, 0, 'Problem', 'NA', 'PROBLEM', 'CONSTANT_VALUE', NULL);

-- ----------------------------
-- Table structure for IB_RECEIVEDESTINATION
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVEDESTINATION`;
CREATE TABLE `IB_RECEIVEDESTINATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `INVENTORY_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '库存类型',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `AREA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '功能区',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `RECEIVEDESTIONATION_NAME_UK`(`WAREHOUSE_ID`, `NAME`) USING BTREE,
  INDEX `RECEIVEDESTIONATION_AREA_ID_FK`(`AREA_ID`) USING BTREE,
  INDEX `RECEIVEDESTIONATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `RECEIVEDESTIONATION_AREA_ID_FK` FOREIGN KEY (`AREA_ID`) REFERENCES `MD_AREA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVEDESTIONATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货目的地' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_RECEIVEDESTINATION
-- ----------------------------
INSERT INTO `IB_RECEIVEDESTINATION` VALUES ('135cf13d-f3f2-477d-96a8-c3527cfdd283', '2019-12-18 06:06:49', 'admin', '2019-12-18 06:06:49', 'admin', NULL, 0, 0, 'D_EACH_MEASURE', NULL, '', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `IB_RECEIVEDESTINATION` VALUES ('8e203002-63f5-4c66-b66b-f43067f1b217', '2019-12-18 06:06:33', 'admin', '2019-12-18 06:06:33', 'admin', NULL, 0, 0, 'D_EACH_DEMAGE', NULL, NULL, 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `IB_RECEIVEDESTINATION` VALUES ('c9b219cb-619b-478b-85d8-d58b2f59d85e', '2019-12-18 06:06:59', 'admin', '2019-12-18 06:06:59', 'admin', NULL, 0, 0, 'D_EACH_PENDING', NULL, NULL, 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for IB_RECEIVEELIGIBILITY
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVEELIGIBILITY`;
CREATE TABLE `IB_RECEIVEELIGIBILITY`  (
  `RECEIVETHRESHOLD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货权限',
  `USER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '用户',
  INDEX `RECEIVETHRESHOLD_ID`(`RECEIVETHRESHOLD_ID`) USING BTREE,
  INDEX `USER_ID`(`USER_ID`) USING BTREE,
  CONSTRAINT `RECEIVEELIGIBILITY_RECEIVETHRESHOLD_ID_FK` FOREIGN KEY (`RECEIVETHRESHOLD_ID`) REFERENCES `IB_RECEIVETHRESHOLD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVEELIGIBILITY_USER_ID_FK` FOREIGN KEY (`USER_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '具体用户收货可以超过的百分比设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_RECEIVEPROCESS
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVEPROCESS`;
CREATE TABLE `IB_RECEIVEPROCESS`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` int(11) NOT NULL COMMENT '绑定顺序',
  `RECEIVESTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货工作站',
  `RECEIVESTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作站具体位置',
  `RECEIVESTORAGE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货容器',
  `RECEIVEUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '收货容器载具',
  `RECEIVIEDESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货目的地',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `RECEIVESTORAGE_ID`(`RECEIVESTORAGE_ID`) USING BTREE,
  INDEX `RECEIVESTATION_ID`(`RECEIVESTATION_ID`) USING BTREE,
  INDEX `RECEIVIEDESTINATION_ID`(`RECEIVIEDESTINATION_ID`) USING BTREE,
  INDEX `WAREHOUSE_ID`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `RECEIVEPROCESS_RECEIVESTATIONPOSTION_ID_FK`(`RECEIVESTATIONPOSITION_ID`) USING BTREE,
  INDEX `RECEIVEUNITLOAD_ID`(`RECEIVEUNITLOAD_ID`) USING BTREE,
  CONSTRAINT `RECEIVEPROCESS_RECEIVEDESITINATION_ID_FK` FOREIGN KEY (`RECEIVIEDESTINATION_ID`) REFERENCES `IB_RECEIVEDESTINATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVEPROCESS_RECEIVESTATIONPOSTION_ID_FK` FOREIGN KEY (`RECEIVESTATIONPOSITION_ID`) REFERENCES `IB_RECEIVESTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVEPROCESS_RECEIVESTATION_ID_FK` FOREIGN KEY (`RECEIVESTATION_ID`) REFERENCES `IB_RECEIVESTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVEPROCESS_STORAGELOCATION_ID_FK` FOREIGN KEY (`RECEIVESTORAGE_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVEPROCESS_UNITLOAD_ID_FK` FOREIGN KEY (`RECEIVEUNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVEPROCESS_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货工作站、容器、目的地的绑定' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_RECEIVESTATION
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVESTATION`;
CREATE TABLE `IB_RECEIVESTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '工作站类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '当前操作人员',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CHOSE_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `RECEIVESTATION_NAME_UK`(`WAREHOUSE_ID`, `NAME`) USING BTREE,
  INDEX `RECEIVESTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `RECEIVESTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `RECEIVESTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `RECEIVESTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `IB_RECEIVESTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVESTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVESTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_RECEIVESTATION
-- ----------------------------
INSERT INTO `IB_RECEIVESTATION` VALUES ('801c04a9-1933-43ae-92cf-bcff56a306cd', '2019-12-18 06:19:07', 'admin', '2019-12-18 06:19:07', 'admin', NULL, 0, 0, 'SERP001', NULL, '318cc5cf-4ab5-4bc3-83f5-c22b8861de5f', NULL, '3ba41fe1-6b95-4849-8e50-31995ade08b0', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL);

-- ----------------------------
-- Table structure for IB_RECEIVESTATIONBINTYPE
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVESTATIONBINTYPE`;
CREATE TABLE `IB_RECEIVESTATIONBINTYPE`  (
  `STORAGELOCATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RECEIVESTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  INDEX `RECEIVESTATIONBINTYPE_STORAGELOCATIONTYPE_ID_FK`(`STORAGELOCATIONTYPE_ID`) USING BTREE,
  INDEX `RECEIVESTATIONBINTYPE_RECEIVESTATION_ID_FK`(`RECEIVESTATION_ID`) USING BTREE,
  CONSTRAINT `RECEIVESTATIONBINTYPE_RECEIVESTATION_ID_FK` FOREIGN KEY (`RECEIVESTATION_ID`) REFERENCES `IB_RECEIVESTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVESTATIONBINTYPE_STORAGELOCATIONTYPE_ID_FK` FOREIGN KEY (`STORAGELOCATIONTYPE_ID`) REFERENCES `MD_STORAGELOCATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货工作站需要哪些类型的BIN' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_RECEIVESTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVESTATIONPOSITION`;
CREATE TABLE `IB_RECEIVESTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `RECEIVESTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `RECEIVESTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `RECEIVESTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `RECEIVESTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `IB_RECEIVESTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVESTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVESTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_RECEIVESTATIONPOSITION
-- ----------------------------
INSERT INTO `IB_RECEIVESTATIONPOSITION` VALUES ('151c58fc-a848-4745-a781-1d65984e69fd', '2019-12-18 06:19:07', 'admin', '2019-12-18 06:19:07', 'admin', NULL, 0, 0, '953bd55b-3fa5-402b-9d35-675ca2d0369e', 'DAMAGE', '801c04a9-1933-43ae-92cf-bcff56a306cd', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `IB_RECEIVESTATIONPOSITION` VALUES ('3e8316ed-20ea-4504-9e65-0ea26664012e', '2019-12-18 06:19:07', 'admin', '2019-12-18 06:19:07', 'admin', NULL, 0, 0, '71fc8b6b-f1bd-4986-bf0e-0074cfdbccb6', 'MEASURE', '801c04a9-1933-43ae-92cf-bcff56a306cd', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `IB_RECEIVESTATIONPOSITION` VALUES ('6a829e7f-94fb-4986-ba4f-8a357637b4fd', '2019-12-18 06:19:07', 'admin', '2019-12-18 06:19:07', 'admin', NULL, 0, 0, '4d2b6d29-7262-47c8-b61d-6578f722ebdf', 'PENDING', '801c04a9-1933-43ae-92cf-bcff56a306cd', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for IB_RECEIVESTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVESTATIONTYPE`;
CREATE TABLE `IB_RECEIVESTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `RECEIVE_STATION_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '收货工作站类型',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `RECEIVESTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `RECEIVESTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `RECEIVESTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货工作类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_RECEIVESTATIONTYPE
-- ----------------------------
INSERT INTO `IB_RECEIVESTATIONTYPE` VALUES ('318cc5cf-4ab5-4bc3-83f5-c22b8861de5f', '2019-12-18 06:08:16', 'admin', '2019-12-18 06:08:16', 'admin', NULL, 0, 0, 'EACH_RECIVE_TO_STOW', 'Each Receive To Stow', NULL, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for IB_RECEIVESTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVESTATIONTYPEPOSITION`;
CREATE TABLE `IB_RECEIVESTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `RECEIVEDESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '目的地',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `RECEIVESTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `RECEIVESTATIONTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  INDEX `RECEIVESTATIONTYPEPOSITION_RECEIVEDESTINATION_ID_FK`(`RECEIVEDESTINATION_ID`) USING BTREE,
  CONSTRAINT `RECEIVESTATIONTYPEPOSITION_RECEIVEDESTINATION_ID_FK` FOREIGN KEY (`RECEIVEDESTINATION_ID`) REFERENCES `IB_RECEIVEDESTINATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVESTATIONTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `IB_RECEIVESTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `RECEIVESTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_RECEIVESTATIONTYPEPOSITION
-- ----------------------------
INSERT INTO `IB_RECEIVESTATIONTYPEPOSITION` VALUES ('0faa6ea2-7911-4e78-912e-7bfb28fd894f', '2019-12-18 06:08:16', 'admin', '2019-12-18 06:08:16', 'admin', NULL, 0, 0, 1, 'DAMAGE', '8e203002-63f5-4c66-b66b-f43067f1b217', '318cc5cf-4ab5-4bc3-83f5-c22b8861de5f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `IB_RECEIVESTATIONTYPEPOSITION` VALUES ('4e027d01-5e6b-40be-870f-9e884e954823', '2019-12-18 06:08:16', 'admin', '2019-12-18 06:08:16', 'admin', NULL, 0, 0, 2, 'MEASURE', '135cf13d-f3f2-477d-96a8-c3527cfdd283', '318cc5cf-4ab5-4bc3-83f5-c22b8861de5f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `IB_RECEIVESTATIONTYPEPOSITION` VALUES ('73755e47-566a-4579-9c9f-28e07890a069', '2019-12-18 06:08:16', 'admin', '2019-12-18 06:08:16', 'admin', NULL, 0, 0, 3, 'PENDING', 'c9b219cb-619b-478b-85d8-d58b2f59d85e', '318cc5cf-4ab5-4bc3-83f5-c22b8861de5f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for IB_RECEIVETHRESHOLD
-- ----------------------------
DROP TABLE IF EXISTS `IB_RECEIVETHRESHOLD`;
CREATE TABLE `IB_RECEIVETHRESHOLD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '收货权限',
  `THRESHOLD` decimal(11, 2) NOT NULL COMMENT '阀值（百分比）',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `WAREHOUSE_ID`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `RECEIVETHRESHOLD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货超过实际数量的百分比设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_REPLENISHSTRATEGY
-- ----------------------------
DROP TABLE IF EXISTS `IB_REPLENISHSTRATEGY`;
CREATE TABLE `IB_REPLENISHSTRATEGY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NULL DEFAULT NULL,
  `SHIPMENT_DAY` decimal(17, 4) NULL DEFAULT NULL COMMENT 'S/D',
  `UNITS_SHIPMENT` decimal(17, 4) NULL DEFAULT NULL COMMENT 'U/S',
  `REPLENISH_TRIGGER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '触发补货条件（安全库存，库存为零）',
  `FUD_STRATEGY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'FUD策略',
  `REPLENISH_PAD_TIME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '补货周期时间',
  `RECEIVE_IS_REPLENISH` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否收获直接补货',
  `RECEIVE_IS_REPLENISH_CONDITION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '收货补货的判断条件（最大库存，安全库存）',
  `SKU_MAX_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '最大匹配种类',
  `REPLENISH_COUNT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '补货库存计算方式',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REPLENISHORDER_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `REPLENISHORDER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `REPLENISHORDER_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REPLENISHORDER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '补货策略' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_STOWELIGIBILITY
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWELIGIBILITY`;
CREATE TABLE `IB_STOWELIGIBILITY`  (
  `STOWTHRESHOLD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '上架权限',
  `USER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '用户',
  INDEX `STOWTHRESHOLD_ID`(`STOWTHRESHOLD_ID`) USING BTREE,
  INDEX `USER_ID`(`USER_ID`) USING BTREE,
  CONSTRAINT `STOWELIGIBILITY_STOWTHRESHOLD_ID_FK` FOREIGN KEY (`STOWTHRESHOLD_ID`) REFERENCES `IB_STOWTHRESHOLD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWELIGIBILITY_USER_ID_FK` FOREIGN KEY (`USER_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '具体用户上架可以超过的百分比设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_STOWPROCESS
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWPROCESS`;
CREATE TABLE `IB_STOWPROCESS`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` int(11) NOT NULL COMMENT '绑定顺序',
  `STOWSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '上架工作站',
  `STOWSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作站具体位置',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '容器',
  `UNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '容器载具',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOWPROCESS_STOWSTATION_ID_FK`(`STOWSTATION_ID`) USING BTREE,
  INDEX `STOWPROCESS_STOWSTATIONPOSITION_ID_FK`(`STOWSTATIONPOSITION_ID`) USING BTREE,
  INDEX `STOWPROCESS_STORAGELOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  INDEX `STOWPROCESS_UNITLOAD_ID_FK`(`UNITLOAD_ID`) USING BTREE,
  INDEX `STOWPROCESS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOWPROCESS_STORAGELOCATION_ID_FK` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWPROCESS_STOWSTATIONPOSITION_ID_FK` FOREIGN KEY (`STOWSTATIONPOSITION_ID`) REFERENCES `IB_STOWSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWPROCESS_STOWSTATION_ID_FK` FOREIGN KEY (`STOWSTATION_ID`) REFERENCES `IB_STOWSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '上架工作站、容器绑定关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_STOWSTATION
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWSTATION`;
CREATE TABLE `IB_STOWSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CHOSE_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `STOWSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `STOWSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STOWSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `STOWSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `STOWSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `STOWSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `IB_STOWSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '上架工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_STOWSTATION
-- ----------------------------
INSERT INTO `IB_STOWSTATION` VALUES ('d400b1fe-eaf3-4e16-a83d-784f7d3afe96', '2019-12-18 06:20:43', 'admin', '2019-12-18 06:20:43', 'admin', NULL, 0, 0, 'STOW001', NULL, 'dace2cf9-0c18-44c1-901f-fb8b674bdd04', NULL, '3ba41fe1-6b95-4849-8e50-31995ade08b0', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL);

-- ----------------------------
-- Table structure for IB_STOWSTATIONBINTYPE
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWSTATIONBINTYPE`;
CREATE TABLE `IB_STOWSTATIONBINTYPE`  (
  `STORAGELOCATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STOWSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  INDEX `STOWSTATIONBINTYPE_STOWSTATION_ID_FK`(`STOWSTATION_ID`) USING BTREE,
  INDEX `STOWSTATIONBINTYPE_STORAGELOCATIONTYPE_ID_FK`(`STORAGELOCATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `STOWSTATIONBINTYPE_STORAGELOCATIONTYPE_ID_FK` FOREIGN KEY (`STORAGELOCATIONTYPE_ID`) REFERENCES `MD_STORAGELOCATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWSTATIONBINTYPE_STOWSTATION_ID_FK` FOREIGN KEY (`STOWSTATION_ID`) REFERENCES `IB_STOWSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '上架工作站需要哪些BIN类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_STOWSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWSTATIONPOSITION`;
CREATE TABLE `IB_STOWSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOWSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `STOWSTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `STOWSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOWSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `IB_STOWSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '上架工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_STOWSTATIONPOSITION
-- ----------------------------
INSERT INTO `IB_STOWSTATIONPOSITION` VALUES ('5d27a62e-539c-49df-bc32-8c9026be0b4a', '2019-12-18 06:20:43', 'admin', '2019-12-18 06:20:43', 'admin', NULL, 0, 0, '953bd55b-3fa5-402b-9d35-675ca2d0369e', 'DAMAGE', 'd400b1fe-eaf3-4e16-a83d-784f7d3afe96', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for IB_STOWSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWSTATIONTYPE`;
CREATE TABLE `IB_STOWSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `STOWSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `STOWSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOWSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '上架工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_STOWSTATIONTYPE
-- ----------------------------
INSERT INTO `IB_STOWSTATIONTYPE` VALUES ('dace2cf9-0c18-44c1-901f-fb8b674bdd04', '2019-12-18 06:20:31', 'admin', '2019-12-18 06:20:31', 'admin', NULL, 0, 0, 'STOW', NULL, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for IB_STOWSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWSTATIONTYPEPOSITION`;
CREATE TABLE `IB_STOWSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOWSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STOWSTATIONTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `STOWSTATIONTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `IB_STOWSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOWSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '上架工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of IB_STOWSTATIONTYPEPOSITION
-- ----------------------------
INSERT INTO `IB_STOWSTATIONTYPEPOSITION` VALUES ('ef4101c6-36f6-4595-95f2-44adaed1ae36', '2019-12-18 06:20:31', 'admin', '2019-12-18 06:20:31', 'admin', NULL, 0, 0, 1, 'DAMAGE', 'dace2cf9-0c18-44c1-901f-fb8b674bdd04', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for IB_STOWTHRESHOLD
-- ----------------------------
DROP TABLE IF EXISTS `IB_STOWTHRESHOLD`;
CREATE TABLE `IB_STOWTHRESHOLD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '上架权限',
  `THRESHOLD` decimal(11, 2) NOT NULL COMMENT '阀值（个数）',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOWTHRESHOLD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOWTHRESHOLD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '上架超过实际数量的百分比设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_TRANSFERINREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `IB_TRANSFERINREQUEST`;
CREATE TABLE `IB_TRANSFERINREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRANSFER__NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '调拨入生成的DN号码',
  `TRANSFER_OUT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '外部系统调拨入单号',
  `TRANSFER_IN_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '内部系统调拨入单号',
  `TRANSFER_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'DN状态',
  `EXPECTED_DELIVERY` timestamp(0) NULL DEFAULT NULL COMMENT '预期交货日期',
  `RECEIVE_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '接收时间',
  `DELIVERY_WAREHOUSE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发货库房',
  `DELIVER_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '发货时间',
  `CLOSE_TIME` timestamp(0) NULL DEFAULT NULL COMMENT '调拨关闭时间',
  `EXPIRE_BATCH` bit(1) NULL DEFAULT NULL COMMENT '是否为过期的收货单',
  `TRANSFER_LESS` int(11) NULL DEFAULT NULL,
  `TRANFER_GOODS_RECEIVE_AMOUNT` decimal(17, 0) NULL DEFAULT NULL COMMENT '收到商品数量',
  `TRANFER_GOODS_ORDER_AMOUNT` decimal(17, 0) NULL DEFAULT NULL COMMENT '收货单商品数量',
  `CONTAINER_AMOUNT` int(11) NULL DEFAULT NULL COMMENT '收货容器数量',
  `TRANSFER_MORE` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ADVICEREQUEST_ADVICE_NO`(`TRANSFER__NO`) USING BTREE,
  INDEX `ADVICEREQUEST_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `ADVICEREQUEST_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `IB_ADVICEREQUEST_copy_ibfk_1` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IB_ADVICEREQUEST_copy_ibfk_2` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货单DN' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for IB_TRANSFERREQUESTINPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `IB_TRANSFERREQUESTINPOSITION`;
CREATE TABLE `IB_TRANSFERREQUESTINPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_NO` int(11) NULL DEFAULT NULL COMMENT '收货单详情编号',
  `NOTIFIED_AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '因收货数量',
  `RECEIPT_AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '实际收货数量',
  `STORAGELOCATIONID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '存储容器ID',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '商品',
  `TRANSFER_REQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '调拨DN编号',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `ADVICEREQUESTPOSITION_ADVICE_ID_FK`(`TRANSFER_REQUEST_ID`) USING BTREE,
  INDEX `IB_TRANSFERREQUESTPOSITION_ibfk_5`(`STORAGELOCATIONID`) USING BTREE,
  CONSTRAINT `IB_TRANSFERREQUESTINPOSITION_ibfk_1` FOREIGN KEY (`TRANSFER_REQUEST_ID`) REFERENCES `IB_TRANSFERINREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IB_TRANSFERREQUESTINPOSITION_ibfk_2` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IB_TRANSFERREQUESTINPOSITION_ibfk_3` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IB_TRANSFERREQUESTINPOSITION_ibfk_4` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `IB_TRANSFERREQUESTINPOSITION_ibfk_5` FOREIGN KEY (`STORAGELOCATIONID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货单DN的明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_STOCKTAKING
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKING`;
CREATE TABLE `ICQA_STOCKTAKING`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STOCKTAKING_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '盘点编号',
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '盘点名称',
  `ZONE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '指定区域',
  `AMOUNT` int(11) NOT NULL COMMENT '盘点数量',
  `STOCKTAKING_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '盘点类型',
  `ENDED` timestamp(0) NULL DEFAULT NULL COMMENT '结束时间',
  `STARTED` timestamp(0) NULL DEFAULT NULL COMMENT '开始时间',
  `TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `STOCKTAKING_NO_UK`(`STOCKTAKING_NO`) USING BTREE,
  INDEX `STOCKTAKING_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKING_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点创建以及库存清点' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGORDER
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGORDER`;
CREATE TABLE `ICQA_STOCKTAKINGORDER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AREA_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能区名称',
  `COUNTING_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '盘点时间',
  `LOCATION_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货位',
  `STOCKTAKINGRULE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '盘点规则',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户',
  `TIMES` int(11) NULL DEFAULT NULL COMMENT '处理时间',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `UNITLOAD_LABEL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '载具编号',
  `STOCKTAKING_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '盘点',
  `PARAMETER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '附加',
  `TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOCKTAKINGORDER_STOCKTAKING_ID_FK`(`STOCKTAKING_ID`) USING BTREE,
  INDEX `STOCKTAKINGORDER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STOCKTAKINGORDER_STOCKTAKINGRULE_ID_FK`(`STOCKTAKINGRULE_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKINGORDER_STOCKTAKINGRULE_ID_FK` FOREIGN KEY (`STOCKTAKINGRULE_ID`) REFERENCES `ICQA_STOCKTAKINGRULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGORDER_STOCKTAKING_ID_FK` FOREIGN KEY (`STOCKTAKING_ID`) REFERENCES `ICQA_STOCKTAKING` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGORDER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点明细以及盘点顺序' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGRECORD
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGRECORD`;
CREATE TABLE `ICQA_STOCKTAKINGRECORD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TIMES` int(11) NULL DEFAULT NULL COMMENT '时间',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `COUNTED_QUANTITY` decimal(19, 2) NOT NULL COMMENT '计数量',
  `STOCKUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '库存',
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `LOT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期编号',
  `LOCATION_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '储位名称',
  `PLANNED_QUANTITY` decimal(19, 2) NULL DEFAULT NULL COMMENT '盘点量',
  `SERIAL_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SN',
  `ULTYPE_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '载具类型编号',
  `UNITLOAD_LABEL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '载具编号',
  `STOCKTAKINGORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '盘点顺序',
  `CLIENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '日常还是系统(daily/system)',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOCKTAKINGRECORD_STOCKTAKINGORDER_ID_FK`(`STOCKTAKINGORDER_ID`) USING BTREE,
  INDEX `STOCKTAKINGRECORD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STOCKTAKINGRECORD_STOCKUNITS_ID_FK`(`STOCKUNIT_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKINGRECORD_STOCKTAKINGORDER_ID_FK` FOREIGN KEY (`STOCKTAKINGORDER_ID`) REFERENCES `ICQA_STOCKTAKINGORDER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGRECORD_STOCKUNITS_ID_FK` FOREIGN KEY (`STOCKUNIT_ID`) REFERENCES `INV_STOCKUNIT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGRECORD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点历史记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGRULE
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGRULE`;
CREATE TABLE `ICQA_STOCKTAKINGRULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '用户',
  `DECISION_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '值',
  `COMPARISON_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '比较值类型',
  `COMP_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '比较KEY',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `CATEGORYRULE_NAME_UK`(`NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点规则' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ICQA_STOCKTAKINGRULE
-- ----------------------------
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('6tfr4557-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.OPERATOR_OF_ANYDAY', 'ADMIN', '', 'DDL_USER', '-', '2018-03-16 11:12:17', 'ADMIN', '2018-03-16 11:12:24', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('6tfr4557-f327-11e6-8e32-0242ac110015', 'ICQA.ICQA_STOCKING_RULE.GT_OPERATE_TIMES_OF_ANYDAY', 'ADMIN', '', 'TEXT', '-', '2018-03-16 11:13:40', 'ADMIN', '2018-03-16 11:13:46', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('a97ae2ca-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.GT_OPERATE_TIMES_OF_ONE_WEEK', 'ADMIN', '5', 'TEXT', '-', '2017-02-15 02:37:15', 'ADMIN', '2017-02-15 02:37:15', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d30b4d1a-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.GT_OPERATE_TIMES_OF_TWO_WEEK', 'ADMIN', '14', 'TEXT', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d310db22-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.GT_OPERATE_TIMES_OF_THREE_WEEK', 'ADMIN', '21', 'TEXT', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d31a22f2-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.GT_OPERATE_TIMES_OF_ONE_MONTH', 'ADMIN', '30', 'TEXT', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d3252ac2-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.OPERATOR_OF_ONE_WEEK', 'ADMIN', '7', 'DDL_USER', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d32c2c0f-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.OPERATOR_OF_TWO_WEEK', 'ADMIN', '14', 'DDL_USER', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d333b0d7-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.OPERATOR_OF_THREE_WEEK', 'ADMIN', '21', 'DDL_USER', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d33ba3a8-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.OPERATOR_OF_ONE_MONTH', 'ADMIN', '30', 'DDL_USER', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);
INSERT INTO `ICQA_STOCKTAKINGRULE` VALUES ('d342d557-f327-11e6-8e32-0242ac110014', 'ICQA.ICQA_STOCKING_RULE.CREATED_BY_ZONE', 'ADMIN', '-', 'DDL_ZONE', '-', '2017-02-15 02:38:25', 'ADMIN', '2017-02-15 02:38:25', 'ADMIN', '-', 0, 0);

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGSTATION
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGSTATION`;
CREATE TABLE `ICQA_STOCKTAKINGSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `STOCKTAKINGSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKINGSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `ICQA_STOCKTAKINGSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ICQA_STOCKTAKINGSTATION
-- ----------------------------
INSERT INTO `ICQA_STOCKTAKINGSTATION` VALUES ('087230fd-eec7-4395-b153-cf8b514cd0eb', 'SQCBC001', NULL, 'f2b38e1f-282f-440e-a484-b6cde0a4b550', NULL, '3ba41fe1-6b95-4849-8e50-31995ade08b0', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:30:24', 'admin', '2019-12-18 06:30:24', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGSTATIONPOSITION`;
CREATE TABLE `ICQA_STOCKTAKINGSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKINGSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `ICQA_STOCKTAKINGSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGSTATIONTYPE`;
CREATE TABLE `ICQA_STOCKTAKINGSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATIONTYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `STOCKTAKINGSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `STOCKTAKINGSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKINGSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ICQA_STOCKTAKINGSTATIONTYPE
-- ----------------------------
INSERT INTO `ICQA_STOCKTAKINGSTATIONTYPE` VALUES ('f2b38e1f-282f-440e-a484-b6cde0a4b550', 'HLXNR-QST-BINCHECK', NULL, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '货位盘点', '2019-12-18 06:30:13', 'admin', '2019-12-18 06:30:13', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGSTATIONTYPEPOSITION`;
CREATE TABLE `ICQA_STOCKTAKINGSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOCKTAKINGTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STOCKTAKINGTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKINGTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `ICQA_STOCKTAKINGSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_STOCKTAKINGUSER
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_STOCKTAKINGUSER`;
CREATE TABLE `ICQA_STOCKTAKINGUSER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STOCKTAKING_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '日常盘点',
  `USER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '用户',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '货位',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `OPERATOR_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户状态',
  `ORDER_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '排序方式',
  `ORDER_INDEX` int(11) NULL DEFAULT NULL COMMENT '排序',
  `TIMES` int(11) NULL DEFAULT NULL COMMENT '时间',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SYSTEM_STOCKTAKING_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '系统盘点',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOCKTAKINGUSER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STOCKTAKINGUSER_STORAGELOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  INDEX `STOCKTAKINGUSER_USER_ID_FK`(`USER_ID`) USING BTREE,
  INDEX `STOCKTAKINGUSER_STOCKTAKING_ID_FK`(`STOCKTAKING_ID`) USING BTREE,
  CONSTRAINT `STOCKTAKINGUSER_STOCKTAKING_ID_FK` FOREIGN KEY (`STOCKTAKING_ID`) REFERENCES `ICQA_STOCKTAKING` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGUSER_STORAGELOCATION_ID_FK` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGUSER_USER_ID_FK` FOREIGN KEY (`USER_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKTAKINGUSER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '盘点用户权限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_SYSTEM_STOCKTAKING
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_SYSTEM_STOCKTAKING`;
CREATE TABLE `ICQA_SYSTEM_STOCKTAKING`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STOCK_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '盘点单号',
  `STOCK_TYPE` int(11) NOT NULL COMMENT '盘点方式',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `REMARK` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ZONE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '区域',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_SYSTEM_STOCKTAKINGORDER
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_SYSTEM_STOCKTAKINGORDER`;
CREATE TABLE `ICQA_SYSTEM_STOCKTAKINGORDER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AMONUT_SYSTEM` decimal(18, 2) NOT NULL COMMENT '系统数量',
  `AMONUT_CHECK` decimal(18, 2) NOT NULL COMMENT '实盘数量',
  `TIMES` int(11) NULL DEFAULT NULL COMMENT '第几轮盘点(1,2,3)',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `ITEMDATE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FROMLOCATION_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '位置名称',
  `FROMSTOCKUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自哪个库存',
  `STOCKTAKINGPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STOCKTAKING_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STOCK_INDEX` int(11) NULL DEFAULT 0 COMMENT '排序',
  `POD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '对应POD',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '对应操作人',
  `STOCKTAKING_TIME` timestamp(0) NULL DEFAULT NULL COMMENT '盘点时间',
  `STOCKTAKINGSTATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '对应盘点工作站',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PRODUCT_DATE` date NULL DEFAULT NULL COMMENT '生产日',
  `MATURITY_DATE` date NULL DEFAULT NULL COMMENT '到期日',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ICQA_SYSTEM_STOCKTAKINGPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `ICQA_SYSTEM_STOCKTAKINGPOSITION`;
CREATE TABLE `ICQA_SYSTEM_STOCKTAKINGPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '商品编码',
  `SKU_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SKU',
  `ITEM_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `LOCATION_CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '库位',
  `INVENTORY_STS` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '库存状态，ZP：正品、良品，CP：不良品、次品',
  `AMOUNT_SYSTEM_WMS` decimal(18, 2) NOT NULL COMMENT '牧星系统数量',
  `AMOUNT_SYSTEM_ANNTO` decimal(18, 2) NOT NULL COMMENT '美的系统数量',
  `AMOUNT_STOCKTAKING` decimal(18, 2) NULL DEFAULT NULL COMMENT '盘点数量',
  `OPERATOR` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `STARTED` timestamp(0) NULL DEFAULT NULL COMMENT '开始时间',
  `ENDED` timestamp(0) NULL DEFAULT NULL COMMENT '完成时间',
  `AMOUNT_ADJUST` decimal(18, 2) NULL DEFAULT NULL COMMENT '调整数量',
  `STOCKTAKING_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for INV_LOT
-- ----------------------------
DROP TABLE IF EXISTS `INV_LOT`;
CREATE TABLE `INV_LOT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `LOT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '有效期编号',
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `LOT_DATE` date NOT NULL COMMENT '创建时间',
  `PRODUCT_DATE` date NULL DEFAULT NULL COMMENT '生成日期',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `USE_NOT_AFTER` date NULL DEFAULT NULL COMMENT '到期日期',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `LOT_NO_UK`(`LOT_NO`, `ITEMDATA_ID`) USING BTREE,
  INDEX `LOT_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `LOT_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `LOT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `LOT_LOT_DATE_IX`(`LOT_DATE`) USING BTREE,
  INDEX `LOT_USE_NOT_AFTER_IX`(`USE_NOT_AFTER`) USING BTREE,
  CONSTRAINT `LOT_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `LOT_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `LOT_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '有效期' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for INV_LOTRECORD
-- ----------------------------
DROP TABLE IF EXISTS `INV_LOTRECORD`;
CREATE TABLE `INV_LOTRECORD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `ITEMDATA_ITEMNO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品ITEM_NO',
  `ITEMDATA_SKU` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品SKU',
  `ITEMDATA_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `FROM_STORAGELOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个容器',
  `AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '数量',
  `FROM_USE_NOT_AFTER` date NULL DEFAULT NULL COMMENT '原到期日期',
  `TO_USE_NOT_AFTER` date NULL DEFAULT NULL COMMENT '到期日期',
  `RECORD_TOOL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `LOTRECORD_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `LOTRECORD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `FK3aoa26s4wbyjhmkcuv9xko7mb` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `LOTRECORD_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `LOTRECORD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '有效期录入记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for INV_MEASURERECORD
-- ----------------------------
DROP TABLE IF EXISTS `INV_MEASURERECORD`;
CREATE TABLE `INV_MEASURERECORD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `ITEMDATA_ITEMNO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品ITEM_NO',
  `ITEMDATA_SKU` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品SKU',
  `ITEMDATA_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `FROM_STORAGELOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个容器',
  `FROM_HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '原高',
  `FROM_WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '原长',
  `FROM_DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '原宽',
  `FROM_WEIGHT` decimal(16, 3) NULL DEFAULT NULL COMMENT '原重量',
  `TO_HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '高',
  `TO_WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '长',
  `TO_DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '宽',
  `TO_WEIGHT` decimal(16, 3) NULL DEFAULT NULL COMMENT '重量',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `MEASURERECORD_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `MEASURERECORD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `MEASURERECORD_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `MEASURERECORD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '测量记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for INV_STOCKUNIT
-- ----------------------------
DROP TABLE IF EXISTS `INV_STOCKUNIT`;
CREATE TABLE `INV_STOCKUNIT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `AMOUNT` decimal(17, 4) NOT NULL COMMENT '数量',
  `RESERVED_AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '锁定数量',
  `SERIAL_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序列号',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `LOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期',
  `BATCH_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '外部批次号',
  `UNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '容器载具',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOCKUNIT_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `STOCKUNIT_LOT_ID_FK`(`LOT_ID`) USING BTREE,
  INDEX `STOCKUNIT_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `STOCKUNIT_UNITLOAD_ID_FK`(`UNITLOAD_ID`) USING BTREE,
  INDEX `STOCKUNIT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STOCKUNIT_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKUNIT_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKUNIT_LOT_ID_FK` FOREIGN KEY (`LOT_ID`) REFERENCES `INV_LOT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKUNIT_UNITLOAD_ID_FK` FOREIGN KEY (`UNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STOCKUNIT_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '库存' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of INV_STOCKUNIT
-- ----------------------------
INSERT INTO `INV_STOCKUNIT` VALUES ('0d7e963b-d6d0-48af-b513-4606e162b522', '2019-12-25 15:28:27', 'Test1', '2019-12-25 15:28:27', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '5d4f2a34-d731-4398-a7c2-93a265aaef2a', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('0e82025f-0ee4-4ebe-af3e-6b0998906c24', '2019-12-23 18:38:32', 'Test1', '2019-12-23 18:38:32', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, 'e99d559f-39c9-4721-979d-b46acc7b8b45', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('12375a17-0ee9-4514-8e47-29c21587a2bf', '2019-12-25 10:37:32', 'Test1', '2019-12-25 10:37:32', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, 'b161cc1c-bdff-4f9c-aa4f-d66be5dacf51', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('1e5242bc-0dd9-4c1b-b6b2-172e822f7693', '2020-01-15 16:33:02', 'Test1', '2020-01-15 16:33:02', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'Z4592-32050', NULL, NULL, '7ac2a2d5-e94d-419b-bebb-6eee3bcaa472', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('27cc5c29-c493-4fd3-835b-8d912958e0fe', '2019-12-20 11:32:57', 'SYSTEM', NULL, NULL, NULL, 0, 0, 50.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-2019-12-20', NULL, '', '5f3d7645-2fd7-4e2b-846b-6fab9f4698b9', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('379fd502-ab43-4850-b061-a5ab818be67c', '2020-01-15 16:36:11', 'Test1', '2020-01-15 16:36:11', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'Z4592-10016', NULL, NULL, 'aabd4684-acb4-4186-9fa5-e456d252e889', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('3c5830f8-6cd5-4c87-9730-672e6310d8d8', '2019-12-25 15:07:45', 'Test1', '2019-12-25 15:07:45', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '5fa3afb6-8a99-441a-8a01-d43bbf0d588f', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('42183a94-4c61-4bf1-b485-707c9fd4cf0c', '2020-01-15 15:01:27', 'Test1', '2020-01-15 15:01:27', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'Z4592-32050', NULL, NULL, '1397c243-15c9-4805-be2c-8a79898a6347', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('53515d87-5cc1-422c-8bfc-b2c7b5edb29f', '2019-12-25 10:01:52', 'Test1', '2019-12-25 10:01:52', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '1de4c45d-ce97-4fb7-bc52-9875eeeab085', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('53f263e1-c913-471d-b211-1eda8e747f4b', '2019-12-25 17:01:10', 'Test1', '2019-12-25 17:01:11', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '0603bb42-ea44-4009-9117-7b98c5a26140', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('842d6813-b207-48e3-8f33-47c03ee5fa06', '2019-12-25 16:54:41', 'Test1', '2019-12-25 16:54:42', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '3e153348-8dbd-4448-ab30-dec4c457a6b3', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('8b88c830-1109-4f8a-8f8f-29815062ddeb', '2019-12-25 10:26:06', 'Test1', '2019-12-25 10:26:06', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '2e0d1283-17f7-4a0d-8636-10e113c838f1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('8e274464-cb43-4755-af5c-7c7c13de2bf1', '2020-01-15 14:44:21', 'SYSTEM', '2020-01-15 16:33:02', 'Test1', NULL, 0, 12, 1997.0000, 0.0000, NULL, 'Inventory', 'Z4592-32050', NULL, '', '643b3c50-0704-4657-9393-15ef96e2c2c9', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('90776b5b-a89d-49df-b1bf-362b0f6a164f', '2019-12-25 15:01:32', 'Test1', '2019-12-25 15:01:32', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '138e5e2b-5dea-4340-8851-b6755ce68369', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('9ec54d86-8d3e-422c-931c-e8301da0897a', '2019-12-20 13:15:30', 'SYSTEM', NULL, NULL, NULL, 0, 0, 10.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-2020-12-17', NULL, '', 'e08db2e7-da3a-454b-a7da-2ddfe290e032', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('a28803a5-884b-45c5-bee0-72181f020737', '2019-12-24 15:55:04', 'Test1', '2019-12-24 15:55:04', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, 'b158dd45-d5f8-4f51-8532-a0003cb37f94', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('a49cba59-b683-4862-8d41-8b3da81ae400', '2019-12-20 11:07:58', 'SYSTEM', '2019-12-20 14:01:25', 'SYSTEM', NULL, 0, 0, 130.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-2019-12-18', NULL, '', 'ecdf713e-eea5-49a3-94c0-3fb74fa6a6d1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '2019-12-23 16:15:06', 'SYSTEM', '2019-12-25 17:01:10', 'Test1', NULL, 0, 43, 986.0000, 1.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, '', '14642e7d-7df8-4104-8fb6-feb4e002d5f1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('ad464569-96b4-4b16-9f84-94c08492c249', '2019-12-24 16:00:59', 'Test1', '2019-12-24 16:00:59', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, '344531e3-bcd1-4891-a4b3-7203002df839', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('b29ee6fa-9911-4212-9174-f002f466ccfa', '2019-12-25 11:17:22', 'Test1', '2019-12-25 11:17:22', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, 'e041c2f5-97ad-40dd-b832-fd05dc604cc1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('bb4495a1-262f-4e09-8a77-7c44f35e98f9', '2019-12-21 13:10:51', 'SYSTEM', '2019-12-23 16:05:15', 'system', NULL, 0, 4, 1332.0000, 4.0000, NULL, 'Inventory', 'ITEM-XNR-2020-01-11', NULL, '', '408ab20d-262c-4790-bd3f-cd683538a0a7', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('bbb9bf25-2d79-44e8-99e0-91e26bd7678d', '2019-12-25 13:39:50', 'Test1', '2019-12-25 13:39:50', 'Test1', NULL, 100, 2, 1.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, 'd725d4cf-2d69-4dc4-b223-da5037ec97aa', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('c4284b49-6636-467e-8059-e7222cf8360a', '2020-01-15 15:15:03', 'Test1', '2020-01-15 15:15:03', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'Z4592-32050', NULL, NULL, '2f815e86-932a-49ff-8e7f-fb827004c22c', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('c5daef6c-3170-475a-95b1-d2eb58b35c77', '2019-12-25 15:34:20', 'Test1', '2019-12-25 15:34:20', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-01', NULL, NULL, 'bcf84f67-85de-45fa-b392-daf3c03730eb', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('cf5728ab-b318-46db-b744-6a35ef860888', '2019-12-19 16:52:03', 'SYSTEM', '2019-12-20 11:26:58', 'SYSTEM', NULL, 0, 0, 160.0000, 0.0000, NULL, 'Inventory', 'ITEM-XNR-2019-12-19', NULL, '', '27db7678-c1e2-47c6-9b8e-321d53622bef', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('f679b92e-480d-41ed-a98e-6b1ef181e197', '2020-01-15 16:01:13', 'SYSTEM', '2020-01-15 16:36:11', 'Test1', NULL, 0, 3, 2000.0000, 0.0000, NULL, 'Inventory', 'Z4592-10016', NULL, '', '001bc687-cfbd-41f4-9ea4-056f4c9518ed', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_STOCKUNIT` VALUES ('f8e2370b-1545-40b0-8119-a5c0dd185e29', '2020-01-15 14:48:34', 'Test1', '2020-01-15 14:48:34', 'Test1', NULL, 100, 2, 0.0000, 0.0000, NULL, 'Inventory', 'Z4592-32050', NULL, NULL, 'd2dad799-2747-47a6-80ea-c391c853c312', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for INV_STOCKUNITRECORD
-- ----------------------------
DROP TABLE IF EXISTS `INV_STOCKUNITRECORD`;
CREATE TABLE `INV_STOCKUNITRECORD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `RECORD_CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作代码',
  `RECORD_TOOL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '操作工具',
  `RECORD_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '操作类型',
  `AMOUNT` decimal(17, 4) NULL DEFAULT NULL COMMENT '数量',
  `AMOUNT_STOCK` decimal(17, 4) NULL DEFAULT NULL COMMENT '历史数量',
  `FROM_STOCKUNIT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个库存',
  `FROM_UNITLOAD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个容器载具',
  `FROM_STORAGELOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个容器',
  `ITEMDATA_ITEMNO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品ITEM_NO',
  `ITEMDATA_SKU` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品SKU',
  `FROM_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '原始状态',
  `SERIAL_NUMBER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SN',
  `LOT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期编号',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作人USERNAME',
  `TO_STOCKUNIT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目标库存',
  `TO_UNITLOAD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目标载具',
  `TO_STORAGELOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目标容器',
  `ADJUSTREASON` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '调整原因',
  `THOSERESPONSIBLE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '责任人',
  `PROBLEMDESTINATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题描述',
  `ADJUSTANALYSISREASON` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ADJUSTANALYSIS` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TO_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目的状态',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `STOCKUNITRECORD_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `STOCKUNITRECORD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `idx_INV_STOCKUNITRECORD_ITEMDATA_ITEMNO`(`ITEMDATA_ITEMNO`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '库存历史记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of INV_STOCKUNITRECORD
-- ----------------------------
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('02487249-adab-4e09-8c1f-041628e0642c', '2019-12-25 10:37:32', 'Test1', '2019-12-25 10:37:32', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000012', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '12375a17-0ee9-4514-8e47-29c21587a2bf', '70598169601866609525', 'ZP008', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('0f1a5f7a-5e9f-4632-be4e-ff8b6fc56a0e', '2019-12-25 15:07:45', 'Test1', '2019-12-25 15:07:45', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000016', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '3c5830f8-6cd5-4c87-9730-672e6310d8d8', '24379037357090514824', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('12849983-933d-447f-aae2-f3d4676f68e8', '2020-01-15 14:48:34', 'Test1', '2020-01-15 14:48:34', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000021', 1.0000, 0.0000, '8e274464-cb43-4755-af5c-7c7c13de2bf1', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'P0000009AA01', 'Z4592-32050', '', 'Inventory', NULL, NULL, 'Test1', 'f8e2370b-1545-40b0-8119-a5c0dd185e29', '09333897833220403628', 'ZP025', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('180cafeb-befb-41a8-b354-2fa5d30afdf6', '2019-12-25 15:28:27', 'Test1', '2019-12-25 15:28:27', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000017', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '0d7e963b-d6d0-48af-b513-4606e162b522', '89761367201205171759', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('2a14c5ce-6308-4e9f-a587-59ca6ad4967b', '2019-12-22 14:53:36', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 666.0000, NULL, 'INBOUND-20191211-013', NULL, NULL, 'ITEM-XNR-2020-01-11', NULL, 'Inventory', NULL, NULL, 'Lisi', 'bb4495a1-262f-4e09-8a77-7c44f35e98f9', '408ab20d-262c-4790-bd3f-cd683538a0a7', 'P0000007AC01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('36f3fc8d-bd5a-48ae-834f-cf7775a0fc2a', '2019-12-24 16:00:59', 'Test1', '2019-12-24 16:00:59', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000008', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', 'ad464569-96b4-4b16-9f84-94c08492c249', '53387516702123413038', 'ZP003', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('39e4a79a-c4de-4cbf-8398-7ae0dab369a6', '2019-12-20 13:15:30', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 10.0000, NULL, 'INBOUND-2020-1205-0001', NULL, NULL, 'ITEM-XNR-2020-12-17', NULL, 'Inventory', NULL, NULL, 'Lisi', '9ec54d86-8d3e-422c-931c-e8301da0897a', 'e08db2e7-da3a-454b-a7da-2ddfe290e032', 'P0000010AF01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('3a39b3ac-17c9-4c8b-8d88-7b0049fcf214', '2020-01-15 15:59:31', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 1000.0000, NULL, 'BT202001150210', NULL, NULL, 'Z4592-32050', NULL, 'Inventory', NULL, NULL, 'Lisi', '8e274464-cb43-4755-af5c-7c7c13de2bf1', '643b3c50-0704-4657-9393-15ef96e2c2c9', 'P0000009AA01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('3bb8d357-4686-4e28-86fe-dbb9a85cfd30', '2019-12-21 13:10:51', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 666.0000, NULL, 'INBOUND-20191211-5554', NULL, NULL, 'ITEM-XNR-2020-01-11', NULL, 'Inventory', NULL, NULL, 'Lisi', 'bb4495a1-262f-4e09-8a77-7c44f35e98f9', '408ab20d-262c-4790-bd3f-cd683538a0a7', 'P0000007AC01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('3fb44a68-31eb-4bab-bcff-fcea395b8d8b', '2019-12-24 15:55:04', 'Test1', '2019-12-24 15:55:04', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000007', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', 'a28803a5-884b-45c5-bee0-72181f020737', '03078475503944947771', 'ZP010', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('47930d67-04b2-4f0d-8bcd-f6be1a019b23', '2019-12-25 17:01:11', 'Test1', '2019-12-25 17:01:11', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000020', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '53f263e1-c913-471d-b211-1eda8e747f4b', '42237536824597299908', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('5016007d-e408-4355-8e39-3f4ece475df9', '2019-12-25 16:54:42', 'Test1', '2019-12-25 16:54:42', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000019', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '842d6813-b207-48e3-8f33-47c03ee5fa06', '39210295808298124674', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('692dd7ad-c281-454c-9e07-b2ce727045f8', '2019-12-25 10:26:06', 'Test1', '2019-12-25 10:26:06', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000011', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '8b88c830-1109-4f8a-8f8f-29815062ddeb', '18086129163933680147', 'ZP007', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('6c9c46c7-f961-46ed-baad-8c53f6bd0043', '2020-01-15 15:15:03', 'Test1', '2020-01-15 15:15:03', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000023', 1.0000, 0.0000, '8e274464-cb43-4755-af5c-7c7c13de2bf1', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'P0000009AA01', 'Z4592-32050', '', 'Inventory', NULL, NULL, 'Test1', 'c4284b49-6636-467e-8059-e7222cf8360a', '51819747100054163130', 'ZP025', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('73d51108-3e1e-4654-afb6-dd898b6bacaf', '2020-01-15 16:01:13', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 2000.0000, NULL, 'BT202001150210', NULL, NULL, 'Z4592-10016', NULL, 'Inventory', NULL, NULL, 'Lisi', 'f679b92e-480d-41ed-a98e-6b1ef181e197', '001bc687-cfbd-41f4-9ea4-056f4c9518ed', 'P0000015AA01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('787f381e-eb84-480b-b758-0c8fcc081050', '2020-01-15 16:04:11', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 1000.0000, NULL, 'BT202001150110', NULL, NULL, 'Z4592-32050', NULL, 'Inventory', NULL, NULL, 'Lisi', '8e274464-cb43-4755-af5c-7c7c13de2bf1', '643b3c50-0704-4657-9393-15ef96e2c2c9', 'P0000009AA01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('7f1253fc-8330-45d3-a136-c10a1636b8e6', '2019-12-25 15:01:32', 'Test1', '2019-12-25 15:01:32', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000015', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '90776b5b-a89d-49df-b1bf-362b0f6a164f', '88781938148388472191', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('8a112468-0ccb-4922-9d93-5452e1f4f53b', '2019-12-25 13:39:50', 'Test1', '2019-12-25 13:39:50', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000014', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', 'bbb9bf25-2d79-44e8-99e0-91e26bd7678d', '76840746797230769816', 'ZP021', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('8e6577f6-61d6-46c5-bedb-7bfdd055d457', '2019-12-20 11:32:57', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 50.0000, NULL, 'INBOUND-20191205-0003', NULL, NULL, 'ITEM-XNR-2019-12-20', NULL, 'Inventory', NULL, NULL, 'Lisi', '27cc5c29-c493-4fd3-835b-8d912958e0fe', '5f3d7645-2fd7-4e2b-846b-6fab9f4698b9', 'P0000008CD01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('9308f193-9726-4a45-a006-93d9b823d673', '2020-01-15 15:01:27', 'Test1', '2020-01-15 15:01:27', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000022', 1.0000, 0.0000, '8e274464-cb43-4755-af5c-7c7c13de2bf1', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'P0000009AA01', 'Z4592-32050', '', 'Inventory', NULL, NULL, 'Test1', '42183a94-4c61-4bf1-b485-707c9fd4cf0c', '65651140903761420886', 'ZP025', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('a0711195-4b6f-4dc1-93de-600881ea8bee', '2019-12-25 10:01:52', 'Test1', '2019-12-25 10:01:52', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000010', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '53515d87-5cc1-422c-8bfc-b2c7b5edb29f', '53703378229265646971', 'ZP005', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('b48baac0-1a1b-4509-a68c-810613a485e8', '2019-12-23 16:15:06', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 1000.0000, NULL, 'INBOUND-test-01', NULL, NULL, 'ITEM-XNR-01', NULL, 'Inventory', NULL, NULL, 'Lisi', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '14642e7d-7df8-4104-8fb6-feb4e002d5f1', 'P0000016AD01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('ba37f491-a88b-4342-b008-9253f7a591fe', '2019-12-20 11:26:58', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 150.0000, NULL, 'INBOUND-20191205-0002', NULL, NULL, 'ITEM-XNR-2019-12-19', NULL, 'Inventory', NULL, NULL, 'Lisi', 'cf5728ab-b318-46db-b744-6a35ef860888', '27db7678-c1e2-47c6-9b8e-321d53622bef', 'P0000012AD01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('bf8cfb99-8a8a-41a1-aba3-e106cb9068cd', '2019-12-20 11:07:59', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 10.0000, NULL, 'INBOUND-20191205-0001', NULL, NULL, 'ITEM-XNR-2019-12-18', NULL, 'Inventory', NULL, NULL, 'Lisi', 'a49cba59-b683-4862-8d41-8b3da81ae400', 'ecdf713e-eea5-49a3-94c0-3fb74fa6a6d1', 'P0000013CC01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('c176a257-c9e8-4eef-b934-a22ee458decf', '2020-01-15 16:05:13', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 2000.0000, NULL, 'BT202001150110', NULL, NULL, 'Z4592-10016', NULL, 'Inventory', NULL, NULL, 'Lisi', 'f679b92e-480d-41ed-a98e-6b1ef181e197', '001bc687-cfbd-41f4-9ea4-056f4c9518ed', 'P0000015AA01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('c44ada4e-4334-46e7-b218-da7a7a8872ee', '2020-01-15 16:33:02', 'Test1', '2020-01-15 16:33:02', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000024', 1000.0000, 0.0000, '8e274464-cb43-4755-af5c-7c7c13de2bf1', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'P0000009AA01', 'Z4592-32050', '', 'Inventory', NULL, NULL, 'Test1', '1e5242bc-0dd9-4c1b-b6b2-172e822f7693', '42509260134479194416', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('c881759f-e153-4a86-bf25-abf7aed64b18', '2019-12-23 18:38:32', 'Test1', '2019-12-23 18:38:32', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000006', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', '0e82025f-0ee4-4ebe-af3e-6b0998906c24', '87632011700302111500', 'ZP002', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('cf94a9c4-6f53-4a6c-9a09-e71d0715c5d0', '2019-12-25 11:17:22', 'Test1', '2019-12-25 11:17:22', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000013', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', 'b29ee6fa-9911-4212-9174-f002f466ccfa', '90871575051251225147', 'ZP004', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('d0c6a4f3-95dd-4d84-8596-600dbeb30c1c', '2019-12-20 14:01:25', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 110.0000, NULL, 'INBOUND-20191205-0022', NULL, NULL, 'ITEM-XNR-2019-12-18', NULL, 'Inventory', NULL, NULL, 'Lisi', 'a49cba59-b683-4862-8d41-8b3da81ae400', 'ecdf713e-eea5-49a3-94c0-3fb74fa6a6d1', 'P0000013CC01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('d99dd2c8-92ef-4938-a074-90fcc270cd95', '2019-12-25 15:34:20', 'Test1', '2019-12-25 15:34:20', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000018', 1.0000, 0.0000, 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '52f828b5-6723-461f-b7e6-64d955e336d6', 'P0000016AD01', 'ITEM-XNR-01', '', 'Inventory', NULL, NULL, 'Test1', 'c5daef6c-3170-475a-95b1-d2eb58b35c77', '82601770265388184225', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('dc9e7432-991a-4057-958f-fefb438e0ff9', '2020-01-15 14:44:21', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 1000.0000, NULL, 'INBOUND-2020-1-15-345', NULL, NULL, 'Z4592-32050', NULL, 'Inventory', NULL, NULL, 'Lisi', '8e274464-cb43-4755-af5c-7c7c13de2bf1', '643b3c50-0704-4657-9393-15ef96e2c2c9', 'P0000009AA01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('f363e80b-cf45-40f5-bfbb-ec40fc4b76ae', '2020-01-15 16:36:11', 'Test1', '2020-01-15 16:36:11', 'Test1', NULL, 0, 0, 'M', 'Pick', 'PICK PICK-PICK000000025', 2000.0000, 0.0000, 'f679b92e-480d-41ed-a98e-6b1ef181e197', '98ee7f52-4a47-4f3b-bdb5-7ffc7abc4100', 'P0000015AA01', 'Z4592-10016', '', 'Inventory', NULL, NULL, 'Test1', '379fd502-ab43-4850-b061-a5ab818be67c', '55450198107287882235', 'ZP023', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 'Inventory');
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('f632bb86-378d-4ce0-b11b-c1047f3b44a5', '2019-12-19 16:52:03', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 10.0000, NULL, 'INBOUND-20191205-0001', NULL, NULL, 'ITEM-XNR-2019-12-19', NULL, 'Inventory', NULL, NULL, 'Lisi', 'cf5728ab-b318-46db-b744-6a35ef860888', '27db7678-c1e2-47c6-9b8e-321d53622bef', 'P0000012AD01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);
INSERT INTO `INV_STOCKUNITRECORD` VALUES ('fa0608d4-96f2-4a76-961c-7cba0861f9d7', '2019-12-20 13:58:25', 'SYSTEM', NULL, NULL, NULL, 0, 0, NULL, 'Receive', 'EACH_RECEIVE_TO_STOW', 10.0000, NULL, 'INBOUND-20191205-0011', NULL, NULL, 'ITEM-XNR-2019-12-18', NULL, 'Inventory', NULL, NULL, 'Lisi', 'a49cba59-b683-4862-8d41-8b3da81ae400', 'ecdf713e-eea5-49a3-94c0-3fb74fa6a6d1', 'P0000013CC01', NULL, NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', NULL, NULL);

-- ----------------------------
-- Table structure for INV_UNITLOAD
-- ----------------------------
DROP TABLE IF EXISTS `INV_UNITLOAD`;
CREATE TABLE `INV_UNITLOAD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `LABEL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '编号',
  `STOCKTAKING_DATE` timestamp(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后一次盘点日期',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '容器',
  `WEIGHT` decimal(16, 3) NULL DEFAULT 0.000 COMMENT '重量',
  `WEIGHT_CALCULATED` decimal(16, 3) NULL DEFAULT 0.000 COMMENT '计算重量',
  `WEIGHT_MEASURE` decimal(16, 3) NULL DEFAULT 0.000 COMMENT '测量重量',
  `LOCATION_INDEX` int(11) NOT NULL COMMENT '容器排序',
  `CARRIER` bit(1) NOT NULL COMMENT '承载容器',
  `STATION_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '当前绑定工作站',
  `CARRIERUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '承载载具',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `UNITLOAD_LABEL_UK`(`LABEL`) USING BTREE,
  INDEX `UNITLOAD_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `UNITLOAD_STORAGELOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  INDEX `UNITLOAD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `UNITLOAD_CARRIERUNITLOAD_ID_FK`(`CARRIERUNITLOAD_ID`) USING BTREE,
  CONSTRAINT `UNITLOAD_CARRIERUNITLOAD_ID_FK` FOREIGN KEY (`CARRIERUNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `UNITLOAD_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `UNITLOAD_STORAGEBIN_ID_FK` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `UNITLOAD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '载具' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of INV_UNITLOAD
-- ----------------------------
INSERT INTO `INV_UNITLOAD` VALUES ('001bc687-cfbd-41f4-9ea4-056f4c9518ed', '2020-01-15 15:54:33', 'SYSTEM', NULL, NULL, NULL, 0, 0, '98ee7f52-4a47-4f3b-bdb5-7ffc7abc4100', NULL, '0ada7c12-4f22-4e2e-bc5c-b546ad25ccdd', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('0603bb42-ea44-4009-9117-7b98c5a26140', '2019-12-25 17:01:02', 'Test1', '2019-12-25 17:01:11', 'Test1', NULL, 2, 1, '42237536824597299908', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('0859365f-2b6b-492e-9f5b-6ec99a7bd86a', '2019-12-21 14:58:37', 'Test1', '2019-12-21 15:01:58', 'Test1', NULL, 2, 1, '04143007831798319276', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('0af3dfe8-f0e5-4974-b51c-92d897586363', '2019-12-21 14:37:37', 'Test1', '2019-12-21 14:47:50', 'admin', NULL, 2, 1, '35759616757916694981', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('0cf1b1e7-e1f4-4660-aae7-c8ddb4464a8d', '2020-01-15 16:30:39', 'Test1', '2020-01-15 16:30:39', 'Test1', NULL, 0, 0, '74367364283363218263', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', 'sptt001', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('11ae31ff-9c74-4c8d-8fdb-c466b5dc9129', '2019-12-25 10:01:07', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 2, 1, '14371424968019713044', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('138e5e2b-5dea-4340-8851-b6755ce68369', '2019-12-25 15:01:17', 'Test1', '2019-12-25 15:02:03', 'Test1', NULL, 2, 1, '88781938148388472191', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('1397c243-15c9-4805-be2c-8a79898a6347', '2020-01-15 15:01:01', 'Test1', '2020-01-15 15:01:28', 'Test1', NULL, 2, 1, '65651140903761420886', NULL, '1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('14642e7d-7df8-4104-8fb6-feb4e002d5f1', '2019-12-21 17:31:56', 'SYSTEM', NULL, NULL, NULL, 0, 0, '52f828b5-6723-461f-b7e6-64d955e336d6', NULL, '08a1463e-9b81-48bf-b76f-5b80c006b310', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('14af0a1a-e2db-4695-a768-5e789bfe2586', '2019-12-22 10:08:00', 'Test1', '2019-12-22 10:19:04', 'Test1', NULL, 2, 1, '71655317571614427177', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('1d1ae38c-27f2-4812-b9fa-6296264c25e6', '2019-12-21 15:32:09', 'Test1', '2019-12-21 15:57:35', 'Test1', NULL, 2, 1, '96856254083331458167', NULL, '2d38a48e-8039-470c-9a02-2b4bf42d1428', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('1de4c45d-ce97-4fb7-bc52-9875eeeab085', '2019-12-25 10:01:32', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 1, '53703378229265646971', NULL, '2d38a48e-8039-470c-9a02-2b4bf42d1428', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('1e9aff6a-ee9b-462c-9289-3cdcb940db37', '2019-12-23 13:23:02', 'admin', '2019-12-23 13:37:49', 'admin', NULL, 2, 1, '50378794768066544637', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('1f6a0921-1674-409a-a3c2-c9363049f491', '2019-12-21 18:27:34', 'Test1', '2019-12-22 09:21:46', 'Test1', NULL, 2, 1, '13397315662856398676', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('21f85f33-f6d9-4ad3-806b-e8aa6299cbe8', '2019-12-23 13:50:20', 'Test1', '2019-12-23 14:21:29', 'Test1', NULL, 2, 1, '12554887563925700818', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('2701673b-1913-4410-b86b-162d0f570406', '2019-12-23 10:52:40', 'Test1', '2019-12-23 10:54:35', 'Test1', NULL, 2, 1, '57030236173903486084', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('27a5ff48-8970-4c19-b342-1f655ca6a3e3', '2019-12-22 09:48:44', 'Test1', '2019-12-22 09:57:03', 'Test1', NULL, 2, 1, '69380343375622197293', NULL, '2d38a48e-8039-470c-9a02-2b4bf42d1428', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('27db7678-c1e2-47c6-9b8e-321d53622bef', '2019-12-19 14:09:38', 'SYSTEM', NULL, NULL, NULL, 0, 0, '42befc86-cc65-442e-a34c-0d4195efe904', NULL, '02ac463c-7336-4d30-96fb-7c4fbad87476', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('2e0d1283-17f7-4a0d-8636-10e113c838f1', '2019-12-25 10:25:54', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 1, '18086129163933680147', NULL, 'b2680360-2708-41a6-981e-88119bddbb4f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('2e5129dd-29d4-46c1-bec6-b5b3449fa8b1', '2020-01-15 15:13:50', 'Test1', '2020-01-15 15:25:32', 'Test1', NULL, 2, 1, '38941563319571682689', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('2f815e86-932a-49ff-8e7f-fb827004c22c', '2020-01-15 15:14:21', 'Test1', '2020-01-15 15:15:03', 'Test1', NULL, 2, 1, '51819747100054163130', NULL, '1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('31b7b3fa-1fb6-4c3a-8477-0a9b31baf2d6', '2019-12-21 16:06:40', 'Test1', '2019-12-21 17:33:48', 'Test1', NULL, 2, 1, '40974286537467336905', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('344531e3-bcd1-4891-a4b3-7203002df839', '2019-12-24 15:59:56', 'Test1', '2019-12-24 16:03:42', 'Test1', NULL, 0, 1, '53387516702123413038', NULL, '229ac92d-ba1c-4d05-b8aa-e5f816707587', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('37f71287-b872-4466-b2b1-73f524c8d2fd', '2019-12-22 14:14:12', 'Test1', '2019-12-22 14:22:36', 'Test1', NULL, 2, 1, '26095336807431944871', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('3a0cdf70-90e5-4c34-b6c7-069af38c3525', '2019-12-21 14:49:29', 'admin', '2019-12-21 14:57:26', 'admin', NULL, 2, 1, '69586158987207841825', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('3a228aab-78e0-4846-924b-31f974d029d9', '2019-12-21 14:49:47', 'admin', '2019-12-21 14:57:26', 'admin', NULL, 2, 1, '51962925820055915900', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('3b5ae243-576a-489f-96fe-382c0b21ccb1', '2019-12-21 15:02:22', 'Test1', '2019-12-21 15:30:56', 'Test1', NULL, 2, 1, '84606161809957695125', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('3e153348-8dbd-4448-ab30-dec4c457a6b3', '2019-12-25 16:54:24', 'Test1', '2019-12-25 16:54:43', 'Test1', NULL, 2, 1, '39210295808298124674', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('408ab20d-262c-4790-bd3f-cd683538a0a7', '2019-12-21 13:09:26', 'SYSTEM', NULL, NULL, NULL, 0, 0, '1f1722d1-cb53-4508-be73-6fab5a9a0b75', NULL, '086d49fb-5cbe-43a3-baaa-d91ea652b121', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('4295a517-4ae0-4810-b889-8bfe6173761a', '2019-12-24 15:52:32', 'Test1', '2019-12-24 15:56:02', 'Test1', NULL, 2, 1, '38746228749256277514', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('435b851f-4d66-48f2-a594-cf97688db341', '2019-12-22 14:31:22', 'Test1', '2019-12-22 14:56:25', 'Test1', NULL, 2, 1, '27404991296949884646', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('4bd453e0-d470-4c24-82a6-e1c35b1de01b', '2019-12-22 10:08:12', 'Test1', '2019-12-22 10:19:04', 'Test1', NULL, 2, 1, '88440577752653716661', NULL, '229ac92d-ba1c-4d05-b8aa-e5f816707587', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('5272cb81-2199-4dd3-89ec-3160a7c5d53f', '2019-12-21 15:02:13', 'Test1', '2019-12-21 15:30:56', 'Test1', NULL, 2, 1, '57695801740260314043', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('5d4f2a34-d731-4398-a7c2-93a265aaef2a', '2019-12-25 15:18:10', 'Test1', '2019-12-25 15:28:34', 'Test1', NULL, 2, 1, '89761367201205171759', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('5e48ab52-26cb-4e0b-a371-7db8ad650660', '2019-12-22 09:58:43', 'Test1', '2019-12-22 10:00:10', 'Test1', NULL, 2, 1, '72102937509537214390', NULL, '5555cc65-024f-45a4-816c-4742c3f18e75', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('5f3d7645-2fd7-4e2b-846b-6fab9f4698b9', '2019-12-20 11:30:15', 'SYSTEM', NULL, NULL, NULL, 0, 0, 'f6652dff-c846-46da-af52-d28f90ec67b5', NULL, '04d06f62-733c-4e82-8550-f89bd5bf3b7c', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('5fa3afb6-8a99-441a-8a01-d43bbf0d588f', '2019-12-25 15:07:22', 'Test1', '2019-12-25 15:07:52', 'Test1', NULL, 2, 1, '24379037357090514824', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('601f91e6-9bc3-4009-82fe-2b0b31b5535d', '2019-12-23 10:52:55', 'Test1', '2019-12-23 10:54:35', 'Test1', NULL, 2, 1, '59222443925513903160', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('6378d72e-0d26-49ca-8e2a-66df9f4b241e', '2019-12-22 10:01:33', 'Test1', '2019-12-22 10:03:44', 'Test1', NULL, 2, 1, '76295423761169220886', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('63a9e0d7-0d26-49c3-a0cb-f0a58fb31ee1', '2019-12-22 12:16:59', 'Test1', '2019-12-22 13:59:13', 'Test1', NULL, 2, 1, '61876325480821757699', NULL, '5555cc65-024f-45a4-816c-4742c3f18e75', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('643b3c50-0704-4657-9393-15ef96e2c2c9', '2020-01-15 14:43:04', 'SYSTEM', NULL, NULL, NULL, 0, 0, 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', NULL, '09362668-b5ce-499f-99ef-2ed7cc566e5f', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('64d052b4-500a-4e25-91ea-6f401f53306e', '2019-12-21 14:34:46', 'Test1', '2019-12-21 14:37:27', 'Test1', NULL, 2, 1, '74771081649787119575', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('67e39a36-e390-4264-8a03-82dc63ac731d', '2019-12-20 17:13:46', 'admin', '2019-12-20 18:20:12', 'admin', NULL, 2, 1, '32108195769493811572', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('6b77e05a-9c51-4e19-bcec-05fee4bd1bb7', '2019-12-23 13:50:09', 'Test1', '2019-12-23 14:21:29', 'Test1', NULL, 2, 1, '21423113437143927211', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('6d39e3c1-202e-4540-bae5-dd3da821ab8b', '2019-12-23 16:06:14', 'admin', '2019-12-23 16:09:54', 'admin', NULL, 2, 1, '50014447663268804070', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('72892270-0b4a-4111-b303-52ce60cdeebc', '2019-12-22 15:00:21', 'Test1', '2019-12-22 15:01:08', 'Test1', NULL, 2, 1, '04949087543766373113', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('75b9c107-3cfd-4f10-a52e-167ea288fb03', '2019-12-21 14:58:24', 'Test1', '2019-12-21 15:01:58', 'Test1', NULL, 2, 1, '76442497345488579059', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('7ac2a2d5-e94d-419b-bebb-6eee3bcaa472', '2020-01-15 16:31:51', 'Test1', '2020-01-15 16:33:02', 'Test1', NULL, 2, 1, '42509260134479194416', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('7b80adde-dcbf-46a6-a2f1-7e04fd0493a1', '2019-12-23 13:38:42', 'Test1', '2019-12-23 13:47:50', 'Test1', NULL, 2, 1, '78107852835877697406', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('7bc930d5-2238-4c37-ba74-458eec7ee575', '2019-12-22 12:01:28', 'Test1', '2019-12-22 12:16:36', 'Test1', NULL, 2, 1, '98081667860891101878', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('7c68a76d-f7ba-4625-8290-1a52873c4cb4', '2019-12-22 11:55:53', 'Test1', '2019-12-22 12:00:28', 'Test1', NULL, 2, 1, '90823992729292191208', NULL, '699eff00-4ae9-4586-b0bb-002f0d3eb302', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('7ce186d6-d20c-403e-9826-7ef281ee4542', '2019-12-21 18:27:47', 'Test1', '2019-12-22 09:21:46', 'Test1', NULL, 2, 1, '81193361719928202477', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('7f4d4f5e-f5fb-4a55-a48d-5424ba79c575', '2019-12-24 15:58:14', 'Test1', '2019-12-24 16:09:30', 'Test1', NULL, 2, 1, '09460496562630703206', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('800a42fe-c5e9-417b-8c64-14db1abea165', '2019-12-20 18:21:16', 'Test1', '2019-12-21 14:34:36', 'Test1', NULL, 2, 1, '81208600416920611491', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('81927af4-8cdf-4271-af3d-2a79ab9e8a0c', '2020-01-15 14:46:29', 'Test1', '2020-01-15 15:01:46', 'Test1', NULL, 2, 1, '73460370343496030178', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('89479789-3783-45b6-8988-91e00d0697b4', '2019-12-23 13:38:31', 'Test1', '2019-12-23 13:47:50', 'Test1', NULL, 2, 1, '10232536245762237618', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('8ea7b42e-0318-47f9-bc95-e79d5765a2d6', '2019-12-22 14:56:38', 'Test1', '2019-12-22 14:58:13', 'Test1', NULL, 2, 1, '56107736136606017341', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('910c4e9d-8a7c-409e-b058-4ce7626c44db', '2019-12-23 16:18:22', 'Test1', '2019-12-23 18:40:16', 'Test1', NULL, 2, 1, '83846778159170705735', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('93a2bd29-875e-492c-807c-faf60fbd7b6e', '2019-12-23 15:20:58', 'admin', '2019-12-23 15:59:35', 'admin', NULL, 2, 1, '40737277664423051484', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('97e74d92-8206-4fab-bcfd-4d8c3d122101', '2019-12-24 15:58:20', 'Test1', '2019-12-24 16:09:30', 'Test1', NULL, 2, 1, '55967662690437281476', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('9d7a3863-a3fd-4df3-9ac2-4a64b4cfde12', '2019-12-22 09:22:04', 'Test1', '2019-12-22 09:48:20', 'Test1', NULL, 2, 1, '34176725141473469309', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('a985171b-5d81-4ca3-8384-d32cc2ffbc42', '2019-12-22 09:58:35', 'Test1', '2019-12-22 10:00:10', 'Test1', NULL, 2, 1, '22136535786757916961', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('aabd4684-acb4-4186-9fa5-e456d252e889', '2020-01-15 16:35:17', 'Test1', '2020-01-15 16:36:11', 'Test1', NULL, 2, 1, '55450198107287882235', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('b032b7b5-0a3b-4e8c-bf08-299142c961a7', '2019-12-21 16:06:21', 'Test1', '2019-12-21 17:33:48', 'Test1', NULL, 2, 1, '43369077751953016959', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('b158dd45-d5f8-4f51-8532-a0003cb37f94', '2019-12-24 15:54:36', 'Test1', '2019-12-24 15:56:02', 'Test1', NULL, 0, 1, '03078475503944947771', NULL, '56ae4338-f27f-4477-b8b4-50f131a00cb9', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('b161cc1c-bdff-4f9c-aa4f-d66be5dacf51', '2019-12-25 10:37:18', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 1, '70598169601866609525', NULL, 'ec0cbf17-fed2-4fd1-b2e3-30437fe68f0a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('b23f6506-0063-481f-9647-0fa0a7607430', '2020-01-15 15:13:38', 'Test1', '2020-01-15 15:25:32', 'Test1', NULL, 2, 1, '53213390406163289171', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('b3dacdd6-b1b5-4992-8e47-80940cc9c0eb', '2019-12-22 15:00:05', 'Test1', '2019-12-22 15:01:08', 'Test1', NULL, 2, 1, '66363796438017206779', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('b6701529-1e4d-44e8-9c2a-9660b89b542f', '2019-12-21 14:38:08', 'Test1', '2019-12-21 14:47:50', 'admin', NULL, 2, 1, '03827670004531018242', NULL, 'd942f0e5-0e6b-4119-92f3-9bcc8ca02cc8', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('bb6e567e-3bf4-4a55-bf9f-1d5b9fc2ff62', '2019-12-22 10:01:40', 'Test1', '2019-12-22 10:03:44', 'Test1', NULL, 2, 1, '46454928375727900029', NULL, 'b2680360-2708-41a6-981e-88119bddbb4f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('bcf84f67-85de-45fa-b392-daf3c03730eb', '2019-12-25 15:33:52', 'Test1', '2019-12-25 15:34:22', 'Test1', NULL, 2, 1, '82601770265388184225', NULL, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('bf250f95-cbbd-48fa-90b7-1a62b91d6b8b', '2019-12-22 14:56:47', 'Test1', '2019-12-22 14:58:13', 'Test1', NULL, 2, 1, '67039841849579799961', NULL, 'd942f0e5-0e6b-4119-92f3-9bcc8ca02cc8', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('c2410b62-e395-452b-9a6b-d350716cf80c', '2019-12-21 14:35:06', 'Test1', '2019-12-21 14:37:27', 'Test1', NULL, 2, 1, '39285527290088595826', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('c2d30ce4-154f-4e22-a331-7807a6dc3fcf', '2019-12-21 15:31:56', 'Test1', '2019-12-21 15:57:35', 'Test1', NULL, 2, 1, '24785202973551951540', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('c4cdc0a0-ac2e-4134-8690-9107ad4e9a17', '2019-12-23 16:06:25', 'admin', '2019-12-23 16:09:54', 'admin', NULL, 2, 1, '55834334103855047014', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('c5a60708-f14b-41f6-bd03-bd95ed8e9c7a', '2019-12-23 13:23:16', 'admin', '2019-12-23 13:37:49', 'admin', NULL, 2, 1, '34374480861756842022', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('d2dad799-2747-47a6-80ea-c391c853c312', '2020-01-15 14:47:41', 'Test1', '2020-01-15 14:48:34', 'Test1', NULL, 2, 1, '09333897833220403628', NULL, '1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('d725d4cf-2d69-4dc4-b223-da5037ec97aa', '2019-12-25 13:39:41', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 1, '76840746797230769816', NULL, '0946fa79-c0a3-470a-b307-7b58581dcef7', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('d7872fec-aa7d-45e2-be60-071482981907', '2019-12-25 10:01:01', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 2, 1, '19856898823709984672', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('d9c00bd7-4741-416d-a529-dab29e856350', '2019-12-24 15:52:25', 'Test1', '2019-12-24 15:56:02', 'Test1', NULL, 2, 1, '42869502395295546935', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('e041c2f5-97ad-40dd-b832-fd05dc604cc1', '2019-12-25 11:17:13', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 1, '90871575051251225147', NULL, 'd942f0e5-0e6b-4119-92f3-9bcc8ca02cc8', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('e08db2e7-da3a-454b-a7da-2ddfe290e032', '2019-12-20 13:13:15', 'SYSTEM', NULL, NULL, NULL, 0, 0, 'ee63ed6f-0f36-46e7-bf25-548814edbf83', NULL, '057cb24b-b0e0-473b-985b-4f213fef88bc', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('e19ecf62-fe48-461a-ab2c-d399a3b3b6cc', '2019-12-22 12:16:46', 'Test1', '2019-12-22 13:59:13', 'Test1', NULL, 2, 1, '51037041914323121512', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('e75be860-6490-4166-87cc-1868456837dd', '2020-01-15 16:31:37', 'Test1', '2020-01-15 16:31:37', 'Test1', NULL, 0, 0, '86260588702122116378', NULL, '1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 0.000, 0.000, 0.000, -1, b'0', 'sptt001', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('e91a7b0e-776a-4359-8c60-53e4dafb9034', '2019-12-25 14:59:13', 'Test1', '2019-12-25 17:02:56', 'Test1', NULL, 2, 1, '01376171519342203989', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('e99d559f-39c9-4721-979d-b46acc7b8b45', '2019-12-23 17:02:33', 'Test1', '2019-12-23 18:40:16', 'Test1', NULL, 0, 1, '87632011700302111500', NULL, '1950884c-8892-4957-9193-46b27fcfebc1', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('eaa4886f-1828-4826-a423-dadd7e1af64f', '2019-12-25 14:59:23', 'Test1', '2019-12-25 17:02:56', 'Test1', NULL, 2, 1, '32331980959329654012', NULL, '909c3063-10ab-42f2-a45c-c72791e93ba8', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('eaca4704-40ca-4dc3-9953-59a964f642df', '2019-12-22 11:55:44', 'Test1', '2019-12-22 12:00:28', 'Test1', NULL, 2, 1, '79575755699807094946', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('eae11f40-35a6-4a55-a098-c1ab72e197bf', '2019-12-23 16:18:07', 'Test1', '2019-12-23 18:40:16', 'Test1', NULL, 2, 1, '59977591595865523774', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('ecdf713e-eea5-49a3-94c0-3fb74fa6a6d1', '2019-12-19 18:19:56', 'SYSTEM', NULL, NULL, NULL, 0, 0, '66b7811e-52f2-4156-adb7-1decc5817d16', NULL, '047c5460-6c81-4daf-b9b7-9758a77cbe2a', 0.000, 0.000, 0.000, 1, b'0', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('ee36ca4e-b982-4fde-b785-bf110c89c044', '2019-12-22 14:14:22', 'Test1', '2019-12-22 14:22:36', 'Test1', NULL, 2, 1, '44639882654213294300', NULL, 'd942f0e5-0e6b-4119-92f3-9bcc8ca02cc8', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('efe1a8bb-0523-4a1c-a6eb-5a0ee87824c4', '2019-12-22 12:01:41', 'Test1', '2019-12-22 12:16:36', 'Test1', NULL, 2, 1, '49805058417714353097', NULL, 'b2680360-2708-41a6-981e-88119bddbb4f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('f087c786-e06e-466a-aee7-4d4c9d70d945', '2020-01-15 14:46:41', 'Test1', '2020-01-15 15:01:46', 'Test1', NULL, 2, 1, '89010830045846979089', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('fb51bbb2-acf2-45df-ad6f-2ca3ba7cbf49', '2019-12-22 14:31:54', 'Test1', '2019-12-22 14:56:25', 'Test1', NULL, 2, 1, '66521120641840282989', NULL, 'd942f0e5-0e6b-4119-92f3-9bcc8ca02cc8', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('fc6874eb-789b-4358-8269-a6213ef52e78', '2019-12-22 09:21:53', 'Test1', '2019-12-22 09:48:20', 'Test1', NULL, 2, 1, '38971186367876570180', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('fd7c8464-5947-441b-b730-73f13aa48775', '2019-12-22 09:48:31', 'Test1', '2019-12-22 09:57:03', 'Test1', NULL, 2, 1, '65821993411988463628', NULL, '716edc4d-4655-41ff-b38b-a4e51727453f', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `INV_UNITLOAD` VALUES ('ff3315d1-1557-47a3-8e1e-8c1585da7062', '2019-12-20 18:22:29', 'Test1', '2019-12-21 14:34:36', 'Test1', NULL, 2, 1, '95189771755933191838', NULL, 'cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 0.000, 0.000, 0.000, -1, b'0', NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');

-- ----------------------------
-- Table structure for INV_UNITLOAD_SHIPMENT
-- ----------------------------
DROP TABLE IF EXISTS `INV_UNITLOAD_SHIPMENT`;
CREATE TABLE `INV_UNITLOAD_SHIPMENT`  (
  `UNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  INDEX `UNITLOAD_SHIPMENT_UNITLOAD_ID_FK`(`UNITLOAD_ID`) USING BTREE,
  INDEX `UNITLOAD_SHIPMENT_SHIPMENT_ID_FK`(`SHIPMENT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '载具里的Shipment' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of INV_UNITLOAD_SHIPMENT
-- ----------------------------
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('e99d559f-39c9-4721-979d-b46acc7b8b45', 'b206e066-01d3-41e7-b4b0-4c76a2298659');
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('b158dd45-d5f8-4f51-8532-a0003cb37f94', '2826cebc-085e-4b39-bf67-77841bdbc215');
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('344531e3-bcd1-4891-a4b3-7203002df839', 'd1c2e784-3934-40cc-afdc-934b472584d0');
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('1de4c45d-ce97-4fb7-bc52-9875eeeab085', 'f6785774-cbb3-464b-a9d0-bd12a34e41b6');
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('2e0d1283-17f7-4a0d-8636-10e113c838f1', 'e6547f74-91fc-4131-9cd4-10c16424d883');
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('b161cc1c-bdff-4f9c-aa4f-d66be5dacf51', '129beb35-1699-4daa-8fb5-068f34654c03');
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('e041c2f5-97ad-40dd-b832-fd05dc604cc1', 'ca8fc06c-07b7-4b65-be5e-63a9ce229207');
INSERT INTO `INV_UNITLOAD_SHIPMENT` VALUES ('d725d4cf-2d69-4dc4-b223-da5037ec97aa', 'b940abe1-2bd9-4cd3-b47e-a6e15481e0d7');

-- ----------------------------
-- Table structure for MD_AREA
-- ----------------------------
DROP TABLE IF EXISTS `MD_AREA`;
CREATE TABLE `MD_AREA`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `USE_FOR_GOODSIN` bit(1) NOT NULL COMMENT '收货',
  `USE_FOR_GOODSOUT` bit(1) NOT NULL COMMENT '出货',
  `USE_FOR_PICKING` bit(1) NOT NULL COMMENT '拣货',
  `USE_FOR_REPLENISH` bit(1) NOT NULL COMMENT '补货',
  `USE_FOR_STORAGE` bit(1) NOT NULL COMMENT '存储',
  `USE_FOR_TRANSFER` bit(1) NOT NULL COMMENT '移货',
  `USE_FOR_RETURN` bit(1) NOT NULL COMMENT '返厂',
  `USE_FOR_TRANSPORT` bit(1) NOT NULL COMMENT '调拨',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `AREA_NAME_UK`(`NAME`, `CLIENT_ID`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `AREA_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `AREA_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `AREA_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `AREA_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '功能区' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_AREA
-- ----------------------------
INSERT INTO `MD_AREA` VALUES ('39ec027d-f21f-4e26-b356-33d49cf19032', 'PickingZone', NULL, b'0', b'0', b'1', b'0', b'0', b'0', b'0', b'0', 'SYSTEM', 'DEFAULT', 0, '2019-12-18 03:05:06', 'admin', 'admin', '2019-12-18 03:05:06', NULL, 0);
INSERT INTO `MD_AREA` VALUES ('e951cba0-0ac1-4a05-bfc6-f7834398fa2f', 'PickingZone', NULL, b'0', b'0', b'1', b'0', b'0', b'0', b'0', b'0', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, '2019-12-18 06:06:15', 'admin', 'admin', '2019-12-18 06:06:15', NULL, 0);

-- ----------------------------
-- Table structure for MD_BATTERCONFIG
-- ----------------------------
DROP TABLE IF EXISTS `MD_BATTERCONFIG`;
CREATE TABLE `MD_BATTERCONFIG`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '电池配置表述',
  `END_NUMBER` decimal(11, 2) NOT NULL COMMENT '电池电量末尾配置值',
  `START_NUMBER` decimal(11, 2) NOT NULL COMMENT '电池电量起始配置值',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '电池配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_BAY
-- ----------------------------
DROP TABLE IF EXISTS `MD_BAY`;
CREATE TABLE `MD_BAY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `AISLE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BAY_INDEX` int(11) NOT NULL,
  `PODTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `BAY_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `BAY_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `BAY_PODTYPE_ID_FK`(`PODTYPE_ID`) USING BTREE,
  CONSTRAINT `MD_BAY_CLIENT_3` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `MD_BAY_PODTYPE_1` FOREIGN KEY (`PODTYPE_ID`) REFERENCES `MD_PODTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `MD_BAY_WAREHOUSE_4` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用于报告暗灯和解决暗灯' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_BOXNO
-- ----------------------------
DROP TABLE IF EXISTS `MD_BOXNO`;
CREATE TABLE `MD_BOXNO`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BOX_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `BOX_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `BOX_WAREHOUSE_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '箱码' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_BOXNO_SERIALNUMBER
-- ----------------------------
DROP TABLE IF EXISTS `MD_BOXNO_SERIALNUMBER`;
CREATE TABLE `MD_BOXNO_SERIALNUMBER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BOX_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SERIAL_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `SERIAL_BOX_ID_FK`(`BOX_ID`) USING BTREE,
  CONSTRAINT `SERIAL_BOX_ID_FK` FOREIGN KEY (`BOX_ID`) REFERENCES `MD_BOXNO` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '箱码序列号' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_BOXNO_STOCKUNIT
-- ----------------------------
DROP TABLE IF EXISTS `MD_BOXNO_STOCKUNIT`;
CREATE TABLE `MD_BOXNO_STOCKUNIT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BOX_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AMOUNT` decimal(17, 0) NULL DEFAULT NULL,
  `LOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `BOX_STOCKUNIT_BOXNO_ID_FK`(`BOX_ID`) USING BTREE,
  CONSTRAINT `BOX_STOCKUNIT_BOXNO_ID_FK` FOREIGN KEY (`BOX_ID`) REFERENCES `MD_BOXNO` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '箱码' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_CHARGER
-- ----------------------------
DROP TABLE IF EXISTS `MD_CHARGER`;
CREATE TABLE `MD_CHARGER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PLACEMARK` int(11) NULL DEFAULT NULL COMMENT '当前地标',
  `TOWARD` int(11) NULL DEFAULT NULL COMMENT '朝向',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态（Available,Error）',
  `CHARGER_TYPE` int(2) NULL DEFAULT 1 COMMENT '充电桩类型，默认是1(牧星使用)',
  `CHARGER_ID` int(6) NULL DEFAULT 0,
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地图区域ID',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `CHARGER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `CHARGER_SECTION_ID_FK`(`SECTION_ID`) USING BTREE,
  CONSTRAINT `CHARGER_SECTION_ID_FK` FOREIGN KEY (`SECTION_ID`) REFERENCES `WD_SECTION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CHARGER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '充电桩详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_DROPZONE
-- ----------------------------
DROP TABLE IF EXISTS `MD_DROPZONE`;
CREATE TABLE `MD_DROPZONE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `STANDARD_TIME` decimal(15, 2) NOT NULL COMMENT '标准时间',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `DROPZONE_NAME_UK`(`WAREHOUSE_ID`, `NAME`) USING BTREE,
  INDEX `DROPZONE_WAREHOUSE_ID_FK_idx`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `DROPZONE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'DropZone' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_DROPZONE
-- ----------------------------
INSERT INTO `MD_DROPZONE` VALUES ('2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'BT01', NULL, 10.00, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, '2019-12-18 06:47:45', 'admin', '2019-12-18 06:47:45', 'admin', NULL, 0);
INSERT INTO `MD_DROPZONE` VALUES ('e3bf5372-790b-4970-959c-2cb0ed24c230', 'Container', NULL, 10.00, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, '2019-12-18 06:04:19', 'admin', '2019-12-18 06:04:19', 'admin', NULL, 0);

-- ----------------------------
-- Table structure for MD_HARDWARE
-- ----------------------------
DROP TABLE IF EXISTS `MD_HARDWARE`;
CREATE TABLE `MD_HARDWARE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `IP_ADDRESS` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'IP地址',
  `PORT_NUMBER` int(11) NULL DEFAULT NULL COMMENT '端口',
  `HARDWARE_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '打印机  称重机  测量机  固定扫描枪',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `HARDWARE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `HARDWARE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '硬件配置信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_HARDWARE_WORKSTATION
-- ----------------------------
DROP TABLE IF EXISTS `MD_HARDWARE_WORKSTATION`;
CREATE TABLE `MD_HARDWARE_WORKSTATION`  (
  `HARDWARE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  INDEX `HARDWARE_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  INDEX `HARDWARE_HARDWARE_ID_FK`(`HARDWARE_ID`) USING BTREE,
  CONSTRAINT `HARDWARE_HARDWARE_ID_FK` FOREIGN KEY (`HARDWARE_ID`) REFERENCES `MD_HARDWARE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `HARDWARE_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '硬件与物理工作站绑定关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ITEMDATA
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA`;
CREATE TABLE `MD_ITEMDATA`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '唯一编码',
  `SKU_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'SKU',
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `SAFETY_STOCK` int(11) NOT NULL COMMENT '安全库存',
  `LOT_MANDATORY` bit(1) NOT NULL COMMENT '是否有效期商品',
  `LOT_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品有效期输入类型可选择，是按照生产日期输入还是到期日期输入',
  `LOT_UNIT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品的有效期的单位可以确认，是年，月还是日',
  `LOT_THRESHOLD` int(11) NULL DEFAULT NULL COMMENT '收货商品到期时间距离当前时间小于多少天直接显示拒收',
  `SERIAL_REGULAR` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序列号规则',
  `SERIAL_RECORD_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品的序列号码有规则的设置',
  `SERIAL_RECORD_LENGTH` int(11) NULL DEFAULT NULL COMMENT '商品的序列号码有长度',
  `HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '宽',
  `ITEMPICTURE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品图片地址',
  `PICTURENAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片名称',
  `VOLUME` decimal(28, 6) NULL DEFAULT NULL COMMENT '体积',
  `WEIGHT` decimal(16, 3) NULL DEFAULT NULL COMMENT '重量',
  `MULTIPLE_PART` bit(1) NOT NULL COMMENT '是否一套',
  `MULTIPLE_PART_AMOUNT` int(11) NOT NULL COMMENT '几套几件',
  `MEASURED` bit(1) NOT NULL COMMENT '是否测量',
  `PREFER_OWNBOX` bit(1) NOT NULL COMMENT '是否自带包装',
  `PREFER_BAG` bit(1) NOT NULL COMMENT '是否用袋子',
  `USE_BUBBLEFILM` bit(1) NOT NULL COMMENT '是否使用气垫膜',
  `ITEMSELLINGDEGREE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '热销度',
  `ITEMGROUP_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品类型',
  `HANDLINGUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品单位',
  `ITEMDATAGLOBAL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '商品GLOBAL',
  `STATE` int(11) NULL DEFAULT NULL,
  `SHELFLIFE` int(10) NULL DEFAULT 0 COMMENT '商品的有效期时间',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SIZE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `AMOUNT_OF_BOX` int(11) NULL DEFAULT 0,
  `COLOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ITEMDATA_ITEMDATAGLOBAL_ID_FK`(`ITEMDATAGLOBAL_ID`) USING BTREE,
  INDEX `ITEMDATA_HANDLINGUNIT_ID_FK`(`HANDLINGUNIT_ID`) USING BTREE,
  INDEX `ITEMDATA_ITEMGROUP_ID_FK`(`ITEMGROUP_ID`) USING BTREE,
  INDEX `IDX_MD_ITEMDATA_ITEMNO`(`ITEM_NO`) USING BTREE,
  CONSTRAINT `ITEMDATA_HANDLINGUNIT_ID_FK` FOREIGN KEY (`HANDLINGUNIT_ID`) REFERENCES `MD_ITEMUNIT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ITEMDATA_ITEMGROUP_ID_FK` FOREIGN KEY (`ITEMGROUP_ID`) REFERENCES `MD_ITEMGROUP` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_ITEMDATA
-- ----------------------------
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-01', 'ITEM-XNR-01', '', '现场上架测试物料', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2019-12-23 16:12:22', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-2019-12-18', 'ITEM-XNR-2019-12-18', '', '小内燃测试物料1', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2019-12-19 10:58:20', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-2019-12-19', 'ITEM-XNR-2019-12-19', '', '小内燃测试物料3', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, 'SYSTEM', '2019-12-19 10:54:11', 'SYSTEM', '2019-12-19 10:53:46', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-2019-12-20', 'ITEM-XNR-2019-12-20', '', '小内燃测试物料2', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2019-12-19 10:58:08', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-2020-01-11', 'ITEM-XNR-2020-01-11', '', '合力小内燃现场测试物料3', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, 'SYSTEM', '2019-12-21 13:06:56', 'SYSTEM', '2019-12-21 13:06:02', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-2020-12-17', 'ITEM-XNR-2020-12-17', '', '小内燃现场测试物料1', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2019-12-20 13:11:34', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-2020-12-18', 'ITEM-XNR-2020-12-18', '', '小内燃现场测试物料2', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2019-12-20 13:11:48', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('ITEM-XNR-2020-12-19', 'ITEM-XNR-2020-12-19', '', '小内燃现场测试物料3', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 100.00, 100.00, 100.00, NULL, NULL, NULL, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2019-12-20 13:11:59', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('Z4592-10016', 'Z4592-10016', '', '德式喉箍10~16', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 0.00, 0.00, 0.00, NULL, NULL, 0.000000, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2020-01-15 15:44:24', NULL, 0, 0, NULL);
INSERT INTO `MD_ITEMDATA` VALUES ('Z4592-32050', 'Z4592-32050', '', '1', NULL, 0, b'0', NULL, NULL, 0, NULL, 'NO_RECORD', 0, 0.00, 0.00, 0.00, NULL, NULL, 0.000000, 0.000, b'0', 0, b'1', b'0', b'0', b'0', NULL, 'fd335ce3-1b83-4819-81d9-34f8aa5a2139', 'd7599399-3da6-478c-b14d-60e6be6ef11e', '', NULL, 0, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, 0, NULL, NULL, 'SYSTEM', '2020-01-15 14:41:34', NULL, 0, 0, NULL);

-- ----------------------------
-- Table structure for MD_ITEMDATA_EXCLUSION
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA_EXCLUSION`;
CREATE TABLE `MD_ITEMDATA_EXCLUSION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ITEMGROUP_NAME_UK`(`NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品分类' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ITEMDATA_EXCLUSIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA_EXCLUSIONPOSITION`;
CREATE TABLE `MD_ITEMDATA_EXCLUSIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `EXCLUSION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` datetime(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL,
  `MODIFIED_DATE` datetime(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL,
  `ENTITY_LOCK` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL,
  `VERSION` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ITEMDATA_CATEGORY_FK_ITEMDATA_ID`(`ITEMDATA_ID`) USING BTREE,
  INDEX `ITEMDATA_EXCLUSION_FK_EXCLUSION_ID`(`EXCLUSION_ID`) USING BTREE,
  CONSTRAINT `ITEMDATA_EXCLUSION_FK_EXCLUSION_ID` FOREIGN KEY (`EXCLUSION_ID`) REFERENCES `MD_ITEMDATA_EXCLUSION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ITEMDATA_EXCLUSION_FK_ITEMDATA_ID` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ITEMDATA_GLOBAL
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA_GLOBAL`;
CREATE TABLE `MD_ITEMDATA_GLOBAL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SKU_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SAFETY_STOCK` int(11) NOT NULL,
  `LOT_MANDATORY` bit(1) NOT NULL,
  `LOT_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOT_UNIT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LOT_THRESHOLD` int(11) NULL DEFAULT NULL,
  `SERIAL_REGULAR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品序列号判断规则',
  `SERIAL_RECORD_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SERIAL_RECORD_LENGTH` int(11) NULL DEFAULT NULL,
  `HEIGHT` decimal(15, 2) NULL DEFAULT NULL,
  `WIDTH` decimal(15, 2) NULL DEFAULT NULL,
  `DEPTH` decimal(15, 2) NULL DEFAULT NULL,
  `ITEMPICTURE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '商品图片地址',
  `PICTURENAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '图片名称',
  `VOLUME` decimal(28, 6) NULL DEFAULT NULL,
  `WEIGHT` decimal(16, 3) NULL DEFAULT NULL,
  `MULTIPLE_PART` bit(1) NOT NULL,
  `MULTIPLE_PART_AMOUNT` int(11) NOT NULL,
  `MEASURED` bit(1) NOT NULL,
  `PREFER_OWNBOX` bit(1) NOT NULL,
  `PREFER_BAG` bit(1) NOT NULL,
  `USE_BUBBLEFILM` bit(1) NOT NULL,
  `ITEMGROUP_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `HANDLINGUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SIZE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SHELFLIFE` int(11) NOT NULL DEFAULT 0 COMMENT '商品有效期，单位天',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ITEMDATAGLOBAL_HANDLINGUNIT_ID_FK`(`HANDLINGUNIT_ID`) USING BTREE,
  INDEX `ITEMDATAGLOBAL_ITEMGROUP_ID_FK`(`ITEMGROUP_ID`) USING BTREE,
  CONSTRAINT `ITEMDATAGLOBAL_HANDLINGUNIT_ID_FK` FOREIGN KEY (`HANDLINGUNIT_ID`) REFERENCES `MD_ITEMUNIT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ITEMDATAGLOBAL_ITEMGROUP_ID_FK` FOREIGN KEY (`ITEMGROUP_ID`) REFERENCES `MD_ITEMGROUP` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品基础' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ITEMDATA_HOT
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA_HOT`;
CREATE TABLE `MD_ITEMDATA_HOT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEMSELLINGDEGREE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '热销度',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ITEMDATAHOT_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `ITEMDATAHOT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `ITEMDATAHOT_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ITEMDATAHOT_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品热度' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ITEMDATA_HOTHISTORY
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA_HOTHISTORY`;
CREATE TABLE `MD_ITEMDATA_HOTHISTORY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEMSELLINGDEGREE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '热销度',
  `HOT_VERSION` bigint(13) NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ITEMDATA_SERIALNUMBER
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA_SERIALNUMBER`;
CREATE TABLE `MD_ITEMDATA_SERIALNUMBER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '商品',
  `SERIAL_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'SN',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '商品SN' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ITEMDATA_SKUNO
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMDATA_SKUNO`;
CREATE TABLE `MD_ITEMDATA_SKUNO`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品编码',
  `SKU_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品条码',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NULL DEFAULT NULL COMMENT '版本号',
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` datetime(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` datetime(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IDX_MIS_SKUNO`(`SKU_NO`) USING BTREE,
  INDEX `IDX_MIS_ITEMDATANO`(`ITEM_NO`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_ITEMDATA_SKUNO
-- ----------------------------
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('082a6f90-2d46-4868-bcd9-a459e556a8c2', 'ITEM-XNR-2020-12-17', 'ITEM-XNR-2020-12-17', '1001', 0, NULL, NULL, 'SYSTEM', '2019-12-20 13:11:34', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('27ba366c-d0a9-4103-a839-acc6951a0de3', 'ITEM-XNR-2019-12-20', 'ITEM-XNR-2019-12-20', '1001', 0, NULL, NULL, 'SYSTEM', '2019-12-19 10:58:08', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('31159d69-94fa-4e71-be3c-3d6fc24da798', '1001', '1001', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 0, 'admin', '2019-12-18 08:29:36', 'admin', '2019-12-18 08:29:36', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('31442d77-28c0-49b1-a426-ac95a79fb79a', 'Z4592-10016', 'Z4592-10016', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 0, NULL, NULL, 'SYSTEM', '2020-01-15 15:44:24', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('5e8cce5d-fe8f-49a6-bc29-3ad2adfb1b76', 'ITEM-XNR-2019-12-18', 'ITEM-XNR-2019-12-18', '1001', 0, NULL, NULL, 'SYSTEM', '2019-12-19 10:58:20', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('a1b83ad9-58b3-4cc8-9735-469be28bbf42', 'ITEM-XNR-2020-01-11', 'ITEM-XNR-2020-01-11', '1001', 0, NULL, NULL, 'SYSTEM', '2019-12-21 13:06:02', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('a5168825-f352-4c8c-a22b-7eb7cce7c622', 'ITEM-XNR-2019-12-19', 'ITEM-XNR-2019-12-19', '1001', 0, NULL, NULL, 'SYSTEM', '2019-12-19 10:53:46', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('b2258c24-5c8e-46b1-b5ac-12291dfb0300', 'ITEM-XNR-2020-12-19', 'ITEM-XNR-2020-12-19', '1001', 0, NULL, NULL, 'SYSTEM', '2019-12-20 13:11:59', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('b492b7eb-9467-4132-b3ee-544171f57ffc', 'ITEM-XNR-01', 'ITEM-XNR-01', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 0, NULL, NULL, 'SYSTEM', '2019-12-23 16:12:23', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('dafc0b0b-a5f4-46ae-8b7e-ff29b0cc124f', 'Z4592-32050', 'Z4592-32050', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 0, NULL, NULL, 'SYSTEM', '2020-01-15 14:41:34', NULL, 0);
INSERT INTO `MD_ITEMDATA_SKUNO` VALUES ('e9e78e38-9762-4a97-a9bd-4e8d4fdb1421', 'ITEM-XNR-2020-12-18', 'ITEM-XNR-2020-12-18', '1001', 0, NULL, NULL, 'SYSTEM', '2019-12-20 13:11:48', NULL, 0);

-- ----------------------------
-- Table structure for MD_ITEMGROUP
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMGROUP`;
CREATE TABLE `MD_ITEMGROUP`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
  `PARENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属分组',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ITEMGROUP_NAME_UK`(`NAME`) USING BTREE,
  INDEX `ITEMGROUP_ITEMGROUP_ID_FK_idx`(`PARENT_ID`) USING BTREE,
  CONSTRAINT `ITEMGROUP_PARENT_ID_FK` FOREIGN KEY (`PARENT_ID`) REFERENCES `MD_ITEMGROUP` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_ITEMGROUP
-- ----------------------------
INSERT INTO `MD_ITEMGROUP` VALUES ('09c2caef-1eed-4675-82fa-2125c8001ea6', '温控食品', NULL, 'ba131919-0d07-4529-aa83-86640d172ac8', 31, 0, '2017-09-02 16:00:39', 'mengmengsun', '2017-09-02 16:00:39', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('1163662d-4aec-485b-846b-4e6b458e5a00', '百货', NULL, NULL, 2, 0, '2017-07-28 09:48:14', 'mengmengsun', '2017-07-28 09:48:14', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('243f0af2-eac5-45d3-ad2e-f2baea47b113', '危险品', NULL, NULL, 4, 0, '2017-07-28 09:49:39', 'mengmengsun', '2017-07-28 09:49:39', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('33ce128e-253b-41f7-bc04-224aedc45044', '冰淇淋', NULL, '09c2caef-1eed-4675-82fa-2125c8001ea6', 10, 0, '2019-09-26 17:10:04', 'songdan', '2019-09-26 17:10:04', 'songdan', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('68effa7e-2fc9-4b20-9b2a-770056190135', '厨卫电器', NULL, 'a84fb9b1-682c-4d34-bf82-f7635763b4fa', 61, 0, '2019-07-04 11:34:22', 'songdan', '2019-07-04 11:34:22', 'songdan', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('6f123726-e34e-44c0-8e51-7a62ee42693c', '高价', NULL, NULL, 5, 0, '2017-07-28 09:49:47', 'mengmengsun', '2017-07-28 09:49:47', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('86285a6d-1d6d-4862-8192-a83600456349', '小百货', NULL, '1163662d-4aec-485b-846b-4e6b458e5a00', 21, 0, '2017-07-28 09:48:26', 'mengmengsun', '2017-07-28 09:48:26', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('928c368c-fac1-40f2-b30f-9156252a6d65', '大件', NULL, '1163662d-4aec-485b-846b-4e6b458e5a00', 22, 0, '2017-07-28 09:48:39', 'mengmengsun', '2017-07-28 09:48:39', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('a84fb9b1-682c-4d34-bf82-f7635763b4fa', '电器', NULL, NULL, 6, 0, '2019-07-04 11:33:57', 'songdan', '2019-07-04 11:33:57', 'songdan', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('aff4e06d-160b-48fd-9928-3d2b1bb24900', '服装', '服装', NULL, 1, 0, '2018-09-11 07:24:21', 'wallace', '2018-09-11 07:24:21', 'wallace', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('b275b710-2664-4a7d-a99e-e8b143a46abb', '大家电', NULL, 'a84fb9b1-682c-4d34-bf82-f7635763b4fa', 62, 0, '2019-07-04 11:34:41', 'songdan', '2019-07-04 11:34:41', 'songdan', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('ba131919-0d07-4529-aa83-86640d172ac8', '食品', NULL, NULL, 3, 0, '2017-07-28 09:49:03', 'mengmengsun', '2017-07-28 09:49:03', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('da892f92-63f4-458f-95ec-757d4fb9bb9a', '图书', NULL, NULL, 1, 0, '2017-07-28 09:48:07', 'mengmengsun', '2017-07-28 09:48:07', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('f1f33a99-b04f-4b33-b2e4-147fda75f3a3', '易爆类危险品', NULL, '243f0af2-eac5-45d3-ad2e-f2baea47b113', 41, 0, '2017-09-02 16:01:06', 'mengmengsun', '2017-09-02 16:01:06', 'mengmengsun', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('fd335ce3-1b83-4819-81d9-34f8aa5a2139', '物料', '物料大类', NULL, 1, 0, '2018-09-11 07:24:46', 'wallace', '2018-09-11 07:24:46', 'wallace', NULL, 0);
INSERT INTO `MD_ITEMGROUP` VALUES ('ffb5cdf7-6418-4774-a029-8b77836eaba4', '母婴用品', NULL, NULL, 1, 0, '2019-07-29 02:15:04', 'jiangshikun', '2019-07-29 02:15:12', 'jiangshikun', NULL, 1);

-- ----------------------------
-- Table structure for MD_ITEMUNIT
-- ----------------------------
DROP TABLE IF EXISTS `MD_ITEMUNIT`;
CREATE TABLE `MD_ITEMUNIT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `UNIT_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '单位类型',
  `BASE_FACTOR` int(11) NOT NULL COMMENT '基础单位数量',
  `BASEUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '基础单位',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ITEMUNIT_NAME_UK`(`NAME`) USING BTREE,
  INDEX `ITEMUNIT_BASEUNIT_ID_FK`(`BASEUNIT_ID`) USING BTREE,
  CONSTRAINT `UOM_BASEUOM_ID_FK` FOREIGN KEY (`BASEUNIT_ID`) REFERENCES `MD_ITEMUNIT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品单位' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_ITEMUNIT
-- ----------------------------
INSERT INTO `MD_ITEMUNIT` VALUES ('46afbc20-ad43-4f0e-b1ac-3b3ce03a85cd', '张', '张', 0, NULL, 0, '2019-07-29 02:22:51', 'jiangshikun', '2019-07-29 02:22:51', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('636da19a-b018-4eed-98f1-fd25512d066c', '个', '个', 0, NULL, 0, '2019-07-29 02:19:06', 'jiangshikun', '2019-07-29 02:19:06', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('798ae3ed-a33c-4798-80c7-4747b837de85', '盒', '盒', 0, NULL, 0, '2019-07-29 02:21:13', 'jiangshikun', '2019-07-29 02:21:13', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('7e6c50af-a1ea-4a7f-9364-6378e7d62366', '包', '包', 0, NULL, 0, '2019-07-29 02:20:04', 'jiangshikun', '2019-07-29 02:20:04', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('8683d4bf-0beb-40c1-a363-f4a47304cb89', '对', '对', 0, NULL, 0, '2019-07-29 02:18:34', 'jiangshikun', '2019-07-29 02:18:34', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('8a7845ef-b91b-4ea7-941a-a17afd24d1ec', '套', '套', 0, NULL, 0, '2019-07-29 02:17:38', 'jiangshikun', '2019-07-29 02:17:38', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('99513c34-b500-426e-84cd-d32750ac44d6', '米', '米', 0, NULL, 0, '2019-07-29 02:21:44', 'jiangshikun', '2019-07-29 02:21:44', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('a014e01f-9944-4a73-bd92-82fc1d683625', '千克', '千克', 0, NULL, 0, '2019-07-29 02:20:31', 'jiangshikun', '2019-07-29 02:20:31', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('bba6ea2b-a5eb-4998-addb-69aa460add8a', '箱', '箱', 0, NULL, 0, '2019-07-29 02:21:38', 'jiangshikun', '2019-07-29 02:21:38', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('be724e70-581a-4ac7-9769-9f2c79e02fa1', '床', '床', 0, NULL, 0, '2019-07-29 02:19:36', 'jiangshikun', '2019-07-29 02:19:36', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('c40eac33-106c-411e-8e45-2a4ce9434d52', 'piece', '个', 0, NULL, 0, '2019-04-24 11:15:21', 'xiongxiaoning', '2019-04-24 11:15:21', 'xiongxiaoning', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('c507fd28-215f-4b09-a1db-98726be7aebc', '双', '双', 0, NULL, 0, '2019-07-29 02:18:25', 'jiangshikun', '2019-07-29 02:18:25', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('ced02b5c-9db4-4018-9063-21c65d38309e', '条', '条', 0, NULL, 0, '2019-07-29 02:18:04', 'jiangshikun', '2019-07-29 02:18:04', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('d212cd28-fe9f-4fe0-b8ab-e8aff368110d', '片', '片', 0, NULL, 0, '2019-07-29 02:26:03', 'jiangshikun', '2019-07-29 02:26:03', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('d7599399-3da6-478c-b14d-60e6be6ef11e', '件', '件', 0, NULL, 0, '2019-07-29 02:19:12', 'jiangshikun', '2019-07-29 02:19:12', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('eb31243b-acd7-483f-8721-09f74c5dd382', '块', '块', 0, NULL, 0, '2019-07-29 02:25:56', 'jiangshikun', '2019-07-29 02:25:56', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('f3a14984-be6e-4cb6-884f-cb3683629f65', '台', '台', 0, NULL, 0, '2019-07-29 02:18:54', 'jiangshikun', '2019-07-29 02:18:54', 'jiangshikun', NULL, 0);
INSERT INTO `MD_ITEMUNIT` VALUES ('fa7526ae-8263-4f18-b710-53c63e6126d7', 's', 's', 0, NULL, 0, '2019-07-29 02:19:24', 'jiangshikun', '2019-07-29 02:19:24', 'jiangshikun', NULL, 0);

-- ----------------------------
-- Table structure for MD_POD
-- ----------------------------
DROP TABLE IF EXISTS `MD_POD`;
CREATE TABLE `MD_POD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `POD_INDEX` int(11) NOT NULL COMMENT 'POD创建顺序',
  `PODTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'POD类型',
  `ZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '区域',
  `YPOS` int(11) NULL DEFAULT 0,
  `XPOS` int(11) NULL DEFAULT 0,
  `SELLING_DEGREE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '热销度',
  `PLACEMARK` int(11) NULL DEFAULT NULL COMMENT '当前地标',
  `TOWARD` int(11) NULL DEFAULT NULL COMMENT '当前朝向',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `XPOS_TAR` int(11) NULL DEFAULT NULL COMMENT '目标地址X轴',
  `YPOS_TAR` int(11) NULL DEFAULT NULL COMMENT '目标地址Y轴',
  `ADDRCODEID_TAR` int(11) NULL DEFAULT NULL COMMENT '目标地址码',
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理区域',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `BAY_NAME_UK`(`WAREHOUSE_ID`, `NAME`) USING BTREE,
  INDEX `BAY_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `BAY_BAYTYPE_ID_FK_idx`(`PODTYPE_ID`) USING BTREE,
  INDEX `BAY_PODZONE_ID_FK`(`ZONE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'POD' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_POD
-- ----------------------------
INSERT INTO `MD_POD` VALUES ('01469a33-e0a7-4ca9-8519-2411d2edc76f', 'P0000009', NULL, 9, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 9, 30, NULL, 481, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'system', '2020-01-15 16:29:23', 'admin', '2019-12-19 10:17:18', NULL, 2);
INSERT INTO `MD_POD` VALUES ('157e990f-a185-4765-8d4c-5b2874faf51e', 'P0000014', NULL, 14, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 14, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', 'admin', '2019-12-19 10:17:19', NULL, 0);
INSERT INTO `MD_POD` VALUES ('17f6aab2-627c-4b3e-917f-7db3447e96e7', 'P0000015', NULL, 15, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 9, 32, NULL, 483, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'system', '2020-01-15 16:29:23', 'admin', '2019-12-19 10:17:19', NULL, 1);
INSERT INTO `MD_POD` VALUES ('19090993-1558-4857-8218-43cb0624065f', 'P0000003', NULL, 3, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 3, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', 'admin', '2019-12-19 10:17:17', NULL, 0);
INSERT INTO `MD_POD` VALUES ('214bfaf3-f090-4641-a117-6616f193870f', 'P0000007', NULL, 7, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 9, 30, NULL, 481, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'system', '2019-12-23 13:28:27', 'admin', '2019-12-19 10:17:18', NULL, 2);
INSERT INTO `MD_POD` VALUES ('389e547f-7788-4071-8d2b-ebb05cc0da48', 'P0000016', NULL, 16, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 11, 35, NULL, 586, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'system', '2019-12-23 16:17:59', 'admin', '2019-12-19 10:17:19', NULL, 1);
INSERT INTO `MD_POD` VALUES ('5f51d94f-9510-4c1e-82da-bf83ccee4dbb', 'P0000017', NULL, 17, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 17, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', 'admin', '2019-12-19 10:17:19', NULL, 0);
INSERT INTO `MD_POD` VALUES ('8b11a6be-5624-4946-b83c-e66829e60e1f', 'P0000002', NULL, 2, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 2, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', 'admin', '2019-12-19 10:17:17', NULL, 0);
INSERT INTO `MD_POD` VALUES ('8eb3eaa8-520d-4c5d-a462-e4bd574af31f', 'P0000005', NULL, 5, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 5, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', 'admin', '2019-12-19 10:17:17', NULL, 0);
INSERT INTO `MD_POD` VALUES ('9788e2a0-3783-41ea-a620-bb1136479780', 'P0000006', NULL, 6, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 6, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', 'admin', '2019-12-19 10:17:17', NULL, 0);
INSERT INTO `MD_POD` VALUES ('9d32aeff-1392-49ff-b32a-d043b3b9d59c', 'P0000010', NULL, 10, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 10, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', 'admin', '2019-12-19 10:17:18', NULL, 0);
INSERT INTO `MD_POD` VALUES ('a85abeaa-30e4-4d95-a400-1d97e637d3c6', 'P0000011', NULL, 11, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 11, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', 'admin', '2019-12-19 10:17:18', NULL, 0);
INSERT INTO `MD_POD` VALUES ('bfed9f83-f2df-48fd-9b17-e1391d3f4995', 'P0000001', NULL, 1, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 1, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', 'admin', '2019-12-19 10:17:17', NULL, 0);
INSERT INTO `MD_POD` VALUES ('cc161a28-3c9e-466c-ae87-d2247637b5fd', 'P0000004', NULL, 4, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 4, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', 'admin', '2019-12-19 10:17:17', NULL, 0);
INSERT INTO `MD_POD` VALUES ('d8718f45-4855-4f8a-875b-aa19166086f1', 'P0000012', NULL, 12, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 12, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', 'admin', '2019-12-19 10:17:18', NULL, 0);
INSERT INTO `MD_POD` VALUES ('e07709c1-771a-4d39-8550-15cd634036fc', 'P0000008', NULL, 8, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 8, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', 'admin', '2019-12-19 10:17:18', NULL, 0);
INSERT INTO `MD_POD` VALUES ('fd6e58de-dc82-45ca-b3a3-49e9403606ed', 'P0000013', NULL, 13, '82a40db1-7276-4554-ac2e-6b49ba826d24', '36d88dac-d6d8-4717-8323-0cd497b49f66', 0, 0, NULL, 13, 0, 'Available', 0, 0, 0, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', 'admin', '2019-12-19 10:17:19', NULL, 0);

-- ----------------------------
-- Table structure for MD_PODTYPE
-- ----------------------------
DROP TABLE IF EXISTS `MD_PODTYPE`;
CREATE TABLE `MD_PODTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `NUMBER_OF_COLUMNS` int(11) NULL DEFAULT NULL COMMENT '几列',
  `NUMBER_OF_ROWS` int(11) NULL DEFAULT NULL COMMENT '几行',
  `HEIGHT` int(11) NULL DEFAULT NULL COMMENT '高',
  `WIDTH` int(11) NULL DEFAULT NULL COMMENT '长',
  `DEPTH` int(11) NULL DEFAULT NULL COMMENT '宽',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `BAYTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `BAYTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `BAYTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'POD类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_PODTYPE
-- ----------------------------
INSERT INTO `MD_PODTYPE` VALUES ('82a40db1-7276-4554-ac2e-6b49ba826d24', 'PT01', NULL, 0, 14, 2400, 1200, 1200, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-18 06:51:22', NULL, 2);

-- ----------------------------
-- Table structure for MD_PODTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `MD_PODTYPEPOSITION`;
CREATE TABLE `MD_PODTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_NO` int(11) NOT NULL COMMENT '编号',
  `LEVEL` int(11) NOT NULL COMMENT '层',
  `NUMBER_OF_COLUMNS` int(11) NOT NULL COMMENT '列数',
  `FACE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '面',
  `COLOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '颜色',
  `STORAGELOCATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '货位类型',
  `DROPZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'DROPZONE',
  `PODTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'POD类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`, `STORAGELOCATIONTYPE_ID`) USING BTREE,
  INDEX `BAYTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `BAYTYPEPOSITION_BAYTYPE_ID_FK`(`PODTYPE_ID`) USING BTREE,
  INDEX `BAYTYPEPOSITION_DROPZONE_ID_FK`(`DROPZONE_ID`) USING BTREE,
  INDEX `BAYTYPEPOSITION_STORAGELOCATIONTYPE_ID_FK`(`STORAGELOCATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `BAYTYPEPOSITION_BAYTYPE_ID_FK` FOREIGN KEY (`PODTYPE_ID`) REFERENCES `MD_PODTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `BAYTYPEPOSITION_DROPZONE_ID_FK` FOREIGN KEY (`DROPZONE_ID`) REFERENCES `MD_DROPZONE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `BAYTYPEPOSITION_STORAGELOCATIONTYPE_ID_FK` FOREIGN KEY (`STORAGELOCATIONTYPE_ID`) REFERENCES `MD_STORAGELOCATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `BAYTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'POD类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_PODTYPEPOSITION
-- ----------------------------
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('0c9e8fc5-db01-4d63-b2c7-4fe3270bbebb', 6, 6, 1, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('278d1f0f-6385-4886-9358-161bdd2d6cd9', 2, 2, 1, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('3f8b0738-6b5c-4956-812d-6e9c6d65b1d5', 7, 7, 1, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('5d86f071-1dee-4168-bdfc-7b15932160ca', 9, 2, 1, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('731db566-5e45-4fcb-8012-8864b326283f', 4, 4, 1, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('7de004f3-cc75-4fb6-a501-e5b5318484e2', 13, 6, 1, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('7f49a4db-7cda-485a-929d-5afa26191c33', 3, 1, 1, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('86dd4cac-3b51-4a13-948d-0d6538cbef1f', 14, 7, 1, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('91383389-e8bf-474d-a119-583a5e56ddc1', 10, 3, 1, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('a139f10b-f274-4abf-ba6e-2e8de51501eb', 1, 3, 1, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('a8b2a299-310c-4c56-ba16-537fa85e9b7e', 12, 5, 1, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('c5226399-aabb-49f3-a389-2a2ff131c9d1', 8, 1, 1, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('dc1f0ed3-244c-4282-94f0-41714ed16a1e', 5, 5, 1, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);
INSERT INTO `MD_PODTYPEPOSITION` VALUES ('ed603321-0395-4313-97b4-c2b62c5f6ea5', 11, 4, 1, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '82a40db1-7276-4554-ac2e-6b49ba826d24', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:10:51', 'admin', '2019-12-19 10:10:51', NULL, 0);

-- ----------------------------
-- Table structure for MD_ROBOT
-- ----------------------------
DROP TABLE IF EXISTS `MD_ROBOT`;
CREATE TABLE `MD_ROBOT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ROBOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PASSWORD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '车辆连接密码',
  `ROBOT_TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '车辆类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '车辆所属库房',
  `HARDWARE_VERSION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '硬件版本号',
  `SOFTWARE_VERSION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '软件版本号',
  `PRODUCTION_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '出厂日期',
  `ACC_DURATION` int(11) NULL DEFAULT 0 COMMENT '累计时长',
  `RECENTLY_MAINTAIN_TIME` timestamp(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最近维修时间',
  `INBREAK_DETECT_TIMES` int(11) NULL DEFAULT 0 COMMENT '入侵检测次数',
  `COLD_RESET_TIMES` int(11) NULL DEFAULT 0 COMMENT '冷复位次数',
  `HOT_RESET_TIMES` int(11) NULL DEFAULT 0 COMMENT '热复位次数',
  `ROBOT_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '小车状态',
  `BATTERY_NUMBER` int(11) NULL DEFAULT 0,
  `ENTITY_LOCK` int(11) NULL DEFAULT 0,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  INDEX `ROBOT_TYPE_ID_FK`(`ROBOT_TYPE_ID`) USING BTREE,
  INDEX `ROBOT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `ROBOT_TYPE_ID_FK` FOREIGN KEY (`ROBOT_TYPE_ID`) REFERENCES `MD_ROBOTTYPE` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `ROBOT_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '硬件小车' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_ROBOTTYPE
-- ----------------------------
DROP TABLE IF EXISTS `MD_ROBOTTYPE`;
CREATE TABLE `MD_ROBOTTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '车辆类型名称',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '车辆类型ID',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '硬件小车类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_SABC_RULE
-- ----------------------------
DROP TABLE IF EXISTS `MD_SABC_RULE`;
CREATE TABLE `MD_SABC_RULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SKU_TYPE_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '(s,a,b,c .......）占比名称',
  `FROM_NO` decimal(15, 2) NOT NULL COMMENT '开始值',
  `TO_NO` decimal(15, 2) NOT NULL COMMENT '截止值',
  `MAX_DOC` decimal(17, 4) NOT NULL COMMENT '商品在packIng区的最大数量',
  `REPLEN_DOC` decimal(17, 4) NOT NULL COMMENT '商品在buffer区的最大存储数量',
  `SAFELY_DOC` decimal(17, 4) NOT NULL COMMENT '补货触发值',
  `SALES_PROPORTION` decimal(15, 2) NULL DEFAULT NULL COMMENT '销量占比',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用于报告暗灯和解决暗灯' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_SEMBLENCE
-- ----------------------------
DROP TABLE IF EXISTS `MD_SEMBLENCE`;
CREATE TABLE `MD_SEMBLENCE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NULL DEFAULT NULL,
  `RULE_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COMPARISON_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VALUE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `fk_s_client`(`CLIENT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品相似度' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_SEMBLENCE
-- ----------------------------
INSERT INTO `MD_SEMBLENCE` VALUES ('2209b3de-eb70-42db-b8b3-f36807703a78', 'SYSTEM', NULL, 0, '2019-08-26 18:12:18', 'hanlei', '2019-08-26 18:23:45', 'hanlei', NULL, 2, 'GREATER_THAN', 'NAME', '95');

-- ----------------------------
-- Table structure for MD_SEQUENCE_NO
-- ----------------------------
DROP TABLE IF EXISTS `MD_SEQUENCE_NO`;
CREATE TABLE `MD_SEQUENCE_NO`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `SEQUENCE_NO` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '串码号',
  `ITEM_NO` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '商品编码',
  `STATE` int(3) NOT NULL DEFAULT 0 COMMENT '串码状态 0禁用 1启用',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '串码信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_SIZEFILTERRULE
-- ----------------------------
DROP TABLE IF EXISTS `MD_SIZEFILTERRULE`;
CREATE TABLE `MD_SIZEFILTERRULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PRICE` int(21) NOT NULL COMMENT '值',
  `RULE_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规则名称',
  `MODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '方式（是大于小于。。）',
  `NUMBER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '级别',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_SIZEFILTERRULE
-- ----------------------------
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('02d034c1-988c-4896-949f-596f668cf82c', '中', 3000, '重量', '小于等于', '2', 0, '2017-07-28 11:05:35', 'mengmengsun', '2017-07-28 11:05:35', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('30ed9d13-cd33-457f-9745-b6f640ca4c6c', '大', 576000000, '体积', '小于等于', '3', 0, '2017-07-28 11:06:05', 'mengmengsun', '2017-07-28 11:06:05', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('31625f16-4d9f-4fa5-8a33-329cf66d7d27', '超大', 1000000000, '重量', '小于等于', '4', 0, '2017-07-28 11:06:49', 'mengmengsun', '2017-07-28 11:06:49', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('324df34a-2288-4dea-a8c1-849a1d626690', '中', 400, '最长边', '小于等于', '2', 0, '2017-07-28 11:05:09', 'mengmengsun', '2017-07-28 11:05:09', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('359cd15f-a51e-4f6f-ad2e-dac3110126ad', '小', 180, '最长边', '小于等于', '1', 0, '2017-07-28 11:04:30', 'mengmengsun', '2018-04-01 16:00:34', 'mengmengsun', NULL, 2);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('3dcd975f-da3d-41b9-a133-3ea221b459bd', '小', 2000, '重量', '小于等于', '1', 0, '2017-07-28 11:04:54', 'mengmengsun', '2017-07-28 11:04:54', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('5992bcc6-dd6c-4bf9-953d-f3fce2eeb1da', '大', 5000, '重量', '小于等于', '3', 0, '2017-07-28 11:06:19', 'mengmengsun', '2017-07-28 11:06:19', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('5d62a718-8776-487f-ad23-50ef1ed6d520', '小', 3780000, '体积', '小于等于', '1', 0, '2017-07-28 11:04:42', 'mengmengsun', '2017-07-28 11:04:42', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('5ed896ab-39f2-49cb-9345-53e4efa8d158', '中', 36000000, '体积', '小于等于', '2', 0, '2017-07-28 11:05:23', 'mengmengsun', '2017-07-28 11:05:23', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('98410c28-99d7-4c3b-aead-6214ff85c745', '超大', 1000000000, '最长边', '小于等于', '4', 0, '2017-07-28 11:06:32', 'mengmengsun', '2017-07-28 11:06:32', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('99605386-fd0d-4abd-9098-2a5aeb313610', '大', 900, '最长边', '小于等于', '3', 0, '2017-07-28 11:05:50', 'mengmengsun', '2017-07-28 11:05:50', 'mengmengsun', NULL, 0);
INSERT INTO `MD_SIZEFILTERRULE` VALUES ('fbe2c7c7-308d-42f6-896a-570d1e6afca3', '超大', 1000000000, '体积', '小于等于', '4', 0, '2017-07-28 11:06:41', 'mengmengsun', '2017-07-28 11:06:41', 'mengmengsun', NULL, 0);

-- ----------------------------
-- Table structure for MD_STORAGELOCATION
-- ----------------------------
DROP TABLE IF EXISTS `MD_STORAGELOCATION`;
CREATE TABLE `MD_STORAGELOCATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `XPOS` int(11) NOT NULL COMMENT 'X坐标',
  `YPOS` int(11) NOT NULL COMMENT 'Y坐标',
  `ZPOS` int(11) NOT NULL COMMENT 'Z坐标',
  `FIELD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '段',
  `FIELD_INDEX` int(11) NULL DEFAULT NULL COMMENT '段顺序',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `ALLOCATION` decimal(15, 2) NULL DEFAULT NULL COMMENT '分配',
  `ALLOCATION_STATE` int(11) NULL DEFAULT NULL COMMENT '分配状态',
  `STOCKTAKING_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '最后一次盘点',
  `FACE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '面',
  `COLOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '颜色',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '货位类型',
  `AREA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '功能区',
  `ZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '区域',
  `DROPZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'DROPZONE',
  `POD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'POD',
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '物理区域',
  `BAY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'buffer区podid',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `STORAGELOCATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `STORAGELOCATION_AREA_ID_FK`(`AREA_ID`) USING BTREE,
  INDEX `STORAGELOCATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `STORAGELOCATION_ZONE_ID_FK`(`ZONE_ID`) USING BTREE,
  INDEX `STORAGELOCATION_DROPZONE_ID_FK`(`DROPZONE_ID`) USING BTREE,
  INDEX `STORAGELOCATION_WAREHOUSE_ID_FK_idx`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `STORAGELOCATION_POD_ID_FK`(`POD_ID`) USING BTREE,
  INDEX `STORAGELOCATION_BAY1_ID_FK`(`BAY_ID`) USING BTREE,
  CONSTRAINT `STORAGELOCATION_AREA_ID_FK` FOREIGN KEY (`AREA_ID`) REFERENCES `MD_AREA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STORAGELOCATION_BAY1_ID_FK` FOREIGN KEY (`BAY_ID`) REFERENCES `MD_BAY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STORAGELOCATION_DROPZONE_ID_FK` FOREIGN KEY (`DROPZONE_ID`) REFERENCES `MD_DROPZONE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STORAGELOCATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `MD_STORAGELOCATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STORAGELOCATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STORAGELOCATION_ZONE_ID_FK` FOREIGN KEY (`ZONE_ID`) REFERENCES `MD_ZONE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '容器' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_STORAGELOCATION
-- ----------------------------
INSERT INTO `MD_STORAGELOCATION` VALUES ('02ac463c-7336-4d30-96fb-7c4fbad87476', 'P0000012AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('047c5460-6c81-4daf-b9b7-9758a77cbe2a', 'P0000013CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('04d06f62-733c-4e82-8550-f89bd5bf3b7c', 'P0000008CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('057cb24b-b0e0-473b-985b-4f213fef88bc', 'P0000010AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('07218f78-772a-4c8a-9fa5-05083f6df500', 'ZP024', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('07282cb4-1dca-44be-b87c-6984a788f53a', 'P0000015CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('086d49fb-5cbe-43a3-baaa-d91ea652b121', 'P0000007AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('08a1463e-9b81-48bf-b76f-5b80c006b310', 'P0000016AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('08cb2db3-658f-4f15-81a6-2450a173f05c', 'P0000013CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('08fbae92-3b66-4898-a0be-118e46d62c1a', 'ZP056', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('09362668-b5ce-499f-99ef-2ed7cc566e5f', 'P0000009AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('0946fa79-c0a3-470a-b307-7b58581dcef7', 'ZP021', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('0ada7c12-4f22-4e2e-bc5c-b546ad25ccdd', 'P0000015AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('0c6a70a7-b331-4314-9962-10fdd090355e', 'P0000015AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('0ce45d60-0ade-41ca-bfc1-fa95ce625287', 'P0000016AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'ZP023', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('0fdf174a-d69e-4062-9826-b9dda82feba7', 'P0000015AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('10102a48-eaad-4ca1-8024-4e4da40ff40a', 'P0000008CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('10565d99-5ded-41b0-8033-6ecaa1af6915', 'P0000008CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('118bbf3b-3105-42d9-b604-9bce0d69404f', 'ZP047', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1283b74e-188d-4799-b13c-62bbd2220511', 'ZP028', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('12992bec-de14-4c12-8c8e-b574917b9c4b', 'P0000017AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('12e3283b-eec5-4579-b1d4-5d6205f39000', 'P0000007AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('139ed9eb-3b80-40d1-a4c9-e74a351336bf', 'P0000011AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1478bcbe-e2df-4b51-8b51-7b2e16cbce69', 'P0000002AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1511e5b1-ec95-4c24-ba0f-5a100dff36a8', 'P0000005CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('181e9a48-5fa1-49e2-874e-9f5a9f3f4560', 'P0000014AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1866be97-b60d-4483-b155-39f2a077f710', 'P0000007CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1950884c-8892-4957-9193-46b27fcfebc1', 'ZP002', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1b9d6bd8-05b5-4c3f-8207-67314d07b790', 'P0000010CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1bac5ad1-d3be-459f-9cd9-c39baa98eec0', 'P0000001CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 'ZP025', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1d447437-6dd6-47e4-a625-5526530420f5', 'P0000001CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1d98aa5c-262c-461b-950b-4a58ecc3e210', 'P0000017AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('1ee5445a-3ed7-415e-8884-209e6301640b', 'P0000016CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('207da795-45cf-4df3-ad79-449e8696a216', 'P0000017AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('229ac92d-ba1c-4d05-b8aa-e5f816707587', 'ZP003', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('22a688cd-6413-4dab-98ef-8522911cf9e4', 'ZP014', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('22e543c0-cd84-42ab-9dc2-a20cc419bd38', 'P0000013CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2387bc09-bec9-41da-8a86-e9f583e0defb', 'ZP018', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('238ded0f-6a95-4b79-a70a-3f137db176a8', 'P0000007CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('23a7ef52-d1cd-4dcb-879e-25915dc5e63f', 'P0000002AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('23e0af2e-70b4-4129-a72d-77f009b73173', 'P0000011CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2618abe4-be4f-4cc3-84fc-af52573cc422', 'P0000006CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2620d2f7-202c-44bd-be74-9226c2815a34', 'P0000007CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('27971a6c-bf81-4a1c-8828-00954b612fd2', 'P0000014AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('282f53e7-9330-436b-a861-c0a0cad63c00', 'P0000013CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('28445f5c-99ae-42dc-b6cd-81ea5171cd48', 'ZP011', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('286b9d95-5e09-48d4-84a4-72289bc39218', 'P0000014AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('29038642-8fda-4578-bd57-939416e3c232', 'P0000009AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('29342e4c-d91d-4702-bcc8-91c2277baa73', 'P0000017AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2a12358e-7338-4491-adbc-38004ae5f93d', 'P0000004AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2a1d2da8-c9cc-42d7-a7ac-c738229b48af', 'P0000004CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2a9d257a-8cb3-4951-bcae-47fec8e73b40', 'P0000005AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2bb3a5f3-309a-46f4-9cb4-a5eb5acaaaae', 'ZP029', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2bce0f74-01a3-4033-9a39-5c338663fb18', 'P0000013AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2c52bab3-581b-478c-9b48-0b3ff4ddabfe', 'P0000008AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2c584d7a-88a1-47dd-8865-5bab1e467b36', 'P0000012CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2d38a48e-8039-470c-9a02-2b4bf42d1428', 'ZP005', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2f58119b-1b46-44f1-8037-d8ca2bdb43c3', 'P0000001AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2f581288-f64b-4312-b300-d0d5b3c78aa2', 'ZP052', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('2ff3ae95-de51-4a49-bc75-e9f3ffb01aca', 'P0000005CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('306dfd68-1f8f-4d8e-aa61-844573f8b4ba', 'ZP051', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('30d7a347-6899-4c35-8aef-191263adc58f', 'ZP048', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('316ab1aa-135e-46bd-98ec-e466215c0122', 'P0000002CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('31ddd89a-1d5a-48ad-958e-84c7d5ef6f9d', 'P0000007CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('32ac00fe-40e0-4a33-9b37-23381f1d3760', 'ZP033', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('336cec39-c554-425b-92cd-1f8cab7fb1f0', 'P0000014CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('34cca093-783d-4b69-b0a7-a07ba294a811', 'P0000016AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('3945df05-dc4e-4698-9c6e-f7416dcb7ea4', 'P0000003AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('39a8d7c6-7ca2-4849-9493-f1093d2e3b61', 'P0000009CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('3a83f3df-731f-41ad-ac1a-360f6311a97c', 'P0000010AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('3b4a6ed8-8969-4d33-abb3-796eddaf1149', 'ZP053', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('3b9825c7-aab5-463e-8a49-ac97d2706fc0', 'P0000015CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4086588c-4585-439e-bd7b-4476c00bd58d', 'ZP015', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('40a07660-03a8-4899-8468-85f644aa3bd9', 'P0000001AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4195e732-c8fc-4994-9d65-ae4af35fb2b9', 'P0000005AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4238ff57-0b3b-4283-ab13-424a847f60be', 'P0000005CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('42d1534e-7e1e-496b-8dfd-70c6c74a7539', 'P0000011AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('43abfe7d-4458-458a-afee-8b03ae52c93a', 'P0000007AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('440fc4ae-97b2-424c-8184-e93559f84834', 'P0000016AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4640d4fe-f543-4984-a543-119e6bd2de8f', 'P0000005AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('467c1f63-6045-4508-8a83-8645cd9065a8', 'P0000009CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('474e8f10-45b2-45ad-878f-b6004f6439b7', 'P0000005AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4794e766-f985-415b-9771-84edf1f5c152', 'P0000015AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('48106fa6-d53c-4fe8-a927-98b0b452380f', 'P0000010CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('482553b4-4961-4351-a666-a05576e58f27', 'ZP038', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('49489a3b-dec7-4e2d-9c8a-92ede8e333c7', 'P0000016AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('498dbcef-786c-4a4e-840d-d937c13ae54e', 'P0000004CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4991553c-285e-49e3-a4cc-4026b65c0ebf', 'P0000014AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4a1325ac-1a49-4f2c-aa35-a86950d91fa0', 'P0000007AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4a8c565e-24fc-4720-ab93-1ecedb986d37', 'P0000004AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4a98ae64-e718-4bf2-82fe-6b935f4757f4', 'P0000016CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4aeed069-047c-4fb5-9f93-940dbb485328', 'P0000015CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4bf85627-45aa-4e83-bd5a-d1ad9145d0ae', 'P0000002AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4d5a85c2-ed96-434f-98cb-5bc8e3b3adfa', 'ZP027', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4e0c0387-f040-4155-bb7e-59f9512198f8', 'P0000014AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('4f8af9c0-9b51-4025-a40c-4ec226e8281e', 'P0000015CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('51a269a6-b7a4-4c36-b983-1ea31f531535', 'P0000007AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5247946a-4880-413c-bf42-b5cbc242c736', 'ZP050', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('526b7576-9ec3-45c6-8302-665d14575708', 'P0000003CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('535a99af-1f73-4131-b9fc-b2b1fa834530', 'P0000010AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('543f627c-89f0-42ac-acaf-a531962f46ab', 'ZP039', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('54b115b7-bd28-484f-8694-b0a188febfda', 'P0000006CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('54d6d37b-2f81-4bb3-9fe5-18e8b604a475', 'P0000007CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('551c0fed-c415-49d3-98dc-6bd88fbeaadc', 'P0000016CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5555cc65-024f-45a4-816c-4742c3f18e75', 'ZP006', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('55e9e993-f71b-4a57-b91c-d323d0bd8818', 'P0000012CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('55f4f4fa-0014-4ca6-bb74-23c582998c9a', 'P0000008AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('56ae4338-f27f-4477-b8b4-50f131a00cb9', 'ZP010', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('57663bc7-2146-431f-ab5f-6f8b03b71f58', 'ZP060', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('579afbf1-8d68-47c5-a3ca-46354bd565c9', 'P0000001AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5841dba8-1774-423a-b8ee-506f0b10f85d', 'P0000006AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('587f11b5-6336-43e8-bb3a-51ccdb81cbc2', 'ZP026', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5a077b11-3387-4790-ac27-8eab13bbb8f0', 'P0000017CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5adb26e7-8210-4842-8835-c16656c69f40', 'ZP059', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5ae3aa34-a1a1-4cf8-822f-80cacbe8defc', 'P0000011CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5d99f8e0-cce0-41d7-988f-3a7b5a81d4a2', 'P0000006AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5e48d715-1eba-4b46-8bf1-b4dd76c058c9', 'P0000006CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('5e8fc268-9609-4ca6-b7ea-817a78b02c83', 'P0000016CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6048236a-99de-46e0-85cc-8584f59e32be', 'P0000014CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('61c2fe44-244c-4136-bb40-c11c06781f29', 'P0000008AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('623efd76-3dfb-41d3-a720-4e7ec6c56cc4', 'P0000014CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6516999a-14fa-49b1-8d11-2bbbef5c8e5d', 'P0000016AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('66a96544-058a-4780-b857-a00c54699dee', 'P0000007CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('67fa3f13-2488-4cbd-afff-58168e78b193', 'P0000011AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6848f92e-e9e8-4bae-8e23-e08835f5eb6e', 'P0000003AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('68a0eb3e-da7b-4667-bdf6-c5638a975fec', 'P0000006CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('699eff00-4ae9-4586-b0bb-002f0d3eb302', 'ZP009', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('69ba4202-8bb2-41e5-9875-31932ef2e00d', 'P0000009CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6a2e248d-d1dc-489e-bcbe-bb7c0640b6fe', 'P0000013AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6b10907a-b8aa-46f6-97d7-072024550d82', 'ZP045', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6b73d661-05a7-486c-bbb1-483e1d536ccb', 'P0000013AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6e31aeaa-a9b5-45af-9a1c-8d16ac49e868', 'P0000008AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('6e796124-e2fd-4825-9014-c4434ac94986', 'P0000008CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('70e9709f-ece3-4763-8ef2-cc613ea6c0a5', 'P0000012AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7100bdfb-aca6-475e-8887-c4fdb342e3f5', 'ZP017', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('715d3122-111f-40f4-b31d-ccb94a762ce5', 'P0000008CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('716edc4d-4655-41ff-b38b-a4e51727453f', 'CP001', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '2b3dd0bc-d6fb-41d1-a38f-6bcefa5cc087', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:17:22', '2019-12-20 16:17:22', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('72aa49ce-91ef-4baf-b1a4-492e2cf06fff', 'P0000001CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('73f2b318-a699-4ad2-a427-e6c262dd9e97', 'P0000017CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('76d6ab45-410e-4bbb-a3ad-0ecfab60ac57', 'P0000008CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('770a01b3-0223-4153-a16a-bfe902dc107d', 'P0000011AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7b070a8c-7731-4073-bbcd-233873ee9fea', 'P0000006AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7c2dd476-2d33-4229-936c-fc66dcc41d15', 'P0000017CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7c34eb45-b8e4-4002-a0c3-5cb9972c1970', 'P0000015CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7c6f0c0f-2035-4fee-b430-902d21ba8ba0', 'ZP031', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7ca897c6-65cc-470c-9618-1b657fdca968', 'ZP036', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7d676e28-b15e-438c-bf94-9770d782630e', 'P0000010CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7db93771-68ab-40ee-8d18-0794b8612160', 'P0000005AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7de1378f-e7b0-4aab-8f75-49fdfc8aae39', 'P0000009AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('7e4c3fc3-dad7-44b3-95cf-efd5be122a92', 'P0000003AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('8164c612-f695-4f85-89f6-21b331fa6b4a', 'P0000011CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('817e704f-e1f0-4a2b-9bac-e22904c66a8f', 'P0000003CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('84991906-a4b0-4743-b5f3-07457f631547', 'P0000012CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('84c8ddf3-b487-4d52-8805-c97f448c03ab', 'P0000004AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('862ab35b-75b8-4bd4-9f1d-b40ac6bddf97', 'P0000013CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('862fc5cd-688c-48ca-ae4a-e1b48e9b1df0', 'P0000013AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('865b2e86-204d-4ddb-a991-cae8b726857b', 'P0000009AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('8a209ae2-6fcc-49f3-8233-4b95a2acf060', 'P0000014CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('8a565ebe-0e03-4b12-aa5b-3987e220797f', 'ZP013', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('8b2f009c-bab9-4093-8449-1d41ef422884', 'P0000012CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('8b3438fe-6c48-4a07-ab76-811a0e0d1993', 'P0000002CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('8c56f2cd-0ae6-4ee3-9754-34c3580f6950', 'P0000008AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('8d75a603-e4cd-41cc-9418-e9200caf67af', 'P0000012AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9055c864-1595-4a7a-b01b-e279da831675', 'P0000003CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('909c3063-10ab-42f2-a45c-c72791e93ba8', 'ZP022', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('90b3b33b-7f2d-4bad-b979-798ea90b61d2', 'P0000011CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('913fdee7-cee3-4402-b459-388caa1d40ca', 'P0000014AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9145f10e-35d6-47ff-9be7-d09e7ec8cfc2', 'P0000017CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('935d84ee-2bf4-44b8-9eeb-cf9176c11b0a', 'ZP049', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('93c3fe58-e31b-4be8-a8e2-f22b29f2cb3b', 'P0000003AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9596a010-98a1-4f47-90d3-d0157efe510a', 'ZP043', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9a77ea68-9334-4d8b-bf7c-2e167b8b6532', 'P0000003CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9ba888d1-7652-4490-8965-ea10bf15d1e6', 'P0000007AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9cd40fc6-0cc5-4de7-938a-ab4a6889bb54', 'P0000006AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9d25189f-862e-44b8-a489-b13e935f6354', 'P0000012AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9d622df8-f774-4bb2-9384-acd025c3fb27', 'P0000002AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('9ef5167e-6baa-472e-ab13-3671e72de359', 'P0000014CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a0485e24-59e7-41db-bf74-2b2fe12c1292', 'P0000007CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a1ad2a77-c10f-41d5-8ab8-b24dd9bb5024', 'P0000001CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a1face98-aa16-42ad-8ffb-d4ae76151f3a', 'P0000004CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a27b58fe-0072-4241-9aee-d4ee8cb7340b', 'P0000003CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a3021fc9-f1df-48d6-8565-68634463ee6c', 'P0000010AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a8e054e3-1c78-483d-9d19-5e5ffe1279a4', 'P0000003AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a9cfd5d1-62b7-441c-916d-3ecf65b8d866', 'ZP020', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('a9e8ab70-95ca-4889-9344-c24915c8805f', 'ZP055', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('aaa24481-bcb6-4713-b370-e925dfd59ff3', 'P0000007AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '214bfaf3-f090-4641-a117-6616f193870f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('abc26b9f-48cf-48bb-9f74-393a9c01ea71', 'P0000004CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('aca5bdb6-309a-4520-ae63-5b02e449c8af', 'P0000014AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('add08176-3154-42d7-a6ee-f6baa14d30a7', 'ZP035', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('addfc73c-e3ae-4966-b417-2b95affae266', 'P0000004CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ae1aaefa-57c9-4543-9700-21ecd4a77dbf', 'P0000011AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('aecc0e8b-65da-4c56-9014-9dd62917d263', 'P0000016CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b12a7c27-da4c-4e75-b7d2-716d3ff084eb', 'P0000015CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b144d947-63c0-4851-8e2a-156ceedeef57', 'P0000016AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b1857e68-7c18-4ddb-992c-52edd949ddf5', 'P0000011CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b2680360-2708-41a6-981e-88119bddbb4f', 'ZP007', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b3ec4303-47bd-4e3d-9456-0ed993f39006', 'P0000010CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b40d306c-5b39-4f99-a5bc-e06d48eaee38', 'ZP057', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b55ed680-2e90-4547-9f52-13d9fa65ae64', 'ZP016', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b64a848b-8904-46ac-a1f7-f207db650b45', 'ZP058', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b65ea8b5-4a38-485b-a72c-41019a2622f0', 'P0000012CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b6649dd6-4f58-444f-aea4-0dd9dd308201', 'P0000012AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b74add52-055d-41ed-b786-07bcc55adc57', 'ZP044', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('b7c55f0c-0b96-4426-a705-3ff2463a1559', 'P0000016CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ba347117-75f2-4348-aff1-b1896181ea0b', 'P0000006CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ba5f6c98-64d1-4b8f-8182-f77654d010bc', 'ZP032', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ba9a2fb7-0a98-4cd8-90b9-0614d898ad9f', 'P0000005CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('babb5c44-4109-4b5f-a237-aa6f874771fd', 'P0000016CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '389e547f-7788-4071-8d2b-ebb05cc0da48', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('bb26f588-ab74-4fbc-9dc6-8dffdedd298b', 'P0000010CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('bc6826c6-443a-4136-b494-09217b4b8fef', 'P0000013AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('be1b772e-6e0d-4411-b43c-c0d37b2f90f8', 'P0000003AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('be36fce0-5da6-41bf-ad95-90eaaf365939', 'P0000001AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('bfa49ce5-3923-4e02-b8b4-13a5ce8ee9fd', 'P0000015AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c13359a1-b58e-4fa1-86ba-309c57e25b93', 'P0000004AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c163c7e8-0107-4c26-b3a8-7e99d76be7ce', 'ZP030', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c236e59d-b0a0-4500-8099-d94c533e9a0d', 'P0000011AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c3a8bd33-33c8-42bb-ac1d-a7070fefa348', 'ZP040', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c3c899b7-7dc8-4860-94f6-d708a12b53c9', 'P0000011CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c3f78920-ac9a-4794-80fd-41bb9795ae32', 'P0000003CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c473a049-daa9-4075-b770-2c337565a4fd', 'P0000005AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c620bc73-a1a8-47ce-bc9f-1dd4a071459c', 'ZP042', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c7306e14-efe7-4847-b26b-cbf5c36da53f', 'P0000013CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c7905e65-05d4-465f-8b24-cf5ebfbd57c4', 'P0000003CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c7c556ba-1c45-4a0e-9ba0-417329f6c7b6', 'P0000006AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c7cbe55b-1911-47c9-8764-d97b2ba63da1', 'ZP037', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('c950de6c-3c65-4600-a2f1-be1c4950e873', 'P0000014CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ca28d88c-f9c4-42be-8338-41197878e308', 'P0000006CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('cabf98b5-0c8e-4111-bae2-3955d8e0d95a', 'ZP001', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('cc37b3a7-10d1-4e73-8fe9-83efc6c5284f', 'P0000009CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('cc8dbc33-a939-4b16-8ded-71c3a4c74e8e', 'P0000015CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('cd3d58bd-06aa-40e1-bb99-67d086167071', 'P0000002AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('cda5b3a9-a3b6-46da-992a-2f46d15b78e3', 'P0000001AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('cde109f7-bd1a-4c01-807e-d45cbdd7c53d', 'P0000013AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ce0693ae-98da-4321-8501-7f9065936452', 'P0000002CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('cec16d20-9c4e-4d95-9947-5cb38ffa6c77', 'P0000006AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d046df73-ece8-4fb8-ae7e-f26c347830b1', 'P0000008CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d19f5daa-8360-4cb5-880d-49c0c63186c7', 'P0000002AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d26e9a02-687b-41ef-8d0d-3003b007b2c4', 'P0000017AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d35f03de-d60f-497e-a52a-d6eda3119f08', 'P0000001CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d4062ece-8d06-4651-84b9-b0a78931d16d', 'P0000017AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d430b85f-85a0-4bf2-baa5-a69d67ce7fef', 'P0000004CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d6082c8b-2dc5-4fd0-ae37-93924d730ae1', 'P0000004AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d74f4dd8-7781-4df5-95d7-175e479ed067', 'P0000009CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d789e8b6-ee2d-4ca7-b3d8-e24eaad6295b', 'P0000006CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d79a0ce1-397f-47cb-bcb2-365fd402892f', 'ZP046', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d85890aa-70ac-4a04-9f52-4de0c8187664', 'P0000002CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d8ac6a23-49c3-4ab2-90e4-082f5c3c235a', 'P0000012CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d8e124d9-acc1-46bb-ab9e-3437027e1082', 'P0000017CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('d942f0e5-0e6b-4119-92f3-9bcc8ca02cc8', 'ZP004', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('da3c3394-fe82-4264-ac13-339de16bb8c0', 'P0000009AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('dad92482-9ecb-4b29-ab69-eddcb3c7455c', 'P0000011AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('dbf1d806-f4e6-4322-8016-71e287669b52', 'P0000010AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('dcc84a47-fc94-4dbf-8884-20789f419955', 'P0000001CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('dd0009a5-4be1-4d73-8dc6-532f31d7bf5e', 'P0000004AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('df66e84b-ffff-4047-a181-f8c8b8312c43', 'P0000002AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e37cab15-7fc0-4da8-8b43-2835d03abf2e', 'P0000009AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e3937413-0dd0-42b6-90b0-6b549be593a4', 'P0000014CF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '157e990f-a185-4765-8d4c-5b2874faf51e', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e42be904-5470-40fd-bc8e-d594a854ec38', 'P0000013AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e50f725a-a200-4494-9202-bf905a1bcb28', 'P0000010AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e53f7fbd-af1d-44a7-acc7-4d0f1e02a1e2', 'P0000005CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e61393f6-b82c-445b-a703-a8488527584a', 'P0000012AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e68f0c52-2945-4959-a98e-2aadbb9fac4e', 'ZP012', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e72e2312-ac07-42c5-8b16-44388c4a73ce', 'P0000015AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e7cd78d6-5282-4cd6-9c28-969be2fcb995', 'P0000012AF01', 6, 1, 1200, NULL, 0, 6, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e8fcd743-fdd4-46c6-bdd5-df2f83b729d1', 'P0000010CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e917be15-f8bd-47c3-92f5-e52c39dc349e', 'P0000008AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e9262473-fef0-41e9-9acb-112c9c9e76a9', 'P0000017CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('e9f57f5b-ab84-4f91-8cdd-77bad3281b95', 'P0000013CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'fd6e58de-dc82-45ca-b3a3-49e9403606ed', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ebf20f8f-0e4e-46ef-b560-6f22989b7bde', 'ZP041', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ec0cbf17-fed2-4fd1-b2e3-30437fe68f0a', 'ZP008', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ec3ac87e-cee6-488d-8cc0-9e49a994210d', 'P0000004CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('edcb6e69-995c-4a3c-8572-8f182985aff7', 'P0000002CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ee2a4340-0ec0-4b44-a022-7d4fdc0c773a', 'P0000012CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'd8718f45-4855-4f8a-875b-aa19166086f1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('eea997ab-d708-4b96-bfee-738a20e79619', 'ZP034', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('eedb3bd4-5486-4818-9317-5726d15abccd', 'P0000009CD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ef80d460-2ad2-431b-8ad4-b00939c3177b', 'P0000011CA01', 1, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'a85abeaa-30e4-4d95-a400-1d97e637d3c6', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('efd266ca-b3fc-45da-96fa-d0cf072e7262', 'P0000001AD01', 4, 1, 1200, NULL, 0, 4, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f2c3aed6-7cc3-446c-90f7-f3f6810f9d01', 'P0000009AB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f3bfa4b9-7f66-4f20-9b03-a4b5f3a256ec', 'ZP019', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:47', '2019-12-20 16:15:47', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f43a2824-94bc-4d1b-a810-82f70a95fd78', 'P0000002CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f4875dd0-e449-4581-be37-5b8e740f8132', 'P0000009CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '01469a33-e0a7-4ca9-8519-2411d2edc76f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f56e8c41-5a4e-45d1-b87a-a5e017df5583', 'P0000003AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '19090993-1558-4857-8218-43cb0624065f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f666bdd0-11d0-4c40-a2ea-ad9e56105276', 'P0000004AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'cc161a28-3c9e-466c-ae87-d2247637b5fd', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f6dc36ec-3f6b-4dab-9387-a0b0b704c80e', 'P0000017CG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f6eaf9dc-c4d1-4c84-b285-178dd6b5f091', 'ZP054', 0, 0, 0, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, '17b338e0-0dcd-4e62-94b3-15c964d21aeb', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', NULL, 'e3bf5372-790b-4970-959c-2cb0ed24c230', NULL, NULL, NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 16:15:48', '2019-12-20 16:15:48', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f87f0ce8-f0fe-4ef8-a590-2c69fdc76bf2', 'P0000015AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '17f6aab2-627c-4b3e-917f-7db3447e96e7', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:19', '2019-12-19 10:17:19', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f898e317-5514-404a-b4ea-b43959646593', 'P0000001AG01', 7, 1, 1200, NULL, 0, 7, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('f8ccfa5a-3d72-4500-a4e6-bf0d4add0e2b', 'P0000005AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('faa1696c-2481-43be-b912-a147e3b40304', 'P0000005CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('fae3e832-b986-4a3a-b0dd-69eed71f0e06', 'P0000002CE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8b11a6be-5624-4946-b83c-e66829e60e1f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('fbaff390-349b-4eb7-867b-ae3fbe3ec67b', 'P0000017AE01', 5, 1, 1200, NULL, 0, 5, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '5f51d94f-9510-4c1e-82da-bf83ccee4dbb', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:20', '2019-12-19 10:17:20', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('fc50a022-1772-418f-8ea1-c1b81b57275f', 'P0000005CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '8eb3eaa8-520d-4c5d-a462-e4bd574af31f', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('fd1b64ec-0892-4db0-9aa2-d58367377d01', 'P0000008AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'e07709c1-771a-4d39-8550-15cd634036fc', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('fde937c9-a8f0-4140-b369-fd2e224d172c', 'P0000006AA01', 1, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9788e2a0-3783-41ea-a620-bb1136479780', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('fe0bf262-e1ca-4497-b697-3d1726e3be2e', 'P0000001CC01', 3, 1, 1200, NULL, 0, 1, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', 'bfed9f83-f2df-48fd-9b17-e1391d3f4995', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:17', '2019-12-19 10:17:17', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ff3d972d-f9ac-4fce-85cf-926a940385aa', 'P0000010CB01', 2, 1, 1200, NULL, 0, 2, 0.00, 0, NULL, 'C', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);
INSERT INTO `MD_STORAGELOCATION` VALUES ('ffa7887f-117d-4e8a-841c-d63d0e6b7ca7', 'P0000010AC01', 3, 1, 1200, NULL, 0, 3, 0.00, 0, NULL, 'A', NULL, 'f9a99dba-c8b7-4485-a2dc-b9342815d308', 'e951cba0-0ac1-4a05-bfc6-f7834398fa2f', '36d88dac-d6d8-4717-8323-0cd497b49f66', '2d72f507-92f5-4af4-b70e-0ecc2bcbd8a6', '9d32aeff-1392-49ff-b32a-d043b3b9d59c', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-19 10:17:18', '2019-12-19 10:17:18', 'admin', NULL, 0);

-- ----------------------------
-- Table structure for MD_STORAGELOCATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `MD_STORAGELOCATIONTYPE`;
CREATE TABLE `MD_STORAGELOCATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '宽',
  `VOLUME` decimal(19, 6) NULL DEFAULT NULL COMMENT '体积',
  `LIFTING_CAPACITY` decimal(16, 3) NULL DEFAULT NULL COMMENT '载重量',
  `MAX_ITEMDATA_AMOUNT` int(11) NULL DEFAULT NULL COMMENT '最大商品种类',
  `INVENTORY_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '库存状态（正品、残品、测量、待调查）',
  `STORAGETYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '属于什么类型（容器，bin）',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `STORAGELOCATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `STORAGELOCATIONTYPE_WAREHOUSE_ID_FK_idx`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `STORAGELOCATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '容器类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_STORAGELOCATIONTYPE
-- ----------------------------
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('17b338e0-0dcd-4e62-94b3-15c964d21aeb', '正品料箱', NULL, 340.00, 600.00, 800.00, 163200000.000000, 500000.000, 5, 'INVENTORY', 'CONTAINER', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 15:20:35', 'admin', '2019-12-20 15:19:50', NULL, 1);
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('2b3dd0bc-d6fb-41d1-a38f-6bcefa5cc087', '残品料箱', NULL, 340.00, 600.00, 800.00, 163200000.000000, 500000.000, 5, 'DAMAGE', 'CONTAINER', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-20 15:30:14', 'admin', '2019-12-20 15:30:14', NULL, 0);
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('44459f06-9b18-4434-8605-8e7e498e8e47', '正品料箱', NULL, 400.00, 300.00, 500.00, 60000000.000000, 50000.000, 100, 'INVENTORY', 'CONTAINER', 'DEFAULT', 0, 'admin', '2019-12-18 03:15:10', 'admin', '2019-12-18 03:15:10', NULL, 0);
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('c11b17a5-69c2-4c8b-b9f7-b83e72a8969e', '待调查料箱', NULL, 400.00, 300.00, 500.00, 60000000.000000, 50000.000, 500, 'PENDING', 'CONTAINER', 'DEFAULT', 0, 'admin', '2019-12-18 03:16:51', 'admin', '2019-12-18 03:16:51', NULL, 0);
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('d840e9af-abfe-4721-982e-8ca37e46a6f1', '待测量料箱', NULL, 400.00, 300.00, 500.00, 60000000.000000, 50000.000, 500, 'MEASURE', 'CONTAINER', 'DEFAULT', 0, 'admin', '2019-12-18 03:17:42', 'admin', '2019-12-18 03:17:42', NULL, 0);
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('da752d52-8b44-4022-9fc1-15ebc19d999c', '残品料箱', NULL, 400.00, 300.00, 500.00, 60000000.000000, 5000.000, 100, 'DAMAGE', 'CONTAINER', 'DEFAULT', 0, 'admin', '2019-12-18 03:15:58', 'admin', '2019-12-18 03:15:58', NULL, 0);
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('f799edf1-0748-4de0-ae93-8241d336d282', 'BT01', NULL, 300.00, 1200.00, 1200.00, 432000000.000000, 5000.000, 5, 'INVENTORY', 'BIN', 'DEFAULT', 0, 'admin', '2019-12-18 05:50:52', 'admin', '2019-12-18 05:50:34', NULL, 1);
INSERT INTO `MD_STORAGELOCATIONTYPE` VALUES ('f9a99dba-c8b7-4485-a2dc-b9342815d308', 'BT01', NULL, 300.00, 1200.00, 1200.00, 432000000.000000, 5000.000, 5, 'INVENTORY', 'BIN', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 'admin', '2019-12-18 06:47:05', 'admin', '2019-12-18 06:47:05', NULL, 0);

-- ----------------------------
-- Table structure for MD_TIMECONFIG
-- ----------------------------
DROP TABLE IF EXISTS `MD_TIMECONFIG`;
CREATE TABLE `MD_TIMECONFIG`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL COMMENT '0，正常；1，问题；2，重包',
  `VERSION` int(11) NOT NULL,
  `START_DAY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作记录时刻',
  `END_DAY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作记录时刻',
  `START_HOUR` int(11) NULL DEFAULT 0,
  `END_HOUR` int(11) NULL DEFAULT NULL,
  `INTERVAL_MIN` int(11) NULL DEFAULT 0,
  `REFRESH_TIME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '每天刷新时间',
  `REFRESH_DAY` int(11) NULL DEFAULT NULL COMMENT '刷新前多少天数据',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `JOBRECORD_RECORD_TIME_FK`(`START_DAY`) USING BTREE,
  INDEX `JOBRECORD_EMPLOYEE_CODE_FK`(`START_HOUR`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_TURNAREA
-- ----------------------------
DROP TABLE IF EXISTS `MD_TURNAREA`;
CREATE TABLE `MD_TURNAREA`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作站ID',
  `MAP_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地图ID',
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '区域ID',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_TURNAREAPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `MD_TURNAREAPOSITION`;
CREATE TABLE `MD_TURNAREAPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `TURNAREANODETYPE` int(11) NULL DEFAULT NULL COMMENT '类型(入口一 1 入口二和二次入口 2 出口 3)',
  `XPOSITION` int(11) NULL DEFAULT NULL COMMENT 'Y坐标',
  `YPOSITION` int(11) NULL DEFAULT NULL COMMENT 'X坐标',
  `TURNAREA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ADDRESSCODEID` int(11) NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_TURNAREAQUEUE
-- ----------------------------
DROP TABLE IF EXISTS `MD_TURNAREAQUEUE`;
CREATE TABLE `MD_TURNAREAQUEUE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ROBOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TURNAREAPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for MD_WORKSTATION
-- ----------------------------
DROP TABLE IF EXISTS `MD_WORKSTATION`;
CREATE TABLE `MD_WORKSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '类型',
  `XPOS` int(11) NULL DEFAULT 0 COMMENT 'X坐标',
  `YPOS` int(11) NULL DEFAULT 0 COMMENT 'Y坐标',
  `PICKPACKWALL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拣货包装墙',
  `FIXED_SCANNER` bit(1) NULL DEFAULT NULL COMMENT '是否有固定扫描枪',
  `WORKING_FACE_ORIENTATION` int(11) NULL DEFAULT NULL COMMENT '工作面朝向',
  `PLACEMARK` int(11) NULL DEFAULT NULL COMMENT '当前地标',
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理区域',
  `STOPPOINT` int(11) NULL DEFAULT NULL COMMENT '停止点',
  `SCANPOINT` int(11) NULL DEFAULT NULL COMMENT '扫描点',
  `BUFFERPOINT` int(11) NULL DEFAULT NULL COMMENT '缓冲点',
  `ISCALLPOD` bit(1) NULL DEFAULT NULL COMMENT '是否呼叫POD',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATION_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICK_OR_PACK` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是捡货还是包装',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `WORKSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `WORKSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `WORKSTATION_PICKPACKWALL_ID_FK`(`PICKPACKWALL_ID`) USING BTREE,
  CONSTRAINT `WORKSTATION_PICKPACKWALL_ID_FK` FOREIGN KEY (`PICKPACKWALL_ID`) REFERENCES `OB_PICKPACKWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `WORKSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `MD_WORKSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `WORKSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '物理工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_WORKSTATION
-- ----------------------------
INSERT INTO `MD_WORKSTATION` VALUES ('3ba41fe1-6b95-4849-8e50-31995ade08b0', 'HLXNR-S01', '036a9c85-e92d-4d51-afd0-52900945240e', 0, 0, NULL, b'1', 3, 475, '37cfb73b-d19c-4035-8348-d8a093a83046', 475, 525, 426, b'0', NULL, NULL, NULL, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, '2020-01-15 16:40:16', 'Test1', '2019-12-18 06:15:55', 'admin', NULL, 157);
INSERT INTO `MD_WORKSTATION` VALUES ('4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 'HLXNR-S001', '73e716f9-fa27-443a-a1d6-2ff95fe37c3f', 0, 0, NULL, b'1', 3, 475, 'f742400b-3217-49dd-af37-504be2d6b240', 475, 525, 426, b'0', NULL, NULL, NULL, 'DEFAULT', 0, '2019-12-18 03:06:59', 'admin', '2019-12-18 03:06:59', 'admin', NULL, 0);

-- ----------------------------
-- Table structure for MD_WORKSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `MD_WORKSTATIONPOSITION`;
CREATE TABLE `MD_WORKSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '明细编号',
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '顺序',
  `ORDER_INDEX` int(11) NULL DEFAULT NULL COMMENT '顺序',
  `DIGITALLABEL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '电子标签',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '物理工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_WORKSTATIONPOSITION
-- ----------------------------
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('052f38c6-c507-4e1b-9d1d-c7edbadd125f', 'S01-5', 5, NULL, '2df01e77-1ea8-4633-b665-89d3b1af0ddd', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('2f3edf8d-ac96-474f-8c2c-a4c8b07aad28', 'S01-9', 9, NULL, '15f82a37-e5ab-4bce-b1b9-c5b06ebf0b09', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('2fa6d278-38b2-4664-a1aa-bbcb9fc3a728', 'S001-2', 2, NULL, 'd2802fa6-96c4-4e63-9c4b-3d88d7791a2b', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('4140a137-f237-47ca-91e0-0422a86c99ba', 'S01-7', 7, NULL, '368a73cf-b93f-490e-b23d-3d167bb10aaf', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('4d2b6d29-7262-47c8-b61d-6578f722ebdf', 'S01-3', 3, NULL, '6f0b4b03-69e6-40c2-9c6d-0c15af54f5a2', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('6a71c7b3-10b6-46bc-a4ba-4c9b9c8f734c', 'S001-3', 3, NULL, 'b058dbb4-c275-415e-91af-fa67e804fe0d', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('6d02558d-c40f-46ea-a360-f8b30c14b94a', 'S001-9', 9, NULL, 'faf7ac38-9c0c-4ee9-b9f6-84a08ad1a5fc', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('71fc8b6b-f1bd-4986-bf0e-0074cfdbccb6', 'S01-2', 2, NULL, '4dc620e8-2182-4e13-bea8-7bc4b9f64acf', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('7402f08d-1baf-43a7-8707-db9d9869d00d', 'S01-4', 4, NULL, '48097755-42fb-48cd-9ccf-8c0d432948d4', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('792247b4-0c79-459c-a9fb-9420ac240d03', 'S001-7', 7, NULL, '13a825bd-af78-43fd-9ce6-07982c8d7ee9', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('8393cc4f-92f0-4b83-a4cc-6a931a86dda9', 'S001-5', 5, NULL, '10b13deb-73be-4be2-af9b-9a1d0de9fddf', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('84bd1486-7c36-4eca-8dd8-411013bd4d2a', 'S001-8', 8, NULL, '1f902110-45e4-4910-9d2b-79b51e137c71', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('89ed60fe-b898-4d60-b079-1c8d41543135', 'S001-1', 1, NULL, 'c9cfeba3-f312-4baf-b849-bfc6dfe0f4a6', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('953bd55b-3fa5-402b-9d35-675ca2d0369e', 'S01-1', 1, NULL, 'b25bfc8f-352f-404d-adc4-0d51f88a199d', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('975ed222-60e2-4270-9ed0-3856565f532e', 'S001-4', 4, NULL, '8ce8f6de-73b0-412e-9b81-70da85d9cdaf', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('acbbb90f-a6c6-49c2-b747-7ee3f8d8b8e9', 'S001-21', 21, NULL, 'f75ef8c1-0b75-429a-8b5d-f4b4d92665b3', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('c41d3284-d510-49f6-a9b5-3e39643e6972', 'S01-8', 8, NULL, '2b5e81e3-c736-413b-bed4-3ad55b3acc85', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('d2272447-8683-4a4e-a925-8b7dd20f03b7', 'S001-22', 22, NULL, '2eb6ec26-06a5-4e52-8648-f4721f122f61', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('e3ed8f6c-b007-4ef9-8c07-f941b6c60040', 'S01-6', 6, NULL, '12abb54a-b9dc-4b1d-a481-e5eff66cd837', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('e6759db0-9318-4082-83cc-68730d2413e3', 'S01-21', 21, NULL, 'c0b1a4c3-b1cc-4b5d-8e9c-0d8703c96700', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('e9a97988-7d82-4615-9bdc-79cbb988b9ff', 'S001-6', 6, NULL, 'b41c6ec4-864e-4632-ab18-fddde4aebd43', 'DEFAULT', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 0, '2019-12-18 03:10:27', 'admin', '2019-12-18 03:10:27', 'admin', NULL, 0);
INSERT INTO `MD_WORKSTATIONPOSITION` VALUES ('fdb38e35-b30f-4276-a4a9-2770f51d9577', 'S01-22', 22, NULL, 'e96b69ae-97ba-4292-8631-2e7e9a5afad1', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 0, '2019-12-18 06:17:46', 'admin', '2019-12-18 06:18:35', 'admin', NULL, 1);

-- ----------------------------
-- Table structure for MD_WORKSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `MD_WORKSTATIONTYPE`;
CREATE TABLE `MD_WORKSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `WORKSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `WORKSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '物理工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_WORKSTATIONTYPE
-- ----------------------------
INSERT INTO `MD_WORKSTATIONTYPE` VALUES ('036a9c85-e92d-4d51-afd0-52900945240e', '2019-12-18 06:11:40', 'admin', '2019-12-18 06:11:40', 'admin', NULL, 0, 0, 'DEFAULT', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b');
INSERT INTO `MD_WORKSTATIONTYPE` VALUES ('73e716f9-fa27-443a-a1d6-2ff95fe37c3f', '2019-12-18 03:04:00', 'admin', '2019-12-18 03:04:00', 'admin', NULL, 0, 0, 'DEFAULT', 'DEFAULT');

-- ----------------------------
-- Table structure for MD_ZONE
-- ----------------------------
DROP TABLE IF EXISTS `MD_ZONE`;
CREATE TABLE `MD_ZONE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理区域',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ZONE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `ZONE_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `ZONE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ZONE_SECTION_ID_FK`(`SECTION_ID`) USING BTREE,
  CONSTRAINT `ZONE_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ZONE_SECTION_ID_FK` FOREIGN KEY (`SECTION_ID`) REFERENCES `WD_SECTION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ZONE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '区域' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MD_ZONE
-- ----------------------------
INSERT INTO `MD_ZONE` VALUES ('3224cb99-b3ef-427b-8f1d-57b6d77154f5', 'HLXNR-Area1', 'f742400b-3217-49dd-af37-504be2d6b240', NULL, 'SYSTEM', 'DEFAULT', 0, '2019-12-18 03:05:21', 'admin', '2019-12-18 03:05:21', 'admin', NULL, 0);
INSERT INTO `MD_ZONE` VALUES ('36d88dac-d6d8-4717-8323-0cd497b49f66', 'HLXNR-Area1', '37cfb73b-d19c-4035-8348-d8a093a83046', NULL, 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, '2019-12-18 06:10:59', 'admin', '2019-12-18 06:10:59', 'admin', NULL, 0);

-- ----------------------------
-- Table structure for MD_ZONE_ITEMGROUP
-- ----------------------------
DROP TABLE IF EXISTS `MD_ZONE_ITEMGROUP`;
CREATE TABLE `MD_ZONE_ITEMGROUP`  (
  `ZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ITEMGROUP_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ZONE_ID`, `ITEMGROUP_ID`) USING BTREE,
  INDEX `ZONE_ITEMGROUP_ITEMGROUP_ID_FK`(`ITEMGROUP_ID`) USING BTREE,
  INDEX `ZONE_ITEMGROUP_ZONE_ID_FK`(`ZONE_ID`) USING BTREE,
  CONSTRAINT `ZONE_ITEMGROUP_ITEMGROUP_ID_FK` FOREIGN KEY (`ITEMGROUP_ID`) REFERENCES `MD_ITEMGROUP` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ZONE_ITEMGROUP_ZONE_ID_FK` FOREIGN KEY (`ZONE_ID`) REFERENCES `MD_ZONE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '区域包含的商品类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPCELL
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPCELL`;
CREATE TABLE `OBP_OBPCELL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `XPOS` int(11) NOT NULL COMMENT 'X坐标',
  `YPOS` int(11) NOT NULL COMMENT 'Y坐标',
  `ZPOS` int(11) NOT NULL COMMENT 'Z坐标',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WALL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `LABEL_COLOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标签颜色',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `OBPCELL_NAME_WAREHOUSE_ID_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPCELL_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `OBPCELL_WALL_ID_FK`(`WALL_ID`) USING BTREE,
  INDEX `OBPCELL_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPCELL_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OBP_OBPCELLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPCELL_WALL_ID_FK` FOREIGN KEY (`WALL_ID`) REFERENCES `OBP_OBPWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPCELL_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理格' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPCELLTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPCELLTYPE`;
CREATE TABLE `OBP_OBPCELLTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '宽',
  `DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '深',
  `VOLUME` decimal(19, 6) NULL DEFAULT NULL COMMENT '体积',
  `LIFTING_CAPACITY` decimal(16, 3) NULL DEFAULT NULL COMMENT '承载能力',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `OBPCELLTYPE_NAME_WAREHOUSE_ID_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPCELLTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPCELLTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理格类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPLOCATION
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPLOCATION`;
CREATE TABLE `OBP_OBPLOCATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SOLVE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `LOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分配到货位取货的货位',
  `AMOUNT_SCANED` int(11) NOT NULL COMMENT '放入删单或残品车牌时，记录的当前品类商品的已扫描数量',
  `AMOUNT` int(11) NOT NULL,
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `ITEMDATA` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SOLVEPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SHIPMENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `ITEMNAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ISCALLPOD` bit(1) NULL DEFAULT NULL,
  `CELLNAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `SOLVE_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人',
  `SOLVE_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '处理时间',
  `STOCKUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPSOLVEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPSOLVEPOSITION_SOLVE_ID_FK`(`SOLVE_ID`) USING BTREE,
  INDEX `OBP_OBPSOLVEPOSITION_POSITION__FK`(`SOLVEPOSITION_ID`) USING BTREE,
  CONSTRAINT `OBP_LOCATION_WAREHOUSE` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBP_OBPLOCATION_SOLVE_FK` FOREIGN KEY (`SOLVE_ID`) REFERENCES `OBP_OBPSOLVE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBP_OBPSOLVEPOSITION_POSITION__FK` FOREIGN KEY (`SOLVEPOSITION_ID`) REFERENCES `OBP_OBPSOLVEPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理详情，即问题已确认之后，才会进入此表中数据；每处理到一个阶段都会相应更新数据' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPROBLEM
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPROBLEM`;
CREATE TABLE `OBP_OBPROBLEM`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '当前类型问题商品数量',
  `PROBLEM_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '问题类型，如多货、少货等',
  `SOLVED_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '已解决数量',
  `PROBLEM_STORAGELOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发现问题商品的容器',
  `JOB_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '触发环节',
  `CONTAINER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '装载问题商品的容器',
  `LOT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品有效期',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品',
  `SKU_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SKU码',
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品唯一编码',
  `SERIAL_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SN',
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单号',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `REPORT_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '问题触发人员',
  `SOLVED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '解决人员',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `RULE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `REPORT_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '触发时间',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPROBLEM_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPROBLEM_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `OBPROBLEM_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `OBPROBLEM_CUSTOMERSHIPMENT_ID_FK`(`SHIPMENT_ID`) USING BTREE,
  INDEX `OBPROBLEM_RULE_FK`(`RULE`) USING BTREE,
  CONSTRAINT `OBPROBLEM_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPROBLEM_CUSTOMERSHIPMENT_ID_FK` FOREIGN KEY (`SHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPROBLEM_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPROBLEM_RULE_FK` FOREIGN KEY (`RULE`) REFERENCES `IBP_INBOUNDPROBLEMRULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPROBLEM_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB所有报的问题' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPROBLEM_CHECK
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPROBLEM_CHECK`;
CREATE TABLE `OBP_OBPROBLEM_CHECK`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROBLEM_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '问题类型，如多货、少货等',
  `AMOUNT` decimal(11, 2) NOT NULL COMMENT '当前类型问题商品数量',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品',
  `SKU_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SKU码',
  `ITEM_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品唯一编码',
  `SOLVED_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '已解决数量',
  `JOB_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '触发环节',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `RULE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '规则',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `REPORT_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '问题触发人员',
  `SOLVED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '解决人员',
  `PROBLEM_STORAGELOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发现问题商品的容器',
  `LOT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品有效期',
  `REPORT_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '触发时间',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPSOLVE
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPSOLVE`;
CREATE TABLE `OBP_OBPSOLVE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROBLEM_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `AMOUNT` decimal(11, 2) NOT NULL COMMENT '已解决数量',
  `AMOUNT_PROBLEM` decimal(11, 2) NOT NULL COMMENT '问题数',
  `AMOUNT_SHIPMENT` decimal(11, 2) NULL DEFAULT NULL,
  `AMOUNT_SCANED` decimal(11, 2) NULL DEFAULT NULL,
  `AMOUNT_SCANED_PROBLEM` decimal(11, 2) NULL DEFAULT NULL,
  `CELL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题处理格',
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '商品',
  `SCANED` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否已扫描',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单绑定的工作站',
  `WALL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单绑定的问题处理车',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `SOLVE_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人',
  `SOLVE_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '处理时间',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货位',
  `OPERATE_RULE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPSOLVE_PROBLEM_ID_FK`(`PROBLEM_ID`) USING BTREE,
  INDEX `OBPSOLVE_CELL_ID_FK`(`CELL_ID`) USING BTREE,
  INDEX `OBPSOLVE_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `OBPSOLVE_STATION_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `OBPSOLVE_WALL_ID_FK`(`WALL_ID`) USING BTREE,
  INDEX `OBPSOLVE_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `OBPSOLVE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPSOLVE_CUSTOMERSHIPMENT_ID_FK`(`SHIPMENT_ID`) USING BTREE,
  INDEX `OBPSOLVE_STORAGELOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  INDEX `OBPSOLVE_OPERATE_RULE_FK`(`OPERATE_RULE`) USING BTREE,
  CONSTRAINT `OBPSOLVE_CELL_ID_FK` FOREIGN KEY (`CELL_ID`) REFERENCES `OBP_OBPCELL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_CUSTOMERSHIPMENT_ID_FK` FOREIGN KEY (`SHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_OPERATE_RULE_FK` FOREIGN KEY (`OPERATE_RULE`) REFERENCES `IBP_INBOUNDPROBLEMRULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_PROBLEM_ID_FK` FOREIGN KEY (`PROBLEM_ID`) REFERENCES `OBP_OBPROBLEM` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_STATION_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `OBP_OBPSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_STORAGELOCATION_ID_FK` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_WALL_ID_FK` FOREIGN KEY (`WALL_ID`) REFERENCES `OBP_OBPWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理，扫描问题订单时，将会把订单内的所有商品数据存储到该表，包含正常商品' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPSOLVECHECK
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPSOLVECHECK`;
CREATE TABLE `OBP_OBPSOLVECHECK`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROBLEMCHECK_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '问题',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '需核实的货位',
  `LOCATION_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '输入的数量（货位核实）',
  `LOCATION_PROBLEM_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '问题数量（货位核实）',
  `LOCATION_ITEMDATA_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '实际商品数量（货位核实）',
  `STORAGELOCATION_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '货位所有商品数量（货位核实）',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `REBINWALL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '需核实的REBIN墙',
  `REBINCELL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '需核实的REBIN格',
  `REBIN_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '输入的数量（核实REBIN格）',
  `REBIN_PROBLEM_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT '问题数量（核实REBIN格）',
  `REBIN_REBINCELL_AMOUNT` decimal(11, 2) NULL DEFAULT NULL COMMENT 'REBIN格所有商品数量（核实REBIN格）',
  `CHECK_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '核实人',
  `CHECK_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '核实时间',
  `LOCATION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货位是否已核实',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPSOLVECHECK_PROBLEM_ID_FK`(`PROBLEMCHECK_ID`) USING BTREE,
  INDEX `OBPSOLVECHECK_STORAGELOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  INDEX `OBPSOLVECHECK_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `OBPSOLVECHECK_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPSOLVECHECK_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVECHECK_PROBLEM_ID_FK` FOREIGN KEY (`PROBLEMCHECK_ID`) REFERENCES `OBP_OBPROBLEM_CHECK` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVECHECK_STORAGELOCATION_ID_FK` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVECHECK_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理货位核实' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPSOLVEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPSOLVEPOSITION`;
CREATE TABLE `OBP_OBPSOLVEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SOLVE_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理规则，指问题解决结果',
  `SOLVE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '问题(只有当为强删处理时，值可为null)',
  `LOCATION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分配到货位取货的货位',
  `ITEMDATA` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品(只有当为强删处理时，值可为null)',
  `AMOUNT_SCANED` decimal(11, 2) NOT NULL COMMENT '放入删单或残品车牌时，记录的当前品类商品的已扫描数量',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `SHIPMENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '订单',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `LOCATION_CONTAINER` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '放删单商品的容器',
  `SOLVE_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人',
  `SOLVE_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '处理时间',
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPSOLVEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPSOLVEPOSITION_SOLVE_ID_FK`(`SOLVE_ID`) USING BTREE,
  CONSTRAINT `OBPSOLVEPOSITION_SOLVE_ID_FK` FOREIGN KEY (`SOLVE_ID`) REFERENCES `OBP_OBPSOLVE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSOLVEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理详情，即问题已确认之后，才会进入此表中数据；每处理到一个阶段都会相应更新数据' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPSTATION
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPSTATION`;
CREATE TABLE `OBP_OBPSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作站状态',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '类型',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `OBPSTATION_NAME_WAREHOUSE_ID_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `OBPSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `OBPSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  INDEX `OBPSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OBP_OBPSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPSTATIONPOSITION`;
CREATE TABLE `OBP_OBPSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `OBPSTATIONPOSITION_STATION_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `OBPSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPSTATIONPOSITION_STATION_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `OBP_OBPSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理工作站详情' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPSTATIONTYPE`;
CREATE TABLE `OBP_OBPSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '类型（问题处理，问题核实）',
  `CREATED_DATE` datetime(0) NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` datetime(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `OBPSOLVESTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPSOLVESTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPSOLVESTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPSTATIONTYPEPOSITION`;
CREATE TABLE `OBP_OBPSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPSTATIONTYPEPOSITION_OBPSTATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  INDEX `OBPSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPSTATIONTYPEPOSITION_OBPSTATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `OBP_OBPSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理工作站类型详情' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPWALL
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPWALL`;
CREATE TABLE `OBP_OBPWALL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `NUMBER_OF_ROWS` int(11) NOT NULL COMMENT '行数',
  `NUMBER_OF_COLUMNS` int(11) NOT NULL COMMENT '列数',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Unoccupied' COMMENT '状态',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `OBPWALL_NAME_WAREHOUSE_ID_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPWALL_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `OBPWALL_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPWALL_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OBP_OBPWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OBPWALL_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理车' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBPWALLTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBPWALLTYPE`;
CREATE TABLE `OBP_OBPWALLTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `NUMBER_OF_ROWS` int(11) NOT NULL COMMENT '行数',
  `NUMBER_OF_COLUMNS` int(11) NOT NULL COMMENT '列数',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `OBPWALLTYPE_NAME_WAREHOUSE_ID_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPWALLTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OBPWALLTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'OB问题处理车类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OBP_OBSOLVE_CHECK
-- ----------------------------
DROP TABLE IF EXISTS `OBP_OBSOLVE_CHECK`;
CREATE TABLE `OBP_OBSOLVE_CHECK`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROBLEMCHECK_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AMOUNT` decimal(11, 2) NOT NULL COMMENT '已解决数量',
  `AMOUNT_PROBLEM` decimal(11, 2) NOT NULL COMMENT '问题数',
  `CELL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `SOLVE_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货位',
  `OPERATE_RULE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理规则',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SOLVE_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '处理时间',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OBPSOLVE_PROBLEMCHECK_ID_FK`(`PROBLEMCHECK_ID`) USING BTREE,
  INDEX `OBPSOLVE_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `OBPSOLVE_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `OBPSOLVE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `OBPSOLVE_STORAGELOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  INDEX `OBPSOLVE_OPERATE_RULE_FK`(`OPERATE_RULE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_BOXTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_BOXTYPE`;
CREATE TABLE `OB_BOXTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TYPE_GROUP` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '宽',
  `THICKNESS` decimal(15, 2) NULL DEFAULT NULL COMMENT '厚度',
  `VOLUME` decimal(19, 6) NULL DEFAULT NULL COMMENT '体积',
  `WEIGHT` decimal(16, 3) NULL DEFAULT NULL COMMENT '重量',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `BOXTYPE_NAME_UK`(`NAME`, `CLIENT_ID`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `BOXTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `BOXTYPE_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  CONSTRAINT `BOXTYPE_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `BOXTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '箱型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_BOXTYPE
-- ----------------------------
INSERT INTO `OB_BOXTYPE` VALUES ('6e487cec-f668-4260-b252-dac4ceb6dc16', 'BOX', 'Box1', NULL, 10000.00, 10000.00, 10000.00, 20.00, 1000000000000.000000, 20.000, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, 0, NULL, 'admin', '2019-12-18 06:26:14', 'admin', '2019-12-18 06:26:14');

-- ----------------------------
-- Table structure for OB_CARRIER
-- ----------------------------
DROP TABLE IF EXISTS `OB_CARRIER`;
CREATE TABLE `OB_CARRIER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CARRIER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '承运商编号',
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `CARRIER_NUMBER_UK`(`CARRIER_NO`, `WAREHOUSE_ID`) USING BTREE,
  UNIQUE INDEX `CARRIER_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `CARRIER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `DELIVERYSORTCODE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `CARRIER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '承运商' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_COLLATEPROFILE
-- ----------------------------
DROP TABLE IF EXISTS `OB_COLLATEPROFILE`;
CREATE TABLE `OB_COLLATEPROFILE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FROM_DAYS` int(11) NOT NULL,
  `FROM_HOURS` int(11) NOT NULL,
  `FROM_MINUTES` int(11) NOT NULL,
  `TO_DAYS` int(11) NOT NULL,
  `TO_HOURS` int(11) NOT NULL,
  `TO_MINUTES` int(11) NOT NULL,
  `PROFILE_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `TEMPLATE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROCESSPATH_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `ORDER_INDEX` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_COLLATETEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `OB_COLLATETEMPLATE`;
CREATE TABLE `OB_COLLATETEMPLATE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL,
  `MIN_ITEMS` decimal(15, 2) NULL DEFAULT NULL,
  `MAX_ITEMS` decimal(15, 2) NULL DEFAULT NULL,
  `MIN_SHIPMENTS` decimal(15, 2) NULL DEFAULT NULL,
  `MAX_SHIPMENTS` decimal(15, 2) NULL DEFAULT NULL,
  `PURE_EXSD` bit(1) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `COLLATETEMPLATE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_CUSTOMERORDER
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERORDER`;
CREATE TABLE `OB_CUSTOMERORDER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CUSTOMER_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '客户名称',
  `CUSTOMER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '客户编号',
  `DELIVERY_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '发货点',
  `SORT_CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目的地',
  `ORDER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `PRIORITY` int(11) NOT NULL COMMENT '优先等级',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `STRATEGY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '订单策略',
  `TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单类型：出库单，调拨单',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `CUSTOMERORDER_ORDER_NO_UK`(`ORDER_NO`) USING BTREE,
  INDEX `CUSTOMERORDER_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `CUSTOMERORDER_STRATEGY_ID_FK`(`STRATEGY_ID`) USING BTREE,
  INDEX `CUSTOMERORDER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `CUSTOMERORDER_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERORDER_STRATEGY_ID_FK` FOREIGN KEY (`STRATEGY_ID`) REFERENCES `OB_ORDERSTRATEGY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERORDER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_CUSTOMERORDERPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERORDERPOSITION`;
CREATE TABLE `OB_CUSTOMERORDERPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `VERSION` int(11) NOT NULL,
  `AMOUNT` decimal(17, 4) NOT NULL COMMENT '数量',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `POSITION_NO` int(11) NOT NULL COMMENT '订单详情编号',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `ORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `CUSTOMERORDERPOS_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `CUSTOMERORDERPOS_ORDER_ID_FK`(`ORDER_ID`) USING BTREE,
  INDEX `CUSTOMERORDERPOS_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `CUSTOMERORDERPOS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `CUSTOMERORDERPOS_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERORDERPOS_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERORDERPOS_ORDER_ID_FK` FOREIGN KEY (`ORDER_ID`) REFERENCES `OB_CUSTOMERORDER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERORDERPOS_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_CUSTOMERSHIPMENT
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERSHIPMENT`;
CREATE TABLE `OB_CUSTOMERSHIPMENT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CUSTOMER_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '客户名称',
  `CUSTOMER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '客户编号',
  `DELIVERY_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '发货点',
  `SORT_CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目的地',
  `SHIPMENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单拆分后的编号',
  `PRIORITY` int(11) NOT NULL COMMENT '优先等级',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `ORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单ID',
  `BOXTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '箱形',
  `PICK_MODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拣货方式',
  `PICKINGCATEGORY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PASSED_OVER_COUNT` int(11) NOT NULL COMMENT '未选中的次数',
  `ACTIVATED` bit(1) NOT NULL COMMENT '是否激活',
  `ACTIVATION_DATE` datetime(0) NULL DEFAULT NULL COMMENT '激活时间',
  `SELECTED` bit(1) NOT NULL COMMENT '是否进入Select Window',
  `COMPLETED` bit(1) NOT NULL COMMENT '是否已全部分配拣货任务',
  `PICKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICKPACKCELL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STRATEGY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单策略',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ACCOMPLISH` int(11) NULL DEFAULT 0,
  `DESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '目的容器',
  `PICKFROMBAY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '开始货架',
  `PICKTOBAY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '结束货架',
  `TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单类型用于区分补货(replenish)还是日常订单(order)',
  `DOCK_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `SHIPMENT_INDEX` int(11) NULL DEFAULT NULL COMMENT '序号',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `CUSTOMERSHIPMENT_SHIPMENT_NO_UK`(`SHIPMENT_NO`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_ORDER_ID_FK`(`ORDER_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_BOXTYPE_ID_FK`(`BOXTYPE_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_STRATEGY_ID_FK`(`STRATEGY_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_PICKINGCATEGORY_ID_FK`(`PICKINGCATEGORY_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_PICKSTATION_ID_FK`(`PICKSTATION_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_PICKPACKCELL_ID_FK`(`PICKPACKCELL_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_DESTATION_ID_FK`(`DESTINATION_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_FROMBAY_ID_FK`(`PICKFROMBAY_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENT_TOBAY_ID_FK`(`PICKTOBAY_ID`) USING BTREE,
  CONSTRAINT `CUSTOMERSHIPMENT_BOXTYPE_ID_FK` FOREIGN KEY (`BOXTYPE_ID`) REFERENCES `OB_BOXTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_DESTATION_ID_FK` FOREIGN KEY (`DESTINATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_ORDER_ID_FK` FOREIGN KEY (`ORDER_ID`) REFERENCES `OB_CUSTOMERORDER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_PICKINGCATEGORY_ID_FK` FOREIGN KEY (`PICKINGCATEGORY_ID`) REFERENCES `OB_PICKINGCATEGORY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_PICKPACKCELL_ID_FK` FOREIGN KEY (`PICKPACKCELL_ID`) REFERENCES `OB_PICKPACKCELL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_STRATEGY_ID_FK` FOREIGN KEY (`STRATEGY_ID`) REFERENCES `OB_ORDERSTRATEGY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_TOBAY_ID_FK` FOREIGN KEY (`PICKTOBAY_ID`) REFERENCES `MD_BAY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENT_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '面单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_CUSTOMERSHIPMENT
-- ----------------------------
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('129beb35-1699-4daa-8fb5-068f34654c03', NULL, NULL, NULL, NULL, 'OUTBOUND-test-57', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 10:27:34', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 10:37:32', '2019-12-25 10:26:47', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('15e466c4-ce59-4b9e-9e12-714a362d2382', NULL, NULL, NULL, NULL, 'OUTBOUND-test-99', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 14:57:57', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 15:01:33', '2019-12-25 14:56:58', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('1b1efe8f-b9e6-403f-94c3-7580064f2be8', 'OUTBOUND-test-52', 'OUTBOUND-test-52', '2019-12-24 16:19:00', '小内燃', 'OUTBOUND-test-52', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 09:52:54', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 09:52:54', '2019-12-24 16:15:52', 'system', NULL, 0, 3, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('2826cebc-085e-4b39-bf67-77841bdbc215', 'OUTBOUND-test-49', 'OUTBOUND-test-49', '2019-12-24 16:18:56', '小内燃', 'OUTBOUND-test-49', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-24 15:52:19', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-24 15:55:05', '2019-12-24 15:50:02', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('2b361f97-bf36-4897-8282-a0eb8b771e59', 'lllllllll', 'lllllllll', '2020-01-15 14:45:53', '小内燃', 'lllllllll', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2020-01-15 14:46:20', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2020-01-15 14:48:34', '2020-01-15 14:45:53', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('2fd7fdb2-3d66-49c6-a08e-31c76a3e79de', NULL, NULL, NULL, NULL, 'OUTBOUND-test-990', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 15:04:54', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 15:07:46', '2019-12-25 15:04:18', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('713e7932-7f2c-4880-88ae-3d571850d5d9', 'BT202001151530', 'BT202001151530', '2020-01-15 16:11:36', '小内燃', 'BT202001151530', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2020-01-15 16:29:24', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2020-01-15 16:33:02', '2020-01-15 16:11:36', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('8293e99c-a949-4bb0-ad87-d7ec55ab774b', 'aaaaaaaaaaa', 'aaaaaaaaaaa', '2020-01-15 15:13:22', '小内燃', 'aaaaaaaaaaa', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2020-01-15 15:13:35', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2020-01-15 15:15:03', '2020-01-15 15:13:22', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('b206e066-01d3-41e7-b4b0-4c76a2298659', 'OUTBOUND-test-01', 'OUTBOUND-test-01', '2019-12-23 16:18:17', '小内燃', 'OUTBOUND-test-01', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-23 16:20:37', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-23 18:38:32', '2019-12-23 16:16:04', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('b940abe1-2bd9-4cd3-b47e-a6e15481e0d7', NULL, NULL, NULL, NULL, 'OUTBOUND-test-89', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 13:37:28', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 13:39:50', '2019-12-25 13:36:52', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('c285e6bc-a2b3-481f-9295-82556cee784a', NULL, NULL, NULL, NULL, 'OUTBOUND-test-992', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 15:31:06', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 15:34:22', '2019-12-25 15:30:39', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('ca8fc06c-07b7-4b65-be5e-63a9ce229207', NULL, NULL, NULL, NULL, 'OUTBOUND-test-61', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 11:13:17', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 11:17:22', '2019-12-25 11:12:55', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('cbbad426-2148-4f81-8109-39fa84c3d03b', 'BT202001151531', 'BT202001151531', '2020-01-15 16:12:34', '小内燃', 'BT202001151531', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 1, b'1', '2020-01-15 16:29:26', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2020-01-15 16:36:11', '2020-01-15 16:12:34', 'Test1', NULL, 0, 6, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('d1c2e784-3934-40cc-afdc-934b472584d0', 'OUTBOUND-test-59', 'OUTBOUND-test-59', '2019-12-24 16:19:02', '小内燃', 'OUTBOUND-test-59', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-24 15:58:13', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-24 16:01:00', '2019-12-24 15:56:54', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('d907a82e-143d-4eb5-a6ce-d20f6b57462a', NULL, NULL, NULL, NULL, 'OUTBOUND-test-991', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 15:13:53', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 15:28:28', '2019-12-25 15:13:21', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('dc0fcde1-b235-4a43-a372-7c5eec944b35', 'xxxxxxxxx', 'xxxxxxxxx', '2020-01-15 14:58:44', '小内燃', 'xxxxxxxxx', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2020-01-15 14:58:49', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2020-01-15 15:01:27', '2020-01-15 14:58:44', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('de7526ed-39f2-41f0-8a65-58174e8f6857', NULL, NULL, NULL, NULL, 'OUTBOUND-test-994', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 16:57:04', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 17:01:11', '2019-12-25 16:56:36', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('e6547f74-91fc-4131-9cd4-10c16424d883', 'OUTBOUND-test-56', 'OUTBOUND-test-56', '2019-12-25 10:20:42', '小内燃', 'OUTBOUND-test-56', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 10:20:12', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 10:26:06', '2019-12-25 10:18:52', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('f6785774-cbb3-464b-a9d0-bd12a34e41b6', 'OUTBOUND-test-55', 'OUTBOUND-test-55', '2019-12-25 10:20:53', '小内燃', 'OUTBOUND-test-55', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 10:00:34', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 10:01:52', '2019-12-25 09:53:22', 'Test1', NULL, 0, 5, NULL);
INSERT INTO `OB_CUSTOMERSHIPMENT` VALUES ('f6b6da2d-39a4-4e69-8ae7-2e667dccd89e', NULL, NULL, NULL, NULL, 'OUTBOUND-test-993', 1, 700, NULL, NULL, NULL, 'de413b04-08d1-4043-addc-4ae2a737fa35', 0, b'1', '2019-12-25 16:52:20', b'1', b'0', NULL, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 0, NULL, NULL, NULL, 'Customer', NULL, '37cfb73b-d19c-4035-8348-d8a093a83046', 'SYSTEM', '2019-12-25 16:54:43', '2019-12-25 16:43:06', 'Test1', NULL, 0, 5, NULL);

-- ----------------------------
-- Table structure for OB_CUSTOMERSHIPMENTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERSHIPMENTPOSITION`;
CREATE TABLE `OB_CUSTOMERSHIPMENTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `LINE_NO` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '行号',
  `AMOUNT` decimal(17, 4) NOT NULL DEFAULT 0.0000 COMMENT '数量',
  `AMOUNT_PICKED` decimal(17, 4) NULL DEFAULT 0.0000,
  `AMOUNT_REBINED` decimal(17, 4) NULL DEFAULT NULL,
  `STATE` int(11) NOT NULL COMMENT '状态',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `POSITION_NO` int(11) NOT NULL COMMENT '详细编号',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `STOCK_STATE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拣货商品的类型',
  `LOT_DATE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '指定拣选的到期日',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENTPOS_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENTPOS_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENTPOS_SHIPMENT_ID_FK`(`SHIPMENT_ID`) USING BTREE,
  INDEX `CUSTOMERSHIPMENTPOS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `CUSTOMERSHIPMENTPOS_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENTPOS_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENTPOS_SHIPMENT_ID_FK` FOREIGN KEY (`SHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `CUSTOMERSHIPMENTPOS_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '面单明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_CUSTOMERSHIPMENTPOSITION
-- ----------------------------
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('1c06fbfd-39d5-4cdb-84b4-b2293bb213b1', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'd907a82e-143d-4eb5-a6ce-d20f6b57462a', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:13:21', 'SYSTEM', '2019-12-25 15:28:28', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('26cdf5e0-5b52-4dd8-b3aa-8651d1cecb1e', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'b940abe1-2bd9-4cd3-b47e-a6e15481e0d7', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:36:52', 'SYSTEM', '2019-12-25 13:39:50', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('2a047e43-1bc7-423b-8de9-6e991a00312a', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'c285e6bc-a2b3-481f-9295-82556cee784a', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:30:39', 'SYSTEM', '2019-12-25 15:34:20', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('48c20157-d263-474d-946a-92697f959251', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'e6547f74-91fc-4131-9cd4-10c16424d883', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:18:53', 'SYSTEM', '2019-12-25 10:26:06', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('4b096886-26af-41ba-97b7-e669cecf7378', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', '2fd7fdb2-3d66-49c6-a08e-31c76a3e79de', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:04:18', 'SYSTEM', '2019-12-25 15:07:45', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('5d29245d-4053-4ac6-b652-00dfdc570171', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', '129beb35-1699-4daa-8fb5-068f34654c03', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:26:47', 'SYSTEM', '2019-12-25 10:37:32', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('67e7b04b-8d12-46a2-a065-bc5318efee59', NULL, 1.0000, 1.0000, NULL, 700, 'Z4592-32050', '2b361f97-bf36-4897-8282-a0eb8b771e59', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:45:53', 'SYSTEM', '2020-01-15 14:48:34', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('733dabaa-dc50-44b3-9876-9522f047ca96', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', '15e466c4-ce59-4b9e-9e12-714a362d2382', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 14:56:58', 'SYSTEM', '2019-12-25 15:01:32', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('7b081fe8-2a1b-4dfd-ae40-f953a191b944', NULL, 1000.0000, 1000.0000, NULL, 700, 'Z4592-32050', '713e7932-7f2c-4880-88ae-3d571850d5d9', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:11:36', 'SYSTEM', '2020-01-15 16:33:02', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('8694d8a3-8782-427b-af95-69ce74cca623', NULL, 1.0000, 1.0000, NULL, 700, 'Z4592-32050', '8293e99c-a949-4bb0-ad87-d7ec55ab774b', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:13:22', 'SYSTEM', '2020-01-15 15:15:03', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('875d2684-b5c1-4858-ac03-93401fc8588e', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'ca8fc06c-07b7-4b65-be5e-63a9ce229207', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 11:12:55', 'SYSTEM', '2019-12-25 11:17:22', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('93e098b6-a23f-4549-b22a-93783346a4a9', NULL, 1.0000, 1.0000, NULL, 700, 'Z4592-32050', 'dc0fcde1-b235-4a43-a372-7c5eec944b35', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:58:44', 'SYSTEM', '2020-01-15 15:01:27', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('9715c3e3-efb6-4885-b1e1-b2af362656f8', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'f6b6da2d-39a4-4e69-8ae7-2e667dccd89e', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:43:06', 'SYSTEM', '2019-12-25 16:54:42', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('a2114c0d-2079-4397-809a-4d9bace5e523', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'b206e066-01d3-41e7-b4b0-4c76a2298659', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 16:16:04', 'SYSTEM', '2019-12-23 18:38:32', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('af484476-36b0-4818-98a4-cee7064d50be', NULL, 2000.0000, 2000.0000, NULL, 700, 'Z4592-10016', 'cbbad426-2148-4f81-8109-39fa84c3d03b', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:12:34', 'SYSTEM', '2020-01-15 16:36:11', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('b5a29ef4-8008-4ac3-8838-ca320f9d1ce7', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'f6785774-cbb3-464b-a9d0-bd12a34e41b6', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 09:53:22', 'SYSTEM', '2019-12-25 10:01:52', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('dc7fa9ec-13b4-42e0-be23-b6a4b0531413', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', '2826cebc-085e-4b39-bf67-77841bdbc215', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:50:02', 'SYSTEM', '2019-12-24 15:55:04', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('ebc3e7cd-3d99-4c0b-8513-1bcb0063e162', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'de7526ed-39f2-41f0-8a65-58174e8f6857', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:56:36', 'SYSTEM', '2019-12-25 17:01:11', 'Test1', 0, 2);
INSERT INTO `OB_CUSTOMERSHIPMENTPOSITION` VALUES ('ee748258-00aa-4f2b-8120-ba9f48791fde', NULL, 1.0000, 1.0000, NULL, 700, 'ITEM-XNR-01', 'd1c2e784-3934-40cc-afdc-934b472584d0', NULL, 1, 1, NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:56:54', 'SYSTEM', '2019-12-24 16:00:59', 'Test1', 0, 2);

-- ----------------------------
-- Table structure for OB_CUSTOMERSHIPMENTRECORD
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERSHIPMENTRECORD`;
CREATE TABLE `OB_CUSTOMERSHIPMENTRECORD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '面单',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `STATE_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态名称',
  `STATION_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作站名称',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `SHIPMENTRECORD_CLIENT_ID_FK2`(`CLIENT_ID`) USING BTREE,
  INDEX `SHIPMENTRECORD_WAREHOUSE_ID_FK2`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `SHIPMENTRECORD_OPERATOR_ID_FK2`(`OPERATOR_ID`) USING BTREE,
  INDEX `SHIPMENTRECORD_SHIPMENT_ID_FK2`(`SHIPMENT_ID`) USING BTREE,
  CONSTRAINT `SHIPMENTRECORD_CLIENT_ID_FK2` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SHIPMENTRECORD_OPERATOR_ID_FK2` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SHIPMENTRECORD_SHIPMENT_ID_FK2` FOREIGN KEY (`SHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SHIPMENTRECORD_WAREHOUSE_ID_FK2` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '面单状态发生变化是的记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_CUSTOMERSHIPMENTRECORD
-- ----------------------------
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('0152d18e-445b-41e6-a663-d367487f7fb9', 'ca8fc06c-07b7-4b65-be5e-63a9ce229207', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 11:13:08', 'system', '2019-12-25 11:13:08', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('03761224-b166-4b6f-beb8-1d2ee33fe12c', '2b361f97-bf36-4897-8282-a0eb8b771e59', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:48:34', 'Test1', '2020-01-15 14:48:34', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('078841f5-7936-4bfd-96f6-99068103469a', 'f6785774-cbb3-464b-a9d0-bd12a34e41b6', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:00:34', 'system', '2019-12-25 10:00:34', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('0a37c921-dd9f-4a66-b991-405c6ba4b49c', 'f6785774-cbb3-464b-a9d0-bd12a34e41b6', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:01:52', 'Test1', '2019-12-25 10:01:52', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('0bb34a37-38e8-4b65-9db8-08999f826f48', '1b1efe8f-b9e6-403f-94c3-7580064f2be8', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 09:52:54', 'system', '2019-12-25 09:52:54', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('1145001b-87b1-4f6e-b8cd-dc1af013c1d1', '129beb35-1699-4daa-8fb5-068f34654c03', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:37:32', 'Test1', '2019-12-25 10:37:32', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('125833a5-eb54-4d04-b920-bed39b4e605b', 'f6785774-cbb3-464b-a9d0-bd12a34e41b6', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:01:52', 'Test1', '2019-12-25 10:01:52', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('138fb3ce-a740-4a69-bcfc-2751700b0603', 'e6547f74-91fc-4131-9cd4-10c16424d883', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:26:06', 'Test1', '2019-12-25 10:26:06', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('18fc2748-4900-437d-9f07-12a6a090a444', '15e466c4-ce59-4b9e-9e12-714a362d2382', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:01:33', 'Test1', '2019-12-25 15:01:33', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('1bdb75f1-5471-4f33-a9c6-d2db6344273d', '2fd7fdb2-3d66-49c6-a08e-31c76a3e79de', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:07:45', 'Test1', '2019-12-25 15:07:45', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('1da1fe70-300b-4306-b193-420a61cd4c14', '2826cebc-085e-4b39-bf67-77841bdbc215', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:55:04', 'Test1', '2019-12-24 15:55:04', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('1e4d3908-41a9-40ad-9b25-759546141c64', '2826cebc-085e-4b39-bf67-77841bdbc215', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:51:15', 'system', '2019-12-24 15:51:15', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('204bdf5a-41aa-4a48-bcdc-bea34c65715b', '2b361f97-bf36-4897-8282-a0eb8b771e59', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:45:54', 'system', '2020-01-15 14:45:54', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('21de6336-0856-43f3-8503-38d7632c643d', 'd1c2e784-3934-40cc-afdc-934b472584d0', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:58:13', 'system', '2019-12-24 15:58:13', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('25468d87-3a71-42fe-8ecf-bb68debf94a6', '2826cebc-085e-4b39-bf67-77841bdbc215', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:51:20', 'system', '2019-12-24 15:51:20', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('273721f5-76ef-4758-ba0c-6f4249eb23d1', 'cbbad426-2148-4f81-8109-39fa84c3d03b', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:29:26', 'system', '2020-01-15 16:29:26', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('2ceeb8f3-f618-4c16-ba66-824ee32e6748', 'e6547f74-91fc-4131-9cd4-10c16424d883', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:26:06', 'Test1', '2019-12-25 10:26:06', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('30137271-424c-4658-8c45-f5f5d1fbd3bd', 'de7526ed-39f2-41f0-8a65-58174e8f6857', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 17:01:11', 'Test1', '2019-12-25 17:01:11', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('32c76de3-598a-4649-93d7-652de8fd5c9f', 'b206e066-01d3-41e7-b4b0-4c76a2298659', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 18:38:32', 'Test1', '2019-12-23 18:38:32', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('349a2d40-22c1-4269-8e9e-3283eb8cf2dd', '713e7932-7f2c-4880-88ae-3d571850d5d9', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:33:02', 'Test1', '2020-01-15 16:33:02', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('40085bfe-8601-46be-a0ca-7dbe272d583f', '8293e99c-a949-4bb0-ad87-d7ec55ab774b', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:15:03', 'Test1', '2020-01-15 15:15:03', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('406218a3-4d47-4418-990b-cd6d7dd5041c', '8293e99c-a949-4bb0-ad87-d7ec55ab774b', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:15:03', 'Test1', '2020-01-15 15:15:03', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('442d6a6d-c885-4512-a7d3-992e13789ff3', 'c285e6bc-a2b3-481f-9295-82556cee784a', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:34:22', 'Test1', '2019-12-25 15:34:22', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('49ce5a0d-777e-4ec1-8277-0306a0a8bffe', 'b206e066-01d3-41e7-b4b0-4c76a2298659', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 16:20:37', 'system', '2019-12-23 16:20:37', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('4a130390-73d8-4291-9961-4e4c444cf113', 'b940abe1-2bd9-4cd3-b47e-a6e15481e0d7', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:39:50', 'Test1', '2019-12-25 13:39:50', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('4c66b1b6-8353-4398-817c-7cd1cfcfffe0', '713e7932-7f2c-4880-88ae-3d571850d5d9', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:11:43', 'system', '2020-01-15 16:11:43', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('4feb3cd5-34df-4de2-8e1c-ccdbbc06a3b3', 'ca8fc06c-07b7-4b65-be5e-63a9ce229207', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 11:13:17', 'system', '2019-12-25 11:13:17', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('544c1cfa-7ffe-47ea-827e-ea8ab389b29f', 'd907a82e-143d-4eb5-a6ce-d20f6b57462a', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:13:49', 'system', '2019-12-25 15:13:49', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('566fb2b5-304e-4b4e-a240-8b43da86fb29', 'dc0fcde1-b235-4a43-a372-7c5eec944b35', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:58:49', 'system', '2020-01-15 14:58:49', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('58291d14-654c-4f2e-86ab-9ddd73b8971d', 'd1c2e784-3934-40cc-afdc-934b472584d0', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 16:01:00', 'Test1', '2019-12-24 16:01:00', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5a6c625d-d362-4b3f-a431-b0a2a2688b48', 'ca8fc06c-07b7-4b65-be5e-63a9ce229207', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 11:17:22', 'Test1', '2019-12-25 11:17:22', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5aabf254-68fc-4e05-8423-7124f6a9e030', '713e7932-7f2c-4880-88ae-3d571850d5d9', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:11:38', 'system', '2020-01-15 16:11:38', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5ae7e5c1-d5d9-48ec-ac0f-07a5b8ca85aa', 'de7526ed-39f2-41f0-8a65-58174e8f6857', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:56:59', 'system', '2019-12-25 16:56:59', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5bea4424-805d-47fb-83d7-5a5ba6491655', 'dc0fcde1-b235-4a43-a372-7c5eec944b35', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:58:45', 'system', '2020-01-15 14:58:45', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5c605e43-0c38-4947-ab1a-8ab480c19d25', '1b1efe8f-b9e6-403f-94c3-7580064f2be8', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 16:16:14', 'system', '2019-12-24 16:16:14', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5c85a36b-35ed-4646-ac15-deb3c2b0c8ef', '15e466c4-ce59-4b9e-9e12-714a362d2382', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:01:32', 'Test1', '2019-12-25 15:01:32', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5f6bb209-4ad1-49c0-b93b-58df2c06428c', '2b361f97-bf36-4897-8282-a0eb8b771e59', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:46:20', 'system', '2020-01-15 14:46:20', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('5fb70ead-b4f7-49cc-a389-fad815b43850', 'f6b6da2d-39a4-4e69-8ae7-2e667dccd89e', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:52:20', 'system', '2019-12-25 16:52:20', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('6150bb92-ef05-4174-acdb-36fbf1a40538', 'c285e6bc-a2b3-481f-9295-82556cee784a', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:31:02', 'system', '2019-12-25 15:31:02', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('644bda06-c1d0-4cc1-bd06-055acf7283d9', '2fd7fdb2-3d66-49c6-a08e-31c76a3e79de', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:04:46', 'system', '2019-12-25 15:04:46', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('66e71ab2-85e1-4274-9ee0-dc2f42feb4ce', '8293e99c-a949-4bb0-ad87-d7ec55ab774b', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:13:35', 'system', '2020-01-15 15:13:35', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('68b994c1-c015-4183-b54b-f1f775195152', 'b206e066-01d3-41e7-b4b0-4c76a2298659', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 18:38:32', 'Test1', '2019-12-23 18:38:32', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('68fe09f6-68f9-42c8-980d-9bd04aff88b7', '713e7932-7f2c-4880-88ae-3d571850d5d9', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:33:02', 'Test1', '2020-01-15 16:33:02', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('6c662862-2581-46d0-88be-0c801fd63fe5', '2b361f97-bf36-4897-8282-a0eb8b771e59', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:48:34', 'Test1', '2020-01-15 14:48:34', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('6de5d1ca-1197-4dc1-9517-a6bab2b84813', '2fd7fdb2-3d66-49c6-a08e-31c76a3e79de', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:07:45', 'Test1', '2019-12-25 15:07:45', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('73459e76-b078-45d7-b872-534fa3d5b090', 'c285e6bc-a2b3-481f-9295-82556cee784a', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:31:06', 'system', '2019-12-25 15:31:06', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('74f7b50c-2464-4808-ad4c-221ecce47c18', 'e6547f74-91fc-4131-9cd4-10c16424d883', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:20:11', 'system', '2019-12-25 10:20:11', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('7967899d-07de-47b7-9691-77bddb6b7200', 'd1c2e784-3934-40cc-afdc-934b472584d0', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 16:01:00', 'Test1', '2019-12-24 16:01:00', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('7ab7aeb5-a6f4-4216-8f1b-78cedaae029a', 'c285e6bc-a2b3-481f-9295-82556cee784a', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:34:22', 'Test1', '2019-12-25 15:34:22', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('7c4c5dd5-5edc-4aa0-b371-ec6501d8e028', 'b940abe1-2bd9-4cd3-b47e-a6e15481e0d7', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:37:22', 'system', '2019-12-25 13:37:22', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('7c8d09d5-312e-441a-b68a-f59867389f96', 'b940abe1-2bd9-4cd3-b47e-a6e15481e0d7', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:39:50', 'Test1', '2019-12-25 13:39:50', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('80b2565f-debd-453f-b4b2-d8ab5577566a', 'cbbad426-2148-4f81-8109-39fa84c3d03b', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:36:11', 'Test1', '2020-01-15 16:36:11', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('80b729a5-4e03-46fb-a3f3-578f04d1dc90', '129beb35-1699-4daa-8fb5-068f34654c03', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:27:32', 'system', '2019-12-25 10:27:32', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('821b5dea-25a6-466a-b5df-0f5af7294b4a', 'f6b6da2d-39a4-4e69-8ae7-2e667dccd89e', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:54:42', 'Test1', '2019-12-25 16:54:42', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('8418b900-ae37-4f91-b5da-676dbfb27eee', 'dc0fcde1-b235-4a43-a372-7c5eec944b35', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:01:27', 'Test1', '2020-01-15 15:01:27', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('87c1f315-eacd-4189-90c4-6d237ab7199f', 'd1c2e784-3934-40cc-afdc-934b472584d0', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:57:16', 'system', '2019-12-24 15:57:16', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('8e9f170f-fa3c-4c57-80ce-a060d4a94523', 'e6547f74-91fc-4131-9cd4-10c16424d883', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:20:09', 'system', '2019-12-25 10:20:09', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('925a756b-026c-451d-8f8b-5d97f914cd74', '15e466c4-ce59-4b9e-9e12-714a362d2382', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 14:57:57', 'system', '2019-12-25 14:57:57', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('957e6caf-77a0-464d-8a1b-6fc85ef14ab3', '2fd7fdb2-3d66-49c6-a08e-31c76a3e79de', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:04:54', 'system', '2019-12-25 15:04:54', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('969746be-7e1e-4c7a-9bab-399032be5954', 'f6785774-cbb3-464b-a9d0-bd12a34e41b6', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 09:59:03', 'system', '2019-12-25 09:59:03', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('9a941701-e366-4540-8dc8-743e61f5eb3c', 'ca8fc06c-07b7-4b65-be5e-63a9ce229207', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 11:13:13', 'system', '2019-12-25 11:13:13', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('a394de3f-c8b7-4b06-a7fd-faca2bd1e4f9', 'f6b6da2d-39a4-4e69-8ae7-2e667dccd89e', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:52:13', 'system', '2019-12-25 16:52:13', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('a51506eb-2199-4b1a-a265-c5dc186e8c56', 'cbbad426-2148-4f81-8109-39fa84c3d03b', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:12:43', 'system', '2020-01-15 16:12:43', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('a671aee2-73dc-449c-9989-ab228fd52924', '8293e99c-a949-4bb0-ad87-d7ec55ab774b', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:13:26', 'system', '2020-01-15 15:13:26', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('a69ce4d6-fc76-4503-bf0b-507a13b5ca53', 'cbbad426-2148-4f81-8109-39fa84c3d03b', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:12:38', 'system', '2020-01-15 16:12:38', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('a7e31f22-151d-4efd-b42e-dacdf128305c', 'de7526ed-39f2-41f0-8a65-58174e8f6857', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 17:01:11', 'Test1', '2019-12-25 17:01:11', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('ac55e73a-679f-48fd-a895-957a9a6a4124', '129beb35-1699-4daa-8fb5-068f34654c03', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:27:30', 'system', '2019-12-25 10:27:30', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('b6194711-1964-4e44-ac95-1e0a85561dc4', '2b361f97-bf36-4897-8282-a0eb8b771e59', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:45:57', 'system', '2020-01-15 14:45:57', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('b61cd0bb-6452-4b19-b954-a2bb3b28ce66', 'f6b6da2d-39a4-4e69-8ae7-2e667dccd89e', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:54:43', 'Test1', '2019-12-25 16:54:43', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('b8e0fd24-0850-4fd3-8ff8-c3f143d18ea5', 'cbbad426-2148-4f81-8109-39fa84c3d03b', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:36:11', 'Test1', '2020-01-15 16:36:11', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('bd32cc73-94c4-4442-b528-5d58c6f33aa5', '2826cebc-085e-4b39-bf67-77841bdbc215', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:52:19', 'system', '2019-12-24 15:52:19', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('bfa6ba1d-7e50-42e8-b15e-9545954087df', '15e466c4-ce59-4b9e-9e12-714a362d2382', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 14:57:27', 'system', '2019-12-25 14:57:27', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('bffe7df3-1174-48fe-ab2b-c4ce62668fca', 'b940abe1-2bd9-4cd3-b47e-a6e15481e0d7', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:37:28', 'system', '2019-12-25 13:37:28', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('c5a11213-add4-4e73-ac81-17640cde7374', 'b940abe1-2bd9-4cd3-b47e-a6e15481e0d7', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:37:27', 'system', '2019-12-25 13:37:27', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('c8e45a98-e69a-47d7-a252-5ee87d783231', 'dc0fcde1-b235-4a43-a372-7c5eec944b35', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:58:49', 'system', '2020-01-15 14:58:49', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('c9819caf-60f1-4d46-b39c-7fa21ce3b80d', 'ca8fc06c-07b7-4b65-be5e-63a9ce229207', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 11:17:22', 'Test1', '2019-12-25 11:17:22', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('ce6fd108-a31f-490e-889c-61fba713ace7', '2826cebc-085e-4b39-bf67-77841bdbc215', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:55:04', 'Test1', '2019-12-24 15:55:04', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('d33b44fd-6ec9-4a45-9fb6-cbf79c53d35a', '713e7932-7f2c-4880-88ae-3d571850d5d9', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:29:24', 'system', '2020-01-15 16:29:24', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('d5b4340c-0f9e-4ed9-a971-96016aecf3d9', '15e466c4-ce59-4b9e-9e12-714a362d2382', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 14:57:22', 'system', '2019-12-25 14:57:22', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('d91b5db6-8c4a-4ab6-a679-6129eda811c3', 'de7526ed-39f2-41f0-8a65-58174e8f6857', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:57:04', 'system', '2019-12-25 16:57:04', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('d9e427bf-8a04-414d-9ddb-916bd77d24d1', 'f6785774-cbb3-464b-a9d0-bd12a34e41b6', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 09:59:03', 'system', '2019-12-25 09:59:03', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('daa4aff8-421e-4973-a28b-8dea92c581e8', 'f6b6da2d-39a4-4e69-8ae7-2e667dccd89e', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:52:18', 'system', '2019-12-25 16:52:18', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('de023ab5-6803-4af7-a7de-9483322396eb', '8293e99c-a949-4bb0-ad87-d7ec55ab774b', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:13:31', 'system', '2020-01-15 15:13:31', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('e081ddd0-79db-4988-bc14-f9e2fe2b2803', 'c285e6bc-a2b3-481f-9295-82556cee784a', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:30:57', 'system', '2019-12-25 15:30:57', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('e447418d-3980-4cfc-8fae-11df9240ff4b', '1b1efe8f-b9e6-403f-94c3-7580064f2be8', 100, 'Categorized', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 16:16:09', 'system', '2019-12-24 16:16:09', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('e62e4ace-5388-4d4b-94f5-75713e1af0a4', 'de7526ed-39f2-41f0-8a65-58174e8f6857', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:57:04', 'system', '2019-12-25 16:57:04', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('e65db3ef-cfc1-4755-964f-5fc761306013', 'e6547f74-91fc-4131-9cd4-10c16424d883', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:20:12', 'system', '2019-12-25 10:20:12', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('e97ccefe-ba8b-488f-8a78-a07812830121', 'dc0fcde1-b235-4a43-a372-7c5eec944b35', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:01:27', 'Test1', '2020-01-15 15:01:27', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('e9969bdf-4927-44ec-82ff-f9b473f14d2b', 'd907a82e-143d-4eb5-a6ce-d20f6b57462a', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:13:50', 'system', '2019-12-25 15:13:50', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('ea9d022b-86bb-4dbd-b0ee-1afc5248386d', '2fd7fdb2-3d66-49c6-a08e-31c76a3e79de', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:04:51', 'system', '2019-12-25 15:04:51', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('ec1f51bc-a1e2-4e07-b120-0a071dc514d5', '129beb35-1699-4daa-8fb5-068f34654c03', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:37:32', 'Test1', '2019-12-25 10:37:32', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('eeec2145-afb0-4a9b-83dc-f45a9cb099f9', 'd907a82e-143d-4eb5-a6ce-d20f6b57462a', 700, 'Finished', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:28:28', 'Test1', '2019-12-25 15:28:28', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('f8bd9608-4936-4078-b8e4-dfaa22fad66b', '129beb35-1699-4daa-8fb5-068f34654c03', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:27:34', 'system', '2019-12-25 10:27:34', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('fa7acfc5-f67c-4401-9f2f-3b4ae7b0aa98', 'd907a82e-143d-4eb5-a6ce-d20f6b57462a', 300, 'Processable', 'SPTT001', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:13:53', 'system', '2019-12-25 15:13:53', 'system', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('fae8e26d-fdae-4765-b86c-381f618c450f', 'd907a82e-143d-4eb5-a6ce-d20f6b57462a', 500, 'Started', 'SPTT001', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:28:28', 'Test1', '2019-12-25 15:28:28', 'Test1', NULL, 0, 0);
INSERT INTO `OB_CUSTOMERSHIPMENTRECORD` VALUES ('fc23fb2b-5a33-4df3-80af-f9b4c3298b5b', 'd1c2e784-3934-40cc-afdc-934b472584d0', 200, 'Selected', NULL, NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:57:21', 'system', '2019-12-24 15:57:21', 'system', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_CUSTOMERSHIPMENT_HOTPICK
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERSHIPMENT_HOTPICK`;
CREATE TABLE `OB_CUSTOMERSHIPMENT_HOTPICK`  (
  `ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `SHIPMENT_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL COMMENT 'shipment',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `AMOUNT` decimal(17, 4) NOT NULL DEFAULT 0.0000 COMMENT '数量',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_CUSTOMERSHIPMENT_HOTPICK
-- ----------------------------
INSERT INTO `OB_CUSTOMERSHIPMENT_HOTPICK` VALUES ('2c86fbb2-f1e7-4bca-9a39-49f036bbb7aa', 'a5eaf29c-2c61-4e7c-ad50-668bc28f9d2e', '812339cf-e5a4-4bf7-add7-ab80b3e044a3', 1.0000, 400, 'f64a1c95-209b-48df-b4c7-c0ec86a5c203', '2019-08-19 17:17:58', 'jiangshikun', '2019-08-26 14:45:58', 'system', NULL, 0, 1);
INSERT INTO `OB_CUSTOMERSHIPMENT_HOTPICK` VALUES ('74d4f7ff-5823-4d28-84b9-87c2aa5810c0', '04226ddc-1c79-4e50-adda-63272bcf6a3a', '6181f33a-9676-46c1-8ef3-cb967dd59e6a', 1.0000, 400, 'f64a1c95-209b-48df-b4c7-c0ec86a5c203', '2019-08-19 17:15:32', 'jiangshikun', '2019-08-26 14:43:56', 'system', NULL, 0, 1);
INSERT INTO `OB_CUSTOMERSHIPMENT_HOTPICK` VALUES ('a09f3b3d-c224-42fc-80f4-e46b259a64aa', 'b3190e41-38c4-4f48-a1aa-b94a01968f99', '632ec5c3-a456-4ad3-bd24-5e43cd5defc6', 1.0000, 400, 'f64a1c95-209b-48df-b4c7-c0ec86a5c203', '2019-08-26 19:13:14', 'mengmengsun', '2019-08-27 11:19:51', 'system', NULL, 0, 1);
INSERT INTO `OB_CUSTOMERSHIPMENT_HOTPICK` VALUES ('c6ad96aa-9bfb-41aa-a206-27a701689d1a', '9317377c-6674-48ea-80a9-70b70f0cb6c9', '9e32abed-9d7d-42c6-9999-0ba753241cb8', 1.0000, 400, 'f64a1c95-209b-48df-b4c7-c0ec86a5c203', '2019-08-22 08:43:56', 'mengmengsun', '2019-08-26 14:44:57', 'system', NULL, 0, 1);
INSERT INTO `OB_CUSTOMERSHIPMENT_HOTPICK` VALUES ('eb860c0d-9186-429e-85c4-252f2ff7132d', '071ff391-7fe1-4376-af28-62c13da6d223', '632ec5c3-a456-4ad3-bd24-5e43cd5defc6', 1.0000, 400, 'f64a1c95-209b-48df-b4c7-c0ec86a5c203', '2019-08-26 19:03:11', 'mengmengsun', '2019-08-27 11:19:51', 'system', NULL, 0, 1);

-- ----------------------------
-- Table structure for OB_CUSTOMERSHIPMENT_PRIORITY
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERSHIPMENT_PRIORITY`;
CREATE TABLE `OB_CUSTOMERSHIPMENT_PRIORITY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '加急  紧急',
  `ADVANCE_TIME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_CUSTOMERSHIPMENT_SERIALNUMBER
-- ----------------------------
DROP TABLE IF EXISTS `OB_CUSTOMERSHIPMENT_SERIALNUMBER`;
CREATE TABLE `OB_CUSTOMERSHIPMENT_SERIALNUMBER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SERIALNUMBER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单序列号对应表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_DELIVERYPOINT
-- ----------------------------
DROP TABLE IF EXISTS `OB_DELIVERYPOINT`;
CREATE TABLE `OB_DELIVERYPOINT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CARRIER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SORTCODE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DELIVERYTIME_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OB_DELIVERYPOINT_CARRIER_ID_FK`(`CARRIER_ID`) USING BTREE,
  INDEX `OB_DELIVERYPOINT_DELIVERYTIME_ID_FK`(`DELIVERYTIME_ID`) USING BTREE,
  INDEX `OB_DELIVERYPOINT_DELIVERYSORTCODE_ID_FK`(`SORTCODE_ID`) USING BTREE,
  CONSTRAINT `OB_DELIVERYPOINT_CARRIER_ID_FK` FOREIGN KEY (`CARRIER_ID`) REFERENCES `OB_CARRIER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_DELIVERYPOINT_DELIVERYSORTCODE_ID_FK` FOREIGN KEY (`SORTCODE_ID`) REFERENCES `OB_DELIVERYSORTCODE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_DELIVERYPOINT_DELIVERYTIME_ID_FK` FOREIGN KEY (`DELIVERYTIME_ID`) REFERENCES `OB_DELIVERYTIME` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '承运商、发货点以及SortCode的关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_DELIVERYSORTCODE
-- ----------------------------
DROP TABLE IF EXISTS `OB_DELIVERYSORTCODE`;
CREATE TABLE `OB_DELIVERYSORTCODE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'SORT CODE',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `DELIVERY_SORTCODE_UK`(`CODE`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `DELIVERYSORTCODE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `DELIVERYSORTCODE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'SortCode' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_DELIVERYTIME
-- ----------------------------
DROP TABLE IF EXISTS `OB_DELIVERYTIME`;
CREATE TABLE `OB_DELIVERYTIME`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `DELIVERY_TIME` timestamp(0) NULL DEFAULT NULL COMMENT '发货时间',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '发货点' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_DIGITALLABEL
-- ----------------------------
DROP TABLE IF EXISTS `OB_DIGITALLABEL`;
CREATE TABLE `OB_DIGITALLABEL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `NUM_ORDER` int(11) NULL DEFAULT NULL COMMENT '灯的序号',
  `LABELCONTROLLER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '控制器',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `DIGITALLABEL_LABELCONTROLLER_ID_FK`(`LABELCONTROLLER_ID`) USING BTREE,
  CONSTRAINT `DIGITALLABEL_LABELCONTROLLER_ID_FK` FOREIGN KEY (`LABELCONTROLLER_ID`) REFERENCES `OB_LABELCONTROLLER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '电子标签' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_DIGITALLABEL
-- ----------------------------
INSERT INTO `OB_DIGITALLABEL` VALUES ('013aaaba-5f33-4274-9ea7-ab643f92a777', 'EL001-052', 52, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('025dff2c-a37d-4b90-9ee6-8781f0c0ff01', 'EL001-054', 54, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('02dc4c61-a36a-43fa-a264-0afaec371323', 'EL01-094', 94, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('04c4e1ab-4c2e-4283-93e4-7e41ef4e6916', 'EL01-018', 18, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('052e8cef-d638-46fc-b745-ed0c250384ff', 'EL01-030', 30, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0ac86f8d-4f6e-442b-b737-620b396113b4', 'EL01-016', 16, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0c8d540b-68b8-4f79-9ba3-0d863478e6d2', 'EL001-013', 13, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0d2a9ae6-2322-4feb-8b87-84d325e50859', 'EL01-056', 56, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0d6e1a41-2d5e-43dc-9a2b-df3c9eaafdde', 'EL001-063', 63, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0e03853c-1d7d-49d8-8368-be1fdbc6467a', 'EL001-018', 18, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0eafdf03-3887-457f-95b9-2965573b1198', 'EL01-091', 91, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0ee4b8fa-b27f-4478-b1eb-e57ea65ccb32', 'EL01-039', 39, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('0ef0b910-0515-4ac6-a5cc-ac9faae9b9c1', 'EL01-097', 97, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('10b13deb-73be-4be2-af9b-9a1d0de9fddf', 'EL001-005', 5, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('114620e3-f39c-447d-9ca6-52a9ddb6f478', 'EL001-034', 34, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('12abb54a-b9dc-4b1d-a481-e5eff66cd837', 'EL01-006', 6, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('130157e5-9572-4086-bc1b-ffb55aaf8fbd', 'EL001-053', 53, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('13a825bd-af78-43fd-9ce6-07982c8d7ee9', 'EL001-007', 7, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('15df33d2-1989-4532-b432-50a71bae69f5', 'EL01-060', 60, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('15f82a37-e5ab-4bce-b1b9-c5b06ebf0b09', 'EL01-009', 9, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('15fd3dd2-224f-4588-8976-d4781ba0b202', 'EL001-087', 87, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('163aa407-1c2f-4af5-a00f-bf1666b47efd', 'EL001-016', 16, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('17474400-a1ed-4533-b2f0-c0b6913cc689', 'EL01-064', 64, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('1beb5706-ad33-4563-afcc-7c6819f6597f', 'EL01-032', 32, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('1c88dd8d-7bec-4172-a520-ec4ea9a524fc', 'EL001-094', 94, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('1c93336f-ed94-41ff-aec7-7a51cb5c3faa', 'EL001-026', 26, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('1e2f27e8-851c-43a4-8064-b2236094bc39', 'EL001-068', 68, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('1f8e0015-4179-4161-ba60-e82d08753e32', 'EL001-085', 85, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('1f902110-45e4-4910-9d2b-79b51e137c71', 'EL001-008', 8, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('208a29ff-a19f-47df-b4bf-905a462499f5', 'EL001-032', 32, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('20c4bc95-3abd-46c2-a857-12b66f781415', 'EL001-055', 55, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('21448c0f-e142-46b8-ba00-50dd942860a7', 'EL01-015', 15, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('23dd78c5-0351-45df-a7d9-4f07bec853eb', 'EL01-046', 46, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('23f7d7f9-2eb6-44c7-ac7c-230c1dc4b291', 'EL01-067', 67, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('274d0d93-647b-4867-838d-baecb53b07c5', 'EL001-098', 98, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('2b5e81e3-c736-413b-bed4-3ad55b3acc85', 'EL01-008', 8, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('2d346588-075c-4c70-a46a-1cc4cdc2f4dc', 'EL001-089', 89, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('2df01e77-1ea8-4633-b665-89d3b1af0ddd', 'EL01-005', 5, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('2eb6ec26-06a5-4e52-8648-f4721f122f61', 'EL001-022', 22, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('2efd2d9a-a491-4d8e-8baf-379ad2b6eecb', 'EL001-028', 28, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('30e02645-e79a-4e07-8bf2-d270afe8cdb8', 'EL001-092', 92, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('329a88c2-9e2e-4a3b-bdd2-384897cf2348', 'EL01-069', 69, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('33c45984-b6c8-4669-9e44-691b5e1204f4', 'EL001-070', 70, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('3674e0b2-f379-466a-af58-186dcd241aec', 'EL001-012', 12, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('368a73cf-b93f-490e-b23d-3d167bb10aaf', 'EL01-007', 7, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('368ee9cc-82a0-49e8-9eea-27066b0ea2bc', 'EL01-066', 66, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('388eac63-529b-4004-8cbc-c9a9ef2b42bf', 'EL01-025', 25, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('38fb125a-13de-48aa-99cc-a9bf5a2b78e6', 'EL01-068', 68, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('3ceb930c-ab7a-4141-a33d-e69abe2acae5', 'EL01-048', 48, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('3dc70854-d3cf-4981-9896-f73bc4f6eeb8', 'EL01-017', 17, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('3f44161a-326c-477d-8e3a-a8e639f11379', 'EL001-076', 76, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('41833e97-6386-40f2-a141-83a56c0beeff', 'EL01-041', 41, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('462ceeda-4f06-4fd7-8ae2-1f5f0d36024f', 'EL01-040', 40, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('48097755-42fb-48cd-9ccf-8c0d432948d4', 'EL01-004', 4, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('483c2ddc-d319-4115-9778-e062e123b66d', 'EL001-038', 38, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('4848df78-d04f-4254-9ebc-3bd41ac1d60e', 'EL001-031', 31, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('4dbad280-1523-48d1-97ab-4362b3f5bb10', 'EL01-049', 49, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('4dc620e8-2182-4e13-bea8-7bc4b9f64acf', 'EL01-002', 2, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('4e2fd2b3-21a4-492a-bc3e-d014fc5a5c90', 'EL001-069', 69, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('4e8f38e7-c7d4-482d-80a6-66ce2d4fd731', 'EL01-098', 98, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('503ca9bd-dc62-4a1f-b672-dfa9057c89d4', 'EL01-026', 26, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('52faec47-61dd-44f0-8cf7-1a04baf90743', 'EL001-067', 67, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('5319198c-b764-4375-8b09-c41e06d95da1', 'EL01-063', 63, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('54b3a2e6-66db-4ca8-b090-908a5c1debdc', 'EL01-055', 55, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('55c4d3cb-4a5c-4432-b771-3c928bfefe99', 'EL01-050', 50, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('55cae30e-4dd7-48a8-aaff-201dc801260e', 'EL001-088', 88, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('55ff308e-2ac2-461b-be7a-8709d41b2334', 'EL01-079', 79, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('57ec3636-c363-43d2-b311-173301f8eeb9', 'EL001-010', 10, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('583f763c-16d0-417f-917b-c99c7c5f9b1c', 'EL01-099', 99, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('58a32c5b-9e95-4065-95d3-44ca4a557dff', 'EL001-093', 93, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('5bceb27d-e9f0-48af-9996-f15dd6aa7597', 'EL01-080', 80, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('5e2e5882-b878-4c05-bbd6-85f5fb8329c2', 'EL01-096', 96, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('5e41d13b-a54d-48da-a1fb-bb84907b246b', 'EL01-011', 11, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('602a16e0-92c4-4435-a7ae-5011c828d906', 'EL01-014', 14, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('6518ae72-3e5a-4360-a3fb-da28e5c067ab', 'EL001-082', 82, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('68393fcb-4d00-419f-b123-c3b92b5b338a', 'EL001-073', 73, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('6844a2c9-6d46-44d8-972b-1d1e079199ef', 'EL01-031', 31, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('6978a378-975e-42d8-bcb0-985a3c2d9773', 'EL001-043', 43, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('6aefb58c-c493-4251-a4ec-1fec165d1bcc', 'EL01-028', 28, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('6f0b4b03-69e6-40c2-9c6d-0c15af54f5a2', 'EL01-003', 3, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('6f163f31-ef61-4a18-80d9-399fe2b23ceb', 'EL01-100', 100, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('6f2b0fc2-0b0b-445b-b96e-65869a89f987', 'EL01-054', 54, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('7077ecec-ba01-4432-83d4-1eb22f5da537', 'EL01-076', 76, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('70e4b71f-a187-4750-a16c-8c8251e22f82', 'EL01-075', 75, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('73196569-8207-40ec-a5dc-b0704a669b64', 'EL001-014', 14, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('741c431e-3bfb-49bb-85f1-ce4f746cc919', 'EL01-070', 70, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('763a6e24-ae75-42ce-8ee3-6eb4f4c510f4', 'EL01-020', 20, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('766ee948-0aa9-4e66-9b60-95c5f685c114', 'EL001-017', 17, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('76931c89-fd48-4fe5-871e-0350c1212241', 'EL001-081', 81, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('76c121b1-108b-454a-aab8-f0fd6a8ccd57', 'EL01-027', 27, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('772beef3-15fe-419f-b1ca-1e1119040bd7', 'EL001-058', 58, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('776c86c0-a220-4a8e-b979-ee6ffa726f81', 'EL01-052', 52, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('7965d358-d3ff-4b6a-bf5c-41bace50bede', 'EL001-099', 99, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('7d4ad729-edd2-4dcc-ae6c-b842c5168120', 'EL01-082', 82, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('7eed9d5f-4a49-4c6f-8ba6-57e5744faa07', 'EL01-088', 88, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('7f414cbf-b92c-4679-8c88-6a402720f92f', 'EL01-057', 57, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('7f6a8f2b-785e-4344-9b1c-8ba9a4ca0987', 'EL001-080', 80, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('80860229-6680-44d4-a5cf-ecf3a5b6bc65', 'EL01-010', 10, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('80c0be69-c079-45c4-95f5-91cd7398c179', 'EL001-042', 42, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('81426d79-f651-40b7-a429-8b74e223f93d', 'EL01-071', 71, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('832915a8-eed7-4b8e-af64-dec0bb6b6db7', 'EL001-040', 40, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('858d5782-4c13-42b3-a4ce-a5be0cfe7ed0', 'EL01-035', 35, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('8592657b-0e47-4de7-be72-421a4630900f', 'EL01-072', 72, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('88119619-554b-4c20-9d40-8d7d15729e42', 'EL001-090', 90, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('886d3f77-88f3-4e01-9ee4-fce06d7a95eb', 'EL01-065', 65, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('89373eac-979f-4029-b69e-2b7fceedc251', 'EL001-096', 96, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('8a229697-612b-4fa7-9cf0-3df0e307deb8', 'EL001-095', 95, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('8ac5ac67-5b37-464e-85d8-3a09b207f02f', 'EL01-033', 33, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('8ce8f6de-73b0-412e-9b81-70da85d9cdaf', 'EL001-004', 4, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('8d31fe6e-dc0e-4617-a667-b5fb65ab5310', 'EL01-085', 85, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('8f0873b0-7f81-4a0e-8a54-f7409c62cd7a', 'EL001-084', 84, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('8f98446e-5b64-4f70-bd41-447e5098b43f', 'EL001-049', 49, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('9220725f-6984-4ba4-89af-6308beb043fd', 'EL01-053', 53, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('92fe7989-1ea6-4c07-b1f8-f941a35e8caa', 'EL01-034', 34, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('9565b94b-009a-43ce-bd8c-3ac4e7ade1e0', 'EL01-037', 37, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('9965b8e7-bdf8-436d-a75c-5b5782ab1705', 'EL01-044', 44, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('9a44730c-0f51-4f3a-90d1-ec4599ce94ce', 'EL001-060', 60, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('9b11b3cc-c993-4794-9da9-edcc37270a13', 'EL001-086', 86, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('9ce64091-afa7-4210-8b33-d2b6b616a2bb', 'EL001-041', 41, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('a34babb0-8b77-4c50-9a71-89e754737c54', 'EL001-097', 97, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('a6c1f8b5-66e6-47d0-a9cc-125e717dbd60', 'EL01-092', 92, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('aa38de31-26f3-444b-9169-eb0c9fe562fe', 'EL01-013', 13, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('ab0043dc-50a3-4858-adf3-5e6f48a8e167', 'EL01-089', 89, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('ac0eb9d3-fe38-4e2f-ab20-19cb89179dd8', 'EL001-029', 29, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('afd819d5-c945-467b-94f4-4bff6ce5755c', 'EL01-058', 58, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b058dbb4-c275-415e-91af-fa67e804fe0d', 'EL001-003', 3, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b25bfc8f-352f-404d-adc4-0d51f88a199d', 'EL01-001', 1, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b290350b-efa3-463b-9eec-f8b38c2775e4', 'EL01-023', 23, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b41c6ec4-864e-4632-ab18-fddde4aebd43', 'EL001-006', 6, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b4d3ec52-08df-49e7-9a2a-767b8f0ac20a', 'EL001-023', 23, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b521fb66-2d61-436e-858a-a9806265aaff', 'EL001-075', 75, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b5dff495-cbca-4709-a67a-c0ccd2c7b810', 'EL001-039', 39, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b726f1f4-d8f1-448f-8744-7f2bc02384dc', 'EL001-048', 48, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b76d6aa6-a0fb-49b1-8523-ad32c6dd4eed', 'EL001-019', 19, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('b861e8b7-5dbf-4b67-acaa-9120e439127f', 'EL001-065', 65, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('bdf621c4-f7f1-44f6-b215-7d881d29cd01', 'EL001-072', 72, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('be12e74a-bac1-442a-91fd-cbf4e44fb9bf', 'EL001-059', 59, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('be8b8500-d817-48dc-b16d-40f463d95aa4', 'EL01-029', 29, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('bfe914e9-524d-4e7f-a4da-052be413ea69', 'EL001-061', 61, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c009e185-840c-4f98-bdad-46b87b14089b', 'EL01-047', 47, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c0b1a4c3-b1cc-4b5d-8e9c-0d8703c96700', 'EL01-021', 21, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c1a7015c-c50c-4ce7-8558-b4008c3b6fdd', 'EL001-046', 46, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c27677e5-7554-476c-8608-eb53d4d9a447', 'EL001-071', 71, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c3c7b5e6-7ada-43c4-8f2c-50dfb0e053c4', 'EL01-077', 77, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c5f21588-52fd-45eb-a0c3-3022e9df447c', 'EL001-057', 57, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c6bf5db8-9e31-4c20-a10b-e80e0d5d55ba', 'EL001-020', 20, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c7a708f4-8c70-401e-acdf-af88fa743056', 'EL01-090', 90, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c83c289c-f420-4219-bc10-05feae072eec', 'EL01-078', 78, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c84296b9-59dc-4151-92b3-cee5efc04c82', 'EL001-051', 51, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c906d941-dc6d-412e-a4d0-f5c09d1dfe81', 'EL01-024', 24, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('c9cfeba3-f312-4baf-b849-bfc6dfe0f4a6', 'EL001-001', 1, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('cd431ba7-31a5-4d97-b780-3e160055b1d2', 'EL01-087', 87, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('ce12b77f-b447-4665-9068-bc578ddf1595', 'EL001-045', 45, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('cf7c2a27-8f2c-4b6a-bae6-a5b772c32cc4', 'EL01-086', 86, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d013fd6d-2242-43e5-9a12-9e9df543d8b2', 'EL001-030', 30, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d1daa255-12a1-4887-bdfc-98652bc18a69', 'EL01-074', 74, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d2802fa6-96c4-4e63-9c4b-3d88d7791a2b', 'EL001-002', 2, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d2da278f-42e7-4b64-96af-0b036cd85373', 'EL001-035', 35, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d2df5ec7-bc2f-4db2-82ab-5f375b9866c9', 'EL001-074', 74, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d5d8e7fb-7264-4d76-b27f-8b8fabbb33bb', 'EL001-036', 36, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d651de66-7667-4488-9e4d-d4f6af71d24d', 'EL001-083', 83, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d83c77ab-36c4-4a4a-b95b-06633795da45', 'EL001-033', 33, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d9247909-19c7-41bf-9261-e70109f5d22a', 'EL01-019', 19, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('d9df436a-a7b4-41a4-a044-055468748eec', 'EL01-093', 93, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('da8711a8-e1e3-4684-86f3-ed9f16e71171', 'EL001-064', 64, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('de798704-8470-4a34-8c45-94dfc83db5ee', 'EL01-036', 36, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('dfc556e6-cfc9-46c8-a8d7-7dc9e9c61c26', 'EL01-012', 12, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('dfe5ff71-e7e6-4d19-8ae0-1943de70c7b1', 'EL01-081', 81, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e19ba3fc-6788-45c6-aca2-0046802040d5', 'EL01-038', 38, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e3484f90-e062-46b9-a24a-cda979114ca5', 'EL01-043', 43, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e3683dde-5169-4e91-8e4a-5510de6eb184', 'EL001-078', 78, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e52cb8be-1b55-4721-8d7f-f63b4f363648', 'EL001-066', 66, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e6545279-8a4d-4f5b-82a6-4253cfc3bd41', 'EL001-024', 24, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e66e39af-c425-405e-b3f6-5ea97b701589', 'EL001-077', 77, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e77530f9-7f2f-4337-a343-d07005f7f149', 'EL01-061', 61, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e813c928-b955-4fd1-8f85-06c6f3c9cfc8', 'EL01-083', 83, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('e96b69ae-97ba-4292-8631-2e7e9a5afad1', 'EL01-022', 22, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('eb73d861-4689-402d-b40b-2dc3d23c5be8', 'EL01-084', 84, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('eba49228-4c44-4379-8069-bcb625eed33d', 'EL001-011', 11, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('ed386c45-e57f-40bf-8593-38529365cb36', 'EL01-062', 62, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('ed91796b-c4be-4c0a-8a4d-200a8a94b352', 'EL001-050', 50, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('eda0e8ee-744e-47f0-8a48-4e82ce16476a', 'EL001-091', 91, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('eebbf66d-76be-4048-be0b-92cfffadd322', 'EL001-056', 56, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f11c624c-1fe8-4d43-916f-33ba416c4922', 'EL001-047', 47, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f4059cdb-b758-4481-a3b5-8c5cab7930a2', 'EL01-042', 42, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f458f0df-1fe2-41b9-b89b-46db40e6d7d0', 'EL001-015', 15, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f50ee389-6e4c-4e99-8b0c-9addb171154c', 'EL01-045', 45, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f66b9d32-9e7b-4603-b189-790b84e6845c', 'EL001-044', 44, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f6ee7b75-38ab-4375-80f6-bcc422c65d2b', 'EL001-027', 27, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f75ef8c1-0b75-429a-8b5d-f4b4d92665b3', 'EL001-021', 21, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f80476bb-0730-40a9-9b00-315900f6d5bf', 'EL01-073', 73, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f84fb9b9-2e96-4449-8968-f9482269feef', 'EL001-100', 100, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('f8cd5064-0ec3-405a-bacf-f77904371512', 'EL001-025', 25, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('faf7ac38-9c0c-4ee9-b9f6-84a08ad1a5fc', 'EL001-009', 9, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('fb0edcc9-bf31-4f12-b291-5dac7e2da20f', 'EL01-095', 95, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('fcfd7309-e1aa-425e-b70b-9932bd4253ee', 'EL001-037', 37, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('fd32a0d0-f2ab-4f7f-b406-d6f342974750', 'EL01-059', 59, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('fd8416f6-a10c-4343-a3ed-5718fb44455e', 'EL001-079', 79, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('fdb3b73b-345e-4997-b976-60c3b9f3eae9', 'EL01-051', 51, '429a1d64-6ed5-4292-9603-bf7a895eb086', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-18 06:13:22', 'admin', NULL, 0, 0);
INSERT INTO `OB_DIGITALLABEL` VALUES ('fe4de673-da25-4742-803e-2a1eec22bb2f', 'EL001-062', 62, 'b3f2971d-9507-4775-b1b9-90b8c216c597', 'DEFAULT', '2019-12-18 03:07:26', 'admin', '2019-12-18 03:07:26', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_DIGITALLABEL_SHIPMENT
-- ----------------------------
DROP TABLE IF EXISTS `OB_DIGITALLABEL_SHIPMENT`;
CREATE TABLE `OB_DIGITALLABEL_SHIPMENT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATE` int(11) NOT NULL COMMENT '状态',
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `PICKPACKWALL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `DIGITALLABEL2` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `DIGITALSHIPMENT_SHIPMENT_ID_FK`(`SHIPMENT_ID`) USING BTREE,
  INDEX `DIGITALSHIPMENT_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `DIGITALSHIPMENT_STATION_ID_FK`(`STATION_ID`) USING BTREE,
  CONSTRAINT `DIGITALSHIPMENT_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `DIGITALSHIPMENT_SHIPMENT_ID_FK` FOREIGN KEY (`SHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `DIGITALSHIPMENT_STATION_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `OB_PACKINGSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_DOOR_STORAGELOCATION
-- ----------------------------
DROP TABLE IF EXISTS `OB_DOOR_STORAGELOCATION`;
CREATE TABLE `OB_DOOR_STORAGELOCATION`  (
  `DOORID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STORAGEID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  INDEX `OB_DOOR_STORAGE_DOORID`(`DOORID`) USING BTREE,
  INDEX `OB_DOOR_STORAGE_STORAGEID`(`STORAGEID`) USING BTREE,
  CONSTRAINT `OB_DOOR_STORAGE_DOORID` FOREIGN KEY (`DOORID`) REFERENCES `OB_GOODSOUTDOOR` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_DOOR_STORAGE_STORAGEID` FOREIGN KEY (`STORAGEID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '发货门与笼车绑定关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_ENDINGSETTING
-- ----------------------------
DROP TABLE IF EXISTS `OB_ENDINGSETTING`;
CREATE TABLE `OB_ENDINGSETTING`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `ENDING_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '终点类型',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'SYSTEM',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0),
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT 0,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_ENDINGSETTING
-- ----------------------------
INSERT INTO `OB_ENDINGSETTING` VALUES ('7472436b-84bc-4722-a5b4-2369f5f425c4', 'HLXNR-PICK', 'PICK', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 'admin', '2019-12-18 06:26:35', 'admin', '2019-12-18 06:26:35', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_ENROUTEPOD
-- ----------------------------
DROP TABLE IF EXISTS `OB_ENROUTEPOD`;
CREATE TABLE `OB_ENROUTEPOD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ENROUTEPOD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ENROUTEPOD_STATION_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `ENROUTEPOD_POD_ID_FK`(`POD_ID`) USING BTREE,
  CONSTRAINT `ENROUTEPOD_STATION_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `OB_PICKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ENROUTEPOD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_GOODSOUTDOOR
-- ----------------------------
DROP TABLE IF EXISTS `OB_GOODSOUTDOOR`;
CREATE TABLE `OB_GOODSOUTDOOR`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `SORT_CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SortCode',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `GOODSOUTDOOR_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `GOODSOUTDOOR_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '发货门' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_GOODSOUTREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `OB_GOODSOUTREQUEST`;
CREATE TABLE `OB_GOODSOUTREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `GOODSOUT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '发货单号',
  `SORT_CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'SortCode',
  `AMOUNT` int(11) NOT NULL COMMENT '数量',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `SHIPPING_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '发货时间',
  `PRINTDATE` timestamp(0) NULL DEFAULT NULL COMMENT '打印时间',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作人',
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `GOODSOUTREQUEST_GOODSOUT_NO_UK`(`GOODSOUT_NO`) USING BTREE,
  INDEX `GOODSOUTREQUEST_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `GOODSOUTREQUEST_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `GOODSOUTREQUEST_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  CONSTRAINT `GOODSOUTREQUEST_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GOODSOUTREQUEST_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GOODSOUTREQUEST_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '发货记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_GOODSOUTREQUESTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_GOODSOUTREQUESTPOSITION`;
CREATE TABLE `OB_GOODSOUTREQUESTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `GOODSOUTREQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '发货记录',
  `AMOUNT` int(11) NOT NULL COMMENT '数量',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '当前发货时间点状态',
  `SHIPPING_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '发货时间',
  `DELIVERY_DATE` datetime(0) NULL DEFAULT NULL COMMENT '发货时间点',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `GOODSOUTREQUESTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `GOODSOUTREQUESTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `GOODSOUTREQUESTPOSITION_GOODSOUTREQUEST_ID_FK`(`GOODSOUTREQUEST_ID`) USING BTREE,
  CONSTRAINT `GOODSOUTREQUESTPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GOODSOUTREQUESTPOSITION_GOODSOUTREQUEST_ID_FK` FOREIGN KEY (`GOODSOUTREQUEST_ID`) REFERENCES `OB_GOODSOUTREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `GOODSOUTREQUESTPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '发货记录明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_LABELCONTROLLER
-- ----------------------------
DROP TABLE IF EXISTS `OB_LABELCONTROLLER`;
CREATE TABLE `OB_LABELCONTROLLER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `IP_ADDRESS` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'IP',
  `PORT_NUMBER` int(11) NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '控制器' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_LABELCONTROLLER
-- ----------------------------
INSERT INTO `OB_LABELCONTROLLER` VALUES ('429a1d64-6ed5-4292-9603-bf7a895eb086', 'EL01', '182.168.100.130', 4660, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:13:22', 'admin', '2019-12-19 10:24:55', 'admin', 'section1', 0, 1);
INSERT INTO `OB_LABELCONTROLLER` VALUES ('b3f2971d-9507-4775-b1b9-90b8c216c597', 'EL001', '0', 0, 'DEFAULT', '2019-12-18 03:07:25', 'admin', '2019-12-18 03:07:25', 'admin', 'section1', 0, 0);

-- ----------------------------
-- Table structure for OB_ORDERSCORE
-- ----------------------------
DROP TABLE IF EXISTS `OB_ORDERSCORE`;
CREATE TABLE `OB_ORDERSCORE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SCORE` decimal(17, 4) NOT NULL,
  `ABSOLUTE_DISTANCE` decimal(17, 4) NOT NULL,
  `RELATIVE_DISTANCE` decimal(17, 4) NOT NULL,
  `RELATIVE_COST` decimal(17, 4) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SECTION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `ORDERSCORE_ORDER_ID_FK`(`ORDER_ID`) USING BTREE,
  INDEX `ORDERSCORE_STATION_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `ORDERSCORE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ORDERSCORE_SECTION_ID_FK`(`SECTION_ID`) USING BTREE,
  CONSTRAINT `ORDERSCORE_SECTION_ID_FK` FOREIGN KEY (`SECTION_ID`) REFERENCES `WD_SECTION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ORDERSCORE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_ORDERSTRATEGY
-- ----------------------------
DROP TABLE IF EXISTS `OB_ORDERSTRATEGY`;
CREATE TABLE `OB_ORDERSTRATEGY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `CREATE_SHIPPING_ORDER` bit(1) NOT NULL COMMENT '是否创建运输订单',
  `CREATE_FOLLOWUP_PICKS` bit(1) NOT NULL COMMENT '追踪图',
  `MANUAL_CREATION_INDEX` bit(1) NOT NULL COMMENT '手动索引',
  `PREFER_MATCHING_STOCK` bit(1) NOT NULL COMMENT '是否有首选匹配的仓库',
  `PREFER_UNOPENED` bit(1) NOT NULL COMMENT '优先选择',
  `USE_LOCKED_LOT` bit(1) NOT NULL COMMENT '锁定的有效期',
  `USE_LOCKED_STOCK` bit(1) NOT NULL COMMENT '锁定的库存',
  `DEFAULTDESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '默认的货位（目的地）',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `ORDERSTRAGEGY_NAME_UK`(`NAME`, `CLIENT_ID`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `ORDERSTRATEGY_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `ORDERSTRATEGY_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `ORDERSTRATEGY_DEFAULTDESTINATION_ID_FK`(`DEFAULTDESTINATION_ID`) USING BTREE,
  CONSTRAINT `ORDERSTRATEGY_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ORDERSTRATEGY_DEFAULTDESTINATION_ID_FK` FOREIGN KEY (`DEFAULTDESTINATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `ORDERSTRATEGY_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单策略' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PACKINGREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `OB_PACKINGREQUEST`;
CREATE TABLE `OB_PACKINGREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PACKING_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '包装编号',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `CUSTOMERSHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单',
  `FROMUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个载具',
  `TOUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '包装载具',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `PACKINGSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '包装工作站',
  `BOXTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '包装箱型',
  `WEIGHT` decimal(17, 4) NULL DEFAULT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PACKINGREQUEST_REBIN_NO_UK`(`PACKING_NO`) USING BTREE,
  INDEX `PACKINGREQUEST_BATCH_ID_FK`(`CUSTOMERSHIPMENT_ID`) USING BTREE,
  INDEX `PACKINGREQUEST_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `PACKINGREQUEST_PACKINGSTATION_ID_FK`(`PACKINGSTATION_ID`) USING BTREE,
  INDEX `PACKINGREQUEST_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PACKINGREQUEST_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `SOURCE_ID`(`FROMUNITLOAD_ID`) USING BTREE,
  INDEX `PACKINGREQUEST_BOXTYPE_ID_FK`(`BOXTYPE_ID`) USING BTREE,
  INDEX `TOUNITLOAD_ID`(`TOUNITLOAD_ID`) USING BTREE,
  CONSTRAINT `PACKINGREQUEST_BOXTYPE_ID_FK` FOREIGN KEY (`BOXTYPE_ID`) REFERENCES `OB_BOXTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUEST_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUEST_CUSTOMERSHIPMENT_ID_FK` FOREIGN KEY (`CUSTOMERSHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUEST_FROMUNITLOAD_ID_FK` FOREIGN KEY (`FROMUNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUEST_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUEST_TOUNITLOAD_ID_FK` FOREIGN KEY (`TOUNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUEST_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '包装记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PACKINGREQUESTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PACKINGREQUESTPOSITION`;
CREATE TABLE `OB_PACKINGREQUESTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AMOUNT` decimal(17, 4) NOT NULL COMMENT '数量',
  `AMOUNT_PACKED` decimal(17, 4) NOT NULL COMMENT '已经包装的数量',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `CUSTOMERSHIPMENTPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '具体订单详情',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `LOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期',
  `PACKINGREQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '包装订单',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PACKINGREQUESTPOSITION_PACKINGREQUEST_ID_FK`(`PACKINGREQUEST_ID`) USING BTREE,
  INDEX `PACKINGREQUESTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `PACKINGREQUESTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `PACKINGREQUESTPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUESTPOSITION_PACKINGREQUEST_ID_FK` FOREIGN KEY (`PACKINGREQUEST_ID`) REFERENCES `OB_PACKINGREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGREQUESTPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '包装记录明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PACKINGSTATION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PACKINGSTATION`;
CREATE TABLE `OB_PACKINGSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '包装工作站类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PACKINGSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PACKINGSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PACKINGSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `PACKINGSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  INDEX `PACKINGSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  CONSTRAINT `PACKINGSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_PACKINGSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '包装工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PACKINGSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PACKINGSTATIONPOSITION`;
CREATE TABLE `OB_PACKINGSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PACKINGSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `PACKINGSTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `PACKINGSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `PACKINGSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `OB_PACKINGSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '包装工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PACKINGSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PACKINGSTATIONTYPE`;
CREATE TABLE `OB_PACKINGSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `IF_SCAN` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否扫描',
  `IF_PRINT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否打印',
  `IF_SCAN_INVOICE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否扫描发票',
  `IF_WEIGHT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否称重',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PACK_STATION_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '包装工作站类型',
  `IS_SCAN_BOX_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否扫描包装箱型',
  `IF_SCAN_SERIALNUMBER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否扫描序列号',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PACKINGSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PACKINGSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `PACKINGSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '包装工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PACKINGSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PACKINGSTATIONTYPEPOSITION`;
CREATE TABLE `OB_PACKINGSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PACKINGSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PACKINGSTATIONTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `PACKINGSTATIONTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `OB_PACKINGSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PACKINGSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '包装工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKINGAREA
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGAREA`;
CREATE TABLE `OB_PICKINGAREA`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKINGAREA_NAME_UK`(`NAME`, `CLIENT_ID`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKINGAREA_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `PICKINGAREA_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `PICKINGAREA_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGAREA_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货区域' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKINGAREAELIGIBILITY
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGAREAELIGIBILITY`;
CREATE TABLE `OB_PICKINGAREAELIGIBILITY`  (
  `USER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PICKINGAREA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`USER_ID`, `PICKINGAREA_ID`) USING BTREE,
  INDEX `USER_PICKINGAREA_PICKINGAREA_ID_FK`(`PICKINGAREA_ID`) USING BTREE,
  CONSTRAINT `USER_PICKINGAREA_PICKINGAREA_ID_FK` FOREIGN KEY (`PICKINGAREA_ID`) REFERENCES `OB_PICKINGAREA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `USER_PICKINGAREA_USER_ID_FK` FOREIGN KEY (`USER_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货权限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKINGAREAPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGAREAPOSITION`;
CREATE TABLE `OB_PICKINGAREAPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拣货区域详情编号',
  `ZONE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '区域ID',
  `PICKINGAREA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拣货区域ID',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKINGAREAPOSITION_ZONE_ID_FK`(`ZONE_ID`) USING BTREE,
  INDEX `PICKINGAREAPOSITION_PICKINGAREA_ID_FK`(`PICKINGAREA_ID`) USING BTREE,
  INDEX `PICKINGAREAPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `PICKINGAREAPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `PICKINGAREAPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGAREAPOSITION_PICKINGAREA_ID_FK` FOREIGN KEY (`PICKINGAREA_ID`) REFERENCES `OB_PICKINGAREA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGAREAPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGAREAPOSITION_ZONE_ID_FK` FOREIGN KEY (`ZONE_ID`) REFERENCES `MD_ZONE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货区域明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKINGCATEGORY
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGCATEGORY`;
CREATE TABLE `OB_PICKINGCATEGORY`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '过滤规则名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '过滤规则描述',
  `CATEGORY_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '过滤规则类型',
  `CONSUMER_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '客户类型',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `PROCESSPATH_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '对应的PP',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKINGCATEGORY_NAME_UK`(`NAME`, `CLIENT_ID`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKINGCATEGORY_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKINGCATEGORY_PROCESSPATH_ID_FK`(`PROCESSPATH_ID`) USING BTREE,
  INDEX `PICKINGCATEGORY_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  CONSTRAINT `PICKINGCATEGORY_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGCATEGORY_PROCESSPATH_ID_FK` FOREIGN KEY (`PROCESSPATH_ID`) REFERENCES `OB_PROCESSPATH` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGCATEGORY_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货过滤' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGCATEGORY
-- ----------------------------
INSERT INTO `OB_PICKINGCATEGORY` VALUES ('de413b04-08d1-4043-addc-4ae2a737fa35', 'HLXNR-OP-PICKTOTE', NULL, NULL, NULL, 0, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:25:01', 'admin', '2019-12-18 06:25:01', 'admin', NULL, 0, 1);

-- ----------------------------
-- Table structure for OB_PICKINGCATEGORYPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGCATEGORYPOSITION`;
CREATE TABLE `OB_PICKINGCATEGORYPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '详情编号',
  `RULE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '规则',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作员',
  `COMP_VALUE` varchar(4096) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '比较值',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `CATEGORY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '过滤规则',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKINGCATEGORYPOSITION_POS_NO_UK`(`POSITION_NO`, `WAREHOUSE_ID`, `CLIENT_ID`) USING BTREE,
  INDEX `PICKINGCATEGORYPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKINGCATEGORYPOSITION_CATEGORY_ID_FK`(`CATEGORY_ID`) USING BTREE,
  INDEX `PICKINGCATEGORYPOSITION_RULE_ID_FK`(`RULE_ID`) USING BTREE,
  INDEX `PICKINGCATEGORYPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  CONSTRAINT `PICKINGCATEGORYPOSITION_CATEGORY_ID_FK` FOREIGN KEY (`CATEGORY_ID`) REFERENCES `OB_PICKINGCATEGORY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGCATEGORYPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGCATEGORYPOSITION_RULE_ID_FK` FOREIGN KEY (`RULE_ID`) REFERENCES `OB_PICKINGCATEGORYRULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGCATEGORYPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货过滤明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGCATEGORYPOSITION
-- ----------------------------
INSERT INTO `OB_PICKINGCATEGORYPOSITION` VALUES ('7c76c14b-466c-4e6e-ba26-8589643fb7dd', 'HLXNR-OP-PICKTOTE-1', '9', 'EQUAL', 'Customer', 1, 'de413b04-08d1-4043-addc-4ae2a737fa35', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 11:16:20', 'admin', '2019-12-22 11:16:20', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_PICKINGCATEGORYRULE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGCATEGORYRULE`;
CREATE TABLE `OB_PICKINGCATEGORYRULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `RULE_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作KEY',
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `COMPARISON_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作VAULE来自于',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKINGCATEGORYRULE_NAME_UK`(`NAME`) USING BTREE,
  UNIQUE INDEX `PICKINGCATEGORYRULE_KEY_UK`(`RULE_KEY`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货规则' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGCATEGORYRULE
-- ----------------------------
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('1', 'BOX_TYPE', 'Box Type', 'VALUE_FROM_CONTEXT', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('10', 'DOCK_TYPE', 'Dock Type', 'VALUE_FROM_CONTEXT', '2019-06-19 12:00:00', 'xiongxiaoning', '2019-06-19 12:00:00', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('2', 'ITEM_GROUP', 'Item Group', 'VALUE_FROM_CONTEXT', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('3', 'ITEM_ZONE', 'Item Zone', 'VALUE_FROM_CONTEXT', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('4', 'NUMBER_OF_ITEM', 'Number of Item', 'CONSTANT_VALUE', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('5', 'NUMBER_OF_UNIT', 'Number of Unit', 'CONSTANT_VALUE', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('6', 'WEIGHT_OF_SHIPMENT', 'Weight of Shipment', 'CONSTANT_VALUE', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('7', 'PICK_MODE', 'Pick Mode', 'VALUE_FROM_CONTEXT', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('8', 'CARRIER', 'Carrier', 'VALUE_FROM_CONTEXT', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);
INSERT INTO `OB_PICKINGCATEGORYRULE` VALUES ('9', 'ORDER_TYPE', 'Order Type', 'VALUE_FROM_CONTEXT', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_PICKINGCATEGORYRULEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGCATEGORYRULEPOSITION`;
CREATE TABLE `OB_PICKINGCATEGORYRULEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `POSITION_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '详情编号',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `OPERATOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作人',
  `RULE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '规则ID',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKINGCATEGORYRULEPOSITION_RULE_ID`(`RULE_ID`) USING BTREE,
  INDEX `PICKINGCATEGORYRULEPOSITION_OPERATOR_ID`(`OPERATOR`) USING BTREE,
  CONSTRAINT `PICKINGCATEGORYRULEPOSITION_RULE_ID` FOREIGN KEY (`RULE_ID`) REFERENCES `OB_PICKINGCATEGORYRULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货规则明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGCATEGORYRULEPOSITION
-- ----------------------------
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('1', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'INCLUDE_ONLY', '1');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('10', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '4', 4, 'GREATER_THAN_OR_EQUAL', '4');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('11', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '5', 5, 'LESS_THAN', '4');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('12', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '6', 6, 'LESS_THAN_OR_EQUAL', '4');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('13', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'EQUAL', '5');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('14', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '2', 2, 'NOT_EQUAL', '5');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('15', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '3', 3, 'GREATER_THAN', '5');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('16', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '4', 4, 'GREATER_THAN_OR_EQUAL', '5');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('17', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '5', 5, 'LESS_THAN', '5');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('18', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '6', 6, 'LESS_THAN_OR_EQUAL', '5');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('19', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'EQUAL', '6');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('2', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '2', 2, 'INCLUDE_ALL', '1');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('20', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '2', 2, 'NOT_EQUAL', '6');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('21', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '3', 3, 'GREATER_THAN', '6');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('22', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '4', 4, 'GREATER_THAN_OR_EQUAL', '6');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('23', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '5', 5, 'LESS_THAN', '6');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('24', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '6', 6, 'LESS_THAN_OR_EQUAL', '6');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('25', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'EQUAL', '7');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('26', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'INCLUDE_ONLY', '8');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('27', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '2', 2, 'INCLUDE_ALL', '8');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('28', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'EQUAL', '9');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('29', '2019-06-19 12:00:00', 'xiongxiaoning', '2019-06-19 12:00:00', 'xiongxiaoning', NULL, 0, 0, '1', 0, 'EQUAL', '10');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('3', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'INCLUDE_ONLY', '2');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('4', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '2', 2, 'INCLUDE_ALL', '2');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('5', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'INCLUDE_ONLY', '3');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('6', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '2', 2, 'INCLUDE_ALL', '3');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('7', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '1', 1, 'EQUAL', '4');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('8', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '2', 2, 'NOT_EQUAL', '4');
INSERT INTO `OB_PICKINGCATEGORYRULEPOSITION` VALUES ('9', '2018-09-25 05:35:25', 'wallace', NULL, NULL, NULL, 0, 0, '3', 3, 'GREATER_THAN', '4');

-- ----------------------------
-- Table structure for OB_PICKINGORDER
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGORDER`;
CREATE TABLE `OB_PICKINGORDER`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PICKINGORDER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拣货订单号',
  `CUSTOMERSHIPMENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单号',
  `MANUAL_CREATION` bit(1) NOT NULL COMMENT '是否手动创建',
  `PRIORITY` int(11) NOT NULL COMMENT '优先级别代码',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `DESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '货位',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `STRATEGY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单策略',
  `PROCESSPATH_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'PP',
  `COMPLETED` bit(1) NULL DEFAULT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PICKSTARTBAY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICKSTARTLOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKINGORDER_NO_UK`(`PICKINGORDER_NO`) USING BTREE,
  INDEX `PICKINGORDER_DESTINATION_ID_FK`(`DESTINATION_ID`) USING BTREE,
  INDEX `PICKINGORDER_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `PICKINGORDER_STRATEGY_ID_FK`(`STRATEGY_ID`) USING BTREE,
  INDEX `PICKINGORDER_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKINGORDER_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `PICKINGORDER_PROCESSPATH_ID_FK`(`PROCESSPATH_ID`) USING BTREE,
  INDEX `PICKINGORDER_PICKSTARTBAY_ID_FK`(`PICKSTARTBAY_ID`) USING BTREE,
  INDEX `PICKINGORDER_PICKSTARTLOCATION_ID_FK`(`PICKSTARTLOCATION_ID`) USING BTREE,
  CONSTRAINT `PICKINGORDER_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGORDER_DESTINATION_ID_FK` FOREIGN KEY (`DESTINATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGORDER_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGORDER_PICKSTARTBAY_ID_FK` FOREIGN KEY (`PICKSTARTBAY_ID`) REFERENCES `MD_BAY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGORDER_PICKSTARTLOCATION_ID_FK` FOREIGN KEY (`PICKSTARTLOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGORDER_PROCESSPATH_ID_FK` FOREIGN KEY (`PROCESSPATH_ID`) REFERENCES `OB_PROCESSPATH` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGORDER_STRATEGY_ID_FK` FOREIGN KEY (`STRATEGY_ID`) REFERENCES `OB_ORDERSTRATEGY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGORDER_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGORDER
-- ----------------------------
INSERT INTO `OB_PICKINGORDER` VALUES ('01878098-6642-4d4e-a27e-a88f39ce7c6e', 'PICK000000008', 'OUTBOUND-test-59', b'0', 50, 500, '229ac92d-ba1c-4d05-b8aa-e5f816707587', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-24 15:58:13', 'system', '2019-12-25 09:52:52', 'system', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('06e3a978-ef26-471b-a069-9ab39d31241d', 'PICK000000022', 'xxxxxxxxx', b'0', 50, 600, '1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2020-01-15 14:58:49', 'system', '2020-01-15 15:01:27', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('094f8705-2f47-4a57-9482-7193943e5d97', 'PICK000000019', 'OUTBOUND-test-993', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 16:52:20', 'system', '2019-12-25 16:54:43', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('0b6003b4-e230-4324-bed5-bcd6bb12c3f7', 'PICK000000010', 'OUTBOUND-test-55', b'0', 50, 500, '2d38a48e-8039-470c-9a02-2b4bf42d1428', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 10:00:34', 'system', '2019-12-25 10:20:12', 'system', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('0cef0e44-7b4e-4a65-82a3-b9bf02802f5e', 'PICK000000007', 'OUTBOUND-test-49', b'0', 50, 500, '56ae4338-f27f-4477-b8b4-50f131a00cb9', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-24 15:52:19', 'system', '2019-12-24 15:55:05', 'Test1', NULL, 0, 3);
INSERT INTO `OB_PICKINGORDER` VALUES ('0d448e85-35bd-4fe5-baae-6be2ca9cba76', 'PICK000000006', 'OUTBOUND-test-01', b'0', 50, 500, '1950884c-8892-4957-9193-46b27fcfebc1', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-23 16:20:37', 'system', '2019-12-23 18:38:32', 'Test1', NULL, 0, 3);
INSERT INTO `OB_PICKINGORDER` VALUES ('1166ab38-f795-4774-b075-29dcfb6173b3', 'PICK000000013', 'OUTBOUND-test-61', b'0', 50, 500, 'd942f0e5-0e6b-4119-92f3-9bcc8ca02cc8', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 11:13:17', 'system', '2019-12-25 11:17:22', 'Test1', NULL, 0, 3);
INSERT INTO `OB_PICKINGORDER` VALUES ('177edb2c-66ec-4810-b0eb-6f9d4bb3291e', 'PICK000000014', 'OUTBOUND-test-89', b'0', 50, 500, '0946fa79-c0a3-470a-b307-7b58581dcef7', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 13:37:28', 'system', '2019-12-25 14:57:57', 'system', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('217f0ae2-25d2-413c-9d0d-b3fd318d3bad', 'PICK000000025', 'BT202001151531', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2020-01-15 16:29:26', 'system', '2020-01-15 16:36:11', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('27f552e9-6ef1-4313-8db9-5b200e77c505', 'PICK000000011', 'OUTBOUND-test-56', b'0', 50, 500, 'b2680360-2708-41a6-981e-88119bddbb4f', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 10:20:12', 'system', '2019-12-25 10:27:34', 'system', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('438349f5-59d2-4001-bdcd-65a8748b4032', 'PICK000000021', 'lllllllll', b'0', 50, 600, '1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2020-01-15 14:46:20', 'system', '2020-01-15 14:48:34', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('48b4f178-1a6d-4fb1-9fbe-2ce9a92ab6f4', 'PICK000000024', 'BT202001151530', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2020-01-15 16:29:24', 'system', '2020-01-15 16:33:02', 'Test1', NULL, 0, 5);
INSERT INTO `OB_PICKINGORDER` VALUES ('4be92702-f07e-426e-8faf-aa602584a67a', 'PICK000000012', 'OUTBOUND-test-57', b'0', 50, 500, 'ec0cbf17-fed2-4fd1-b2e3-30437fe68f0a', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'1', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 10:27:34', 'system', '2019-12-25 11:13:17', 'system', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('6e08f1d7-b9c6-4c66-a1c2-876a60085c46', 'PICK000000015', 'OUTBOUND-test-99', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 14:57:57', 'system', '2019-12-25 15:01:53', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('7161605d-4604-4123-a449-3674eef0563b', 'PICK000000016', 'OUTBOUND-test-990', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 15:04:54', 'system', '2019-12-25 15:07:52', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('7f672a3b-58c0-4eb9-af6f-3b26ebcb06a0', 'PICK000000017', 'OUTBOUND-test-991', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 15:13:53', 'system', '2019-12-25 15:28:34', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('f92d654c-4533-47d5-85bb-7cc71d2da59a', 'PICK000000018', 'OUTBOUND-test-992', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 15:31:06', 'system', '2019-12-25 15:34:22', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('fd1a7f56-ea28-42dd-a52e-8ed4d7ae874a', 'PICK000000023', 'aaaaaaaaaaa', b'0', 50, 600, '1c1a2c5a-f7ef-42c7-8759-d5f4cb8b9d7b', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2020-01-15 15:13:35', 'system', '2020-01-15 15:15:03', 'Test1', NULL, 0, 4);
INSERT INTO `OB_PICKINGORDER` VALUES ('ff797daa-dc46-4947-bb65-6023dac6379d', 'PICK000000020', 'OUTBOUND-test-994', b'0', 50, 600, '0df37c4c-8d65-4905-8a64-3a1059c9cdb2', 'facee513-eed2-4a5f-90d1-fa46e02e83a5', NULL, '429cc5f2-93ae-40e9-84c7-cce8241c58a8', b'0', '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', NULL, NULL, '2019-12-25 16:57:04', 'system', '2019-12-25 17:01:11', 'Test1', NULL, 0, 4);

-- ----------------------------
-- Table structure for OB_PICKINGORDERPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGORDERPOSITION`;
CREATE TABLE `OB_PICKINGORDERPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AMOUNT` decimal(17, 4) NOT NULL COMMENT '数量',
  `AMOUNT_PICKED` decimal(17, 4) NULL DEFAULT 0.0000 COMMENT '已拣数量',
  `PICKING_TYPE` int(11) NOT NULL DEFAULT 0 COMMENT '拣货类型代码',
  `STATE` int(11) NOT NULL DEFAULT 0 COMMENT '状态',
  `CUSTOMERSHIPMENTPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '相对应的订单详情',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `LOTPICKED_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所拣货物的有效期',
  `PICKFROMFACE_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICKFROMLOCATION_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '位置名称',
  `PICKFROMUNITLOAD_LABEL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拖盘纸标签',
  `PICKINGORDER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拣货单号（batch号）',
  `PICKFROMSTOCKUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所拣货物来自哪个库存',
  `PICKTOUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拣到哪个载具',
  `PICKINGORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拣货单',
  `STRATEGY_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订货策略',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '当前操作人',
  `PICK_INDEX` int(11) NULL DEFAULT 0 COMMENT '排序',
  `POD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICKPACKCELL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKINGPOS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKINGPOS_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `PICKINGPOS_LOTPICKED_ID_FK`(`LOTPICKED_ID`) USING BTREE,
  INDEX `PICKINGPOS_PICKFROMSTOCKUNIT_ID_FK`(`PICKFROMSTOCKUNIT_ID`) USING BTREE,
  INDEX `PICKINGPOS_PICKINGORDER_ID_FK`(`PICKINGORDER_ID`) USING BTREE,
  INDEX `PICKINGPOS_STRATEGY_ID_FK`(`STRATEGY_ID`) USING BTREE,
  INDEX `PICKINGPOS_CUSTOMERSHIPMENTPOSITION_ID_FK`(`CUSTOMERSHIPMENTPOSITION_ID`) USING BTREE,
  INDEX `PICKINGPOS_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `PICKINGPOS_PICKTOUNITLOAD_ID_FK`(`PICKTOUNITLOAD_ID`) USING BTREE,
  INDEX `PICKINGPOS_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `PICKINGPOS_POD_ID_FK`(`POD_ID`) USING BTREE,
  INDEX `PICKINGPOS_PICKSTATION_ID_FK`(`PICKSTATION_ID`) USING BTREE,
  INDEX `PICKINGPOS_PICKPACKCELL_ID_FK`(`PICKPACKCELL_ID`) USING BTREE,
  CONSTRAINT `PICKINGPOS_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_ITEMDATA_ID_FK` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_LOTPICKED_ID_FK` FOREIGN KEY (`LOTPICKED_ID`) REFERENCES `INV_LOT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_PICKFROMSTOCKUNIT_ID_FK` FOREIGN KEY (`PICKFROMSTOCKUNIT_ID`) REFERENCES `INV_STOCKUNIT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_PICKINGORDER_ID_FK` FOREIGN KEY (`PICKINGORDER_ID`) REFERENCES `OB_PICKINGORDER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_PICKPACKCELL_ID_FK` FOREIGN KEY (`PICKPACKCELL_ID`) REFERENCES `OB_PICKPACKCELL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_PICKSTATION_ID_FK` FOREIGN KEY (`PICKSTATION_ID`) REFERENCES `OB_PICKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_PICKTOUNITLOAD_ID_FK` FOREIGN KEY (`PICKTOUNITLOAD_ID`) REFERENCES `OB_PICKINGUNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_STRATEGY_ID_FK` FOREIGN KEY (`STRATEGY_ID`) REFERENCES `OB_ORDERSTRATEGY` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPOS_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货单明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGORDERPOSITION
-- ----------------------------
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('010f8bb0-b852-479e-a2da-f31ee9f3bef5', 1.0000, 1.0000, 0, 600, '2a047e43-1bc7-423b-8de9-6e991a00312a', 'ITEM-XNR-01', NULL, 'A', 'P0000016AD01', '52f828b5-6723-461f-b7e6-64d955e336d6', 'PICK000000018', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '913b439f-aebc-4a74-afec-9179e1a5ffa2', 'f92d654c-4533-47d5-85bb-7cc71d2da59a', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '389e547f-7788-4071-8d2b-ebb05cc0da48', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:31:05', 'system', '2019-12-25 15:34:20', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('0db03412-c6b5-43d4-ae53-67d2f79e48d3', 1.0000, 1.0000, 0, 600, '4b096886-26af-41ba-97b7-e669cecf7378', 'ITEM-XNR-01', NULL, 'A', 'P0000016AD01', '52f828b5-6723-461f-b7e6-64d955e336d6', 'PICK000000016', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '9ebf4b6a-42ec-4ea5-b513-9af2a20e51d7', '7161605d-4604-4123-a449-3674eef0563b', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '389e547f-7788-4071-8d2b-ebb05cc0da48', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:04:52', 'system', '2019-12-25 15:07:45', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('154fd508-cb7d-4643-8ff7-3e113f7f3cc9', 1.0000, 1.0000, 0, 600, '26cdf5e0-5b52-4dd8-b3aa-8651d1cecb1e', 'ITEM-XNR-01', NULL, 'A', 'P0000016AD01', '52f828b5-6723-461f-b7e6-64d955e336d6', 'PICK000000014', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '73b0b4ae-093f-45da-bb33-fd3f00884702', '177edb2c-66ec-4810-b0eb-6f9d4bb3291e', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '389e547f-7788-4071-8d2b-ebb05cc0da48', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:37:28', 'system', '2019-12-25 13:39:50', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('1a89455e-d5b1-462d-8894-a483270f405d', 1.0000, 1.0000, 0, 600, 'ebc3e7cd-3d99-4c0b-8513-1bcb0063e162', 'ITEM-XNR-01', NULL, 'A', 'P0000016AD01', '52f828b5-6723-461f-b7e6-64d955e336d6', 'PICK000000020', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', 'ee19bfaf-fa49-49c9-9a63-f0c2f8f5ef45', 'ff797daa-dc46-4947-bb65-6023dac6379d', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '389e547f-7788-4071-8d2b-ebb05cc0da48', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:57:04', 'system', '2019-12-25 17:01:11', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('28ca0836-1abd-4926-ab93-fe2735b25af9', 1000.0000, 1000.0000, 0, 600, '7b081fe8-2a1b-4dfd-ae40-f953a191b944', 'Z4592-32050', NULL, 'A', 'P0000009AA01', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'PICK000000024', '8e274464-cb43-4755-af5c-7c7c13de2bf1', 'dc6ef456-20ce-4828-b995-4c8ec3e4af10', '48b4f178-1a6d-4fb1-9fbe-2ce9a92ab6f4', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '01469a33-e0a7-4ca9-8519-2411d2edc76f', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:29:24', 'system', '2020-01-15 16:33:02', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('58fbec15-ca25-4d1a-bec5-e674f13f20a8', 1.0000, 1.0000, 0, 600, '67e7b04b-8d12-46a2-a065-bc5318efee59', 'Z4592-32050', NULL, 'A', 'P0000009AA01', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'PICK000000021', '8e274464-cb43-4755-af5c-7c7c13de2bf1', '7c731c64-a2fa-4d5d-99ec-f8cd02385ccb', '438349f5-59d2-4001-bdcd-65a8748b4032', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '01469a33-e0a7-4ca9-8519-2411d2edc76f', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:46:20', 'system', '2020-01-15 14:48:34', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('5c845c93-9744-405b-a835-e4512c58d0a0', 2000.0000, 2000.0000, 0, 600, 'af484476-36b0-4818-98a4-cee7064d50be', 'Z4592-10016', NULL, 'A', 'P0000015AA01', '98ee7f52-4a47-4f3b-bdb5-7ffc7abc4100', 'PICK000000025', 'f679b92e-480d-41ed-a98e-6b1ef181e197', '7ace5827-4049-468e-b6af-6e18b1786db6', '217f0ae2-25d2-413c-9d0d-b3fd318d3bad', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '17f6aab2-627c-4b3e-917f-7db3447e96e7', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:29:26', 'system', '2020-01-15 16:36:11', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('a7ebcfef-86dc-4f4b-872a-286bea18ca99', 1.0000, 1.0000, 0, 600, '9715c3e3-efb6-4885-b1e1-b2af362656f8', 'ITEM-XNR-01', NULL, 'A', 'P0000016AD01', '52f828b5-6723-461f-b7e6-64d955e336d6', 'PICK000000019', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', 'a6788abc-adc2-4702-88d0-d5733f6cbd80', '094f8705-2f47-4a57-9482-7193943e5d97', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '389e547f-7788-4071-8d2b-ebb05cc0da48', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:52:19', 'system', '2019-12-25 16:54:42', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('cb40cd70-4b7a-460d-808b-c831f72ada7b', 1.0000, 1.0000, 0, 600, '1c06fbfd-39d5-4cdb-84b4-b2293bb213b1', 'ITEM-XNR-01', NULL, 'A', 'P0000016AD01', '52f828b5-6723-461f-b7e6-64d955e336d6', 'PICK000000017', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', '28caf457-7db0-4c28-a6dc-0a23f932cdaf', '7f672a3b-58c0-4eb9-af6f-3b26ebcb06a0', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '389e547f-7788-4071-8d2b-ebb05cc0da48', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:13:52', 'system', '2019-12-25 15:28:28', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('d1fd63ba-28f7-4595-be4a-17cfdf91bf2e', 1.0000, 1.0000, 0, 600, '8694d8a3-8782-427b-af95-69ce74cca623', 'Z4592-32050', NULL, 'A', 'P0000009AA01', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'PICK000000023', '8e274464-cb43-4755-af5c-7c7c13de2bf1', 'fb401033-3db5-45e5-9723-4e71c61306a0', 'fd1a7f56-ea28-42dd-a52e-8ed4d7ae874a', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '01469a33-e0a7-4ca9-8519-2411d2edc76f', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:13:35', 'system', '2020-01-15 15:15:03', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('db6e78c3-efb0-4b04-b75b-d417b85d64b8', 1.0000, 1.0000, 0, 600, '733dabaa-dc50-44b3-9876-9522f047ca96', 'ITEM-XNR-01', NULL, 'A', 'P0000016AD01', '52f828b5-6723-461f-b7e6-64d955e336d6', 'PICK000000015', 'abeb7ce4-c6a1-4bbb-889c-6768e41ebfe5', 'c7be08b9-e623-4aca-8c1b-74d549d68f1f', '6e08f1d7-b9c6-4c66-a1c2-876a60085c46', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '389e547f-7788-4071-8d2b-ebb05cc0da48', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 14:57:55', 'system', '2019-12-25 15:01:32', 'Test1', NULL, 0, 3);
INSERT INTO `OB_PICKINGORDERPOSITION` VALUES ('df354404-7861-4c1e-b352-0d5861cf5bd4', 1.0000, 1.0000, 0, 600, '93e098b6-a23f-4549-b22a-93783346a4a9', 'Z4592-32050', NULL, 'A', 'P0000009AA01', 'd0aae961-a2d5-4d41-8d46-b29cae06b19a', 'PICK000000022', '8e274464-cb43-4755-af5c-7c7c13de2bf1', '4909acf0-ee26-4fb6-94f2-dfc8acf60aa3', '06e3a978-ef26-471b-a069-9ab39d31241d', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 0, '01469a33-e0a7-4ca9-8519-2411d2edc76f', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, '2ad455d6-acdb-43ab-ba48-ba1fe108b776', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:58:49', 'system', '2020-01-15 15:01:27', 'Test1', NULL, 0, 2);

-- ----------------------------
-- Table structure for OB_PICKINGPROCESSELIGIBILITY
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGPROCESSELIGIBILITY`;
CREATE TABLE `OB_PICKINGPROCESSELIGIBILITY`  (
  `USER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PROCESSPATH_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`USER_ID`, `PROCESSPATH_ID`) USING BTREE,
  INDEX `PICKINGPROCESSELIGIBILITY_PP_ID_FK`(`PROCESSPATH_ID`) USING BTREE,
  INDEX `PICKINGPROCESSELIGIBILITY_USER_ID_FK`(`USER_ID`) USING BTREE,
  CONSTRAINT `PICKINGPROCESSELIGIBILITY_PP_ID_FK` FOREIGN KEY (`PROCESSPATH_ID`) REFERENCES `OB_PROCESSPATH` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGPROCESSELIGIBILITY_USER_ID_FK` FOREIGN KEY (`USER_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货权限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGPROCESSELIGIBILITY
-- ----------------------------
INSERT INTO `OB_PICKINGPROCESSELIGIBILITY` VALUES ('ADMIN', '429cc5f2-93ae-40e9-84c7-cce8241c58a8');
INSERT INTO `OB_PICKINGPROCESSELIGIBILITY` VALUES ('facee513-eed2-4a5f-90d1-fa46e02e83a5', '429cc5f2-93ae-40e9-84c7-cce8241c58a8');

-- ----------------------------
-- Table structure for OB_PICKINGUNITLOAD
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKINGUNITLOAD`;
CREATE TABLE `OB_PICKINGUNITLOAD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CUSTOMERSHIPMENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单编号',
  `POSITION_INDEX` int(11) NOT NULL COMMENT '排序',
  `PICKINGORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '拣货单',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `COMPLETE` int(11) NOT NULL DEFAULT 0 COMMENT '完成状态',
  `UNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '载具ID',
  `PICKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ISCOMPLETE` bit(1) NULL DEFAULT NULL,
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKINGUNITLOAD_PICKINGORDER_ID_FK`(`PICKINGORDER_ID`) USING BTREE,
  INDEX `PICKINGUNITLOAD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKINGUNITLOAD_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `PICKINGUNITLOAD_UNITLOAD_ID_FK`(`UNITLOAD_ID`) USING BTREE,
  INDEX `PICKINGUNITLOAD_PICKSTATION_ID_FK`(`PICKSTATION_ID`) USING BTREE,
  INDEX `PICKINGUNITLOAD_PICKSTATIONPOSITION_ID_FK`(`PICKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `PICKINGUNITLOAD_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  CONSTRAINT `PICKINGUNITLOAD_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGUNITLOAD_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGUNITLOAD_PICKINGORDER_ID_FK` FOREIGN KEY (`PICKINGORDER_ID`) REFERENCES `OB_PICKINGORDER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGUNITLOAD_PICKSTATIONPOSITION_ID_FK` FOREIGN KEY (`PICKSTATIONPOSITION_ID`) REFERENCES `OB_PICKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGUNITLOAD_PICKSTATION_ID_FK` FOREIGN KEY (`PICKSTATION_ID`) REFERENCES `OB_PICKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGUNITLOAD_UNITLOAD_ID_FK` FOREIGN KEY (`UNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKINGUNITLOAD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货载具' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKINGUNITLOAD
-- ----------------------------
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('003fce4c-7287-4cde-a95b-674fc6db0ff2', NULL, 21, NULL, 700, 0, 'd7872fec-aa7d-45e2-be60-071482981907', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:01:01', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('03987346-a217-44d0-b95f-6a541ddccf06', 'OUTBOUND-test-49', 2, '0cef0e44-7b4e-4a65-82a3-b9bf02802f5e', 600, 0, 'b158dd45-d5f8-4f51-8532-a0003cb37f94', '5df4410e-313e-4b20-80ba-980b48803e73', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:54:36', 'Test1', '2019-12-24 15:56:02', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('04f4a363-e88b-411b-98f3-906dfbfc1169', NULL, 21, NULL, 700, 0, '1e9aff6a-ee9b-462c-9289-3cdcb940db37', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 13:23:02', 'admin', '2019-12-23 13:37:49', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('0835086f-16c2-4213-a4cd-bb15ee248514', NULL, 22, NULL, 700, 0, 'b6701529-1e4d-44e8-9c2a-9660b89b542f', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:38:08', 'Test1', '2019-12-21 14:47:50', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('08d8dc24-48ae-49a3-9843-e44750da4979', NULL, 22, NULL, 700, 0, '21f85f33-f6d9-4ad3-806b-e8aa6299cbe8', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 13:50:20', 'Test1', '2019-12-23 14:21:29', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('13a4cf02-ef34-478c-841d-3864a88b5ba9', NULL, 22, NULL, 700, 0, '3b5ae243-576a-489f-96fe-382c0b21ccb1', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 15:02:22', 'Test1', '2019-12-21 15:30:56', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('15837986-c836-4d48-b669-e8ae0b248d80', NULL, 22, NULL, 700, 0, '11ae31ff-9c74-4c8d-8fdb-c466b5dc9129', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:01:07', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('15ebfa28-bde5-4e4c-a080-27a87cfc7e89', NULL, 21, NULL, 700, 0, '6378d72e-0d26-49ca-8e2a-66df9f4b241e', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 10:01:33', 'Test1', '2019-12-22 10:03:44', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('1ecd6bd2-7e06-45fc-9e86-b228dcd1fdf3', NULL, 21, NULL, 700, 0, 'eae11f40-35a6-4a55-a098-c1ab72e197bf', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 16:18:07', 'Test1', '2019-12-23 18:40:16', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('2076d1e1-16f4-4df6-a1a6-a473a783ad4d', NULL, 22, NULL, 700, 0, '72892270-0b4a-4111-b303-52ce60cdeebc', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 15:00:21', 'Test1', '2019-12-22 15:01:08', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('26c8a7df-7469-480a-babe-b011debf0c0c', NULL, 22, NULL, 700, 0, '2e5129dd-29d4-46c1-bec6-b5b3449fa8b1', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:13:50', 'Test1', '2020-01-15 15:25:32', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('28caf457-7db0-4c28-a6dc-0a23f932cdaf', 'OUTBOUND-test-991', 9, '7f672a3b-58c0-4eb9-af6f-3b26ebcb06a0', 600, 0, '5d4f2a34-d731-4398-a7c2-93a265aaef2a', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:18:10', 'Test1', '2019-12-25 15:28:34', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('28e3a846-0064-4cea-b5f2-e15ffabb0894', NULL, 22, NULL, 700, 0, '97e74d92-8206-4fab-bcfd-4d8c3d122101', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:58:20', 'Test1', '2019-12-24 16:09:30', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('2d8949d0-b403-402c-9cff-9bea9c6ac961', NULL, 21, NULL, 700, 0, 'a985171b-5d81-4ca3-8384-d32cc2ffbc42', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 09:58:35', 'Test1', '2019-12-22 10:00:10', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('303d053c-9bc9-4e52-b287-87f5a1e3085e', NULL, 22, NULL, 700, 0, '0859365f-2b6b-492e-9f5b-6ec99a7bd86a', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:58:37', 'Test1', '2019-12-21 15:01:58', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('388eb9ae-8ab4-4b61-aa8a-4df096f04620', NULL, 22, NULL, 700, 0, '4bd453e0-d470-4c24-82a6-e1c35b1de01b', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 10:08:12', 'Test1', '2019-12-22 10:19:04', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('39eba364-50de-4256-9941-b469aea72a5b', NULL, 21, NULL, 700, 0, '0af3dfe8-f0e5-4974-b51c-92d897586363', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:37:37', 'Test1', '2019-12-21 14:47:50', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('46dbaf59-159b-4676-b1d1-58816dba3453', NULL, 21, NULL, 700, 0, '67e39a36-e390-4264-8a03-82dc63ac731d', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-20 17:13:46', 'admin', '2019-12-20 18:20:12', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('4909acf0-ee26-4fb6-94f2-dfc8acf60aa3', 'xxxxxxxxx', 9, '06e3a978-ef26-471b-a069-9ab39d31241d', 600, 0, '1397c243-15c9-4805-be2c-8a79898a6347', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:01:01', 'Test1', '2020-01-15 15:01:28', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('4d98e611-00ac-462c-b554-b17d852785c8', NULL, 22, NULL, 700, 0, 'c2410b62-e395-452b-9a6b-d350716cf80c', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:35:06', 'Test1', '2019-12-21 14:37:27', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('4e919e65-70d0-4d64-997e-c2a68bf33422', 'OUTBOUND-test-59', 3, '01878098-6642-4d4e-a27e-a88f39ce7c6e', 600, 0, '344531e3-bcd1-4891-a4b3-7203002df839', 'b37fab4c-07ee-4d79-9ca1-1733c8de9526', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:59:56', 'Test1', '2019-12-24 16:03:42', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('51ea24a6-f840-4997-a4a1-527d67efb640', NULL, 22, NULL, 700, 0, '4295a517-4ae0-4810-b889-8bfe6173761a', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:52:32', 'Test1', '2019-12-24 15:56:02', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('5d749146-f660-4951-8137-857f2ddcb4d2', NULL, 21, NULL, 700, 0, '800a42fe-c5e9-417b-8c64-14db1abea165', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-20 18:21:16', 'Test1', '2019-12-21 14:34:36', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('6454ee97-c7a5-4e18-9625-dbe0d552abfa', NULL, 22, NULL, 700, 0, '27a5ff48-8970-4c19-b342-1f655ca6a3e3', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 09:48:44', 'Test1', '2019-12-22 09:57:03', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('6891b3c9-d1da-42cc-94f8-32f337c98fb4', NULL, 22, NULL, 700, 0, '9d7a3863-a3fd-4df3-9ac2-4a64b4cfde12', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 09:22:04', 'Test1', '2019-12-22 09:48:20', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('6902fa26-0956-4c42-afc4-5cb9d09580c6', NULL, 21, NULL, 700, 0, '7f4d4f5e-f5fb-4a55-a48d-5424ba79c575', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:58:14', 'Test1', '2019-12-24 16:09:30', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('6992c73e-92c7-41f7-8a85-78c412f50581', NULL, 22, NULL, 700, 0, 'f087c786-e06e-466a-aee7-4d4c9d70d945', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:46:41', 'Test1', '2020-01-15 15:01:46', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('6da05aec-0429-453c-82ab-78796a652988', NULL, 21, NULL, 700, 0, '3a0cdf70-90e5-4c34-b6c7-069af38c3525', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:49:29', 'admin', '2019-12-21 14:57:26', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('6fb8582e-1ca9-43e8-a550-9349df808f74', NULL, 21, NULL, 700, 0, '8ea7b42e-0318-47f9-bc95-e79d5765a2d6', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 14:56:38', 'Test1', '2019-12-22 14:58:13', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('71b89ff8-1134-4cdc-9609-ab2c514352a0', NULL, 22, NULL, 700, 0, '63a9e0d7-0d26-49c3-a0cb-f0a58fb31ee1', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 12:16:59', 'Test1', '2019-12-22 13:59:13', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('73b0b4ae-093f-45da-bb33-fd3f00884702', 'OUTBOUND-test-89', 8, '177edb2c-66ec-4810-b0eb-6f9d4bb3291e', 600, 0, 'd725d4cf-2d69-4dc4-b223-da5037ec97aa', '320a42f4-0138-454f-8c37-02a747b9be58', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 13:39:41', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('73d0e011-156e-4d7c-9aa0-944f326e6592', NULL, 22, NULL, 700, 0, 'fb51bbb2-acf2-45df-ad6f-2ca3ba7cbf49', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 14:31:54', 'Test1', '2019-12-22 14:56:25', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('7666be4e-ed25-4a05-ba78-daea2f7d740c', 'OUTBOUND-test-55', 4, '0b6003b4-e230-4324-bed5-bcd6bb12c3f7', 600, 0, '1de4c45d-ce97-4fb7-bc52-9875eeeab085', '313d1c9c-136a-4f1a-a2d8-180d31e2cae6', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:01:32', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('79031ebf-6958-4556-8c2e-c865931c7bb0', NULL, 21, NULL, 700, 0, '64d052b4-500a-4e25-91ea-6f401f53306e', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:34:46', 'Test1', '2019-12-21 14:37:27', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('79e28538-18f1-47db-ae4a-0a0a35971985', NULL, 21, NULL, 700, 0, '7bc930d5-2238-4c37-ba74-458eec7ee575', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 12:01:28', 'Test1', '2019-12-22 12:16:36', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('7ace5827-4049-468e-b6af-6e18b1786db6', 'BT202001151531', 9, '217f0ae2-25d2-413c-9d0d-b3fd318d3bad', 600, 0, 'aabd4684-acb4-4186-9fa5-e456d252e889', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:35:17', 'Test1', '2020-01-15 16:36:11', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('7c0dd4fe-eda9-4111-b271-52cfcf5a9084', NULL, 21, NULL, 700, 0, '435b851f-4d66-48f2-a594-cf97688db341', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 14:31:22', 'Test1', '2019-12-22 14:56:25', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('7c27b616-7628-452b-9b50-d74e246ddc0f', NULL, 22, NULL, 700, 0, '3a228aab-78e0-4846-924b-31f974d029d9', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:49:47', 'admin', '2019-12-21 14:57:26', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('7c731c64-a2fa-4d5d-99ec-f8cd02385ccb', 'lllllllll', 9, '438349f5-59d2-4001-bdcd-65a8748b4032', 600, 0, 'd2dad799-2747-47a6-80ea-c391c853c312', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:47:41', 'Test1', '2020-01-15 14:48:34', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('808fa8ae-3ab2-46cd-818f-d4d9d7f98929', 'OUTBOUND-test-56', 5, '27f552e9-6ef1-4313-8db9-5b200e77c505', 600, 0, '2e0d1283-17f7-4a0d-8636-10e113c838f1', '2344b438-f0d7-4c0f-b939-d9576fbf652d', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:25:54', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('84dc3662-7c0a-41fb-9ec2-32136c529d88', NULL, 22, NULL, 700, 0, '1d1ae38c-27f2-4812-b9fa-6296264c25e6', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 15:32:09', 'Test1', '2019-12-21 15:57:35', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('84ee59a6-0083-4e3e-ad6b-69c76fae3e1c', NULL, 22, NULL, 700, 0, '910c4e9d-8a7c-409e-b058-4ce7626c44db', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 16:18:22', 'Test1', '2019-12-23 18:40:16', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('86702615-9d97-4a36-8c92-9f9e06391030', NULL, 22, NULL, 700, 0, '7ce186d6-d20c-403e-9826-7ef281ee4542', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 18:27:47', 'Test1', '2019-12-22 09:21:46', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('8b8ccfc5-a2ad-43c9-9872-03cb279aafe9', NULL, 22, NULL, 700, 0, 'eaa4886f-1828-4826-a423-dadd7e1af64f', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 14:59:23', 'Test1', '2019-12-25 17:02:56', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('9093c13c-66f2-441d-9d4b-7bd23a86a52a', NULL, 22, NULL, 700, 0, '31b7b3fa-1fb6-4c3a-8477-0a9b31baf2d6', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 16:06:40', 'Test1', '2019-12-21 17:33:48', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('913b439f-aebc-4a74-afec-9179e1a5ffa2', 'OUTBOUND-test-992', 9, 'f92d654c-4533-47d5-85bb-7cc71d2da59a', 600, 0, 'bcf84f67-85de-45fa-b392-daf3c03730eb', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:33:52', 'Test1', '2019-12-25 15:34:22', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('963bd930-c9fc-4e21-8e6e-3479b1cb3f78', NULL, 21, NULL, 700, 0, 'b3dacdd6-b1b5-4992-8e47-80940cc9c0eb', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 15:00:05', 'Test1', '2019-12-22 15:01:08', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('995ddd43-1ab1-48ba-a4ad-ccfe8ef8160e', NULL, 22, NULL, 700, 0, 'bb6e567e-3bf4-4a55-bf9f-1d5b9fc2ff62', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 10:01:40', 'Test1', '2019-12-22 10:03:44', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('9bc086cf-d966-43b9-94f4-6249b9a80326', NULL, 22, NULL, 700, 0, '601f91e6-9bc3-4009-82fe-2b0b31b5535d', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 10:52:55', 'Test1', '2019-12-23 10:54:35', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('9c502f0d-b4bb-4be1-9cc1-33466135fe5d', NULL, 21, NULL, 700, 0, '14af0a1a-e2db-4695-a768-5e789bfe2586', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 10:08:00', 'Test1', '2019-12-22 10:19:04', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('9ebf4b6a-42ec-4ea5-b513-9af2a20e51d7', 'OUTBOUND-test-990', 9, '7161605d-4604-4123-a449-3674eef0563b', 600, 0, '5fa3afb6-8a99-441a-8a01-d43bbf0d588f', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:07:22', 'Test1', '2019-12-25 15:07:52', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('9f998833-efd9-46c4-9d65-e6c080f89e0b', NULL, 22, NULL, 700, 0, 'c5a60708-f14b-41f6-bd03-bd95ed8e9c7a', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 13:23:16', 'admin', '2019-12-23 13:37:49', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('a0accc91-030d-4369-b435-4572c88ab6ee', NULL, 21, NULL, 700, 0, 'fc6874eb-789b-4358-8269-a6213ef52e78', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 09:21:53', 'Test1', '2019-12-22 09:48:20', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('a6788abc-adc2-4702-88d0-d5733f6cbd80', 'OUTBOUND-test-993', 9, '094f8705-2f47-4a57-9482-7193943e5d97', 600, 0, '3e153348-8dbd-4448-ab30-dec4c457a6b3', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 16:54:24', 'Test1', '2019-12-25 16:54:43', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('a7d7abcf-6d55-4783-9306-0218213ed3fc', NULL, 21, NULL, 700, 0, 'eaca4704-40ca-4dc3-9953-59a964f642df', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 11:55:44', 'Test1', '2019-12-22 12:00:28', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('a84cbfec-9e49-4895-af05-7999b7f15452', NULL, 21, NULL, 700, 0, 'e19ecf62-fe48-461a-ab2c-d399a3b3b6cc', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 12:16:46', 'Test1', '2019-12-22 13:59:13', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('ad51953e-00ef-4ad7-b34b-33b6d4b7d11c', NULL, 21, NULL, 700, 0, '37f71287-b872-4466-b2b1-73f524c8d2fd', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 14:14:12', 'Test1', '2019-12-22 14:22:36', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('b80a6664-1011-498f-9c26-0a70b63877cb', NULL, 22, NULL, 700, 0, 'c4cdc0a0-ac2e-4134-8690-9107ad4e9a17', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 16:06:25', 'admin', '2019-12-23 16:09:54', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('be60a792-062c-4209-ada4-eeb2c921c695', NULL, 21, NULL, 700, 0, '1f6a0921-1674-409a-a3c2-c9363049f491', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 18:27:34', 'Test1', '2019-12-22 09:21:46', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('c44427b1-f99c-4708-b720-65e83e3d918d', 'OUTBOUND-test-01', 1, '0d448e85-35bd-4fe5-baae-6be2ca9cba76', 600, 0, 'e99d559f-39c9-4721-979d-b46acc7b8b45', 'b77e141b-10d8-4437-a5ba-7d165ff1d60a', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 17:02:33', 'Test1', '2019-12-23 18:40:16', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('c4dc7f8c-e324-48fa-a13d-ffca2cdea08d', 'OUTBOUND-test-61', 7, '1166ab38-f795-4774-b075-29dcfb6173b3', 600, 0, 'e041c2f5-97ad-40dd-b832-fd05dc604cc1', '26c82d50-b4b5-4e08-bfb0-e5a4eb6f2842', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 11:17:13', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('c6debe79-cf9f-47ac-8e3d-c8f8a28449b4', NULL, 21, NULL, 700, 0, '93a2bd29-875e-492c-807c-faf60fbd7b6e', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 15:20:58', 'admin', '2019-12-23 15:59:35', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('c7be08b9-e623-4aca-8c1b-74d549d68f1f', 'OUTBOUND-test-99', 9, '6e08f1d7-b9c6-4c66-a1c2-876a60085c46', 600, 0, '138e5e2b-5dea-4340-8851-b6755ce68369', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 15:01:17', 'Test1', '2019-12-25 15:02:03', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('c8e9e464-8620-46d1-91ad-f660c3c275a2', NULL, 22, NULL, 700, 0, '7b80adde-dcbf-46a6-a2f1-7e04fd0493a1', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 13:38:42', 'Test1', '2019-12-23 13:47:50', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('c934db84-51ad-4a0f-9d35-e1c58edb56c6', NULL, 21, NULL, 700, 0, '6d39e3c1-202e-4540-bae5-dd3da821ab8b', NULL, NULL, NULL, 'ADMIN', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 16:06:14', 'admin', '2019-12-23 16:09:54', 'admin', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('cae57446-32fc-46bd-b969-542014ba87a1', NULL, 21, NULL, 700, 0, 'd9c00bd7-4741-416d-a529-dab29e856350', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-24 15:52:25', 'Test1', '2019-12-24 15:56:02', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('cc64c5b1-05bb-445d-9610-36e36ea480f3', NULL, 21, NULL, 700, 0, 'fd7c8464-5947-441b-b730-73f13aa48775', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 09:48:31', 'Test1', '2019-12-22 09:57:03', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('d1fc7fd1-d515-471c-9a11-7ab8e2685a93', NULL, 21, NULL, 700, 0, 'e91a7b0e-776a-4359-8c60-53e4dafb9034', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 14:59:13', 'Test1', '2019-12-25 17:02:56', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('d299dcab-108f-440c-b708-f05e133fe784', NULL, 21, NULL, 700, 0, 'c2d30ce4-154f-4e22-a331-7807a6dc3fcf', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 15:31:56', 'Test1', '2019-12-21 15:57:35', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('d4cdf69c-7524-4ceb-a5a7-dbcd722adcc5', NULL, 21, NULL, 700, 0, '89479789-3783-45b6-8988-91e00d0697b4', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 13:38:31', 'Test1', '2019-12-23 13:47:50', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('da91b58b-62d6-4252-bb41-0dcdb42723f1', NULL, 22, NULL, 700, 0, '5e48ab52-26cb-4e0b-a371-7db8ad650660', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 09:58:43', 'Test1', '2019-12-22 10:00:10', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('dc6ef456-20ce-4828-b995-4c8ec3e4af10', 'BT202001151530', 9, '48b4f178-1a6d-4fb1-9fbe-2ce9a92ab6f4', 600, 0, '7ac2a2d5-e94d-419b-bebb-6eee3bcaa472', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:31:51', 'Test1', '2020-01-15 16:33:02', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('dcdfc393-3b65-405c-8d44-43245b3f3966', NULL, 21, NULL, 700, 0, '81927af4-8cdf-4271-af3d-2a79ab9e8a0c', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 14:46:29', 'Test1', '2020-01-15 15:01:46', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('dd7d5214-9406-4e95-b523-1f97b8c0ff57', NULL, 21, NULL, 700, 0, '2701673b-1913-4410-b86b-162d0f570406', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 10:52:40', 'Test1', '2019-12-23 10:54:35', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('e1a923af-5dca-42ba-be24-a0485dd4ee73', NULL, 21, NULL, 0, 0, '0cf1b1e7-e1f4-4660-aae7-c8ddb4464a8d', '258ab28b-9428-4594-8ff7-7a1a2f5e1d3b', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:30:39', 'Test1', '2020-01-15 16:30:39', 'Test1', NULL, 0, 0);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('e473a929-8dc5-4f56-a689-c50999babcf0', 'OUTBOUND-test-57', 6, '4be92702-f07e-426e-8faf-aa602584a67a', 600, 0, 'b161cc1c-bdff-4f9c-aa4f-d66be5dacf51', '9c197b1c-4709-49c1-ae01-876489cb8040', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 10:37:18', 'Test1', '2019-12-25 14:57:47', 'Test1', NULL, 0, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('e58ed3e0-bcac-4e3c-88f1-35c651a7a598', NULL, 22, NULL, 700, 0, '7c68a76d-f7ba-4625-8290-1a52873c4cb4', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 11:55:53', 'Test1', '2019-12-22 12:00:28', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('e6fff1ef-b2bf-4887-97d3-570b0a0e0e4f', NULL, 21, NULL, 700, 0, 'b23f6506-0063-481f-9647-0fa0a7607430', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:13:38', 'Test1', '2020-01-15 15:25:32', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('e7771afa-98db-4f02-bdaa-83fb96409962', NULL, 22, NULL, 700, 0, 'efe1a8bb-0523-4a1c-a6eb-5a0ee87824c4', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 12:01:41', 'Test1', '2019-12-22 12:16:36', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('e8ae4f36-e115-4a96-b062-0b9ef23c1bc2', NULL, 21, NULL, 700, 0, 'b032b7b5-0a3b-4e8c-bf08-299142c961a7', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 16:06:21', 'Test1', '2019-12-21 17:33:48', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('e9ec1527-33c5-437a-8a85-0d35eab7d393', NULL, 22, NULL, 0, 0, 'e75be860-6490-4166-87cc-1868456837dd', '5727edc4-70bc-4fbe-acea-254d654df0ea', '25f5cf90-d91e-4af4-8559-79c1991557d5', NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 16:31:37', 'Test1', '2020-01-15 16:31:37', 'Test1', NULL, 0, 0);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('ee19bfaf-fa49-49c9-9a63-f0c2f8f5ef45', 'OUTBOUND-test-994', 9, 'ff797daa-dc46-4947-bb65-6023dac6379d', 600, 0, '0603bb42-ea44-4009-9117-7b98c5a26140', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-25 17:01:02', 'Test1', '2019-12-25 17:01:11', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('f0288348-1cbe-45f2-8ead-895615881530', NULL, 21, NULL, 700, 0, '6b77e05a-9c51-4e19-bcec-05fee4bd1bb7', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-23 13:50:09', 'Test1', '2019-12-23 14:21:29', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('f6e5f8cd-d7eb-491e-ab7f-f2504fa95360', NULL, 22, NULL, 700, 0, 'ff3315d1-1557-47a3-8e1e-8c1585da7062', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-20 18:22:29', 'Test1', '2019-12-21 14:34:36', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('f8a5660a-1d08-4e0d-ae93-3b8c913ee351', NULL, 21, NULL, 700, 0, '75b9c107-3cfd-4f10-a52e-167ea288fb03', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 14:58:24', 'Test1', '2019-12-21 15:01:58', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('fb401033-3db5-45e5-9723-4e71c61306a0', 'aaaaaaaaaaa', 9, 'fd1a7f56-ea28-42dd-a52e-8ed4d7ae874a', 600, 0, '2f815e86-932a-49ff-8e7f-fb827004c22c', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2020-01-15 15:14:21', 'Test1', '2020-01-15 15:15:03', 'Test1', NULL, 2, 2);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('feb6a398-71e4-4022-91d7-394970e8a2c9', NULL, 22, NULL, 700, 0, 'bf250f95-cbbd-48fa-90b7-1a62b91d6b8b', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 14:56:47', 'Test1', '2019-12-22 14:58:13', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('fecb71d7-3525-4646-8ac4-ff8145e0ae9f', NULL, 21, NULL, 700, 0, '5272cb81-2199-4dd3-89ec-3160a7c5d53f', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-21 15:02:13', 'Test1', '2019-12-21 15:30:56', 'Test1', NULL, 2, 1);
INSERT INTO `OB_PICKINGUNITLOAD` VALUES ('ff9bdd99-ad02-478a-b07e-a2433ed93c4e', NULL, 22, NULL, 700, 0, 'ee36ca4e-b982-4fde-b785-bf110c89c044', NULL, NULL, NULL, 'facee513-eed2-4a5f-90d1-fa46e02e83a5', 'SYSTEM', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-22 14:14:22', 'Test1', '2019-12-22 14:22:36', 'Test1', NULL, 2, 1);

-- ----------------------------
-- Table structure for OB_PICKPACKCELL
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPACKCELL`;
CREATE TABLE `OB_PICKPACKCELL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `XPOS` int(11) NOT NULL COMMENT 'X坐标',
  `YPOS` int(11) NOT NULL COMMENT 'Y坐标',
  `ZPOS` int(11) NOT NULL COMMENT 'Z坐标',
  `FIELD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '段',
  `FIELD_INDEX` int(11) NULL DEFAULT NULL COMMENT '段顺序',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `LABEL_COLOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '颜色',
  `PICKPACKWALL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拣货包装墙',
  `DIGITALLABEL1_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DIGITALLABEL2_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `AREA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STORAGELOCATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKPACKCELL_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKPACKCELL_PICKPACKCELLTYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `PICKPACKCELL_PICKPACKWALL_ID_FK`(`PICKPACKWALL_ID`) USING BTREE,
  INDEX `PICKPACKCELL_DIGITALLABEL1_ID_FK`(`DIGITALLABEL1_ID`) USING BTREE,
  INDEX `PICKPACKCELL_DIGITALLABEL2_ID_FK`(`DIGITALLABEL2_ID`) USING BTREE,
  INDEX `STORAGEOCATIONTYPE_CELL_FK`(`STORAGELOCATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKPACKCELL_ibfk_1` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_PICKPACKCELLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKPACKCELL_ibfk_2` FOREIGN KEY (`PICKPACKWALL_ID`) REFERENCES `OB_PICKPACKWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKPACKCELL_ibfk_3` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKPACKCELL_DIGITALLABEL1_ID_FK` FOREIGN KEY (`DIGITALLABEL1_ID`) REFERENCES `OB_DIGITALLABEL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKPACKCELL_DIGITALLABEL2_ID_FK` FOREIGN KEY (`DIGITALLABEL2_ID`) REFERENCES `OB_DIGITALLABEL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `STORAGEOCATIONTYPE_CELL_FK` FOREIGN KEY (`STORAGELOCATIONTYPE_ID`) REFERENCES `MD_STORAGELOCATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货包装格' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKPACKCELLTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPACKCELLTYPE`;
CREATE TABLE `OB_PICKPACKCELLTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '宽',
  `VOLUME` decimal(19, 6) NULL DEFAULT NULL COMMENT '体积',
  `LIFTING_CAPACITY` decimal(16, 3) NULL DEFAULT NULL COMMENT '载重',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKPACKCELLTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKPACKCELLTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKPACKCELLTYPE_ibfk_1` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货包装格类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKPACKCELLTYPE_OB_BOXTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPACKCELLTYPE_OB_BOXTYPE`;
CREATE TABLE `OB_PICKPACKCELLTYPE_OB_BOXTYPE`  (
  `PICKPACKCELLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `BOXTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`PICKPACKCELLTYPE_ID`, `BOXTYPE_ID`) USING BTREE,
  INDEX `OB_PICKPACKCELLTYPE_OB_BOXTYPE_BOXTYPE_ID_FK`(`BOXTYPE_ID`) USING BTREE,
  INDEX `OB_PICKPACKCELLTYPE_OB_BOXTYPE_PICKPACKCELLTYPE_ID_FK`(`PICKPACKCELLTYPE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKPACKCELLTYPE_OB_BOXTYPE_BOXTYPE_ID_FK` FOREIGN KEY (`BOXTYPE_ID`) REFERENCES `OB_BOXTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKPACKCELLTYPE_OB_BOXTYPE_PICKPACKCELLTYPE_ID_FK` FOREIGN KEY (`PICKPACKCELLTYPE_ID`) REFERENCES `OB_PICKPACKCELLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货包装格类型与箱子关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKPACKFIELDTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPACKFIELDTYPE`;
CREATE TABLE `OB_PICKPACKFIELDTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `NUMBER_OF_COLUMNS` int(11) NULL DEFAULT NULL COMMENT '几列',
  `NUMBER_OF_ROWS` int(11) NULL DEFAULT NULL COMMENT '几行',
  `PICKPACKCELLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '格子类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKPACKWALLTYPEPOS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKPACKWALLTYPEPOS_PICKPACKCELLTYPE_ID_FK`(`PICKPACKCELLTYPE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKPACKFIELDTYPE_ibfk_1` FOREIGN KEY (`PICKPACKCELLTYPE_ID`) REFERENCES `OB_PICKPACKCELLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKPACKFIELDTYPE_ibfk_3` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货包装段类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKPACKWALL
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPACKWALL`;
CREATE TABLE `OB_PICKPACKWALL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `NUMBER_OF_COLUMNS` int(11) NOT NULL COMMENT '列',
  `NUMBER_OF_ROWS` int(11) NOT NULL COMMENT '行',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKPACKWALL_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKPACKWALL_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKPACKWALL_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKPACKWALL_ibfk_1` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_PICKPACKWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKPACKWALL_ibfk_2` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货包装墙' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKPACKWALLTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPACKWALLTYPE`;
CREATE TABLE `OB_PICKPACKWALLTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKPACKWALLTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKPACKWALLTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKPACKWALLTYPE_ibfk_1` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货包装墙类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKPACKWALLTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPACKWALLTYPEPOSITION`;
CREATE TABLE `OB_PICKPACKWALLTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `FIELDTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ORDER_INDEX` int(11) NULL DEFAULT NULL,
  `WALLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION` int(11) NULL DEFAULT NULL,
  `XPOS` int(11) NULL DEFAULT NULL,
  `YPOS` int(11) NULL DEFAULT NULL,
  `ZPOS` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OB_PICKPACKWALLPOS_WALLTYPE_ID_FK`(`WALLTYPE_ID`) USING BTREE,
  INDEX `OB_PICKPACKWALLPOS_FIELDTYPE_ID_FK`(`FIELDTYPE_ID`) USING BTREE,
  INDEX `OB_PICKPACKWALLPOS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKPACKWALLPOS_FIELDTYPE_ID_FK` FOREIGN KEY (`FIELDTYPE_ID`) REFERENCES `OB_PICKPACKFIELDTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `OB_PICKPACKWALLPOS_WALLTYPE_ID_FK` FOREIGN KEY (`WALLTYPE_ID`) REFERENCES `OB_PICKPACKWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `OB_PICKPACKWALLPOS_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货包装墙类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKPODSELECTION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKPODSELECTION`;
CREATE TABLE `OB_PICKPODSELECTION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKPODSELECTION_ORDER_ID_FK`(`ORDER_ID`) USING BTREE,
  INDEX `PICKPODSELECTION_STATION_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `PICKPODSELECTION_POD_ID_FK`(`POD_ID`) USING BTREE,
  INDEX `PICKPODSELECTION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `PICKPODSELECTION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PICKSTATION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKSTATION`;
CREATE TABLE `OB_PICKSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `IS_STOPPICKORDER` bit(1) NOT NULL DEFAULT b'0',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `OB_PICKSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `OB_PICKSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `OB_PICKSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_PICKSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKSTATION
-- ----------------------------
INSERT INTO `OB_PICKSTATION` VALUES ('25f5cf90-d91e-4af4-8559-79c1991557d5', 'SPTT001', NULL, '8cfd7827-3781-4d9d-9868-90a10fc4913f', NULL, b'0', '3ba41fe1-6b95-4849-8e50-31995ade08b0', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2020-01-15 16:40:16', 'Test1', NULL, 0, 73);
INSERT INTO `OB_PICKSTATION` VALUES ('aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'SPTT001', NULL, 'b3ad7912-84b7-4efd-8eec-94688fc29874', NULL, b'0', '4e8abffc-9dd1-4f8d-9f1e-5c7592e2024e', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_PICKSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKSTATIONPOSITION`;
CREATE TABLE `OB_PICKSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PICKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `PICKSTATIONPOSITION_STATION_ID_ID_FK`(`PICKSTATION_ID`) USING BTREE,
  INDEX `PICKSTATIONPOSITION__WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKSTATIONPOSITION_WORKSTATIONPOSITION_ID_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  CONSTRAINT `PICKSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`PICKSTATION_ID`) REFERENCES `OB_PICKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKSTATIONPOSITION_WORKSTATIONPOSITION_ID_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PICKSTATIONPOSITION__WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKSTATIONPOSITION
-- ----------------------------
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('20ca5948-5b9a-4c59-a582-da34f988e03d', '8393cc4f-92f0-4b83-a4cc-6a931a86dda9', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('215b7085-0edd-44e9-8ab8-08c179f596a1', '2fa6d278-38b2-4664-a1aa-bbcb9fc3a728', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('2344b438-f0d7-4c0f-b939-d9576fbf652d', '052f38c6-c507-4e1b-9d1d-c7edbadd125f', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('258ab28b-9428-4594-8ff7-7a1a2f5e1d3b', 'e6759db0-9318-4082-83cc-68730d2413e3', 'DAMAGE', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('26c82d50-b4b5-4e08-bfb0-e5a4eb6f2842', '4140a137-f237-47ca-91e0-0422a86c99ba', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('313d1c9c-136a-4f1a-a2d8-180d31e2cae6', '7402f08d-1baf-43a7-8707-db9d9869d00d', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('320a42f4-0138-454f-8c37-02a747b9be58', 'c41d3284-d510-49f6-a9b5-3e39643e6972', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('356a6b58-44f5-4ac1-8794-fc4e19b77f76', '6d02558d-c40f-46ea-a360-f8b30c14b94a', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('5727edc4-70bc-4fbe-acea-254d654df0ea', 'fdb38e35-b30f-4276-a4a9-2770f51d9577', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('585cf49f-d66c-413a-a2c0-18b7ae4683e1', '89ed60fe-b898-4d60-b079-1c8d41543135', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('5c64cce6-663f-4084-830c-71cf25b4ae5c', '6a71c7b3-10b6-46bc-a4ba-4c9b9c8f734c', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('5df4410e-313e-4b20-80ba-980b48803e73', '71fc8b6b-f1bd-4986-bf0e-0074cfdbccb6', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('5e32a24a-75c6-464f-9230-51e3b14e9ca2', '2f3edf8d-ac96-474f-8c2c-a4c8b07aad28', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('60bffc54-04e8-482a-b1ed-34c8ab266c88', 'd2272447-8683-4a4e-a925-8b7dd20f03b7', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('6b2afb0b-9bba-4ba6-9b0b-c495dda4b349', '792247b4-0c79-459c-a9fb-9420ac240d03', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('8c68226f-c430-444c-8e6c-d6dc8b27182d', 'e9a97988-7d82-4615-9bdc-79cbb988b9ff', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('9c197b1c-4709-49c1-ae01-876489cb8040', 'e3ed8f6c-b007-4ef9-8c07-f941b6c60040', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('b37fab4c-07ee-4d79-9ca1-1733c8de9526', '4d2b6d29-7262-47c8-b61d-6578f722ebdf', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('b77e141b-10d8-4437-a5ba-7d165ff1d60a', '953bd55b-3fa5-402b-9d35-675ca2d0369e', 'INVENTORY', '25f5cf90-d91e-4af4-8559-79c1991557d5', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:24:14', 'admin', '2019-12-18 06:24:14', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('c40ef36d-ec5b-4c05-9b11-b3a3de1237f8', '975ed222-60e2-4270-9ed0-3856565f532e', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('d6df6388-851f-4b23-b0ba-e45c58a75874', 'acbbb90f-a6c6-49c2-b747-7ee3f8d8b8e9', 'DAMAGE', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONPOSITION` VALUES ('dfa09f6d-bfe0-4338-adec-bb1bafb715f5', '84bd1486-7c36-4eca-8dd8-411013bd4d2a', 'INVENTORY', 'aa40dd2c-8ddb-45fa-bc53-fee8d523d0a9', 'DEFAULT', '2019-12-18 03:20:41', 'admin', '2019-12-18 03:20:41', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_PICKSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKSTATIONTYPE`;
CREATE TABLE `OB_PICKSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PICKPACKWALLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型',
  `PICK_STATION_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拣货工作站类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `IS_PRINT_FHD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否打印发货单',
  `IS_PRINT_ZXD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否打印装箱单',
  `IS_PRINT_QD` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否打印装箱单',
  `IF_SCAN_SERIALNUMBER` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否扫描序列号',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PICKSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PICKSTATIONTYPE_PICKPACKWALLTYPE_ID_FK`(`PICKPACKWALLTYPE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKSTATIONTYPE_ibfk_1` FOREIGN KEY (`PICKPACKWALLTYPE_ID`) REFERENCES `OB_PICKPACKWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKSTATIONTYPE_ibfk_2` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKSTATIONTYPE
-- ----------------------------
INSERT INTO `OB_PICKSTATIONTYPE` VALUES ('8cfd7827-3781-4d9d-9868-90a10fc4913f', 'HLXBR-PST-PICKTOTE', NULL, NULL, 'PICK_TO_TOTE', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 'NO', 'NO', 'NO', 'NO', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPE` VALUES ('b3ad7912-84b7-4efd-8eec-94688fc29874', 'HLXNR-PST-PICKTOTE', NULL, NULL, 'PICK_TO_TOTE', 'DEFAULT', 'NO', 'NO', 'NO', 'NO', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_PICKSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_PICKSTATIONTYPEPOSITION`;
CREATE TABLE `OB_PICKSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '明细顺序',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '明细状态',
  `PICKSTATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `OB_PICKSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `OB_PICKSTATIONTYPEPOSITION_PICKSTATIONTYPE_ID`(`PICKSTATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `OB_PICKSTATIONTYPEPOSITION_PICKSTATIONTYPE_ID` FOREIGN KEY (`PICKSTATIONTYPE_ID`) REFERENCES `OB_PICKSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_PICKSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '拣货工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PICKSTATIONTYPEPOSITION
-- ----------------------------
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('0a94ad10-8032-44ae-929e-a5f604f695e0', 5, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('0c0e40bc-1b68-41c5-a9b5-1d25031868fd', 1, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('1c13cd0a-cb8c-40f7-8e00-0ba357693575', 21, 'DAMAGE', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('2a943fd3-35d6-406c-ab76-9a29fed466d9', 9, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('2e6d6a72-7110-446f-b033-62d06aebb7dd', 4, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('3c74c760-d94c-4acc-bbb5-234810ebedf1', 3, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('3d342659-c74d-4aa6-9103-e88c04fb8937', 2, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('59d17de9-416c-4d1e-8dde-f4604fa5ef2b', 2, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('5b59a69d-d917-48ce-9ce4-a3445fcd5fc7', 5, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('641ce4d6-6db6-49a5-8041-4b5a9d7c3def', 22, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('68ca39c4-a099-495b-8475-57209e68d007', 3, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('7a7e812a-9e1d-422e-99a0-7490646b98c3', 7, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('7ac273f4-eff5-461e-b82f-678ff0869a4b', 6, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('7b1c83ad-776a-46e4-909f-332c01ece904', 22, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('bac2f3a1-0fb6-412b-9085-7e7c9b868391', 1, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('c39e8544-39c1-47c3-9c59-6471533f83d0', 4, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('c9f1ec6b-3571-4e51-a051-ead477437ec7', 7, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('ce4bbf42-9236-4c60-8bea-5610fc42c6fa', 21, 'DAMAGE', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('d01959b4-e645-4299-a692-f76f58463e53', 9, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('d128bcbe-893f-4e00-8ce9-a6a37c7caa71', 8, 'INVENTORY', '8cfd7827-3781-4d9d-9868-90a10fc4913f', 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', '2019-12-18 06:23:58', 'admin', '2019-12-18 06:23:58', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('eca7b184-30f2-4ea2-bc95-198da973a5a6', 6, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);
INSERT INTO `OB_PICKSTATIONTYPEPOSITION` VALUES ('eff3b5eb-88ad-4297-b48e-2d21a762bbf3', 8, 'INVENTORY', 'b3ad7912-84b7-4efd-8eec-94688fc29874', 'DEFAULT', '2019-12-18 03:20:23', 'admin', '2019-12-18 03:20:23', 'admin', NULL, 0, 0);

-- ----------------------------
-- Table structure for OB_PRINT_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PRINT_TEMPLATE`;
CREATE TABLE `OB_PRINT_TEMPLATE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '订单id',
  `PRINT_TEMPLATE` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '订单对应的打印模板',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '创建时间',
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL COMMENT '修改时间',
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '额外信息',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `OB_PRINT_TEMPLATE_ID_UINDEX`(`ID`) USING BTREE,
  UNIQUE INDEX `OB_PRINT_TEMPLATE_SHIPMENTID_INDEX`(`SHIPMENT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = ucs2 COLLATE = ucs2_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_PROCESSPATH
-- ----------------------------
DROP TABLE IF EXISTS `OB_PROCESSPATH`;
CREATE TABLE `OB_PROCESSPATH`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'PP',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'PP类型',
  `REGENERATE_SHORTED_PICKS` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否生成HOTPICK',
  `MIN_SHIPMENTS_PER_BATCH` int(11) NOT NULL COMMENT '最小订单数量',
  `MAX_SHIPMENTS_PER_BATCH` int(11) NOT NULL COMMENT '最大订单数量',
  `MIN_ITEMS_PER_BATCH` int(11) NOT NULL COMMENT '最小商品数量',
  `MAX_ITEMS_PER_BATCH` int(11) NOT NULL COMMENT '最大商品数量',
  `COLLATE_DOCUMENTS` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'COLLATE文档',
  `PICKDESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '拣货工作站类型',
  `REBINDESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'rebin工作站类型',
  `REBINWALLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'rebin墙类型',
  `PACKDESTINATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '包装站类型',
  `TARGET_PICK_RATE` int(11) NULL DEFAULT 0 COMMENT '目标拣货效率',
  `PROCESS_PAD` int(11) NULL DEFAULT 0 COMMENT '时间间隔',
  `BATCH_LIMIT` int(11) NULL DEFAULT 0 COMMENT 'BATCH数量',
  `TOTE_LIMIT` int(11) NULL DEFAULT NULL COMMENT 'TOTE数量',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `IS_HOTPICK` bit(1) NOT NULL,
  `PICK_WAY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '机器拣货' COMMENT '人工拣货，机器拣货',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PROCESSPATH_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PROCESSPATH_PPTYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `PROCESSPATH_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `PROCESSPATH_REBINDESTINATION_ID_FK`(`REBINDESTINATION_ID`) USING BTREE,
  INDEX `PROCESSPATH_REBINWALLTYPE_ID_FK`(`REBINWALLTYPE_ID`) USING BTREE,
  INDEX `PROCESSPATH_PACKDESTINATION_ID_FK`(`PACKDESTINATION_ID`) USING BTREE,
  INDEX `PROCESSPATH_PICKDESTINATION_ID_FK`(`PICKDESTINATION_ID`) USING BTREE,
  CONSTRAINT `PROCESSPATH_PACKDESTINATION_ID_FK` FOREIGN KEY (`PACKDESTINATION_ID`) REFERENCES `OB_PACKINGSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PROCESSPATH_PICKDESTINATION_ID_FK` FOREIGN KEY (`PICKDESTINATION_ID`) REFERENCES `OB_PICKSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PROCESSPATH_PPTYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_PROCESSPATHTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PROCESSPATH_REBINDESTINATION_ID_FK` FOREIGN KEY (`REBINDESTINATION_ID`) REFERENCES `OB_REBINSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PROCESSPATH_REBINWALLTYPE_ID_FK` FOREIGN KEY (`REBINWALLTYPE_ID`) REFERENCES `OB_REBINWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `PROCESSPATH_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'PP' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PROCESSPATH
-- ----------------------------
INSERT INTO `OB_PROCESSPATH` VALUES ('429cc5f2-93ae-40e9-84c7-cce8241c58a8', 'HLXNR-PP-PCKTOTE', '', 'df437ee6-f9f9-4c3b-b071-b63b520797d4', 'Hot Pick', 1, 1, 1, 1000000, 'Shipment Detail', '8cfd7827-3781-4d9d-9868-90a10fc4913f', NULL, NULL, NULL, 100, 100, 100, 100, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', b'0', '机器拣货', '2019-12-18 06:22:42', 'admin', '2019-12-18 06:34:48', 'admin', NULL, 0, 2);

-- ----------------------------
-- Table structure for OB_PROCESSPATHTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_PROCESSPATHTYPE`;
CREATE TABLE `OB_PROCESSPATHTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PICK_FLOW` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拣货流程',
  `PICK_WAY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拣货方法',
  `PICK_BOX` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `USE_AMOUNT` int(11) NULL DEFAULT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `PROCESSPATHTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `PROCESSPATHTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `PROCESSPATHTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'PP类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_PROCESSPATHTYPE
-- ----------------------------
INSERT INTO `OB_PROCESSPATHTYPE` VALUES ('b8d6caff-87c3-4c9c-9292-34f4e27d9b28', 'HLXNR-PPT-PICKTOTE', NULL, 'DEFAULT', 'PICK_TO_TOTE', 'One Person Per Batch', NULL, NULL, '2019-12-18 03:22:29', 'admin', '2019-12-18 03:22:29', 'admin', NULL, 0, 0);
INSERT INTO `OB_PROCESSPATHTYPE` VALUES ('df437ee6-f9f9-4c3b-b071-b63b520797d4', 'HLXNR-PPT-PICK_TO_TOTE', NULL, 'c9a0eb27-cb87-416b-a926-6d1e2a30096b', 'PICK_TO_TOTE', 'One Person Per Batch', NULL, NULL, '2019-12-18 06:21:25', 'admin', '2019-12-18 06:21:39', 'admin', NULL, 0, 1);

-- ----------------------------
-- Table structure for OB_REBATCHREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBATCHREQUEST`;
CREATE TABLE `OB_REBATCHREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REBATCHREQUEST_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Rebatch 号码',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `PICKINGORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拣货单',
  `REBATCHSLOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '插槽',
  `REBATCHSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作员',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBATCHREQUEST_REBATCH_NO_UK`(`REBATCHREQUEST_NO`) USING BTREE,
  INDEX `REBATCHREQUEST_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `REBATCHREQUEST_REBATCHSTATION_ID_FK`(`REBATCHSTATION_ID`) USING BTREE,
  INDEX `REBATCHREQUEST_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBATCHREQUEST_PICKINGORDER_ID_FK`(`PICKINGORDER_ID`) USING BTREE,
  INDEX `REBATCHREQUEST_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `REBATCHREQUEST_REBATCHSLOT_ID_FK`(`REBATCHSLOT_ID`) USING BTREE,
  CONSTRAINT `REBATCHREQUEST_BATCH_ID_FK` FOREIGN KEY (`PICKINGORDER_ID`) REFERENCES `OB_PICKINGORDER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUEST_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUEST_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUEST_REBATCHSLOT_ID_FK` FOREIGN KEY (`REBATCHSLOT_ID`) REFERENCES `OB_REBATCHSLOT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUEST_REBATCHSTATION_ID_FK` FOREIGN KEY (`REBATCHSTATION_ID`) REFERENCES `OB_REBATCHSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUEST_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合批' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBATCHREQUESTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBATCHREQUESTPOSITION`;
CREATE TABLE `OB_REBATCHREQUESTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态',
  `REBATCHREQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SOURCE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Unit Load',
  `REBATCHSLOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Slot号码',
  `REBATCHSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作员',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBATCHREQUESTPOSITION_REBATCHREQUEST_ID_FK`(`REBATCHREQUEST_ID`) USING BTREE,
  INDEX `REBATCHREQUESTPOSITION_SOURCE_ID_FK`(`SOURCE_ID`) USING BTREE,
  INDEX `REBATCHREQUESTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `REBATCHREQUESTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBATCHREQUESTPOSITION_REBATCHSTATION_ID_FK`(`REBATCHSTATION_ID`) USING BTREE,
  INDEX `REBATCHREQUESTPOSITION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `REBATCHREQUESTPOSITION_REBATCHSLOT_ID`(`REBATCHSLOT_ID`) USING BTREE,
  CONSTRAINT `REBATCHREQUESTPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUESTPOSITION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUESTPOSITION_REBATCHREQUEST_ID_FK` FOREIGN KEY (`REBATCHREQUEST_ID`) REFERENCES `OB_REBATCHREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUESTPOSITION_REBATCHSLOT_ID` FOREIGN KEY (`REBATCHSLOT_ID`) REFERENCES `OB_REBATCHSLOT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUESTPOSITION_REBATCHSTATION_ID_FK` FOREIGN KEY (`REBATCHSTATION_ID`) REFERENCES `OB_REBATCHSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUESTPOSITION_SOURCE_ID_FK` FOREIGN KEY (`SOURCE_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHREQUESTPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合批明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBATCHSLOT
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBATCHSLOT`;
CREATE TABLE `OB_REBATCHSLOT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `LABEL_COLOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标签颜色',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '顺序',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBATCHSLOT_NAME_FK`(`NAME`) USING BTREE,
  INDEX `REBATCHSLOT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBATCHSLOT_ORDER_INDEX_FK`(`ORDER_INDEX`) USING BTREE,
  CONSTRAINT `REBATCHSLOT_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'SOLT' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBATCHSTATION
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBATCHSTATION`;
CREATE TABLE `OB_REBATCHSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBATCHSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `REBATCHSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBATCHSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `REBATCHSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `REBATCHSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `REBATCHSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_REBATCHSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBATCH工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBATCHSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBATCHSTATIONPOSITION`;
CREATE TABLE `OB_REBATCHSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBATCHSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `REBATCHSTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `REBATCHSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `REBATCHSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `OB_REBATCHSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBATCH工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBATCHSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBATCHSTATIONTYPE`;
CREATE TABLE `OB_REBATCHSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBATCHSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `REBATCHSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `REBATCHSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBATCH工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBATCHSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBATCHSTATIONTYPEPOSITION`;
CREATE TABLE `OB_REBATCHSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBATCHSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBATCHSTATIONTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `REBATCHSTATIONTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `OB_REBATCHSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBATCHSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBATCH工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINCELL
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINCELL`;
CREATE TABLE `OB_REBINCELL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `XPOS` int(11) NOT NULL COMMENT 'X坐标',
  `YPOS` int(11) NOT NULL COMMENT 'Y坐标',
  `ZPOS` int(11) NOT NULL COMMENT 'Z坐标',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `LABEL_COLOR` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '颜色',
  `REBINWALL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '墙',
  `DIGITALLABEL1_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DIGITALLABEL2_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBINCELL_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINCELL_REBINCELLTYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `REBINCELL_REBINWALL_ID_FK`(`REBINWALL_ID`) USING BTREE,
  CONSTRAINT `OB_REBINCELL_REBINWALL_ID_FK` FOREIGN KEY (`REBINWALL_ID`) REFERENCES `OB_REBINWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_REBINCELL_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_REBINCELLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_REBINCELL_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN格' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINCELLTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINCELLTYPE`;
CREATE TABLE `OB_REBINCELLTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `HEIGHT` decimal(15, 2) NULL DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15, 2) NULL DEFAULT NULL COMMENT '宽',
  `VOLUME` decimal(19, 6) NULL DEFAULT NULL COMMENT '体积',
  `LIFTING_CAPACITY` decimal(16, 3) NULL DEFAULT NULL COMMENT '载重量',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBINCELLTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINCELLTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `REBINCELLTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN格子类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINCUSTOMERSHIPMENT
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINCUSTOMERSHIPMENT`;
CREATE TABLE `OB_REBINCUSTOMERSHIPMENT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PICKINGORDER_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拣货单号',
  `REBINWALL_INDEX` int(11) NOT NULL COMMENT 'rebin墙顺序',
  `REBINCELL_INDEX` int(11) NOT NULL COMMENT 'rebin格子顺序',
  `REBINCELL_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'rebin格子名称',
  `REBINREQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'rebin',
  `CUSTOMERSHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBINCUSTOMERSHIPMENT_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `REBINCUSTOMERSHIPMENT_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINCUSTOMERSHIPMENT_CUSTOMERSHIPMENT_ID_FK`(`CUSTOMERSHIPMENT_ID`) USING BTREE,
  INDEX `REBINCUSTOMERSHIPMENT_REBINREQUEST_ID_FK`(`REBINREQUEST_ID`) USING BTREE,
  CONSTRAINT `OB_REBINCUSTOMERSHIPMENT_ibfk_1` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_REBINCUSTOMERSHIPMENT_ibfk_2` FOREIGN KEY (`REBINREQUEST_ID`) REFERENCES `OB_REBINREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_REBINCUSTOMERSHIPMENT_ibfk_3` FOREIGN KEY (`CUSTOMERSHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `OB_REBINCUSTOMERSHIPMENT_ibfk_4` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN格子与面单的关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINREQUEST`;
CREATE TABLE `OB_REBINREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REBINREQUEST_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'rebin编号',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `PICKINGORDER_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '拣货单',
  `REBINWALLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'rebin墙',
  `NUMBER_OF_REBINWALLS` int(11) NOT NULL COMMENT 'renbin墙顺序',
  `REBINWALL1_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'renbin墙1',
  `REBINWALL2_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'renbin墙2',
  `REBINSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'renbin工作站',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBINREQUEST_REBIN_NO_UK`(`REBINREQUEST_NO`) USING BTREE,
  INDEX `REBINREQUEST_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `REBINREQUEST_REBINSTATION_ID_FK`(`REBINSTATION_ID`) USING BTREE,
  INDEX `REBINREQUEST_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINREQUEST_PICKINGORDER_ID_FK`(`PICKINGORDER_ID`) USING BTREE,
  INDEX `REBINREQUEST_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `REBINREQUEST_REBINWALL1_ID_FK`(`REBINWALL1_ID`) USING BTREE,
  INDEX `REBINREQUEST_REBINWALL2_ID_FK`(`REBINWALL2_ID`) USING BTREE,
  INDEX `REBINREQUEST)REBINWALLTYPE_ID_FK`(`REBINWALLTYPE_ID`) USING BTREE,
  CONSTRAINT `REBINREQUEST)REBINWALLTYPE_ID_FK` FOREIGN KEY (`REBINWALLTYPE_ID`) REFERENCES `OB_REBINWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUEST_BATCH_ID_FK` FOREIGN KEY (`PICKINGORDER_ID`) REFERENCES `OB_PICKINGORDER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUEST_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUEST_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUEST_REBINSTATION_ID_FK` FOREIGN KEY (`REBINSTATION_ID`) REFERENCES `OB_REBINSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUEST_REBINWALL1_ID_FK` FOREIGN KEY (`REBINWALL1_ID`) REFERENCES `OB_REBINWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUEST_REBINWALL2_ID_FK` FOREIGN KEY (`REBINWALL2_ID`) REFERENCES `OB_REBINWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUEST_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINREQUESTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINREQUESTPOSITION`;
CREATE TABLE `OB_REBINREQUESTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `AMOUNT` decimal(17, 4) NOT NULL COMMENT '数量',
  `AMOUNT_REBINED` decimal(17, 4) NOT NULL COMMENT 'renbin数量',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `CUSTOMERSHIPMENTPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单详情',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品',
  `LOT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '有效期',
  `REBINWALL_INDEX` int(11) NOT NULL COMMENT 'renbin墙排序',
  `REBINWALL_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'renbin墙',
  `REBINFROMCONTAINER_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个容器',
  `REBINFROMUNITLOAD_LABEL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个容器载具',
  `REBINFROMSTOCKUNIT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来自于那个库存',
  `REBINTOUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'renbin载具',
  `REBINTOCELL_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'renbin格子名称',
  `REBINREQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'renbin',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBINREQUESTPOSITION_CUSTOMERSHIPMENT_ID_FK`(`CUSTOMERSHIPMENTPOSITION_ID`) USING BTREE,
  INDEX `REBINREQUESTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINREQUESTPOSITION_REBINWALL_ID_FK`(`REBINWALL_ID`) USING BTREE,
  INDEX `REBINREQUESTPOSITION_REBINREQUEST_ID_FK`(`REBINREQUEST_ID`) USING BTREE,
  INDEX `REBINREQUESTPOSITION_REBINTOUNITLOAD_ID_FK`(`REBINTOUNITLOAD_ID`) USING BTREE,
  INDEX `REBINREQUESTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `REBINREQUESTPOSITION_REBINFROMSTOCKUNIT_ID_FK`(`REBINFROMSTOCKUNIT_ID`) USING BTREE,
  CONSTRAINT `REBINREQUESTPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUESTPOSITION_CUSTOMERSHIPMENT_ID_FK` FOREIGN KEY (`CUSTOMERSHIPMENTPOSITION_ID`) REFERENCES `OB_CUSTOMERSHIPMENTPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUESTPOSITION_REBINFROMSTOCKUNIT_ID_FK` FOREIGN KEY (`REBINFROMSTOCKUNIT_ID`) REFERENCES `INV_STOCKUNIT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUESTPOSITION_REBINREQUEST_ID_FK` FOREIGN KEY (`REBINREQUEST_ID`) REFERENCES `OB_REBINREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUESTPOSITION_REBINTOUNITLOAD_ID_FK` FOREIGN KEY (`REBINTOUNITLOAD_ID`) REFERENCES `OB_REBINUNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUESTPOSITION_REBINWALL_ID_FK` FOREIGN KEY (`REBINWALL_ID`) REFERENCES `OB_REBINWALL` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINREQUESTPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN记录明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINSTATION
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINSTATION`;
CREATE TABLE `OB_REBINSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBINSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `REBINSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `REBINSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_REBINSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINSTATIONTYPE`;
CREATE TABLE `OB_REBINSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `REBINWALLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'renbin墙类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBINSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINSTATIONTYPE_REBINWALLTYPE_ID_FK`(`REBINWALLTYPE_ID`) USING BTREE,
  CONSTRAINT `REBINSTATIONTYPE_REBINWALLTYPE_ID_FK` FOREIGN KEY (`REBINWALLTYPE_ID`) REFERENCES `OB_REBINWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINUNITLOAD
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINUNITLOAD`;
CREATE TABLE `OB_REBINUNITLOAD`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CUSTOMERSHIPMENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '订单编号',
  `POSITION_INDEX` int(11) NOT NULL COMMENT '排序',
  `REBINREQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'renbin',
  `STATE` int(11) NOT NULL COMMENT '状态',
  `UNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '载具',
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBINUNITLOAD_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `REBINUNITLOAD_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINUNITLOAD_UNITLOAD_ID_FK`(`UNITLOAD_ID`) USING BTREE,
  INDEX `REBINUNITLOAD_REBINREQUEST_ID_FK`(`REBINREQUEST_ID`) USING BTREE,
  CONSTRAINT `REBINUNITLOAD_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINUNITLOAD_REBINREQUEST_ID_FK` FOREIGN KEY (`REBINREQUEST_ID`) REFERENCES `OB_REBINREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINUNITLOAD_UNITLOAD_ID_FK` FOREIGN KEY (`UNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINUNITLOAD_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN载具' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINWALL
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINWALL`;
CREATE TABLE `OB_REBINWALL`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `NUMBER_OF_COLUMNS` int(11) NOT NULL COMMENT '列',
  `NUMBER_OF_ROWS` int(11) NOT NULL COMMENT '行',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBINWALL_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINWALL_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINWALL_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  CONSTRAINT `REBINWALL_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_REBINWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINWALL_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN墙' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINWALLTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINWALLTYPE`;
CREATE TABLE `OB_REBINWALLTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `NUMBER_OF_ROWS` int(11) NOT NULL COMMENT '行',
  `NUMBER_OF_COLUMNS` int(11) NOT NULL COMMENT '列',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `REBINWALLTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINWALLTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `REBINWALLTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN墙类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_REBINWALLTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_REBINWALLTYPEPOSITION`;
CREATE TABLE `OB_REBINWALLTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `XPOS` int(11) NOT NULL COMMENT 'X坐标',
  `YPOS` int(11) NOT NULL COMMENT 'Y坐标',
  `ZPOS` int(11) NOT NULL COMMENT 'Z坐标',
  `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
  `REBINCELLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'rebin格子类型',
  `REBINWALLTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'rebin墙类型',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `REBINWALLTYPEPOS_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `REBINWALLTYPEPOS_REBINCELLTYPE_ID_FK`(`REBINCELLTYPE_ID`) USING BTREE,
  INDEX `REBINWALLTYPEPOS_REBINWALLTYPE_ID_FK`(`REBINWALLTYPE_ID`) USING BTREE,
  CONSTRAINT `REBINWALLTYPEPOS_REBINCELLTYPE_ID_FK` FOREIGN KEY (`REBINCELLTYPE_ID`) REFERENCES `OB_REBINCELLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINWALLTYPEPOS_REBINWALLTYPE_ID_FK` FOREIGN KEY (`REBINWALLTYPE_ID`) REFERENCES `OB_REBINWALLTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `REBINWALLTYPEPOS_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'REBIN墙类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_SEQUENCENUMBER
-- ----------------------------
DROP TABLE IF EXISTS `OB_SEQUENCENUMBER`;
CREATE TABLE `OB_SEQUENCENUMBER`  (
  `CLASSNAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SEQUENCENUMBER` bigint(20) NOT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`CLASSNAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of OB_SEQUENCENUMBER
-- ----------------------------
INSERT INTO `OB_SEQUENCENUMBER` VALUES ('com.mushiny.wms.collating.model.PickingOrder', 25, 49);

-- ----------------------------
-- Table structure for OB_SORTINGREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `OB_SORTINGREQUEST`;
CREATE TABLE `OB_SORTINGREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `SORTINGREQUEST_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '移动包裹编号',
  `SORT_CODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '目的地',
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `STORAGELOCATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '笼车',
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作人',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `SORTINGREQUEST_SORTING_NO_UK`(`SORTINGREQUEST_NO`) USING BTREE,
  INDEX `SORTINGREQUEST_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `SORTINGREQUEST_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `SORTINGREQUEST_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `PACKINGREQUEST_SORTLOCATION_ID_FK`(`STORAGELOCATION_ID`) USING BTREE,
  CONSTRAINT `SORTINGREQUEST_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGREQUEST_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGREQUEST_STORAGELOCATION_ID_FK` FOREIGN KEY (`STORAGELOCATION_ID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGREQUEST_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '移动包裹记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_SORTINGREQUESTPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_SORTINGREQUESTPOSITION`;
CREATE TABLE `OB_SORTINGREQUESTPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '状态',
  `SORTINGREQUEST_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '移动包裹',
  `CUSTOMERSHIPMENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单',
  `FROMUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '来自于那个载具',
  `TOUNITLOAD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '去那个载具',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `SORTINGREQUESTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `SORTINGREQUESTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `SORTINGREQUESTPOSITION_SOURCE_ID_FK`(`FROMUNITLOAD_ID`) USING BTREE,
  INDEX `SORTINGREQUESTPOSITION_REQEUEST_ID_FK`(`SORTINGREQUEST_ID`) USING BTREE,
  INDEX `SORTINGREQUESTPOSITION_SHIPMENT_ID_FK`(`CUSTOMERSHIPMENT_ID`) USING BTREE,
  CONSTRAINT `SORTINGREQUESTPOSITION_CLIENT_ID_FK` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGREQUESTPOSITION_REQEUEST_ID_FK` FOREIGN KEY (`SORTINGREQUEST_ID`) REFERENCES `OB_SORTINGREQUEST` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGREQUESTPOSITION_SHIPMENT_ID_FK` FOREIGN KEY (`CUSTOMERSHIPMENT_ID`) REFERENCES `OB_CUSTOMERSHIPMENT` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGREQUESTPOSITION_SOURCE_ID_FK` FOREIGN KEY (`FROMUNITLOAD_ID`) REFERENCES `INV_UNITLOAD` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGREQUESTPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '移动包裹记录明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_SORTINGSTATION
-- ----------------------------
DROP TABLE IF EXISTS `OB_SORTINGSTATION`;
CREATE TABLE `OB_SORTINGSTATION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `OPERATOR_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `WORKSTATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `SORTINGSTATION_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `SORTINGSTATION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `SORTINGSTATION_TYPE_ID_FK`(`TYPE_ID`) USING BTREE,
  INDEX `SORTINGSTATION_OPERATOR_ID_FK`(`OPERATOR_ID`) USING BTREE,
  INDEX `SORTINGSTATION_WORKSTATION_ID_FK`(`WORKSTATION_ID`) USING BTREE,
  CONSTRAINT `SORTINGSTATION_OPERATOR_ID_FK` FOREIGN KEY (`OPERATOR_ID`) REFERENCES `SYS_USER` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGSTATION_TYPE_ID_FK` FOREIGN KEY (`TYPE_ID`) REFERENCES `OB_SORTINGSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGSTATION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGSTATION_WORKSTATION_ID_FK` FOREIGN KEY (`WORKSTATION_ID`) REFERENCES `MD_WORKSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '移动包裹工作站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_SORTINGSTATIONPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_SORTINGSTATIONPOSITION`;
CREATE TABLE `OB_SORTINGSTATIONPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKSTATIONPOSITION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物理工作站明细',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属于残品，测量，待调查，正品',
  `STATION_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '工作站',
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `SORTINGSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK`(`WORKSTATIONPOSITION_ID`) USING BTREE,
  INDEX `SORTINGSTATIONPOSITION_STATION_ID_ID_FK`(`STATION_ID`) USING BTREE,
  INDEX `SORTINGSTATIONPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `SORTINGSTATIONPOSITION_STATION_ID_ID_FK` FOREIGN KEY (`STATION_ID`) REFERENCES `OB_SORTINGSTATION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGSTATIONPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGSTATIONPOSITION_WORKSTATIONPOSITION_ID_FK` FOREIGN KEY (`WORKSTATIONPOSITION_ID`) REFERENCES `MD_WORKSTATIONPOSITION` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '移动包裹工作站明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_SORTINGSTATIONTYPE
-- ----------------------------
DROP TABLE IF EXISTS `OB_SORTINGSTATIONTYPE`;
CREATE TABLE `OB_SORTINGSTATIONTYPE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `SORTINGSTATIONTYPE_NAME_UK`(`NAME`, `WAREHOUSE_ID`) USING BTREE,
  INDEX `SORTINGSTATIONTYPE_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  CONSTRAINT `SORTINGSTATIONTYPE_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '移动包裹工作站类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_SORTINGSTATIONTYPEPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_SORTINGSTATIONTYPEPOSITION`;
CREATE TABLE `OB_SORTINGSTATIONTYPEPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `POSITION_INDEX` int(11) NULL DEFAULT NULL COMMENT '必须在物理站台MD_WORKSTATIONPOSITION的position_index可以找到',
  `POSITION_STATE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站台是属于残品，测量，待调查，正品',
  `STATIONTYPE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站台类型',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `SORTINGSTATIONTYPEPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `SORTINGSTATIONTYPEPOSITION_STATIONTYPE_ID_FK`(`STATIONTYPE_ID`) USING BTREE,
  CONSTRAINT `SORTINGSTATIONTYPEPOSITION_STATIONTYPE_ID_FK` FOREIGN KEY (`STATIONTYPE_ID`) REFERENCES `OB_SORTINGSTATIONTYPE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `SORTINGSTATIONTYPEPOSITION_WAREHOUSE_ID_FK` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '移动包裹工作站类型明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_TRANSFEROUTREQUEST
-- ----------------------------
DROP TABLE IF EXISTS `OB_TRANSFEROUTREQUEST`;
CREATE TABLE `OB_TRANSFEROUTREQUEST`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRANSFER_OUT__NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '调拨出外部单号',
  `TRANSFER_DELIVERY_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '调拨发货单号',
  `RECEIVE_HOUSE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发货时间',
  `DELIVERY_TIME` timestamp(0) NULL DEFAULT NULL,
  `EXPECT_ARRIVAL_TIME` timestamp(0) NULL DEFAULT NULL COMMENT '预计到货时间',
  `EXPECT_DELIVERY_TIME` timestamp(0) NULL DEFAULT NULL COMMENT '预计发货时间',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VERSION` int(255) NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for OB_TRANSFEROUTREQUESTINPOSITION
-- ----------------------------
DROP TABLE IF EXISTS `OB_TRANSFEROUTREQUESTINPOSITION`;
CREATE TABLE `OB_TRANSFEROUTREQUESTINPOSITION`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STORAGELOCATIONID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '存储容器ID',
  `ITEMDATA_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '商品',
  `TRANSFER_DELIVERY_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '调拨DN编号',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `CLIENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `TRANSFEROUTPOSITION_WAREHOUSE_ID_FK`(`WAREHOUSE_ID`) USING BTREE,
  INDEX `TRANSFEROUTPOSITION_CLIENT_ID_FK`(`CLIENT_ID`) USING BTREE,
  INDEX `TRANSFEROUTPOSITION_ITEMDATA_ID_FK`(`ITEMDATA_ID`) USING BTREE,
  INDEX `TRANSFEROUTPOSITION_ADVICE_ID_FK`(`TRANSFER_DELIVERY_NO`) USING BTREE,
  INDEX `TRANSFEROUTPOSITION_ibfk_5`(`STORAGELOCATIONID`) USING BTREE,
  CONSTRAINT `OB_TRANSFEROUTREQUESTINPOSITION_ibfk_1` FOREIGN KEY (`TRANSFER_DELIVERY_NO`) REFERENCES `OB_TRANSFEROUTREQUEST` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `OB_TRANSFEROUTREQUESTINPOSITION_ibfk_2` FOREIGN KEY (`CLIENT_ID`) REFERENCES `SYS_CLIENT` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `OB_TRANSFEROUTREQUESTINPOSITION_ibfk_3` FOREIGN KEY (`ITEMDATA_ID`) REFERENCES `MD_ITEMDATA` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `OB_TRANSFEROUTREQUESTINPOSITION_ibfk_4` FOREIGN KEY (`WAREHOUSE_ID`) REFERENCES `SYS_WAREHOUSE` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `OB_TRANSFEROUTREQUESTINPOSITION_ibfk_5` FOREIGN KEY (`STORAGELOCATIONID`) REFERENCES `MD_STORAGELOCATION` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收货单DN的明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for PQA_ENROUTEPOD
-- ----------------------------
DROP TABLE IF EXISTS `PQA_ENROUTEPOD`;
CREATE TABLE `PQA_ENROUTEPOD`  (
  `ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CREATED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `CREATED_BY` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `MODIFIED_BY` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  `WORKLOAD` decimal(10, 4) NULL DEFAULT NULL,
  `STATION_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL,
  `POD_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `WAREHOUSE_ID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `ROUTETYPE` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT 'IBPPod、OBPPod、ICQAPod',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for SYS_CLIENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CLIENT`;
CREATE TABLE `SYS_CLIENT`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CLIENT_NO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `EMAIL` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `PHONE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '电话',
  `FAX` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '传真',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `CLIENT_NAME_UK`(`NAME`) USING BTREE,
  UNIQUE INDEX `CLIENT_NO_UK`(`CLIENT_NO`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '客户' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CLIENT
-- ----------------------------
INSERT INTO `SYS_CLIENT` VALUES ('2ad455d6-acdb-43ab-ba48-ba1fe108b776', '1001', '合力小内燃', '', '', NULL, '2019-12-18 03:21:18', 'admin', '2019-12-18 03:21:18', 'admin', NULL, 0, 0);
INSERT INTO `SYS_CLIENT` VALUES ('SYSTEM', 'SYSTEM', 'SYSTEM', NULL, NULL, NULL, '2018-08-22 20:44:43', 'ADMIN', '2019-09-17 17:03:34', 'zhaoboxing', NULL, 0, 2);

-- ----------------------------
-- Table structure for SYS_MENU
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MENU`;
CREATE TABLE `SYS_MENU`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `PARENT_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CHILD_ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ORDER_INDEX` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `MENU_PARENT_ID_FK`(`PARENT_ID`) USING BTREE,
  INDEX `MENU_CHILD_ID_FK`(`CHILD_ID`) USING BTREE,
  CONSTRAINT `MENU_CHILD_ID_FK` FOREIGN KEY (`CHILD_ID`) REFERENCES `SYS_MODULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION,
  CONSTRAINT `MENU_PARENT_ID_FK` FOREIGN KEY (`PARENT_ID`) REFERENCES `SYS_MODULE` (`ID`) ON DELETE RESTRICT ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'PC端菜单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MENU
-- ----------------------------
INSERT INTO `SYS_MENU` VALUES ('000b026b-a134-47c8-b445-fce258b76abc', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 'd1a58179-bc55-481a-9cd5-bcc2d4d83944', 9);
INSERT INTO `SYS_MENU` VALUES ('01ddf4ca-df82-43ad-b5b5-2aee8fdb9c20', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', '88d89766-e0ea-4d2e-8a37-5f8705d161d6', 6);
INSERT INTO `SYS_MENU` VALUES ('02c23ee7-5683-44ec-ab89-1a2a5612880a', 'df6ce431-121a-4f43-98b7-3912738d1af8', 'f4f18b61-ab2d-4baf-8461-9eaa5849f462', 1);
INSERT INTO `SYS_MENU` VALUES ('030afd65-08b5-48ad-87bb-5efcb7a45b62', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', 'dae17ff2-f308-4b52-9eab-e51b59fb1b6a', 1);
INSERT INTO `SYS_MENU` VALUES ('04df6fd1-f43c-45be-9830-4ecaa465d65a', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'fbc600b4-0ea3-4373-9a18-b196ac6f4f99', 4);
INSERT INTO `SYS_MENU` VALUES ('052a20ac-9346-4a53-8648-84b6324ba73b', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '8516dacf-42b0-4f8d-8eb6-77b173085195', 0);
INSERT INTO `SYS_MENU` VALUES ('0559b3fa-e53f-425e-97cb-8252da4b19c4', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '003f3eec-170a-4bc8-adf5-567d37de6b51', 18);
INSERT INTO `SYS_MENU` VALUES ('05e498f1-8701-471c-842d-fe39600579b4', '0b8dde03-cf52-437a-b9e5-78126c5557aa', '5c8cd376-f5dd-4f01-b873-0c2b5959143e', 0);
INSERT INTO `SYS_MENU` VALUES ('063d2b03-a3bb-4458-945f-042f9f98ec70', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 'itemdataimages', 1);
INSERT INTO `SYS_MENU` VALUES ('06a98be9-dc5f-4fc7-b442-649a1f981f16', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 'c17477bd-9c82-4981-852f-bce1c87e5754', 18);
INSERT INTO `SYS_MENU` VALUES ('086dd4cb-434e-4f84-b43a-2242a4274303', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '2a5ffffa-5b65-4cca-a1d2-1ef4ebd2c3df', 37);
INSERT INTO `SYS_MENU` VALUES ('09483b5d-37b3-4a3b-bf3f-89e7688d709e', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'bde6b804-56f1-4612-9ed2-251c1857abee', 3);
INSERT INTO `SYS_MENU` VALUES ('098d8cad-f31f-4bba-a2b8-20b58b2e865a', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '1e7b70bf-fa6f-4d89-9e08-9d20f7789dda', 9);
INSERT INTO `SYS_MENU` VALUES ('0ad3138e-d30f-4a9c-801f-a81021172917', 'a982693b-1f56-4b9c-902b-c3630ab414b5', 'abb8665d-1021-47a8-bd67-fd703814f9f8', 2);
INSERT INTO `SYS_MENU` VALUES ('0f173c5e-2c1b-4b6f-83c6-7698ddeaef71', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '7bd4e4d8-ef70-4a4c-96af-16d3ada13685', 1);
INSERT INTO `SYS_MENU` VALUES ('10cd8ba7-ec55-41be-bf09-9f135fa66fa5', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 'f949833e-efb0-4b43-8965-1f818d300c29', 11);
INSERT INTO `SYS_MENU` VALUES ('10e03251-2bff-402a-be03-5c8bf4433096', 'ROOT', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 4);
INSERT INTO `SYS_MENU` VALUES ('1207b112-186f-4800-87d2-4f91d0350d57', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '8e78a416-bcb1-4ccb-940b-c29e88938a1e', 38);
INSERT INTO `SYS_MENU` VALUES ('153934fb-0a32-4c90-8149-50d6c1a5ee6b', '59634d7c-15bf-4e1e-ad42-22ec78cbb1ff', 'd7a11398-0a5f-4709-85ea-86579d5d29e1', 1);
INSERT INTO `SYS_MENU` VALUES ('15cb87be-b69e-4cc9-a5fd-d0a90b20cdd5', '168d0a00-848e-4d75-bcd2-7beb06fae5c8', '581c1728-12fe-49f2-8e11-7588bde58117', 1);
INSERT INTO `SYS_MENU` VALUES ('15da8f1d-0503-46bc-882f-1a37128676c6', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '8601c443-aaee-4046-a85f-cbf034f71d1c', 3);
INSERT INTO `SYS_MENU` VALUES ('16235f1b-fc1a-411e-9088-8a75c485f544', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', 'cc7ea382-46e9-4601-a95a-acaf3a97c768', 5);
INSERT INTO `SYS_MENU` VALUES ('1665c50d-6a9a-49be-bd79-7a6585897395', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 'f489a95f-934e-461f-bcc0-e58c18d4e41b', 5);
INSERT INTO `SYS_MENU` VALUES ('172016f2-c907-42d6-971b-43b7a27b95ec', 'df6ce431-121a-4f43-98b7-3912738d1af8', '3b3b1e74-42ef-4869-ad2e-1e3e66790c46', 10);
INSERT INTO `SYS_MENU` VALUES ('17b27227-ccfd-414a-9322-a366f6301262', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'f49640f3-b460-44d7-920b-89f72bf30b59', 39);
INSERT INTO `SYS_MENU` VALUES ('182e48a6-280b-43fe-a394-c106e139a499', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '80e0d818-2a9d-4b7c-9ad6-194edbb3c683', 20);
INSERT INTO `SYS_MENU` VALUES ('1b71c4ce-34b4-45a6-9067-53da200b219b', 'ROOT', 'a89695af-de9a-4fa7-a140-e12ca2e93499', 7);
INSERT INTO `SYS_MENU` VALUES ('1c614055-6253-4efd-ad27-755db01c6339', 'ce8b4d2f-b05c-42b9-8d28-4bb2a4ab3f62', '469a2852-0913-4135-baf0-3b561a6d694b', 2);
INSERT INTO `SYS_MENU` VALUES ('1d03ce9c-506b-471e-bcb5-a7f202f380c5', 'df6ce431-121a-4f43-98b7-3912738d1af8', '49f0a561-ba25-4953-b0bf-023dfeeee9d6', 14);
INSERT INTO `SYS_MENU` VALUES ('1ec140e9-667d-449f-b1a9-d71882a26fbc', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', 'd31c5190-b276-4953-83df-deba1f39dff2', 1);
INSERT INTO `SYS_MENU` VALUES ('1ffd2b73-4bfc-4f69-9537-188b9a1bffe9', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '3e05c6cf-04e0-4df3-aac2-917c662fc6aa', 2);
INSERT INTO `SYS_MENU` VALUES ('204056f9-d0c2-4ac9-ae87-c10578e40a56', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '20c7b087-e916-464f-a976-35326457cf25', 0);
INSERT INTO `SYS_MENU` VALUES ('2227fb2e-7f72-421f-98bc-bb182c4f2c8b', 'a982693b-1f56-4b9c-902b-c3630ab414b5', 'a6ed995b-9c8c-480b-8275-496b68ebae2d', 11);
INSERT INTO `SYS_MENU` VALUES ('23761c8f-118e-4c72-ae52-7db4e83f381e', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'e7a9078e-77a7-4bf9-8c03-1f0f0d80fff6', 36);
INSERT INTO `SYS_MENU` VALUES ('2384b348-7313-4fb4-b92b-4c06c5799af8', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '5c6936df-d88f-427e-8e77-27336e1f23ec', 16);
INSERT INTO `SYS_MENU` VALUES ('239be1b8-7944-4233-a37a-d7f11d123617', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '1e0f438f-2eb1-43cf-b4e4-f652331cd759', 19);
INSERT INTO `SYS_MENU` VALUES ('23b1987e-a9a8-4974-a536-6fb1b949725d', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'e18c43b1-2096-49cb-9fe6-606751c7e74b', 6);
INSERT INTO `SYS_MENU` VALUES ('257c743b-67ac-4f72-91fd-ca6bfdeda3eb', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', 'ed6df69c-35b7-49eb-94f9-43c6c988d4c1', 3);
INSERT INTO `SYS_MENU` VALUES ('258a4a2d-c83c-4ceb-ab2e-0f07c9c21c34', '59634d7c-15bf-4e1e-ad42-22ec78cbb1ff', '1b1f4a76-e27a-47d0-8107-6fd004374f30', 5);
INSERT INTO `SYS_MENU` VALUES ('26a7d882-a214-4d11-96e2-f755de2c1c77', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '94cab3a6-3eb2-468c-93e5-91cb17af1315', 7);
INSERT INTO `SYS_MENU` VALUES ('27cce920-c2d4-4b30-8a0c-cc26ff6534d8', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '43b6e161-56ee-4730-b1b5-e80920378b9f', 7);
INSERT INTO `SYS_MENU` VALUES ('293142b8-1626-4313-bf39-024595af2916', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '9551a8f7-0efb-4a0c-a069-4d21f5f5688d', 11);
INSERT INTO `SYS_MENU` VALUES ('2a11c936-09ae-4d39-9c17-69471db6da95', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'cf119ec0-50a5-48e1-b73b-b39b4bee88dd', 13);
INSERT INTO `SYS_MENU` VALUES ('2b0d5472-669e-4635-8f2e-9c6c0504b07d', 'ROOT', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 1);
INSERT INTO `SYS_MENU` VALUES ('2b697a57-d9e8-46b1-afa4-ef652dd1d812', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 'c9f8a80d-eb4f-4447-9845-987850480bfd', 1);
INSERT INTO `SYS_MENU` VALUES ('2fcbfd25-ff43-4868-96d4-56c14532ac20', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '79082e5e-df81-41ac-abe7-a39512042dd3', 6);
INSERT INTO `SYS_MENU` VALUES ('30937286-76de-4b9f-948e-15a2af416443', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'ccd27135-71f4-4246-92f4-474350cad220', 15);
INSERT INTO `SYS_MENU` VALUES ('31005f09-1d41-43ad-b883-b732421d7a36', 'ce8b4d2f-b05c-42b9-8d28-4bb2a4ab3f62', '2447c23c-4f34-4b21-b3b2-22697b202b59', 3);
INSERT INTO `SYS_MENU` VALUES ('33731a92-0fb6-474d-b747-e1b69debd5bb', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '6a564454-d5f8-4681-b92e-781766c5a3df', 15);
INSERT INTO `SYS_MENU` VALUES ('3398e845-4669-4c71-ab66-0fd0daa19a84', 'df6ce431-121a-4f43-98b7-3912738d1af8', '13b57d81-c9db-4ba0-afe9-df858612ea04', 4);
INSERT INTO `SYS_MENU` VALUES ('363be3dc-bd9b-437c-9640-1fe008ce34fb', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '4dd9e31d-3af5-4e56-9e26-3a8cf7f3856e', 7);
INSERT INTO `SYS_MENU` VALUES ('38521628-a7f7-4dfb-beb5-98e2ec77e75a', '59634d7c-15bf-4e1e-ad42-22ec78cbb1ff', '16bd71f8-1833-4c52-b475-48b0053e0d3d', 2);
INSERT INTO `SYS_MENU` VALUES ('39ec6dac-e124-40b7-94b3-c22ef6766f31', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '48ed545c-38f2-408e-b46a-a9c41cf4f67b', 4);
INSERT INTO `SYS_MENU` VALUES ('3afbb2ff-04b2-49cd-a92c-6a1a143306ff', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', '9bb751a8-ae25-4355-9848-66d71aa2ea06', 2);
INSERT INTO `SYS_MENU` VALUES ('3b533419-a235-473a-9929-18ea42616d3c', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '4be29f18-603d-4128-9707-6e0de2c1b947', 20);
INSERT INTO `SYS_MENU` VALUES ('3d446f27-2f13-4995-b9cd-162c6cdd9b17', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', '43264535-3661-41f7-97eb-0e615ae42626', 11);
INSERT INTO `SYS_MENU` VALUES ('3ed5ffd1-bfea-418c-92ab-4dac7b9ea799', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '4fef1f0e-810d-44c6-9669-ec05644ba357', 21);
INSERT INTO `SYS_MENU` VALUES ('3f2faab9-02e5-43b5-bd75-c1810dd3209f', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '2d562cdd-846c-48ff-bac0-c127aa5e0e66', 5);
INSERT INTO `SYS_MENU` VALUES ('41ccafa7-db3e-463c-9bfa-cfd9f6f291f0', 'a89695af-de9a-4fa7-a140-e12ca2e93499', '335d89ed-1e66-40c0-8ffc-3a2c959f3367', 0);
INSERT INTO `SYS_MENU` VALUES ('45db9dd0-0096-44a5-84fc-42aeb24e2eef', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '6ab3264b-6183-4154-97ff-39ff953e50b4', 4);
INSERT INTO `SYS_MENU` VALUES ('463e865a-59b5-4dd6-abe6-46e6fac0a6fa', '59634d7c-15bf-4e1e-ad42-22ec78cbb1ff', '4e9c4ebf-a8ec-42ce-a7a2-9deb43b0174a', 0);
INSERT INTO `SYS_MENU` VALUES ('472ab948-76e0-4c5e-8f6a-fbcf907aedac', '168d0a00-848e-4d75-bcd2-7beb06fae5c8', '6fa904cb-ef11-411f-9e65-d528e789a6d2', 0);
INSERT INTO `SYS_MENU` VALUES ('4aef23fd-6243-4a82-af64-b0962e6d87fa', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 'c202d0f4-a767-4f88-aca4-3cf9196d0b2b', 0);
INSERT INTO `SYS_MENU` VALUES ('4b16174a-bd6b-46e7-88d2-95f33a67a5ed', 'ROOT', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', 11);
INSERT INTO `SYS_MENU` VALUES ('4d5ec467-7f6a-454d-8d66-9cf62ebbecb3', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '0a90efad-8e04-465a-9fdc-70a6d9d9cbd2', 12);
INSERT INTO `SYS_MENU` VALUES ('4d87753d-a4f1-4859-849b-af85b18d45f8', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '1028b088-c7a6-48ff-8ed5-493f97588670', 16);
INSERT INTO `SYS_MENU` VALUES ('4f909584-1997-42a5-b544-61a4d4bc1f39', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '1fd62eab-bcf3-46de-8fde-c0cabdb6a488', 15);
INSERT INTO `SYS_MENU` VALUES ('514cfcbf-cc49-45ab-b5bf-e0aaab4b7cf3', 'ROOT', 'ce8b4d2f-b05c-42b9-8d28-4bb2a4ab3f62', 9);
INSERT INTO `SYS_MENU` VALUES ('51d809a4-6189-40fe-9f4e-0c5a9f3d4867', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', '9bc809f8-b24f-4249-8ff9-a41e9c20cbd0', 4);
INSERT INTO `SYS_MENU` VALUES ('528768b4-1e42-4012-bcc6-c01bc06d26d0', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '7f12c8d7-5e96-4c4f-ae7d-e9ec84ba1d63', 9);
INSERT INTO `SYS_MENU` VALUES ('5313c1e0-5295-413e-b664-358ae2284142', 'ROOT', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 5);
INSERT INTO `SYS_MENU` VALUES ('550b2e0e-40d6-4b1d-918b-48c3787ce3e1', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'b6b859b2-4ccb-4bad-8205-7995b6ae68dc', 20);
INSERT INTO `SYS_MENU` VALUES ('552d34c4-cf32-432f-ad48-2dff72496e36', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', '0c1cd64f-bbd5-49aa-be7d-f3ba8581fc7e', 3);
INSERT INTO `SYS_MENU` VALUES ('58edcab5-d536-490e-9aab-f85f1f32bb56', 'ROOT', '168d0a00-848e-4d75-bcd2-7beb06fae5c8', 3);
INSERT INTO `SYS_MENU` VALUES ('5949b356-0208-4081-8f8c-747b1ff893c9', '68dd6201-db86-4f1d-9adb-0c3d08af7739', '4b3617b1-a0e0-4a42-8b51-2fb7c6cd9970', 2);
INSERT INTO `SYS_MENU` VALUES ('5a30f844-88b3-4bae-a20d-3793b8cfa778', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 'dbeadb28-b1cb-47bb-a3c8-ff6f3235daa7', 4);
INSERT INTO `SYS_MENU` VALUES ('5ade5dd0-61ad-4a21-963f-413505382dc9', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'ef532383-4137-4c85-883d-41147c33ba5a', 33);
INSERT INTO `SYS_MENU` VALUES ('5b06d298-a831-4362-8198-66a513c0aa7d', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 'bae13256-7c1c-42e3-9881-8ab3d615cb1a', 2);
INSERT INTO `SYS_MENU` VALUES ('5cc914f6-7e57-420f-8812-7a4cc78942be', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 'f3aa4cd0-77c3-4af5-87ca-dc5274ce49b9', 5);
INSERT INTO `SYS_MENU` VALUES ('5cfb4582-5536-4c2a-abea-fcb0a390b81c', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '7f422889-25fa-41d5-9868-30ceeb9b4907', 13);
INSERT INTO `SYS_MENU` VALUES ('5e09b5f8-50e9-4179-81de-18e5fe14d2c4', 'df6ce431-121a-4f43-98b7-3912738d1af8', 'cd18df12-34ba-4ff0-8830-9b3b02775cd1', 7);
INSERT INTO `SYS_MENU` VALUES ('608a0635-c7a1-487a-a03c-c4c926ab092a', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'da7e71a1-5248-4191-800b-7b703c59b771', 22);
INSERT INTO `SYS_MENU` VALUES ('61b9a89b-3420-453c-86c1-cb16aade718c', '0b8dde03-cf52-437a-b9e5-78126c5557aa', '0066c927-7a80-4847-b41f-9b80df1f1672', 1);
INSERT INTO `SYS_MENU` VALUES ('6460dad2-4d6d-4504-8c77-77ed509f400e', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '19701011-eec5-46fc-b3fa-2ae0e103b55c', 17);
INSERT INTO `SYS_MENU` VALUES ('64e6095e-de6e-42fa-a1c9-a9adcda5df5c', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '1eead127-7307-4ca0-a4d7-607fc77d1d1f', 10);
INSERT INTO `SYS_MENU` VALUES ('6587b506-04e9-492a-a7b3-a470df0f2bc0', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '3d1cafc3-f816-4283-9979-4a0244cfeec1', 13);
INSERT INTO `SYS_MENU` VALUES ('67c25506-1868-4106-8cfe-86fd3b2f2171', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '3bebb678-b615-4d65-9459-7c1578e4e718', 0);
INSERT INTO `SYS_MENU` VALUES ('67e2b7ad-d6e6-41c5-9b0b-386cef8a0fc3', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '8389c04b-0197-450b-b5a0-b3a359620975', 10);
INSERT INTO `SYS_MENU` VALUES ('69f414b0-9a4f-4d86-b787-6f9040dcf373', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 'e54163af-6101-4c25-aad3-3e2fd78d8a8b', 9);
INSERT INTO `SYS_MENU` VALUES ('6b8ba53b-ac54-4aee-8ee2-fee2d15c1efb', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '2928f06a-96fb-49d7-92f0-dfaedc643b6b', 2);
INSERT INTO `SYS_MENU` VALUES ('6c0ce534-4414-42fb-b4d4-d700d0ef82b2', 'df6ce431-121a-4f43-98b7-3912738d1af8', 'ade442ae-7763-410e-8917-1168e3f83c35', 12);
INSERT INTO `SYS_MENU` VALUES ('6ce92808-22e3-4ff3-b673-b31f84871ec3', '59634d7c-15bf-4e1e-ad42-22ec78cbb1ff', '3bdfbef9-7bd2-4c70-946f-4b9b7589a3c9', 3);
INSERT INTO `SYS_MENU` VALUES ('6e17ae85-c808-4593-8037-8e39a05cafe7', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'c9615bd3-84f3-4ce4-b257-d513f1e6d1bd', 35);
INSERT INTO `SYS_MENU` VALUES ('6ec8df12-fb46-4734-9721-e390f0d1a839', 'df6ce431-121a-4f43-98b7-3912738d1af8', '858e24e4-3c47-4c27-920d-94d097dbab14', 13);
INSERT INTO `SYS_MENU` VALUES ('6ef667ea-a780-48ed-a425-9073e736da0e', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'da94c8b7-3f1e-44b5-b0ea-f50b5ce09f5e', 11);
INSERT INTO `SYS_MENU` VALUES ('6f4fcf29-937d-4661-a187-04fa2de11795', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '068be016-92e7-4b3b-900c-f71fc9e61767', 25);
INSERT INTO `SYS_MENU` VALUES ('70555f44-8509-4a6e-8f01-481bd127edd0', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', '4c25bcc4-9a19-48a8-8350-91e386fd536c', 7);
INSERT INTO `SYS_MENU` VALUES ('70f73478-83f6-4b2e-bc8d-1deafcf764f3', 'ROOT', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 6);
INSERT INTO `SYS_MENU` VALUES ('7254b6c1-7b73-4433-b73e-d020841634de', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '2e947524-6260-4761-afc8-116caccd7fc7', 16);
INSERT INTO `SYS_MENU` VALUES ('75637951-d661-4f13-b553-fb82b98036dc', 'ROOT', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', 10);
INSERT INTO `SYS_MENU` VALUES ('75c37119-d960-4de7-9686-dd2f93415f77', 'df6ce431-121a-4f43-98b7-3912738d1af8', 'ad663103-3313-4e57-b8c2-f830a616345b', 5);
INSERT INTO `SYS_MENU` VALUES ('768f6af2-b3ca-4832-9d94-393d7b4f4548', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '1cb31f78-d9cd-4522-8b8c-71a3dd37c197', 10);
INSERT INTO `SYS_MENU` VALUES ('76968e28-af68-4e52-86bb-68f5569f4315', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '1bb1b8df-9c90-4dc4-ab9a-492f77d1d1e4', 6);
INSERT INTO `SYS_MENU` VALUES ('76b677e7-5e61-4ebe-ae93-8276612e7356', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'e4a5f2ce-83bb-41e7-852d-620b2d85da67', 9);
INSERT INTO `SYS_MENU` VALUES ('7b9c5e8d-940f-4092-8500-27a626f79800', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '3c8294dc-0155-4249-8f87-07130067577f', 12);
INSERT INTO `SYS_MENU` VALUES ('7bd3eab2-3b85-431f-8668-a63dddd8e238', '1acf1949-c336-47fa-9bef-dadbea0b3af2', 'f87a113c-53bf-4c00-8a8f-452eeed5dfd0', 3);
INSERT INTO `SYS_MENU` VALUES ('7c87c09b-3764-4018-a1ea-24d3ed10ecc2', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'd90044e9-7685-49ba-8335-cdabb840abf6', 28);
INSERT INTO `SYS_MENU` VALUES ('7d1e39c3-b961-4c3e-86ae-8e1796a7b9ec', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '3ebf2218-4512-4cff-bf53-92f4ce716d2a', 23);
INSERT INTO `SYS_MENU` VALUES ('7d94bfb6-a8f0-43ed-8425-2e6bede7955a', '1acf1949-c336-47fa-9bef-dadbea0b3af2', 'bc377572-2ffb-44a9-b792-39bebbbbde79', 8);
INSERT INTO `SYS_MENU` VALUES ('7da26687-eaed-4d56-9deb-76011b6bc210', '59634d7c-15bf-4e1e-ad42-22ec78cbb1ff', '2b9a9121-17c5-451d-8984-d0da27006356', 4);
INSERT INTO `SYS_MENU` VALUES ('81862d91-6a60-4522-87f8-cc13ed05dfb3', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', '5a1527a8-9a38-4d6b-8427-20811221efce', 2);
INSERT INTO `SYS_MENU` VALUES ('831b5f23-7428-4836-bc09-fe9b7957c30a', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'd276b3bb-bb4b-48ce-a4fa-9b9c79bd3110', 0);
INSERT INTO `SYS_MENU` VALUES ('83281a5e-90eb-434a-a75a-f76b4bcb3c64', '168d0a00-848e-4d75-bcd2-7beb06fae5c8', '0702b987-7fe9-4ea8-b6f3-591ad65c733b', 2);
INSERT INTO `SYS_MENU` VALUES ('857fb142-7dd2-407c-b300-e9c28c9976e6', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '7eda7753-baa3-4dd5-928a-d633836f0cd2', 26);
INSERT INTO `SYS_MENU` VALUES ('85f251cc-74d4-479a-b7ac-2d1b97ddbda2', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '7c40fe97-fb4a-4b31-b73a-67dcd364a338', 8);
INSERT INTO `SYS_MENU` VALUES ('8733c1cf-41e1-4b5e-929e-d909b68a2cdd', 'ROOT', '0b8dde03-cf52-437a-b9e5-78126c5557aa', 12);
INSERT INTO `SYS_MENU` VALUES ('8830c6cc-c20d-4fd1-876c-85906e48a0ef', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', '979a1933-a17f-4eb3-8e57-4d4391d4ef46', 7);
INSERT INTO `SYS_MENU` VALUES ('89e17410-da10-4dfd-8c58-5ac76861244c', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', 'db129b91-31a8-4fc1-a912-8ffb9ef46d1d', 4);
INSERT INTO `SYS_MENU` VALUES ('8b4d95a3-5f20-4b9c-9f47-0e571c43d984', '68dd6201-db86-4f1d-9adb-0c3d08af7739', '86169f68-185f-4a26-8ab7-59b5f9009229', 4);
INSERT INTO `SYS_MENU` VALUES ('8c5e5bb6-e7aa-4bf8-829e-d196cbfbcc96', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', 'a63298ba-7098-413a-95e1-69c143800fcf', 3);
INSERT INTO `SYS_MENU` VALUES ('8cff307d-7734-4f78-abfe-0fbd53b253f3', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'f1a0f435-7c96-4f4d-9f8f-3590ba78fe4d', 34);
INSERT INTO `SYS_MENU` VALUES ('8d76443a-a906-4c17-b686-36d59c37d9ac', 'df6ce431-121a-4f43-98b7-3912738d1af8', 'e6f4da5f-0887-47b2-bcd2-5cd884633c87', 9);
INSERT INTO `SYS_MENU` VALUES ('8f2b3f2f-e36f-43b4-abd6-9cbda82f4337', 'ce8b4d2f-b05c-42b9-8d28-4bb2a4ab3f62', '6fcc095a-2924-48ea-bddf-46dc46e18693', 0);
INSERT INTO `SYS_MENU` VALUES ('91b3f9cf-36c9-4550-af91-fa69ea068981', '1acf1949-c336-47fa-9bef-dadbea0b3af2', 'acf36287-f155-4e9d-922c-141fd089e9d5', 5);
INSERT INTO `SYS_MENU` VALUES ('91bc92b8-b192-4ee4-9cf1-3740fdc3ed14', '1acf1949-c336-47fa-9bef-dadbea0b3af2', 'f2009bcd-37a6-49da-b748-cfea3e1beafb', 4);
INSERT INTO `SYS_MENU` VALUES ('91fd18a7-d9c6-46f6-924f-7c99faa19bcb', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '9e2c1b41-a898-4349-907b-b52e4f10fa9d', 5);
INSERT INTO `SYS_MENU` VALUES ('92cebb28-ed0c-4a0d-bcd8-0d4956eaab7a', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '46dd4e72-8371-47d7-b13b-ad516b923d6d', 7);
INSERT INTO `SYS_MENU` VALUES ('942a0816-e390-48c4-a231-a514ea0fc9c1', 'df6ce431-121a-4f43-98b7-3912738d1af8', 'f4b1883e-5ace-44c4-aa36-1e81a84a737a', 11);
INSERT INTO `SYS_MENU` VALUES ('949b5f3c-de55-4a65-b867-d7cf02426d00', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '95619049-1c97-4edd-876c-49e4aafa2192', 13);
INSERT INTO `SYS_MENU` VALUES ('96086d6a-d946-47e3-8ca6-4baffcdf8234', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '406fa1aa-d840-4eaf-a86b-4055c3f41ca5', 5);
INSERT INTO `SYS_MENU` VALUES ('963895fc-4022-404e-9223-6d191e7be24d', 'df6ce431-121a-4f43-98b7-3912738d1af8', '4309441b-c6c2-4201-80ac-217e2282781d', 8);
INSERT INTO `SYS_MENU` VALUES ('964229f8-7a97-4e09-a0fe-ba0c14ebfe04', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'b28713ba-d67a-42cc-8f0d-68f07b5027ce', 21);
INSERT INTO `SYS_MENU` VALUES ('970cbebc-4847-4991-8ff8-a59152cf3137', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '56dd8a50-fa10-434f-a7e8-0a7f941a8184', 12);
INSERT INTO `SYS_MENU` VALUES ('98399ade-5ad8-45f4-8d3d-83522b6d61dd', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '48ef7f9d-ebd8-492e-838e-0a5666eeab8f', 18);
INSERT INTO `SYS_MENU` VALUES ('98da13d3-2f72-45e4-8285-324b1fa30874', 'df6ce431-121a-4f43-98b7-3912738d1af8', '24c5d2ee-f72d-422c-a77e-bc0e8f0ff84a', 2);
INSERT INTO `SYS_MENU` VALUES ('9a9c7b72-ac5b-4946-a404-4dea1be3a89a', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'b506e536-6018-4961-9f8a-3217b884311e', 7);
INSERT INTO `SYS_MENU` VALUES ('9aa222ba-058e-4415-b2a0-e75cffbe4517', 'ROOT', 'a982693b-1f56-4b9c-902b-c3630ab414b5', 13);
INSERT INTO `SYS_MENU` VALUES ('9ac368e5-2203-44af-8084-b87e8cacc789', 'df6ce431-121a-4f43-98b7-3912738d1af8', '93ec49f2-3bf9-421f-a048-185c5277e5e2', 6);
INSERT INTO `SYS_MENU` VALUES ('9bacbda6-c322-4f53-b0da-921c0e48345a', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', '2626df9d-f4fd-47e2-abab-0310a3f66ae8', 0);
INSERT INTO `SYS_MENU` VALUES ('9c515276-ea96-49b7-ad30-c0f25b9d15fd', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '190a6e35-6b85-49c8-a872-bdedafdea2ea', 1);
INSERT INTO `SYS_MENU` VALUES ('9f75e93f-eec9-42da-9d83-f9cf50852453', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'd4401143-b4ad-4d2c-8049-73213498d072', 5);
INSERT INTO `SYS_MENU` VALUES ('a30ab70b-a8c5-45a2-b770-01b7db631ba1', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '64049781-601d-422b-9d42-a0f79eae8188', 4);
INSERT INTO `SYS_MENU` VALUES ('a3ae2b52-82c8-490b-959d-28ae0843466d', '1acf1949-c336-47fa-9bef-dadbea0b3af2', 'ca0ada8f-4bf3-4a93-b115-45f6e15c4ae0', 1);
INSERT INTO `SYS_MENU` VALUES ('a8a72765-74ec-4a8b-b711-502230bc9bd6', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', '07d2bcc6-a3c4-45ca-b4b4-2078696b2f3a', 3);
INSERT INTO `SYS_MENU` VALUES ('a9d4f25d-8164-4dc7-8cec-9db8f80ee97c', '68dd6201-db86-4f1d-9adb-0c3d08af7739', 'c211ee27-5ce7-4303-86ee-601b4c912bbb', 0);
INSERT INTO `SYS_MENU` VALUES ('aa6ddb9f-ed32-4dda-8846-057c9fe73136', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', '7b01ae91-5e82-4c08-92a2-203732b70dd4', 6);
INSERT INTO `SYS_MENU` VALUES ('aa890bae-9426-4414-ac82-bacd709e4cd7', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '79927ee7-bc68-4ade-98f7-284f38f5eb6f', 10);
INSERT INTO `SYS_MENU` VALUES ('aab5463c-bf1c-4e82-a5bf-29d87a6f9207', '68dd6201-db86-4f1d-9adb-0c3d08af7739', '7ca1eeda-34a3-428b-bbaf-9030530fcfc6', 3);
INSERT INTO `SYS_MENU` VALUES ('abc486c0-b1eb-48ec-838a-022a3d3b8bcb', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '9fb6afe7-3ee6-44d9-94f0-11e29b6d92ee', 6);
INSERT INTO `SYS_MENU` VALUES ('aceb5b96-8e59-4191-a82e-b10d1284dd86', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', 'f55ff6de-5504-4cc4-9074-126ec4231358', 9);
INSERT INTO `SYS_MENU` VALUES ('ad7c5609-7e7a-4422-832a-047776490d1e', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '8652604e-d568-48d8-a2df-383303c975da', 8);
INSERT INTO `SYS_MENU` VALUES ('ae4c1e4f-b154-4a2e-8fbc-5f45d53dd8b3', '68dd6201-db86-4f1d-9adb-0c3d08af7739', 'a53f7913-2af4-4c52-bff1-178fa76722a7', 5);
INSERT INTO `SYS_MENU` VALUES ('af476d1c-2b26-415e-97c6-4e1705c3b0f3', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'd08d49ed-4433-4dc3-b883-ab2ce6bd858f', 10);
INSERT INTO `SYS_MENU` VALUES ('af7ee28f-6c5e-4f01-91e0-75b4125786a2', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'ff033e0e-7a9b-448d-b25f-066d0df2026d', 10);
INSERT INTO `SYS_MENU` VALUES ('b321feeb-df4b-4d65-a4ba-de3e743ccc2d', '68dd6201-db86-4f1d-9adb-0c3d08af7739', '1eda79de-2bd6-4989-ad58-5fdfc907939b', 6);
INSERT INTO `SYS_MENU` VALUES ('b45ec8ad-6d4b-4202-bd99-f2e7e8e1ed9a', 'a89695af-de9a-4fa7-a140-e12ca2e93499', '52e27306-9d31-499d-8bb7-3c60ce98cbdb', 1);
INSERT INTO `SYS_MENU` VALUES ('b9771fd2-0c55-448f-91f2-af653a620b7d', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'cd5e1e08-fa16-4eb3-b199-3d2b2bbee40a', 19);
INSERT INTO `SYS_MENU` VALUES ('ba080e13-c7de-411e-b89a-b0d9088b6908', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '63317294-fd49-4c7a-a04a-63d6001890b4', 14);
INSERT INTO `SYS_MENU` VALUES ('bb861741-83af-47e4-b8f6-cdb9be042479', 'ROOT', '68dd6201-db86-4f1d-9adb-0c3d08af7739', 8);
INSERT INTO `SYS_MENU` VALUES ('bec71f9d-8de8-40de-8619-2e2f10b53ec2', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '5a6294d6-a8bb-4a59-a781-b863e7376bb5', 17);
INSERT INTO `SYS_MENU` VALUES ('bffbff74-5c4c-428b-bd2f-de34d6ef7220', 'df6ce431-121a-4f43-98b7-3912738d1af8', 'a8213828-83d5-4fd6-a4b0-d61cea571fb5', 0);
INSERT INTO `SYS_MENU` VALUES ('c3d02c1a-e549-4392-814e-619d72770d67', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', '83b0fe5b-ead8-40c1-93ab-0e7c7ca1ee04', 0);
INSERT INTO `SYS_MENU` VALUES ('c53254a9-d48c-4f43-8d20-bd79c3d10516', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '0455efb7-123b-4290-afe9-59aade46844d', 8);
INSERT INTO `SYS_MENU` VALUES ('c534d88e-96f8-4531-93af-b437fc8c3883', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', '5de94366-170f-4c2f-b5fa-e2b2fbb5824c', 5);
INSERT INTO `SYS_MENU` VALUES ('c5ed1d75-c32c-4489-ac1f-3a86fff0e994', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '191e48f9-5c7a-463f-a96d-127f0235a596', 11);
INSERT INTO `SYS_MENU` VALUES ('c66f1faf-f819-42ed-9f1b-8006dd99ebf4', 'ce8b4d2f-b05c-42b9-8d28-4bb2a4ab3f62', 'a29f0237-72a8-449e-af68-397328f8b54c', 1);
INSERT INTO `SYS_MENU` VALUES ('c8befaac-dc7e-4e3e-bf68-916e2c427542', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 'c8e147f7-4a2a-40d3-8625-508e274e2a99', 12);
INSERT INTO `SYS_MENU` VALUES ('ca3de734-5da4-409a-9af2-1c5fba59d37b', 'ROOT', '1acf1949-c336-47fa-9bef-dadbea0b3af2', 2);
INSERT INTO `SYS_MENU` VALUES ('cb287ecc-4b88-4835-8215-ac8abbc8d1b9', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '9371a7a4-fc53-4ada-97ec-5bfa2b18a1ce', 2);
INSERT INTO `SYS_MENU` VALUES ('cc3ff779-730e-4dbc-acf8-662b2372873a', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '2fee1a4c-493e-4ad2-89fc-c54feff0e891', 7);
INSERT INTO `SYS_MENU` VALUES ('d065ad1c-8efe-4c24-b834-23f1e56342f8', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'a1b661d3-cccd-433d-ab39-495b79b91a5a', 29);
INSERT INTO `SYS_MENU` VALUES ('d1365249-45bf-4c69-8e8f-b7f70dbee479', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', '7bb40d4b-3474-4f17-89db-6186bf49092d', 10);
INSERT INTO `SYS_MENU` VALUES ('d2c0295a-bdb1-4944-8aef-f702b85cba0a', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '8c5f9dc2-5305-4993-8645-e85cde1eb683', 8);
INSERT INTO `SYS_MENU` VALUES ('d388afbc-220b-4a51-a64f-e69ec55fcd0f', 'a982693b-1f56-4b9c-902b-c3630ab414b5', 'fa34461a-df2f-45f7-b269-c05daef14bb1', 9);
INSERT INTO `SYS_MENU` VALUES ('d446f2c6-e9e4-412b-b5f3-be28d0f41953', 'ROOT', 'df6ce431-121a-4f43-98b7-3912738d1af8', 0);
INSERT INTO `SYS_MENU` VALUES ('d61e22e1-f975-4b7e-9502-fb603aa36888', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', 'a6d1b9de-aa60-4877-bc62-3beaf32e75a7', 6);
INSERT INTO `SYS_MENU` VALUES ('d7afbc7a-c3b2-4bb8-8fa4-d22d7d28994b', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '701b9f24-70ef-4f70-8988-0845a113e5a0', 14);
INSERT INTO `SYS_MENU` VALUES ('d81b62cb-a38e-4839-8e50-48775672c1f9', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '9eca489d-d25b-47bd-9589-10ed1bfe8ec4', 1);
INSERT INTO `SYS_MENU` VALUES ('da635e8a-af15-44d6-9bae-b15477dd91d2', 'f77824d4-d1a1-4290-b27f-b2c93db00090', 'c7544083-879f-4603-9c45-50b4a2f30712', 19);
INSERT INTO `SYS_MENU` VALUES ('dc76cccf-d2d7-4a78-ae36-147e00b7469e', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'ad184766-0003-4bc8-9441-de7ba3a9f1b7', 24);
INSERT INTO `SYS_MENU` VALUES ('debc4205-9c4a-49c8-945b-7788dc1feffc', '168d0a00-848e-4d75-bcd2-7beb06fae5c8', '0fe3b5ce-a5c2-42b3-91bc-53b15fb296fe', 3);
INSERT INTO `SYS_MENU` VALUES ('df382da2-860c-4d38-8b57-f476d3745b7c', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'bda77bd3-473f-495d-9824-c385a17f282f', 3);
INSERT INTO `SYS_MENU` VALUES ('df48d8ef-2265-4035-bda6-d8999a42d8e6', 'adb4d975-9d79-46a8-be79-4dbd4194bffc', '6298380a-e18b-4044-aad3-3828e448245a', 4);
INSERT INTO `SYS_MENU` VALUES ('df7339c3-400c-4556-b013-644f142cbcec', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '2b446496-0e35-4424-bd03-0f40317bdb80', 31);
INSERT INTO `SYS_MENU` VALUES ('e0425f5c-843a-4c10-9f07-9f9af432d6de', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', '008342aa-bc6d-4253-b917-28a3443bd3cd', 1);
INSERT INTO `SYS_MENU` VALUES ('e0fad595-4be6-439b-8cf4-c96b856546f7', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '91d2da7d-c527-4785-8b35-043fc38e09f3', 0);
INSERT INTO `SYS_MENU` VALUES ('e101bd5b-103a-4733-93ec-1de2a2ac5103', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '7b36be2b-686d-44b3-92a9-2416731b1348', 27);
INSERT INTO `SYS_MENU` VALUES ('e25da7e0-ad45-48f6-a10a-8186434abb96', 'df6ce431-121a-4f43-98b7-3912738d1af8', '5056a27e-263e-4134-933c-26d1fb05d704', 3);
INSERT INTO `SYS_MENU` VALUES ('e2ab81db-7d28-4dd9-8f6d-f2cdb27582cb', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'f135c86d-9962-47c0-ae6e-dd5ee5351112', 6);
INSERT INTO `SYS_MENU` VALUES ('e2dccdd0-2ab4-465b-9e90-5c36bf4516a7', 'ROOT', '152195a8-f83d-48e5-94bc-bdc04d2f8e26', 14);
INSERT INTO `SYS_MENU` VALUES ('e420e110-a5bc-44f5-8d6c-9134a6ff9204', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '2e04a8c6-53ea-4e83-acca-fdb425022c26', 17);
INSERT INTO `SYS_MENU` VALUES ('ecb720ca-fcf2-4eb5-81b6-65afdda85a05', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', '54666a06-27b6-43a8-bbd2-709713a90e72', 8);
INSERT INTO `SYS_MENU` VALUES ('ee4d2f47-9a70-417d-b327-96c1dbf55b12', '67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', 'f1638285-3e24-4168-8e86-26e7191de254', 2);
INSERT INTO `SYS_MENU` VALUES ('efd178af-e077-4724-a665-1c04eb84eeac', '8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', '09e5d50b-9645-4e80-8841-73c75cc4200a', 8);
INSERT INTO `SYS_MENU` VALUES ('f04c975a-6b25-494d-9624-c4615ffbc78e', '0b8dde03-cf52-437a-b9e5-78126c5557aa', '14a19e75-5e21-4339-9874-92123b556527', 3);
INSERT INTO `SYS_MENU` VALUES ('f0dbce46-34de-4538-ba23-e7ffc35b8f58', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '305235f7-b510-415a-823c-d884bb89913b', 0);
INSERT INTO `SYS_MENU` VALUES ('f1f0980c-0fa2-4058-9ab8-420eca9201fd', 'f77824d4-d1a1-4290-b27f-b2c93db00090', '9a5a26b5-c714-4028-906b-d2f6bdad72a3', 14);
INSERT INTO `SYS_MENU` VALUES ('f247a465-0038-43d9-b486-080ceeefeca9', 'a982693b-1f56-4b9c-902b-c3630ab414b5', '49aa2dfe-4444-45ef-93d5-c5fe3b4ba5df', 3);
INSERT INTO `SYS_MENU` VALUES ('f713db79-f466-4e35-ac80-140bae0d8c0f', '1acf1949-c336-47fa-9bef-dadbea0b3af2', 'ad999379-de61-4187-90fd-3a5295e75483', 12);
INSERT INTO `SYS_MENU` VALUES ('f7313fe2-35dc-4a39-ac97-a3c037b7118e', '1acf1949-c336-47fa-9bef-dadbea0b3af2', '301bc9c2-a77b-4aef-a5b1-6a1ff6348b3a', 2);
INSERT INTO `SYS_MENU` VALUES ('f7a69945-c4a4-42ea-aafa-d461e0250ced', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', '11b423eb-4222-48ed-aed6-12e54ab4cb56', 32);
INSERT INTO `SYS_MENU` VALUES ('f86b786c-b965-4086-ab23-fd9fc644c581', '5c2917e7-6766-4bc0-802d-dd3abc2ee0df', '3e9d2031-8c7f-4c88-a67f-5ba432203aea', 8);
INSERT INTO `SYS_MENU` VALUES ('f9b4f0ce-60ca-4aa2-9931-5ac8abf71c39', '68dd6201-db86-4f1d-9adb-0c3d08af7739', '84082695-01ff-466d-97be-3d32b778c508', 1);
INSERT INTO `SYS_MENU` VALUES ('fa3fe9fc-d9fd-4168-a95d-bd47a9f0c057', 'f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'aea084f4-8879-4a58-bc4f-abf64162d759', 30);
INSERT INTO `SYS_MENU` VALUES ('feeb0101-1c60-40e2-a788-7f9a5d13ad56', '0b8dde03-cf52-437a-b9e5-78126c5557aa', '6be3e9d0-9750-4819-b6f7-d8111d6bbeb2', 2);
INSERT INTO `SYS_MENU` VALUES ('ffa41b10-cd7c-4501-a6bf-7c455e534ad4', 'a982693b-1f56-4b9c-902b-c3630ab414b5', 'a5e6d4d2-81d8-4610-bfcf-1dfc81ba8398', 6);

-- ----------------------------
-- Table structure for SYS_MODULE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MODULE`;
CREATE TABLE `SYS_MODULE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `MODULE_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模块类型',
  `RF_ACTIVE` bit(1) NOT NULL COMMENT '是否移动端',
  `DK_ACTIVE` bit(1) NOT NULL COMMENT '是否PC端',
  `FORM_PATH` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块路径',
  `REPORT_FILENAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '报表名称',
  `REPORT_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '报表类型',
  `PRINT_PREVIEW` bit(1) NOT NULL COMMENT '是否打印预览',
  `PRINT_DIALOG` bit(1) NOT NULL COMMENT '打印窗口',
  `PRINT_COPIES` int(11) NOT NULL COMMENT '打印数量',
  `RESOURCE_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '多语言资源',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `MODULE_NAME_UK`(`NAME`) USING BTREE,
  INDEX `MODULE_TYPE_IX`(`MODULE_TYPE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '模块' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MODULE
-- ----------------------------
INSERT INTO `SYS_MODULE` VALUES ('003f3eec-170a-4bc8-adf5-567d37de6b51', 'MASTER_OUTBOUND_REBATCH_STATION', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBATCH_STATION', '2017-11-24 23:35:25', 'mengmengsun', '2017-11-24 23:35:25', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0066c927-7a80-4847-b41f-9b80df1f1672', 'REPORT_FUD', 'FUD', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'FUD', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('008342aa-bc6d-4253-b917-28a3443bd3cd', 'OUTBOUND_PROBLEM_VERIFY', 'OB问题核实', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OUTBOUND_PROBLEM_VERIFY', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0410aa59-2c59-4c97-a28d-c43caa53073f', 'transferStockIn', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 2, 'transferStockIn', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0455efb7-123b-4290-afe9-59aade46844d', 'MASTER_ZONE', '区域', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ZONE', '2017-11-24 23:39:33', 'mengmengsun', '2017-11-24 23:39:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('050b771d-27f1-42f1-8c93-c11469db00cd', 'TOT_CLOCKDETAIL', '打卡详情', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_CLOCKDETAIL', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('068be016-92e7-4b3b-900c-f71fc9e61767', 'MASTER_OUTBOUND_PICK_PACK_CELL', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_PACK_CELL', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0702b987-7fe9-4ea8-b6f3-591ad65c733b', 'INBOUND_RECEIVING', '收货', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVING', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('07d2bcc6-a3c4-45ca-b4b4-2078696b2f3a', 'OUTBOUND_PROBLEM_OBP_STATION', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OBP_STATION', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('09e5d50b-9645-4e80-8841-73c75cc4200a', 'OUTBOUND_REBIN_PACK', 'rebin包装', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBIN_PACK', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0a90efad-8e04-465a-9fdc-70a6d9d9cbd2', 'MASTER_OUTBOUND_REBIN_WALL', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBIN_WALL', '2017-12-02 00:16:29', 'mengmengsun', '2017-12-02 00:16:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0b8dde03-cf52-437a-b9e5-78126c5557aa', 'REPORT', '报表', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REPORT', '2017-11-24 23:39:35', 'mengmengsun', '2017-11-24 23:39:35', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0c1cd64f-bbd5-49aa-be7d-f3ba8581fc7e', 'ICQA_CALLPOD', 'ICQA_CALLPOD', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CALLPOD', '2018-03-28 19:21:49', 'gaofenghe', '2018-03-28 19:21:49', 'gaofenghe', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0cf0f907-a1b8-472a-9c20-cc305e56e871', 'INBOUND_CALL_POD', '呼叫货架', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CALL_POD', '2019-09-16 17:49:26', 'hanlei', '2019-09-16 17:49:26', 'hanlei', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('0fe3b5ce-a5c2-42b3-91bc-53b15fb296fe', 'INBOUND_STOW', '上架', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOW', '2017-11-24 23:36:33', 'mengmengsun', '2017-11-24 23:36:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1028b088-c7a6-48ff-8ed5-493f97588670', 'OUTBOUND_CUSTOMER_TIME', '优先级', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CUSTOMER_TIME', '2018-02-11 01:36:48', 'xiaofanyang', '2018-02-11 01:36:48', 'xiaofanyang', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('11b423eb-4222-48ed-aed6-12e54ab4cb56', 'MASTER_OUTBOUND_DELIVERY_TIME', '发货时间', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'DELIVERY_TIME', '2017-12-02 00:41:24', 'mengmengsun', '2017-12-02 00:41:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('13b57d81-c9db-4ba0-afe9-df858612ea04', 'SYSTEM_ROLE', '角色', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ROLE', '2017-12-02 00:17:26', 'mengmengsun', '2017-12-02 00:17:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('14a19e75-5e21-4339-9874-92123b556527', 'STOCKUNIT_NEW_CHECK', '货位库存详情', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOCKUNIT_NEW_CHECK', '2019-08-07 18:20:46', 'weipengxiang', '2019-08-07 18:20:46', 'weipengxiang', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('152195a8-f83d-48e5-94bc-bdc04d2f8e26', 'PROBLEM_SOLVING', '问题处理', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PROBLEM_SOLVING', '2018-11-08 17:18:54', 'xiongxiaoning', '2018-11-08 17:18:54', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('15634f04-210d-44c5-b17b-04451bae114f', 'ICQA_PENDINGADJUST', '盘亏盘盈等待处理', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA_PENDINGADJUST', '2017-12-02 00:16:29', 'mengmengsun', '2017-12-02 00:16:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('168d0a00-848e-4d75-bcd2-7beb06fae5c8', 'INBOUND', '入库菜单栏', 'MENU', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INBOUND', '2017-12-02 00:14:47', 'mengmengsun', '2018-03-19 04:56:47', 'admin', NULL, 0, 2);
INSERT INTO `SYS_MODULE` VALUES ('16bd71f8-1833-4c52-b475-48b0053e0d3d', 'MASTER_ROBOT_BATTER_CONFIG', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BATTER_CONFIG', '2017-11-24 23:39:28', 'mengmengsun', '2017-11-24 23:39:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('17ee7b73-9c1e-426a-b714-e9dd8d7f4908', 'Collate', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'COLLATE', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1866d724-f7d5-46cd-bc60-4c6b52b23f71', 'REPORT_TOTSTATISTICS', '员工考核', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REPORT_TOTSTATISTICS', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('190a6e35-6b85-49c8-a872-bdedafdea2ea', 'OUTBOUND_UNPICKMENU', '未拣拣货单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'0', b'0', 1, 'UNPICKMENU', '2018-03-28 03:53:59', 'yunyiliu', '2018-03-28 03:53:59', 'yunyiliu', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('191e48f9-5c7a-463f-a96d-127f0235a596', 'MASTER_OUTBOUND_REBIN_WALL_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBIN_WALL_TYPE', '2017-11-24 23:40:01', 'mengmengsun', '2017-11-24 23:40:01', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('19701011-eec5-46fc-b3fa-2ae0e103b55c', 'MASTER_OUTBOUND_REBATCH_STATION_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBATCH_STATION_TYPE', '2017-12-02 00:17:55', 'mengmengsun', '2017-12-02 00:17:55', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1acf1949-c336-47fa-9bef-dadbea0b3af2', 'MASTER_INBOUND', 'IB基础菜单栏', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MASTER_INBOUND', '2017-11-24 23:39:33', 'mengmengsun', '2017-11-24 23:39:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1b1f4a76-e27a-47d0-8107-6fd004374f30', 'INTERNAL_TOOL_ROBOT_LAVEBATTERY', '小车电量', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ROBOT_LAVEBATTERY', '2018-05-10 02:25:46', 'admin', '2018-05-10 02:25:46', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1b7510f3-3cb5-4e1d-b5ea-7ad2a297b2f6', 'Live Picker', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'LIVE_PICKER', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1bb1b8df-9c90-4dc4-ab9a-492f77d1d1e4', 'MASTER_INBOUND_RECEIVE_ELIGIBILITY', '收货权限', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVE_ELIGIBILITY', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1cb31f78-d9cd-4522-8b8c-71a3dd37c197', 'LOT_MANAGER', '有效期管理', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'LOT_MANAGER', '2017-12-02 00:42:48', 'mengmengsun', '2017-12-02 00:42:48', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1e0f438f-2eb1-43cf-b4e4-f652331cd759', 'WEIGH', '称重', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'IF_WEIGHT', '2019-07-04 16:38:06', 'xiongxiaoning', '2019-07-04 16:44:15', 'xiongxiaoning', NULL, 0, 2);
INSERT INTO `SYS_MODULE` VALUES ('1e7b70bf-fa6f-4d89-9e08-9d20f7789dda', 'MASTER_OUTBOUND_PACKING_STATION', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PACKING_STATION', '2017-11-24 23:39:28', 'mengmengsun', '2017-11-24 23:39:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1ea539fd-a416-42e6-9e99-73acca72b0d2', 'REPORT_PICK_QUERY', 'pick查询', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_QUERY', '2017-11-24 23:35:26', 'mengmengsun', '2017-11-24 23:35:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1eda79de-2bd6-4989-ad58-5fdfc907939b', 'REPLENISH_SHIPMENT', '补货单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REPLENISH_SHIPMENT', '2019-09-25 14:14:37', 'zhaoboxing', '2019-09-25 14:14:37', 'zhaoboxing', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1eead127-7307-4ca0-a4d7-607fc77d1d1f', 'MASTER_ITEM_UNIT', '单位', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_UNIT', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('1fd62eab-bcf3-46de-8fde-c0cabdb6a488', 'MASTER_OUTBOUND_REBIN_CELL_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBIN_CELL_TYPE', '2017-12-02 00:27:43', 'mengmengsun', '2017-12-02 00:27:43', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('20c7b087-e916-464f-a976-35326457cf25', 'PROBLEM_SHIPMENT', '问题订单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PROBLEM_SHIPMENT', '2019-09-24 11:20:40', 'xiongxiaoning', '2019-09-24 11:20:40', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2447c23c-4f34-4b21-b3b2-22697b202b59', 'INBOUND_PROBLEM_IBP_STATION_TYPE', 'IB问题处理工作站类型', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'IBP_STATION_TYPE', '2017-12-02 23:31:27', 'mengmengsun', '2017-12-02 23:31:27', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('24c5d2ee-f72d-422c-a77e-bc0e8f0ff84a', 'SYSTEM_USERGROUP', '用户组', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'USERGROUP', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2626df9d-f4fd-47e2-abab-0310a3f66ae8', 'CHECK_POD', '查看pod状态', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CHECK_POD', '2018-11-08 17:19:21', 'xiongxiaoning', '2018-11-08 17:19:21', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('27607167-a2e6-488b-ad37-9521425942b0', 'MASTER_ITEM_DATA_GLOBAL', 'SKU Global', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_DATA_GLOBAL', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2928f06a-96fb-49d7-92f0-dfaedc643b6b', 'INTERNAL_TOOL_MOVE', '移货工具', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MOVE_TOOL', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2a5ffffa-5b65-4cca-a1d2-1ef4ebd2c3df', 'MASTER_OUTBOUND_SORTING_STATION_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SORTING_STATION_TYPE', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2b446496-0e35-4424-bd03-0f40317bdb80', 'MASTER_OUTBOUND_DIGITAL_LABEL', '电子标签', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'DIGITAL_LABEL', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2b9a9121-17c5-451d-8984-d0da27006356', 'INTERNAL_TOOL_TRIP_MANAGER', '调度单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TRIP_MANAGER', '2018-05-10 01:37:49', 'admin', '2018-05-10 01:37:49', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2bdc2bbf-13f2-44a2-a039-07be540b88d1', 'ICQA_STOCKTAKING_SYSTEM', '系统盘点', 'FORM', b'0', b'0', NULL, NULL, NULL, b'1', b'0', 1, 'STOCKTAKING_SYSTEM', '2017-11-24 23:39:59', 'mengmengsun', '2018-03-23 22:42:45', 'jupingli', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('2d562cdd-846c-48ff-bac0-c127aa5e0e66', 'OUTBOUND_REBIN', 'rebin', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RE_BIN', '2017-12-02 00:28:45', 'mengmengsun', '2017-12-02 00:28:45', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2e04a8c6-53ea-4e83-acca-fdb425022c26', 'MASTER_HARDWARE', '硬件', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'HARDWARE', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2e947524-6260-4761-afc8-116caccd7fc7', 'MASTER_SIZE_FILTER_RULE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SIZE_FILTER_RULE', '2017-11-24 23:35:25', 'mengmengsun', '2017-11-24 23:35:25', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('2fee1a4c-493e-4ad2-89fc-c54feff0e891', 'MASTER_INBOUND_STOW_ELIGIBILITY', '上架权限', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOW_ELIGIBILITY', '2017-12-02 00:15:47', 'mengmengsun', '2017-12-02 00:15:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('301bc9c2-a77b-4aef-a5b1-6a1ff6348b3a', 'MASTER_INBOUND_RECEIVE_STATION', '收货工作站', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVE_STATION', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('305235f7-b510-415a-823c-d884bb89913b', 'TOT_ATTENDANCE', '上下班打卡系统', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_ATTENDANCE', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('335d89ed-1e66-40c0-8ffc-3a2c959f3367', 'CONSOLIDATION_VIEW', '理货任务查看', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CONSOLIDATION_VIEW', '2018-12-25 09:50:42', 'admin', '2018-12-25 09:50:42', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('33c4481b-16c1-4582-940c-f38b034bb17a', 'schedule_robot', '小车调度单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'schedule_robot', '2017-11-24 23:35:20', 'mengmengsun', '2017-11-24 23:35:20', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3680f735-5254-4b85-a737-c27ff9dceb10', 'CONSOLIDATION_SETTING', '理货设置界面', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CONSOLIDATION_SETTING', '2018-12-25 07:20:04', 'admin', '2018-12-25 07:20:04', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3b3b1e74-42ef-4869-ad2e-1e3e66790c46', 'SYSTEM_MENU', '菜单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MENU', '2017-11-24 23:39:34', 'mengmengsun', '2017-11-24 23:39:34', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3bdfbef9-7bd2-4c70-946f-4b9b7589a3c9', 'MASTER_ROBOT_CHARGING_PILE', '充电桩', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CHARGING_PILE', '2017-11-24 23:35:30', 'mengmengsun', '2017-11-24 23:35:30', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3bebb678-b615-4d65-9459-7c1578e4e718', 'MASTER_INBOUND_ADVICE_REQUEST', '送货单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ADVICE_REQUEST', '2017-11-24 23:39:30', 'mengmengsun', '2017-11-24 23:39:30', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3c8294dc-0155-4249-8f87-07130067577f', 'OUTBOUND_QUERY_CART', '笼车查看', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'QUERY_CART', '2017-11-24 23:39:31', 'mengmengsun', '2017-11-24 23:39:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3d1cafc3-f816-4283-9979-4a0244cfeec1', 'MASTER_INBOUND_BOXCODE', '箱号查询', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BOXCODE', '2019-08-20 03:45:07', 'hanlei', '2019-08-20 03:45:07', 'hanlei', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3d607e20-f8dd-4186-8b68-e810b3b5abf8', 'REPLENISH_PICK', '补货拣货', 'FORM', b'1', b'0', NULL, NULL, NULL, b'0', b'0', 1, 'REPLENISH_PICK', '2019-06-03 11:21:07', 'tianshiyi', '2019-06-03 11:22:20', 'tianshiyi', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('3e05c6cf-04e0-4df3-aac2-917c662fc6aa', 'OUTBOUND_CUSTOMER_SHIPMENT', '订单拆分', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CUSTOMER_SHIPMENT', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('3e9d2031-8c7f-4c88-a67f-5ba432203aea', 'ICQA_SYSTEMSTOCKTAKING', 'SKU盘点', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA_SYSTEMSTOCKTAKING', '2017-11-24 23:39:59', 'mengmengsun', '2018-03-23 23:09:08', 'jupingli', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('3ebf2218-4512-4cff-bf53-92f4ce716d2a', 'MASTER_OUTBOUND_PICK_PACK_CELL_TYPE_BOX_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_PACK_CELL_TYPE_BOX_TYPE', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('406fa1aa-d840-4eaf-a86b-4055c3f41ca5', 'INTERNAL_TOOL_MEASURE', '测量工具', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MEASURE_TOOL', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('4309441b-c6c2-4201-80ac-217e2282781d', 'SYSTEM_USER_WAREHOUSE', '用户仓库', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'USER_WAREHOUSE', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('43264535-3661-41f7-97eb-0e615ae42626', 'ICQA_STOCKTAKING_STATION', '盘点工作站', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOCKTAKING_STATION', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('43b6e161-56ee-4730-b1b5-e80920378b9f', 'TOT_JOB', '间接工作', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_JOB', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('469a2852-0913-4135-baf0-3b561a6d694b', 'INBOUND_PROBLEM_IBP_STATION', 'IB问题处理工作站', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'IBP_STATION', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('46dd4e72-8371-47d7-b13b-ad516b923d6d', 'INTERNAL_TOOL_INPUT_VALIDITY_QUERY', '有效期录入查询', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INPUT_VALIDITY_QUERY', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('48ed545c-38f2-408e-b46a-a9c41cf4f67b', 'MASTER_POD', 'Pod', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'POD', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('48ef7f9d-ebd8-492e-838e-0a5666eeab8f', 'BATCH_REPORTDETAIL', '波次详查', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BATCH_REPORTDETAIL', '2019-08-27 11:41:04', 'xiongxiaoning', '2019-08-27 11:41:04', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('49aa2dfe-4444-45ef-93d5-c5fe3b4ba5df', 'REPORT_PPRSTATISTICS', 'ppr', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PPRSTATISTICS', '2017-11-24 23:35:25', 'mengmengsun', '2017-11-24 23:35:25', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('49f0a561-ba25-4953-b0bf-023dfeeee9d6', 'SYSTEM_RESOURCE', '资源', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RESOURCE', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('4b3617b1-a0e0-4a42-8b51-2fb7c6cd9970', 'MASTER_INBOUND_REPLENISH_STRATEGY', '补货策略', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REPLENISH_STRATEGY', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('4be29f18-603d-4128-9707-6e0de2c1b947', 'WEIGH_DETAIL', '重量记录', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'WEIGH_DETAIL', '2019-08-27 14:36:29', 'xiongxiaoning', '2019-08-27 14:36:29', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('4c25bcc4-9a19-48a8-8350-91e386fd536c', 'OUTBOUND_PROBLEM_OBP_CELL', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OBP_CELL', '2017-11-24 23:39:32', 'mengmengsun', '2017-11-24 23:39:32', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('4dd9e31d-3af5-4e56-9e26-3a8cf7f3856e', 'MASTER_WORKSTATION_TYPE', '工作站类型', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'WORKSTATION_TYPE', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('4e9c4ebf-a8ec-42ce-a7a2-9deb43b0174a', 'MASTER_ROBOT_ROBOT', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ROBOT', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('4fef1f0e-810d-44c6-9669-ec05644ba357', 'ITEM_DATA_EXCLUSION_POSITION', '商品分类信息', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_DATA_EXCLUSION_POSITION', '2019-07-04 11:05:40', 'songdan', '2019-07-04 11:05:40', 'songdan', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('5056a27e-263e-4134-933c-26d1fb05d704', 'SYSTEM_USER', '用户', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'USER', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('52e27306-9d31-499d-8bb7-3c60ce98cbdb', 'CONSOLIDATION', '任务创建', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CONSOLIDATION', '2018-12-25 11:48:53', 'xiongxiaoning', '2018-12-25 11:48:53', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('54666a06-27b6-43a8-bbd2-709713a90e72', 'OUTBOUND_PROBLEM_OBP_CELL_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OBP_CELL_TYPE', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('56dd8a50-fa10-434f-a7e8-0a7f941a8184', 'MASTER_AREA', '功能区', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'AREA', '2017-11-24 23:39:29', 'mengmengsun', '2017-11-24 23:39:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('581c1728-12fe-49f2-8e11-7588bde58117', 'HELI_INBOUND_STOW', '合力项目上架', 'MENU', b'0', b'1', 'main.heli_inbound_stow', NULL, NULL, b'1', b'0', 1, 'HELI_INBOUND_STOW', '2019-12-18 02:42:30', 'admin', '2019-12-18 02:42:30', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('59634d7c-15bf-4e1e-ad42-22ec78cbb1ff', 'MASTER_ROBOT', '小车', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MASTER_ROBOT', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('5a1527a8-9a38-4d6b-8427-20811221efce', 'HELI_ICQA_ICQATASK', '合力盘点任务', 'MENU', b'0', b'1', 'main.heli_icqa_icqatask', NULL, NULL, b'1', b'0', 1, 'HELI_ICQA_ICQATASK', '2019-12-18 02:46:08', 'admin', '2019-12-18 02:46:08', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('5a6294d6-a8bb-4a59-a781-b863e7376bb5', 'BATCH_REPORT', '波次报表', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BATCH_REPORT', '2019-08-22 09:18:14', 'xiongxiaoning', '2019-08-22 09:18:14', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('5c2917e7-6766-4bc0-802d-dd3abc2ee0df', 'ICQA', 'ICQA菜单栏', 'MENU', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA', '2017-12-02 00:41:23', 'mengmengsun', '2017-12-02 00:41:23', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('5c6936df-d88f-427e-8e77-27336e1f23ec', 'MASTER_OUTBOUND_REBIN_CELL', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBIN_CELL', '2017-12-02 00:27:43', 'mengmengsun', '2017-12-02 00:27:43', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('5c8cd376-f5dd-4f01-b873-0c2b5959143e', 'REPORT_CAPACITY', '容积率', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CAPACITY', '2017-11-24 23:35:24', 'mengmengsun', '2017-11-24 23:35:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('5de94366-170f-4c2f-b5fa-e2b2fbb5824c', 'OUTBOUND_PROBLEM_OBP_WALL', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OBP_WALL', '2017-11-24 23:39:35', 'mengmengsun', '2017-11-24 23:39:35', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('621632a2-fa88-43ca-ae08-6b54e6436be0', 'INTERNAL_TOOL_QUERY', '查询工具', 'FORM', b'1', b'0', NULL, NULL, NULL, b'1', b'0', 1, 'QUERY_TOOL', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('6298380a-e18b-4044-aad3-3828e448245a', 'INTERNAL_TOOL_INVENT_ADJUST', '库存调整工具', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INVENT_ADJUST_TOOL', '2017-11-24 23:40:02', 'mengmengsun', '2017-11-24 23:40:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('63317294-fd49-4c7a-a04a-63d6001890b4', 'OUTBOUND_CAMPARE_BOX', '推荐箱形比较', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CAMPARE_BOX', '2017-11-24 23:35:31', 'mengmengsun', '2017-11-24 23:35:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('64049781-601d-422b-9d42-a0f79eae8188', 'PPRDETAIL', 'PPRDETAIL', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PPRDETAIL', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('67f7817a-3f3b-4f48-8e4b-1c7a1191d83d', 'OUTBOUND_PROBLEM', 'OB问题', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OUTBOUND_PROBLEM', '2017-12-02 00:28:45', 'mengmengsun', '2017-12-02 00:28:45', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('68dd6201-db86-4f1d-9adb-0c3d08af7739', 'MASTER_REPLEN', '补货基础', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REPLEN', '2017-12-02 00:15:47', 'mengmengsun', '2017-12-02 00:15:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('6a564454-d5f8-4681-b92e-781766c5a3df', 'MASTER_SIZE_RULE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SIZE_RULE', '2017-11-24 23:35:24', 'mengmengsun', '2017-11-24 23:35:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('6ab3264b-6183-4154-97ff-39ff953e50b4', 'OUTBOUND_PICK', '拣货', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('6be3e9d0-9750-4819-b6f7-d8111d6bbeb2', 'REPORT_WORKFLOW', 'Workflow', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'WORKFLOW', '2017-11-24 23:39:30', 'mengmengsun', '2017-11-24 23:39:30', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('6fa904cb-ef11-411f-9e65-d528e789a6d2', 'HELI_INBOUND_RECEIPT', '合力项目入库单界面', 'MENU', b'0', b'1', 'main.heli_inbound_receipt', NULL, NULL, b'1', b'0', 1, 'HELI_INBOUND_RECEIPT', '2019-12-18 02:43:35', 'admin', '2019-12-18 02:43:35', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('6fa98f8b-53b9-4e15-91da-a6eff2d221b9', 'ICQA_STOCKTAKING_DAILY', '日常盘点', 'FORM', b'1', b'0', NULL, NULL, NULL, b'1', b'0', 1, 'STOCKTAKING_DAILY', '2017-12-02 00:14:47', 'mengmengsun', '2017-12-02 00:14:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('6fcc095a-2924-48ea-bddf-46dc46e18693', 'INBOUND_PROBLEM_DISPOSAL', 'IB问题处理', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INBOUND_PROBLEM_DISPOSAL', '2017-11-24 23:35:31', 'mengmengsun', '2017-11-24 23:35:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('701b9f24-70ef-4f70-8988-0845a113e5a0', 'MASTER_OUTBOUND_REBIN_STATION', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBIN_STATION', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('720559be-18b1-40b2-8a74-a5d4fe8f0a4b', 'TOT_JOBRECORDDETAIL', '工作详情', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_JOBRECORDDETAIL', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('79082e5e-df81-41ac-abe7-a39512042dd3', 'INTERNAL_TOOL_INPUT_VALIDITY', '有效期录入工具', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INPUT_VALIDITY_TOOL', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('79927ee7-bc68-4ade-98f7-284f38f5eb6f', 'TOT_JOBTHRESHOLD', '阈值配置页面', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_JOBTHRESHOLD', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7b01ae91-5e82-4c08-92a2-203732b70dd4', 'FINISH_TRIP_POSITION', '查看调度单明细', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'FINISH_TRIP_POSITION', '2018-11-08 17:22:34', 'xiongxiaoning', '2018-11-28 15:25:49', 'tumi.lv', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('7b36be2b-686d-44b3-92a9-2416731b1348', 'MASTER_OUTBOUND_PICKING_AREA', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICKING_AREA', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7bb40d4b-3474-4f17-89db-6186bf49092d', 'ICQA_ADJUSTMENT', '库存调整', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA_ADJUSTMENT', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7bd4e4d8-ef70-4a4c-96af-16d3ada13685', 'TOT_JOBRECORD', '间接工作打卡系统', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_JOBRECORD', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7c40fe97-fb4a-4b31-b73a-67dcd364a338', 'MASTER_OUTBOUND_PICK_STATION_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_STATION_TYPE', '2017-12-02 00:41:23', 'mengmengsun', '2017-12-02 00:41:23', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7ca1eeda-34a3-428b-bbaf-9030530fcfc6', 'MASTER_INBOUND_ITEM_DATA_TYPE_GRADE_STAT', '热销度状态', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_DATA_TYPE_GRADE_STAT', '2017-11-24 23:35:22', 'mengmengsun', '2017-11-24 23:35:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7eda7753-baa3-4dd5-928a-d633836f0cd2', 'MASTER_OUTBOUND_PICKING_AREA_ELIGIBILITY', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICKING_AREA_ELIGIBILITY', '2017-12-02 00:41:23', 'mengmengsun', '2017-12-02 00:41:23', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7f12c8d7-5e96-4c4f-ae7d-e9ec84ba1d63', 'MASTER_INBOUND_STOW_THRESHOLD', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOW_THRESHOLD', '2017-11-24 23:39:28', 'mengmengsun', '2017-11-24 23:39:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('7f422889-25fa-41d5-9868-30ceeb9b4907', 'MASTER_OUTBOUND_REBIN_STATION_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBIN_STATION_TYPE', '2017-12-02 00:17:26', 'mengmengsun', '2017-12-02 00:17:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('80e0d818-2a9d-4b7c-9ad6-194edbb3c683', 'ITEM_CATEGORY', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_CATEGORY', '2019-07-04 10:28:06', 'xiongxiaoning', '2019-07-04 10:28:06', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('82990f7a-d055-4c57-8b34-7cd964d4240f', 'HELI_INBOUND_RECEIPT_DETAILE', '合力项目入库单明细', 'MENU', b'0', b'1', 'main.heli_inbound_receipt_detaile', NULL, NULL, b'1', b'0', 1, 'HELI_INBOUND_RECEIPT_DETAILE', '2019-12-18 02:44:24', 'admin', '2019-12-18 02:44:24', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('8389c04b-0197-450b-b5a0-b3a359620975', 'MASTER_INBOUND_RECEIVE_CATEGORY', '过滤规则', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVE_CATEGORY', '2017-12-02 00:15:47', 'mengmengsun', '2017-12-02 00:15:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('83b0fe5b-ead8-40c1-93ab-0e7c7ca1ee04', 'OUTBOUND_PROBLEM_DISPOSAL', 'OB问题处理', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OUTBOUND_PROBLEM_DISPOSAL', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('84082695-01ff-466d-97be-3d32b778c508', 'MASTER_SABC_RULE', '热销度', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SABC_RULE', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('8516dacf-42b0-4f8d-8eb6-77b173085195', 'INTERNAL_TOOL_CONTAINER', '容器查询', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CONTAINER_TOOL', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('858e24e4-3c47-4c27-920d-94d097dbab14', 'SYSTEM_SYSTEM_PROPERTY', '系统属性', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SYSTEM_PROPERTY', '2017-12-02 00:14:47', 'mengmengsun', '2017-12-02 00:14:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('8601c443-aaee-4046-a85f-cbf034f71d1c', 'MASTER_STORAGE_LOCATION_TYPE', '容器类型', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STORAGE_LOCATION_TYPE', '2017-12-02 00:14:04', 'mengmengsun', '2017-12-02 00:14:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('86169f68-185f-4a26-8ab7-59b5f9009229', 'MASTER_INBOUND_INVENTORY_ANALYSIS', '库存数据分析', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INVENTORY_ANALYSIS', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('8652604e-d568-48d8-a2df-383303c975da', 'TOT_DIRECTJOB', '直接工作', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_DIRECTJOB', '2017-12-02 00:14:04', 'mengmengsun', '2017-12-02 00:14:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('88d89766-e0ea-4d2e-8a37-5f8705d161d6', 'ICQA_AllSTOCKTAKING', '系统盘点', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA_AllSTOCKTAKING', '2018-01-30 00:24:12', 'jupingli', '2018-03-23 22:41:23', 'jupingli', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('8bdf8fb7-2057-4f11-9664-7331ca7fb8eb', 'OUTBOUND', '出库', 'MENU', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OUTBOUND', '2017-12-02 00:16:29', 'mengmengsun', '2018-03-19 04:57:50', 'admin', NULL, 0, 2);
INSERT INTO `SYS_MODULE` VALUES ('8c5f9dc2-5305-4993-8645-e85cde1eb683', 'INTERNAL_TOOL_MEASURE_QUERY', '测量工具查询', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MEASURE_QUERY', '2017-12-02 00:16:29', 'mengmengsun', '2017-12-02 00:16:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('8e78a416-bcb1-4ccb-940b-c29e88938a1e', 'MASTER_OUTBOUND_SORTING_AREA', '集货区域', 'FORM', b'0', b'1', NULL, NULL, NULL, b'0', b'0', 1, 'SORTING_AREA', '2019-07-03 11:15:33', 'jiangshikun', '2019-07-03 11:15:33', 'jiangshikun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('909c7840-c39b-48a5-beb6-3e2a7f8517bf', 'OUTBOUND_ZONE_BATCH', 'zone batch', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ZONE_BATCH', '2017-12-02 00:17:55', 'mengmengsun', '2017-12-02 00:17:55', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('91d2da7d-c527-4785-8b35-043fc38e09f3', 'MASTER_ITEM_DATA', 'SKU', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_DATA', '2017-12-02 23:32:07', 'mengmengsun', '2017-12-02 23:32:07', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('91e388d9-a28e-4dc3-85c9-072df8a000b0', 'transferStockInAdd', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 3, 'transferStockInAdd', '2017-11-24 23:35:24', 'mengmengsun', '2017-11-24 23:35:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('92a84dd5-acd3-4c03-b139-e12aeac7cd59', 'MASTER_WAREHOUSE', NULL, 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MASTER_WAREHOUSE', '2017-12-02 00:14:47', 'mengmengsun', '2017-12-02 00:14:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9371a7a4-fc53-4ada-97ec-5bfa2b18a1ce', 'MASTER_OUTBOUND_PROCESS_PATH', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PROCESS_PATH', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('93ec49f2-3bf9-421f-a048-185c5277e5e2', 'SYSTEM_WAREHOUSE_CLIENT', '仓库客户', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'WAREHOUSE_CLIENT', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('94cab3a6-3eb2-468c-93e5-91cb17af1315', 'MASTER_OUTBOUND_PICK_STATION', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_STATION', '2017-11-24 23:39:29', 'mengmengsun', '2017-11-24 23:39:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9551a8f7-0efb-4a0c-a069-4d21f5f5688d', 'MASTER_INBOUND_RECEIVE_DESTINATION', '目的地', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVE_DESTINATION', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('95619049-1c97-4edd-876c-49e4aafa2192', 'MASTER_DROP_ZONE', '上架区', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'DROP_ZONE', '2017-11-24 23:36:33', 'mengmengsun', '2017-11-24 23:36:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9769681c-1a6a-462b-9ccd-9edc4241a595', 'MASTER_WAREHOUSE_MAP', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MAP', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('979a1933-a17f-4eb3-8e57-4d4391d4ef46', 'ICQA_SKU_CREATE', 'SKU盘点创建', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA_SKUCREATE', '2017-11-24 23:35:22', 'mengmengsun', '2017-11-24 23:35:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('99bf089b-65c3-4c40-9a6c-f58bee581a8a', 'INBOUND_PALLET_STOW', '托盘上架', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PALLET_STOW', '2019-09-16 17:50:18', 'hanlei', '2019-09-16 17:50:18', 'hanlei', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9a5a26b5-c714-4028-906b-d2f6bdad72a3', 'MASTER_SEMBLENCE', '商品相似度设置', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SEMBLENCE', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9bb751a8-ae25-4355-9848-66d71aa2ea06', 'UPDATE_POD', '修改数据库pod状态', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'UPDATE_POD', '2018-11-08 17:19:53', 'xiongxiaoning', '2018-11-08 17:19:53', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9bc809f8-b24f-4249-8ff9-a41e9c20cbd0', 'SHIPMENT_ORDER_POSITION', '查看某个订单的明细', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SHIPMENT_ORDER_POSITION', '2018-11-08 17:21:45', 'xiongxiaoning', '2018-11-08 17:21:45', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9e2c1b41-a898-4349-907b-b52e4f10fa9d', 'TOT_JOBCATEGORY', '间接项目', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_JOBCATEGORY', '2017-12-02 00:14:04', 'mengmengsun', '2017-12-02 00:14:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9e665ab3-1af6-4428-a7e4-7d692087768a', 'transferStockOut', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 5, 'transferStockOut', '2017-12-02 00:17:26', 'mengmengsun', '2017-12-02 00:17:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9eca489d-d25b-47bd-9589-10ed1bfe8ec4', 'MASTER_OUTBOUND_BOX_TYPE', '箱型', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BOX_TYPE', '2017-12-02 00:17:55', 'mengmengsun', '2017-12-02 00:17:55', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9f1fee50-92a2-4c80-b1d3-5b62c588ab31', 'transferStockInDifference', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 4, 'transferStockInDifference', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('9fb6afe7-3ee6-44d9-94f0-11e29b6d92ee', 'MASTER_WORKSTATION', '工作站', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'WORKSTATION', '2017-12-02 00:14:04', 'mengmengsun', '2017-12-02 00:14:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a12815ee-b96a-46b7-86c9-440efba194b7', 'TOT_JRD', '详情', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_JRD', '2017-11-24 23:39:32', 'mengmengsun', '2017-11-24 23:39:32', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a1b661d3-cccd-433d-ab39-495b79b91a5a', 'MASTER_OUTBOUND_LABEL_CONTROLLER', '电子标签控制器', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'LABEL_CONTROLLER', '2017-11-24 23:39:34', 'mengmengsun', '2017-11-24 23:39:34', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a29f0237-72a8-449e-af68-397328f8b54c', 'INBOUND_PROBLEM_MANAGE', 'IB问题管理', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INBOUND_PROBLEM_MANAGE', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a53f7913-2af4-4c52-bff1-178fa76722a7', 'INVENTORY_ANALYSIS_LL', '良良库存分析', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INVENTORY_ANALYSIS_LL', '2019-09-23 10:04:20', 'xiongxiaoning', '2019-09-23 10:04:20', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a5e6d4d2-81d8-4610-bfcf-1dfc81ba8398', 'TOT_DIRECTJOBCATEGORY', '直接项目', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_DIRECTJOBCATEGORY', '2017-12-02 00:41:46', 'mengmengsun', '2017-12-02 00:41:46', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a63298ba-7098-413a-95e1-69c143800fcf', 'SHIPMENT_ORDER', '未拣订单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SHIPMENT_ORDER', '2018-11-08 17:21:04', 'xiongxiaoning', '2018-11-28 15:30:54', 'tumi.lv', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('a6d1b9de-aa60-4877-bc62-3beaf32e75a7', 'OUTBOUND_PROBLEM_OBP_WALL_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OBP_WALL_TYPE', '2017-12-02 00:14:47', 'mengmengsun', '2017-12-02 00:14:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a6ed995b-9c8c-480b-8275-496b68ebae2d', 'PPRPLANCONFIG', 'PPRPLANCONFIG', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PPRPLANCONFIG', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a8213828-83d5-4fd6-a4b0-d61cea571fb5', 'SYSTEM_WAREHOUSE', '仓库', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'WAREHOUSE', '2017-11-24 23:39:34', 'mengmengsun', '2017-11-24 23:39:34', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a89695af-de9a-4fa7-a140-e12ca2e93499', 'CONSOLIDATION_MANAGE', '理货管理', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CONSOLIDATION_MANAGE', '2018-12-25 01:25:04', 'admin', '2018-12-25 01:25:04', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a982693b-1f56-4b9c-902b-c3630ab414b5', 'TOT', NULL, 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 11, 'TOT', '2017-11-24 23:39:31', 'mengmengsun', '2017-11-24 23:39:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('a9f9912b-9ae5-4c66-8daf-0a88e5585e2b', 'OUTBOUND_ZONE_PROCESS_PATH', 'zone process path', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ZONE_PROCESS_PATH', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('abb8665d-1021-47a8-bd67-fd703814f9f8', 'TOT_STATISTICS', '员工考核', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_STATISTICS', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('acf36287-f155-4e9d-922c-141fd089e9d5', 'MASTER_INBOUND_STOW_STATION_TYPE', '上架工作站类型', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOW_STATION_TYPE', '2017-11-24 23:39:28', 'mengmengsun', '2017-11-24 23:39:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ad184766-0003-4bc8-9441-de7ba3a9f1b7', 'MASTER_OUTBOUND_PICK_PACK_CELL_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_PACK_CELL_TYPE', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ad663103-3313-4e57-b8c2-f830a616345b', 'SYSTEM_MODULE', '模块', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MODULE', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ad999379-de61-4187-90fd-3a5295e75483', 'MASTER_INBOUND_RECEIVE_CATEGORY_RULE', '规则', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVE_CATEGORY_RULE', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('adb4d975-9d79-46a8-be79-4dbd4194bffc', 'INTERNAL_TOOL', '工具', 'MENU', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INTERNAL_TOOL', '2017-12-02 00:14:47', 'mengmengsun', '2018-03-19 04:58:51', 'admin', NULL, 0, 2);
INSERT INTO `SYS_MODULE` VALUES ('ade442ae-7763-410e-8917-1168e3f83c35', 'SYSTEM_SELECTION', '数据字典', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SELECTION', '2017-11-24 23:40:02', 'mengmengsun', '2017-11-24 23:40:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('aea084f4-8879-4a58-bc4f-abf64162d759', 'MASTER_OUTBOUND_GOODS_OUT_DOOR', '出货门', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'GOODS_OUT_DOOR', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('b28713ba-d67a-42cc-8f0d-68f07b5027ce', 'MASTER_OUTBOUND_PICK_PACK_WALL', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_PACK_WALL', '2017-11-24 23:39:31', 'mengmengsun', '2017-11-24 23:39:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('b506e536-6018-4961-9f8a-3217b884311e', 'OUTBOUND_PACK', '包装', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PACK', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('b6b859b2-4ccb-4bad-8205-7995b6ae68dc', 'MASTER_OUTBOUND_PICK_PACK_WALL_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_PACK_WALL_TYPE', '2017-11-24 23:36:33', 'mengmengsun', '2017-11-24 23:36:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('bae13256-7c1c-42e3-9881-8ab3d615cb1a', 'MASTER_STORAGE_LOCATION', '容器', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STORAGE_LOCATION', '2017-12-02 00:27:43', 'mengmengsun', '2017-12-02 00:27:43', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('bc377572-2ffb-44a9-b792-39bebbbbde79', 'MASTER_INBOUND_RECEIVE_THRESHOLD', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVE_THRESHOLD', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('bda77bd3-473f-495d-9824-c385a17f282f', 'MASTER_OUTBOUND_PROCESS_PATH_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PROCESS_PATH_TYPE', '2017-11-24 23:39:29', 'mengmengsun', '2017-11-24 23:39:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('bde6b804-56f1-4612-9ed2-251c1857abee', 'OUTBOUND_CUSTOMER_ORDER', '订单管理', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CUSTOMER_ORDER', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('beaad852-7942-4f1e-934b-f028d2d55d0e', 'inboundInteface', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 2, 'inboundInteface', '2018-03-27 04:26:13', 'tianyaoxie', '2018-03-27 04:26:13', 'tianyaoxie', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c17477bd-9c82-4981-852f-bce1c87e5754', 'MASTER_HARDWARE_WORKSTATION', '硬件工作站', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'HARDWARE_WORKSTATION', '2017-11-24 23:36:33', 'mengmengsun', '2017-11-24 23:36:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c202d0f4-a767-4f88-aca4-3cf9196d0b2b', 'HELI_ICQA_TASK_LIST', '合力盘点任务列表界面', 'MENU', b'0', b'1', 'main.heli_icqa_task_list', NULL, NULL, b'1', b'0', 1, 'HELI_ICQA_TASK_LIST', '2019-12-18 02:48:27', 'admin', '2019-12-18 02:48:27', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c211ee27-5ce7-4303-86ee-601b4c912bbb', 'MASTER_BAY', '货架', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BAY', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c4740a57-2a68-4864-b6f3-fa7086bd93cd', 'Collate Template', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'COLLATE_TEMPLATE', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c5d1231d-1d32-47ee-9140-56bb0485d792', 'CONSOLIDATION_MODEL', '理货标准模板', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CONSOLIDATION_MODEL', '2018-12-25 07:18:20', 'admin', '2018-12-25 07:18:20', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c7544083-879f-4603-9c45-50b4a2f30712', 'MASTER_WAREHOUSE_SECTION', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SECTION', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c8e147f7-4a2a-40d3-8625-508e274e2a99', 'ICQA_STOCKTAKING_STATION_TYPE', '盘点工作站类型', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOCKTAKING_STATION_TYPE', '2017-11-24 23:39:29', 'mengmengsun', '2017-11-24 23:39:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c9615bd3-84f3-4ce4-b257-d513f1e6d1bd', 'MASTER_OUTBOUND_DELIVERY_SORT_CODE', '发货种类编码', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'DELIVERY_SORT_CODE', '2017-12-02 00:41:24', 'mengmengsun', '2017-12-02 00:41:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('c9f8a80d-eb4f-4447-9845-987850480bfd', 'HELI_ICQA_MATERIAL', '合力盘点', 'MENU', b'0', b'1', 'main.heli_icqa_material', NULL, NULL, b'1', b'0', 1, 'HELI_ICQA_MATERIAL', '2019-12-18 02:47:04', 'admin', '2019-12-18 02:47:04', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ca0ada8f-4bf3-4a93-b115-45f6e15c4ae0', 'MASTER_INBOUND_GOODS_RECEIPT', '收货单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'GOODS_RECEIPT', '2017-11-24 23:35:24', 'mengmengsun', '2017-11-24 23:35:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('cc7ea382-46e9-4601-a95a-acaf3a97c768', 'FINISH_TRIP', '结束调度单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'FINISH_TRIP', '2018-11-08 17:20:26', 'xiongxiaoning', '2018-11-08 17:20:26', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ccd27135-71f4-4246-92f4-474350cad220', 'OUTBOUND_CUSTOMER_STATE', '订单发货时间修改', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CUSTOMER_STATE', '2018-02-11 00:29:34', 'xiaofanyang', '2018-02-11 00:29:34', 'xiaofanyang', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('cd18df12-34ba-4ff0-8830-9b3b02775cd1', 'SYSTEM_ROLE_MODULE', '角色权限', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ROLE_MODULE', '2017-12-02 00:28:45', 'mengmengsun', '2017-12-02 00:28:45', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('cd5e1e08-fa16-4eb3-b199-3d2b2bbee40a', 'MASTER_OUTBOUND_REBATCH_SLOT', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBATCH_SLOT', '2017-12-02 00:14:26', 'mengmengsun', '2017-12-02 00:14:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ce8b4d2f-b05c-42b9-8d28-4bb2a4ab3f62', 'INBOUND_PROBLEM', 'IB问题菜单栏', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'INBOUND_PROBLEM', '2017-12-02 00:41:46', 'mengmengsun', '2017-12-02 00:41:46', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('cf119ec0-50a5-48e1-b73b-b39b4bee88dd', 'OUTBOUND_CART_QUERY_SHIPMENT', '笼车查询订单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CART_QUERY_SHIPMENT', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('cf8b6128-93ad-47b8-8136-827ea1a1efb5', 'OUTBOUND_MOVE_PACKAGE', '移动包裹', 'FORM', b'1', b'0', NULL, NULL, NULL, b'1', b'0', 1, 'MOVE_PACKAGE', '2017-11-24 23:39:34', 'mengmengsun', '2017-11-24 23:39:34', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d08d49ed-4433-4dc3-b883-ab2ce6bd858f', 'OUTBOUND_DELIVERY_SHIPMENTS_DETAIL', '发货Shipment详情', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'DELIVERY_SHIPMENTS_DETAIL', '2017-12-02 00:41:46', 'mengmengsun', '2017-12-02 00:41:46', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d1a58179-bc55-481a-9cd5-bcc2d4d83944', 'ICQA_ANDON', '暗灯处理', 'FORM', b'0', b'1', 'icqa_andon', NULL, NULL, b'1', b'0', 3, 'ICQA_ANDON', '2017-12-02 00:28:45', 'mengmengsun', '2017-12-02 00:28:45', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d22cda71-0eea-44b6-a522-c9ad3834ad4b', 'REPORT_BATCH', '批次', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BATCH', '2017-12-02 00:28:45', 'mengmengsun', '2017-12-02 00:28:45', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d276b3bb-bb4b-48ce-a4fa-9b9c79bd3110', 'ENDING_SETTING', '出库流程终点设置', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ENDING_SETTING', '2018-12-25 15:04:18', 'xiongxiaoning', '2018-12-25 15:04:18', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d31c5190-b276-4953-83df-deba1f39dff2', 'CHECK_ORDER_ALLOT', '查看订单不分配任务原因', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CHECK_ORDER_ALLOT', '2018-11-08 17:22:10', 'xiongxiaoning', '2018-11-08 17:22:10', 'xiongxiaoning', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d4401143-b4ad-4d2c-8049-73213498d072', 'MASTER_OUTBOUND_PICKING_PROCESS_ELIGIBILITY', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICKING_PROCESS_ELIGIBILITY', '2017-11-24 23:35:22', 'mengmengsun', '2017-11-24 23:35:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d56b0c03-1ba1-4e68-9435-bdea3b4fdcfc', 'HELI_ICQA_TASK_LIST_DETAILE', '合力盘点任务列表明细', 'MENU', b'0', b'1', 'main.heli_icqa_task_list_detaile', NULL, NULL, b'1', b'0', 1, 'HELI_ICQA_TASK_LIST_DETAILE', '2019-12-18 02:49:35', 'admin', '2019-12-18 02:49:35', 'admin', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d7a11398-0a5f-4709-85ea-86579d5d29e1', 'MASTER_ROBOT_ROBOT_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ROBOT_TYPE', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('d90044e9-7685-49ba-8335-cdabb840abf6', 'MASTER_OUTBOUND_ORDER_STRATEGY', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ORDER_STRATEGY', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('da7e71a1-5248-4191-800b-7b703c59b771', 'MASTER_OUTBOUND_PICK_PACK_FIELD_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICK_PACK_FIELD_TYPE', '2017-11-24 23:35:24', 'mengmengsun', '2017-11-24 23:35:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('da94c8b7-3f1e-44b5-b0ea-f50b5ce09f5e', 'OUTBOUND_SHIPMENT_DETAIL', 'Shipment详情', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SHIPMENT_DETAIL', '2017-12-02 00:41:23', 'mengmengsun', '2017-12-02 00:41:23', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('dae17ff2-f308-4b52-9eab-e51b59fb1b6a', 'INTERNAL_TOOL_SKU', 'SKU查询', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SKU_TOOL', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('db129b91-31a8-4fc1-a912-8ffb9ef46d1d', 'OUTBOUND_PROBLEM_OBP_STATION_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OBP_STATION_TYPE', '2017-12-02 00:15:47', 'mengmengsun', '2017-12-02 00:15:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('dbeadb28-b1cb-47bb-a3c8-ff6f3235daa7', 'ICQA_CREATE', '盘点创建', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA_CREATE', '2017-12-02 00:42:48', 'mengmengsun', '2018-03-23 22:41:43', 'jupingli', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('dc4299cc-979b-441d-8954-170046bd6a94', 'TOT_CLOCKTIMEDETAIL', '打卡时间详情', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_CLOCKTIMEDETAIL', '2017-11-24 23:39:01', 'mengmengsun', '2017-11-24 23:39:01', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('df6ce431-121a-4f43-98b7-3912738d1af8', 'SYSTEM', '系统管理', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SYSTEM_MANAGE', '2017-11-24 23:39:32', 'mengmengsun', '2017-11-24 23:39:32', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('e18c43b1-2096-49cb-9fe6-606751c7e74b', 'OUTBOUND_REBATCH', 'rebatch', 'FORM', b'1', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'REBATCH', '2017-11-24 23:39:30', 'mengmengsun', '2017-11-24 23:39:30', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('e4a5f2ce-83bb-41e7-852d-620b2d85da67', 'OUTBOUND_DELIVERY_SYSTEM', '发货系统', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'DELIVERY_SYSTEM', '2017-11-24 23:39:31', 'mengmengsun', '2017-11-24 23:39:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('e54163af-6101-4c25-aad3-3e2fd78d8a8b', 'MASTER_ZONE_ITEM_GROUP', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ZONE_ITEM_GROUP', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('e6f4da5f-0887-47b2-bcd2-5cd884633c87', 'SYSTEM_USER_WAREHOUSE_ROLE', '用户仓库角色', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'USER_WAREHOUSE_ROLE', '2017-11-24 23:36:33', 'mengmengsun', '2017-11-24 23:36:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('e7a9078e-77a7-4bf9-8c03-1f0f0d80fff6', 'MASTER_OUTBOUND_SORTING_STATION', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SORTING_STATION', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ed1db2b5-1f2a-4c84-bcd9-2f1fd4b92044', 'REPORT_ZONE_PICKING', 'Zone Picking', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ZONE_PICKING', '2017-12-06 06:46:36', 'mengmengsun', '2017-12-06 06:46:36', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ed6df69c-35b7-49eb-94f9-43c6c988d4c1', 'INTERNAL_TOOL_BAR_CODE', '补打条码工具', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'BAR_CODE_TOOL', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ef30f487-803e-49f7-bf44-c118cd582726', 'OUTBOUND_LOAD_PARCEL', '装载包裹', 'FORM', b'1', b'0', NULL, NULL, NULL, b'1', b'0', 1, 'LOAD_PARCEL', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ef532383-4137-4c85-883d-41147c33ba5a', 'MASTER_OUTBOUND_DELIVERY_POINT', '发货点', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'DELIVERY_POINT', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f1295207-ec07-499d-bf42-58b14507318c', 'OUTBOUND_SORTING', '分拣', 'FORM', b'1', b'0', NULL, NULL, NULL, b'0', b'0', 1, 'SORTING', '2019-07-02 19:20:42', 'jiangshikun', '2019-07-02 19:21:22', 'jiangshikun', NULL, 0, 1);
INSERT INTO `SYS_MODULE` VALUES ('f135c86d-9962-47c0-ae6e-dd5ee5351112', 'MADTER_OUTBOUND_PICKING_AREA_AND_PP_ELIGIBILITY', '拣货权限和PP权限', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICKING_AREA_AND_PP_ELIGIBILITY', '2017-11-24 23:35:31', 'mengmengsun', '2017-11-24 23:35:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f1638285-3e24-4168-8e86-26e7191de254', 'OUTBOUND_PROBLEM_MANAGE', 'OB问题管理', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'OUTBOUND_PROBLEM_MANAGE', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f1a0f435-7c96-4f4d-9f8f-3590ba78fe4d', 'MASTER_OUTBOUND_CARRIER', '承运商', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CARRIER', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f2009bcd-37a6-49da-b748-cfea3e1beafb', 'MASTER_INBOUND_STOW_STATION', '上架工作站', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOW_STATION', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f30a6ec3-9d52-47f1-b3a2-a3e96c944e10', 'MASTER_OUTBOUND', 'OB基础', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MASTER_OUTBOUND', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f3aa4cd0-77c3-4af5-87ca-dc5274ce49b9', 'ICQA_DETAIL', '盘点明细', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ICQA_DETAIL', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f489a95f-934e-461f-bcc0-e58c18d4e41b', 'MASTER_POD_TYPE', 'Pod Type', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'POD_TYPE', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f49640f3-b460-44d7-920b-89f72bf30b59', 'MASTER_OUTBOUND_SORTING_AREA_BATCH', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'SORTING_AREA_BATCH', '2019-07-08 15:51:03', 'weipengxiang', '2019-07-08 15:51:03', 'weipengxiang', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f4b1883e-5ace-44c4-aa36-1e81a84a737a', 'SYSTEM_RF_MENU', '移动端菜单', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RF_MENU', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f4f18b61-ab2d-4baf-8461-9eaa5849f462', 'SYSTEM_CLIENT', '客户', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'CLIENT', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f55ff6de-5504-4cc4-9074-126ec4231358', 'STOCKUNIT_CHECK', '库存查询', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'STOCKUNIT_CHECK', '2017-11-24 23:39:31', 'mengmengsun', '2017-11-24 23:39:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f77824d4-d1a1-4290-b27f-b2c93db00090', 'MASTER', '基础数据菜单栏', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'MASTER', '2017-12-02 00:42:48', 'mengmengsun', '2017-12-02 00:42:48', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f87a113c-53bf-4c00-8a8f-452eeed5dfd0', 'MASTER_INBOUND_RECEIVE_STATION_TYPE', '收货工作站类型', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'RECEIVE_STATION_TYPE', '2017-11-24 23:35:22', 'mengmengsun', '2017-11-24 23:35:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('f949833e-efb0-4b43-8965-1f818d300c29', 'MASTER_ITEM_GROUP', '货物分组', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_GROUP', '2017-11-24 23:40:01', 'mengmengsun', '2017-11-24 23:40:01', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('fa34461a-df2f-45f7-b269-c05daef14bb1', 'TOT_JOBRELATION', '关系表', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'TOT_JOBRELATION', '2017-12-02 00:17:26', 'mengmengsun', '2017-12-02 00:17:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('fbc600b4-0ea3-4373-9a18-b196ac6f4f99', 'MASTER_OUTBOUND_PICKING_CATEGORY', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICKING_CATEGORY', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('fe633bee-94fb-4816-89bd-896dbffb40e7', 'REPORT_PICKING_CART', 'Picking Cart', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PICKING_CART', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ff033e0e-7a9b-448d-b25f-066d0df2026d', 'MASTER_OUTBOUND_PACKING_STATION_TYPE', NULL, 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'PACKING_STATION_TYPE', '2017-11-24 23:35:22', 'mengmengsun', '2017-11-24 23:35:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('ff09b7f9-d43b-4d00-ad7e-6e2c6c58c7d7', 'OUTBOUND_AREA_OUT', '集货区出库', 'FORM', b'1', b'0', NULL, NULL, NULL, b'0', b'0', 1, 'AREA_OUT', '2019-07-02 19:23:35', 'jiangshikun', '2019-07-02 19:23:35', 'jiangshikun', NULL, 0, 0);
INSERT INTO `SYS_MODULE` VALUES ('itemdataimages', 'ITEM_DATA_IMAGES', 'SKU图片', 'FORM', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ITEM_DATA_IMAGES', '2018-08-25 08:00:00', 'altian', '2018-08-25 08:00:00', 'altian', NULL, NULL, 0);
INSERT INTO `SYS_MODULE` VALUES ('ROOT', 'ROOT', 'ROOT', 'MENU', b'0', b'1', NULL, NULL, NULL, b'1', b'0', 1, 'ROOT', '2017-11-24 23:40:01', 'mengmengsun', '2017-11-24 23:40:01', 'mengmengsun', NULL, 0, 0);

-- ----------------------------
-- Table structure for SYS_RESOURCE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_RESOURCE`;
CREATE TABLE `SYS_RESOURCE`  (
  `ID` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `RESOURCE_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '资源KEY',
  `LOCALE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '语言',
  `RESOURCE_VALUE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资源VALUE',
  `CREATED_DATE` timestamp(0) NULL DEFAULT NULL,
  `CREATED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MODIFIED_DATE` timestamp(0) NULL DEFAULT NULL,
  `MODIFIED_BY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ADDITIONAL_CONTENT` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ENTITY_LOCK` int(11) NULL DEFAULT NULL,
  `VERSION` int(11) NOT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  UNIQUE INDEX `RESOURCE_UK`(`RESOURCE_KEY`, `LOCALE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '资源' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_RESOURCE
-- ----------------------------
INSERT INTO `SYS_RESOURCE` VALUES ('01b0bf08-b0c2-4ed1-96f9-b88b58a5da6e', 'HOT_RESET_TIMES', 'CN', '热复位次数', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('01c0cd76-2d60-45c6-9c1d-c8339e66658d', 'D_WARNING_CODE', 'CN', '直接项目条码不能为空', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('01c1e6b7-c08c-478f-8344-66d47fb67152', 'REJECT_REASONS', 'CN', '拒绝理由', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('01e1bcc9-80f9-42e2-a252-a48160992de0', 'TEMPLATE_NAME', 'CN', 'Template', '2017-11-24 23:39:33', 'mengmengsun', '2017-11-24 23:39:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('023203b6-9fab-48c3-a650-976c336b458c', 'INBOUND', 'CN', '入库', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0244396f-1342-440c-989d-b8715788d6ef', 'MAX_SHIPMENTS_PER_BATCH', 'CN', '最大订单数量', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('026e532c-6697-45c8-96cd-377b167ec44b', 'PREFER_BAG', 'CN', '袋子优先', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0296e373-a58a-4991-812c-284dcd827a38', 'PRODUCTINFO', 'CN', '商品信息', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('02b2b2c8-73a4-4a26-9b87-6301a43f5c44', 'EX_SYS_WAREHOUSE_NO_UNIQUE', 'CN', '该仓库已存在', '2018-03-23 18:49:37', 'tianyaoxie', '2018-03-23 18:49:37', 'tianyaoxie', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('03189d73-29d1-4e55-992c-4e8022db0f96', 'PICK_MODEL', 'CN', '选择拣货类型', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('03215e03-0395-4e18-8af4-d7ff12566b2a', 'SELECTION', 'CN', '数据字典', '2017-12-02 00:16:29', 'mengmengsun', '2017-12-02 00:16:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('03461379-c64e-4435-9472-2ffb91d89c4b', 'PROBLEN', 'CN', '问题处理', '2017-11-24 23:39:35', 'mengmengsun', '2017-11-24 23:39:35', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('04b9d639-58ad-4374-8265-46a0012e989a', 'DELIVERY_POINT', 'CN', '发货点', '2017-11-24 23:36:33', 'mengmengsun', '2017-11-24 23:36:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('05c4fa8b-9dd2-477d-8c0a-6b7a6b6d712e', 'POD', 'CN', '货架', '2017-12-02 00:41:24', 'mengmengsun', '2017-12-02 00:41:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('05e9e032-34c9-49da-95f9-d0d52b1ce5fb', 'Unit', 'CN', '商品单位', '2018-03-28 23:57:57', 'tianyaoxie', '2018-03-28 23:57:57', 'tianyaoxie', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('05f80ffe-cbd9-4c86-b164-7099b7849fc0', 'TOT_JRD', 'CN', '详情页', '2017-12-02 00:17:26', 'mengmengsun', '2017-12-02 00:17:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('062e9530-2d50-4a54-baf8-d1dde5280a10', 'ROBOT_ID', 'CN', '车辆ID', '2017-12-02 00:16:29', 'mengmengsun', '2017-12-02 00:16:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0648f147-ddab-4ba4-b56c-f0e569d18872', 'ASSIGN_PICK_PACK_CELL_TYPE', 'CN', '已分配箱型', '2017-12-02 00:14:47', 'mengmengsun', '2017-12-02 00:14:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('066b0885-7097-4f7c-b402-a0780ac89e3c', 'VOLUME', 'CN', '体积', '2017-11-24 23:39:28', 'mengmengsun', '2017-11-24 23:39:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('06722042-f6b9-4c2d-9559-579f29f1355d', 'STOCKUNIT_CHECK', 'CN', '库存查询', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0684d48b-5764-40db-b6bc-53cb01ddd53c', 'ALL_SKU_SCANED', 'CN', '我已扫描完所有商品', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('06915584-c473-442c-96f4-d42f86d5d537', 'DJOB_NAME', 'CN', '直接工作名称', '2017-11-24 23:40:01', 'mengmengsun', '2017-11-24 23:40:01', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0694f364-0f87-4fc6-9609-941efe21c9bc', 'MASTER', 'CN', '基础数据', '2017-12-02 00:17:55', 'mengmengsun', '2017-12-02 00:17:55', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0717c79d-395d-44e0-a79c-aba8ed4191a5', 'ACTIVITYENDTIME', 'CN', '结束', '2017-11-24 23:39:33', 'mengmengsun', '2017-11-24 23:39:33', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0720a168-36c0-417c-8bc1-f0727292f011', 'OK_EXPORT', 'CN', '确认导出', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('072184bd-5ffb-4706-871f-95ad41fef950', 'TOT_JOBRELATION_ERROR', 'CN', '关系已绑定', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0722a0f7-de2c-4268-8936-8c7b1aeb9032', 'WEIGHT_LIMIT', 'CN', '重量限度', '2017-12-02 00:42:48', 'mengmengsun', '2017-12-02 00:42:48', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0738c5db-252a-4eb1-924f-4c8013d794ac', 'CAPACITY', 'CN', '容积率', '2017-11-24 23:39:28', 'mengmengsun', '2017-11-24 23:39:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('089fc04b-6691-4539-b914-81e0583ae530', 'LICENSE_PLATE', 'CN', '车牌号', '2017-11-24 23:35:26', 'mengmengsun', '2017-11-24 23:35:26', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('08a88eee-f3fb-4313-b049-16a12c4262ee', 'SEARCH', 'CN', '搜索', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('08ec2441-c0f3-4370-9886-d01d19044155', 'SAFETY_STOCK', 'CN', '安全库存', '2017-12-02 00:27:43', 'mengmengsun', '2017-12-02 00:27:43', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('093c3408-071e-4135-8c17-8e33d27f10b0', 'UNIT_TYPE', 'CN', '单位类型', '2017-12-02 23:31:27', 'mengmengsun', '2017-12-02 23:31:27', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('096f684c-a76f-4212-914b-da50ad07e21e', 'SCAN_DOWN_BIN', 'CN', '扫描问题货位正下方货位', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('097b6d3e-1d59-4114-8e6e-805c71bb3191', 'PACK', 'CN', 'Pick-Pack包装', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0a211240-a064-435e-9fe1-e4689d5fd99b', 'NO', 'CN', '编号', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0a4b6107-cb41-4160-a562-210083ec84aa', 'PICK_NO', 'CN', '拣货数量', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0ab484e4-84f6-4a3c-8e41-37b632559289', 'STOCKTAKING_SYSTEM', 'CN', '系统盘点', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0ab603d4-75d8-41a9-b7f2-4ad3288f1549', 'X_POS_TAR', 'CN', '目标地址X轴', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0d50b0b3-4130-4317-bdbe-a3f50f70f60c', 'BATCH', 'CN', '批次', '2017-12-02 00:28:45', 'mengmengsun', '2017-12-02 00:28:45', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0d5cfa87-3dca-49b4-a5c5-d797f94b0f7a', 'MENU', 'CN', '菜单', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0d6d990b-2b45-4694-b9cc-6e0c46c21861', 'SYSTEM_VALUE', 'CN', '系统值', '2017-11-24 23:35:25', 'mengmengsun', '2017-11-24 23:35:25', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0d6f60fb-3296-43d2-8dac-e4bc60ba1151', 'CONFIRM_DELETE', 'CN', '确认删除当前信息吗？', '2017-12-02 00:15:47', 'mengmengsun', '2017-12-02 00:15:47', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0dc2e7a1-f8fa-4417-906f-643050d39bf6', 'ORDER_NO', 'CN', '订单编号', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0dcb1a79-63b6-499d-8282-6f6cfb887fc0', 'RESOURCE_VALUE', 'CN', '语言值', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0df447d1-ac43-41b9-8c5d-d8008ec94df9', 'FAX', 'CN', '传真', '2017-11-24 23:35:20', 'mengmengsun', '2017-11-24 23:35:20', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0eca5994-4c36-40ca-ad57-a7de3ddb9001', 'TO', 'CN', 'To', '2017-11-24 23:39:34', 'mengmengsun', '2017-11-24 23:39:34', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('0fc58fe4-05a6-4e83-9cc1-8a9be4d649a6', 'WORKSTATION', 'CN', '工作站', '2017-11-24 23:35:30', 'mengmengsun', '2017-11-24 23:35:30', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1', 'EX_USER_NOT_LOGIN', 'CN', '用户没有登录！', '2017-11-24 23:39:30', 'mengmengsun', '2017-11-24 23:39:30', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1058c100-638b-4783-a90a-8e82a71f6cc1', 'Main Processes', 'CN', '主流程', '2018-03-28 23:56:33', 'tianyaoxie', '2018-03-28 23:56:33', 'tianyaoxie', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('114f3e48-8d9d-4383-af4f-a818abc1a9c0', 'QUANTITY', 'CN', '数量', '2017-11-24 23:39:31', 'mengmengsun', '2017-11-24 23:39:31', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('116699a7-f384-4832-bb0e-6715ffd2027e', 'ALLOWED_PICK_TYPES', 'CN', '允许的拣货类型', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('11cd8daf-b18a-47bd-aa58-a3cbf002152f', 'WARNING_SYSTEM_KEY', 'CN', '系统key不能为空', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('11ee318c-6422-4242-aeda-9b4c97423936', 'SCANDAMAGEDCIBER', 'CN', '请扫描残品货筐', '2017-12-02 00:42:04', 'mengmengsun', '2017-12-02 00:42:04', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1215fcb2-855e-4188-912d-8d23bb2556d2', 'STOWING_TYPE', 'CN', '上架类型', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('127c8420-475f-4a76-a2b9-f4751c3d67bf', 'CLIENT_NO', 'CN', '客户编号', '2017-12-02 00:43:28', 'mengmengsun', '2017-12-02 00:43:28', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1285a5c0-a83b-41ae-905d-b80ab9efc7f3', 'CELL_TYPE', 'CN', '格子类型', '2017-12-02 00:16:13', 'mengmengsun', '2017-12-02 00:16:13', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('12912496-d4f3-4fc6-bef0-386b94db9c4d', 'HARDWARE_TYPE', 'CN', '硬件类型', '2017-12-02 00:42:22', 'mengmengsun', '2017-12-02 00:42:22', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('12dcfc3d-16a1-4635-879e-9bd234bfa4f9', 'J_CODE', 'CN', '间接项目条码', '2017-11-24 23:39:59', 'mengmengsun', '2017-11-24 23:39:59', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('12e6cdad-e7eb-4047-914e-11cd6cd11505', 'DATE', 'CN', '日期', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('13174f49-a20c-4326-bec1-9c7afc11324c', 'REPLENISHSHIPMENT_ERROR', 'CN', '补货单生成失败', '2017-11-24 23:35:21', 'mengmengsun', '2017-11-24 23:35:21', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('13c4b488-00ac-4b38-aa5f-d4a06503d80e', 'DIGITAL_LABEL_FRONT', 'CN', '电子标签正面', '2017-11-24 23:35:25', 'mengmengsun', '2017-11-24 23:35:25', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('13da7967-5bfd-47d4-bdb9-f7bcde615262', 'TOT_JOB_NAME', 'CN', '间接工作', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1419fb04-950e-4509-8532-2fed06c20620', 'TO_IP', 'CN', '终止ip', '2017-11-24 23:40:00', 'mengmengsun', '2017-11-24 23:40:00', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('143a99e4-c746-4d3d-b735-e1a278d7222f', 'IF_SCAN', 'CN', '扫描', '2017-11-24 23:39:32', 'mengmengsun', '2017-11-24 23:39:32', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1479f650-39ca-4940-b4d8-686660f59d89', 'HANDOVER_CONFIRMATION', 'CN', '交接确认单', '2017-12-02 00:16:12', 'mengmengsun', '2017-12-02 00:16:12', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('14e7df75-4436-4847-a3ed-6dbcbb7b2963', 'MEASURING_MACHINE', 'CN', '测量机', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1525c2a6-9867-47a6-9302-87e91ac0c58a', 'RELEASEPOD', 'CN', '释放Pod', '2017-12-02 00:43:09', 'mengmengsun', '2017-12-02 00:43:09', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('15579585-0975-4d48-bfe4-dce5041ca71a', 'OPERATE', 'CN', '操作方式', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('158fbd17-0a24-4f2a-9184-bc786195356f', 'PACK_STATION_TYPE', 'CN', '包装工作站类型', '2017-11-24 23:39:29', 'mengmengsun', '2017-11-24 23:39:29', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('15d80668-a7d7-44e4-8ef6-5b64b858a73a', 'EN', 'CN', '英文', '2017-11-24 23:39:02', 'mengmengsun', '2017-11-24 23:39:02', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('1635efbe-bf68-498e-bd4d-6d84cd9c4f73', 'WELCOME_CLOCK', 'CN', '欢迎进入上下班打卡系统', '2017-12-02 00:41:23', 'mengmengsun', '2017-12-02 00:41:23', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('167453ab-5c6e-40b0-b01a-ac7023cfa4ce', 'GOODS_LEVEL', 'CN', '商品等级', '2017-12-02 00:27:43', 'mengmengsun', '2017-12-02 00:27:43', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('16a4429b-0737-4add-a256-aee07832d5f6', 'TAOZHUANG_ZUTAO_WRONG', 'CN', '套装组套错误', '2017-11-24 23:35:24', 'mengmengsun', '2017-11-24 23:35:24', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('170050d1-dfb9-4af6-ba1b-43e4d8383921', 'WARNING_NUMBER_OF_ROWS', 'CN', '列数不能为空', '2017-11-24 23:39:35', 'mengmengsun', '2017-11-24 23:39:35', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('17571ffa-e47e-4999-89d3-a98246ed7772', 'USERNAME', 'CN', '账号', '2017-12-02 00:16:11', 'mengmengsun', '2017-12-02 00:16:11', 'mengmengsun', NULL, 0, 0);
INSERT INTO `SYS_RESOURCE` VALUES ('176a203d-71e3-488d-9725-fe4c741e8bb3', 'BUFFER_ZONE_FUD', 'CN', 'Buffer Zone Fud', '2017-12-02 00:16:11', 'mengme