package com.mushiny.heli.xnr.controller;

import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.service.ICQAService;
import com.mushiny.heli.xnr.service.InboundService;
import com.mushiny.heli.xnr.service.WMSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Lisi on 2019-11-30.
 */
@RestController
@RequestMapping("/xnr/icqa")
public class ICQAController {

    private final static Logger logger = LoggerFactory.getLogger(ICQAController.class);

    @Autowired
    private WMSService wmsService;

    @Autowired
    private ICQAService icqaService;

    @Autowired
    private InboundService inboundService;

    @PostMapping(value = "/check", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> check(
            @RequestBody String json){
        Map data = JsonUtils.json2Map(json);
        int stored = CommonUtils.parseInteger("counted",data);
        String skuId = CommonUtils.parseString("skuId",data);
        String factory = CommonUtils.parseString("factory",data);
        factory = CommonUtils.getWarehouse(factory);
        String section = CommonUtils.parseString("section",data);
        section = CommonUtils.getSection(section);
        String entryId = CommonUtils.parseString("taskId",data);
        //货架的货位 P0000008AA01
        String containerId = CommonUtils.parseString("containerId",data);
        MessageDTO dto = this.icqaService.check(skuId,stored,containerId,factory,section,entryId);
        return ResponseEntity.ok(dto);
    }

    /**
     * 当前任务
     * @param json
     * @return
     */
    @PostMapping(value = "/currentPodTask", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> currentPodTask(
            @RequestBody String json){
        Map station  = JsonUtils.json2Map(json);
        //工作站号码
        Map dto = this.icqaService.currentPodTask(CommonUtils.parseString("stationName",station));
        return ResponseEntity.ok(JsonUtils.map2Json(dto));
    }

    @PostMapping(value = "/createICQAOrder", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> createICQAOrder(
            @RequestBody String json){
        Map data = JsonUtils.json2Map(json);
        logger.debug("收到创建盘点任务指令:" + json);
        MessageDTO dto = MessageDTO.success();
        try {
            dto = this.wmsService.createICQAOrder(data);
        } catch (Exception e) {
            logger.error("盘点任务创建失败!",e);
            dto.setMESSAGE(e.getMessage());
            dto.setCODE(1);
        }
        return ResponseEntity.ok(dto);
    }

    @PostMapping(value = "/searchIcqa", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> searchIcqa(@RequestBody String json){
        Map data = JsonUtils.json2Map(json);
        Map resData = this.icqaService.searchIcqa(data);
        return ResponseEntity.ok(JsonUtils.map2Json(resData));
    }

    @PostMapping(value = "/searchSkus", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> searchSkus(@RequestBody String json){
        Map data = new HashMap();
        if(!CommonUtils.isEmpty(json)){
            data = JsonUtils.json2Map(json);
        }

        Map resData = this.icqaService.searchSkus(data);
        return ResponseEntity.ok(JsonUtils.map2Json(resData));
    }

    /**
     * 查找明细
     * @param json
     * @return
     */
    @PostMapping(value = "/searchIcqaInfo", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> searchIcqaInfo(@RequestBody String json){
        Map data = JsonUtils.json2Map(json);
        Map resData = this.icqaService.searchIcqaInfo(data);
        return ResponseEntity.ok(JsonUtils.map2Json(resData));
    }

    @PostMapping(value = "/startTasks", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> startTasks(@RequestBody String json){
        Map data = JsonUtils.json2Map(json);
        MessageDTO resData = this.icqaService.startTasks(data);
        return ResponseEntity.ok(resData);
    }

    /**
     * 终止盘点任务
     * @param json
     * @return
     */
    @PostMapping(value = "/taskFinish", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> taskFinish(@RequestBody String json){
        Map data = JsonUtils.json2Map(json);
        MessageDTO dto = this.icqaService.taskFinish(data);
        return ResponseEntity.ok(dto);
    }

    /**
     * 退出盘点 如果stowpod任务还在 就提示并强制退出
     * @param json
     * @return
     */
    @PostMapping(value = "/endICQA", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> endICQA(
            @RequestBody String json){
        Map station  = JsonUtils.json2Map(json);
        //用跟上架 同一个代码
        MessageDTO dto = this.inboundService.endInbound(CommonUtils.parseString("stationName",station));
        return ResponseEntity.ok(dto);
    }

    /**
     * @param json
     * @return
     */
    @PostMapping(value = "/skuNotFound", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> skuNotFound(
            @RequestBody String json){
        Map reqData = JsonUtils.json2Map(json);
        String taskId = CommonUtils.parseString("taskId",reqData);
        String skuId = CommonUtils.parseString("skuId",reqData);
        MessageDTO dto = this.icqaService.skuNotFound(taskId,skuId);
        return ResponseEntity.ok(dto);
    }

}
