package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.dto.StorageLocation;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.*;

/**
 * Created by Lisi on 2019-11-27.
 */
@Service
@Transactional
public class InboundService {
    public static final String SQL_SEARCHINBOUND_FACTORY = " AND WAREHOUSE_ID=? ";
    public static final String SQL_SEARCHINBOUND_SECTION = " AND SECTION_ID=? ";
    public static final String SQL_SEARCHINBOUNDINFO =
            "SELECT SKUID,AMOUNT,IFNULL(STORED,0) AS STORED,STATE FROM WMS_INBOUND_ORDERPOSITION WHERE ENTRYID = ?";

    private final static Logger logger = LoggerFactory.getLogger(InboundService.class);
    private static final String SQL_SEARCHINBOUND_ENTRYID = " AND ENTRYID like ? ";


    @Autowired
    private JdbcRepository jdbcRepository;

    @Autowired
    private SystemPropertiesManager systemPropertiesManager;

    public static final String SQL_SEARCHINBOUND =
            "SELECT ENTRYID,STATE,DATE_FORMAT(CREATED_DATE,'%Y-%m-%d %H:%i:%s') as CREATED_DATE" +
                    ",WAREHOUSE_ID FACTORY,SECTION_ID as SECTION " +
            "FROM WMS_INBOUND_ORDER WHERE 1=1 ";


    public List<Map> searchInbound(String entryId, String warehouseId, String sectionId) {
        List params = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append(SQL_SEARCHINBOUND);
        if(!CommonUtils.isEmpty(warehouseId)){
            sql.append(SQL_SEARCHINBOUND_ENTRYID);
            params.add(entryId);
        }

        if(!CommonUtils.isEmpty(warehouseId)){
            sql.append(SQL_SEARCHINBOUND_FACTORY);
            params.add(warehouseId);
        }
        if(!CommonUtils.isEmpty(sectionId)){
            sql.append(SQL_SEARCHINBOUND_SECTION);
            params.add(warehouseId);
        }

        return this.jdbcRepository.queryBySql(sql.toString(),params);
    }

    public List<Map> searchInboundInfo(String entryId) {
        List params = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append(SQL_SEARCHINBOUNDINFO);
        params.add(entryId);
        List<Map> data = this.jdbcRepository.queryBySql(sql.toString(),params);
        return data;
    }

    public MessageDTO orderFinish(String entryId) {
        MessageDTO messageDTO = MessageDTO.success();
        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setIdName("ENTRYID");
        baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDER);
        baseBpo.setId(entryId);
        baseBpo.addKV("STATE", Sql_Table.FINISH);
        int result = this.jdbcRepository.updateBusinessObject(baseBpo);
        if(result == 0){
            messageDTO.setMESSAGE("更新失败，没有更新记录!");
            messageDTO.setCODE(1);
            //return messageDTO;
        }
        return messageDTO;
    }

    public static final String SQL_INV_UNITLOADID =
            "SELECT INV_UNITLOAD.ID FROM INV_UNITLOAD,MD_STORAGELOCATION WHERE MD_STORAGELOCATION.NAME=? " +
            "AND MD_STORAGELOCATION.ID=INV_UNITLOAD.STORAGELOCATION_ID";
    public static final String SQL_MD_ITEMDATA =
            "SELECT ID FROM MD_ITEMDATA WHERE SKUID=?";

    /**
     * 上架到货位
     * @param skuId
     * @param stored
     * @param containerId
     * @param factory
     * @param section
     * @param entryId
     * @return
     */
    public MessageDTO store(String skuId, int stored, String containerId,
                            String factory, String section, String entryId) {
       MessageDTO messageDTO = MessageDTO.success();
        List<Map> invs = this.jdbcRepository.queryBySql(SQL_INV_UNITLOADID,containerId);
       if(invs.isEmpty()){
          messageDTO.setCODE(1);
          messageDTO.setMESSAGE("没有找到该容器:"+containerId);
          return messageDTO;
       }
        List<Map> items = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId);
        if(items.isEmpty()){
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("没有找到该商品信息:"+skuId);
            return messageDTO;
        }
        Map item = items.get(0);
        String mID = CommonUtils.parseString("ID",item);

       Map data = invs.get(0);
       String uid = CommonUtils.parseString("ID",data);
       List<Map> lists =  this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_INV_SKU,mID,uid);
       //是否存在记录
        if(lists.isEmpty()){
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.TABLE_INV_STOCKUNIT);
            baseBpo.addKV("ID",CommonUtils.genUUID());
            baseBpo.addKV("ITEMDATA_ID",mID);
            baseBpo.addKV("STATE","Inventory");
            baseBpo.addKV("AMOUNT",stored);//上架的数量
            baseBpo.addKV("UNITLOAD_ID",uid);
            baseBpo.addKV("RESERVED_AMOUNT",0);
            baseBpo.addKV("CLIENT_ID",factory);
            baseBpo.addKV("WAREHOUSE_ID",section);
            this.jdbcRepository.insertBusinessObject(baseBpo);
            //end of 新增记录
        }else{
            //获取数据
            Map inv = lists.get(0);
            Integer amount = CommonUtils.parseInteger("AMOUNT",inv);
            Map newValue = new HashMap();
            newValue.put("AMOUNT",amount+stored);//增加的库存数

            Map con = new HashMap();
            con.put("ITEMDATA_ID",mID);
            con.put("UNITLOAD_ID",uid);

            this.jdbcRepository.updateRecords(Sql_Table.TABLE_INV_STOCKUNIT,newValue,con);
        }

        //更新入库单状态
        this.updateInboundOrderStatus(entryId,skuId, Sql_Table.FINISH,stored,"OK");


        return messageDTO;
    }

    /**
     * 更新入库单状态
     * @param entryId
     * @param skuId
     * @param state
     * @param stored
     * @return
     */
    public MessageDTO updateInboundOrderStatus(String entryId,String skuId,
                                               String state,Integer stored,String msg){

        MessageDTO messageDTO = MessageDTO.success();

        Map newValue = new HashMap();
        newValue.put("STATE",state);
        newValue.put("MSG",msg);
        newValue.put("STORED",stored);

        Map con = new HashMap();
        con.put("SKUID",skuId);
        con.put("ENTRYID",entryId);
        //
        int count = this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_ORDERPOSITION, newValue, con);
        if(count == 0){
            messageDTO.setMESSAGE("更新失败,entryId:"+entryId+" skuId:"+skuId);
            messageDTO.setCODE(1);
        }

        return messageDTO;
    }

    /**
     * 物料缺失
     * @param entryId
     * @param skuId
     * @return
     */
    public MessageDTO skuNotFound(String entryId, String skuId) {

        return this.updateInboundOrderStatus(entryId, skuId, Sql_Table.ERROR,0, "物料缺失");

    }

    public static final String STATION_ID = "6db9c7c0-4f93-4fa1-82c0-fb6435af7aae";//NTYH01S1-S001-1
    public static final String STOW_OPERATOR_ID = "stowPod_user";//NTYH01S1-S001-1
    public static final String ICQA_OPERATOR_ID = "icqaPod_user";//NTYH01S1-S001-1
    public static final String STATION_NAME_STOWPOD = "STOWPOD_STATION";//NTYH01S1-S001-1
    public static final String STATION_NAME_ICQAPOD = "ICQAPOD_STATION";//NTYH01S1-S001-1


    /**
     * 批量生成上架任务
     * @param entryIds
     * @param stationName
     * @return
     */
    public MessageDTO startInbound(List entryIds, String stationName) {
        //成功
        MessageDTO dto = MessageDTO.success();
        //查询是否为空
        if(!isLocked(stationName)){
            dto.setCODE(1);
            dto.setMESSAGE("工作站被锁定或不存在，无法启动上架任务!");
            return dto;
        }
        if(!this.lockStowStation(stationName)){
            dto.setCODE(1);
            dto.setMESSAGE("工作站锁定失败，无法启动上架任务!");
            return dto;
        }

        for (int i = 0; i < entryIds.size(); i++) {
            String entryId = (String) entryIds.get(i);
            List<Map> entryPositions = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_INBOUND_POSITION,entryId);
            for (int j = 0; j < entryPositions.size(); j++) {
                Map map = entryPositions.get(j);
                String skuId = CommonUtils.parseString("SKUID",map);
                StorageLocation storageLocation = this.findStorageLocation(skuId);
                if(storageLocation == null){
                    logger.error("SKU没有找到对应存储位，将随机分配空的存储位 SKU:"+skuId);
                    storageLocation = newStorageLocation();
                    if(storageLocation == null){
                        dto.setCODE(1);
                        dto.setMESSAGE("无法为SKU分配库位! SKU:"+skuId);
                        return dto;
                    }
                }
                /* `ID` VARCHAR(255) NOT NULL, WMS_INBOUND_PODORDER
                  `ENTRYID` VARCHAR(255) NOT NULL,
                  `ENTRYPOSITIONID` VARCHAR(255) NOT NULL,
                  `SKUID` VARCHAR(255) NOT NULL,
                  `POD_ID` VARCHAR(255) NOT NULL,
                  `POD_FACE` VARCHAR(255) NOT NULL,
                  `POD_LOCATE` VARCHAR(255) NOT NULL,
                  `PODINDEX` INT(11) DEFAULT NULL COMMENT '货架编号',
                  `STATE` VARCHAR(255) COMMENT '状态',
                  `AMOUNT` INT(11) DEFAULT NULL COMMENT '数量',
                  `WAREHOUSE_ID` VARCHAR(255) NOT NULL COMMENT 'FACTORY',
                  `SECTION_ID` VARCHAR(255) DEFAULT NULL COMMENT '物理区域SECTION',*/
                BaseBpo baseBpo  = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_INBOUND_PODORDER);
                baseBpo.addKV("ID",CommonUtils.genUUID());
                baseBpo.addKV("ENTRYID",entryId);
                baseBpo.addKV("ENTRYPOSITIONID",CommonUtils.parseString("ID",map));
                baseBpo.addKV("POD_ID",storageLocation.getPodId());
                baseBpo.addKV("POD_FACE",storageLocation.getPodFace());
                baseBpo.addKV("POD_LOCATE",storageLocation.getLocate());
                baseBpo.addKV("WORKSTATION_ID",stationName);
                baseBpo.addKV("PODINDEX",storageLocation.getPodIndex());
                baseBpo.addKV("AMOUNT",CommonUtils.parseString("AMOUNT",map));
                baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
                baseBpo.addKV("WAREHOUSE_ID",CommonUtils.parseString("WAREHOUSE_ID",map));
                baseBpo.addKV("SECTION_ID",CommonUtils.parseString("SECTION_ID",map));
                //插入货架搬运任务 指令
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }
        }

        return dto;
    }

    public static final String WAREHOUSE = "456e94fe-127d-4861-9948-cc38760801b4";
    /**
     * 定时启动任务
     */
    @Scheduled(fixedDelay = 10*1000L)
    public void startInboundTrip(){
        //6db9c7c0-4f93-4fa1-82c0-fb6435af7aae
        if(isLocked("6db9c7c0-4f93-4fa1-82c0-fb6435af7aae")){
            logger.error("工作站被锁定，无法启动上架任务!");
            return ;
        }

        //TODO 根据工作站查找
        String pods = this.systemPropertiesManager.getProperty("StowPodStationMaxPod", WAREHOUSE);
        List<Map> runningPods = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_RUNNINGPODS, "StowPod", Sql_Table.AVAILABLE);
        Integer limit = Integer.parseInt(pods) - runningPods.size(); //TODO 按工作站区分
        //先找这么多货架 然后加载所有任务
        List<Map> podIds = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODS, "StowPod", Sql_Table.AVAILABLE);
        for (int i = 0; i < podIds.size() && i < limit; i++) {
            Map map =  podIds.get(i);
            String podId = CommonUtils.parseString("POD_ID",map);
            String workStation = CommonUtils.parseString("WORKSTATION_ID",map);
            List<Map> orderPosition = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODORDERS
                    ,podId, Sql_Table.AVAILABLE);
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable("RCS_TRIP");
            String tripId = CommonUtils.genUUID();
            baseBpo.addKV("ID",tripId);
            baseBpo.addKV("POD_ID",podId);
            baseBpo.addKV("TRIP_TYPE","StowPod");
            baseBpo.addKV("WORKSTATION_ID",workStation);
            baseBpo.addKV("TRIP_STATE","New");
            baseBpo.addKV("WAREHOUSE_ID",CommonUtils.parseString("WAREHOUSE_ID",map));
            baseBpo.addKV("SECTION_ID",CommonUtils.parseString("SECTION_ID",map));
            this.jdbcRepository.insertBusinessObject(baseBpo);
            for (int j = 0; j < orderPosition.size(); j++) {
                //如果存在就不要再创建
                Map podOrders = orderPosition.get(j);
                BaseBpo baseBpo2 = new BaseBpo();
                baseBpo2.setTable("RCS_TRIPPOSITION");
                String tripPositionID = CommonUtils.genUUID();
                baseBpo2.addKV("ID",tripPositionID);
                baseBpo2.addKV("TRIP_ID",tripId);
                baseBpo2.addKV("POD_USING_FACE",CommonUtils.parseString("POD_FACE",map));
                baseBpo2.addKV("POSITION_NO",j+1);
                baseBpo2.addKV("WAREHOUSE_ID",CommonUtils.parseString("WAREHOUSE_ID",map));
                baseBpo2.addKV("SECTION_ID",CommonUtils.parseString("SECTION_ID",map));
                this.jdbcRepository.insertBusinessObject(baseBpo2);

                Map newValue = new HashMap();
                newValue.put("STATE", Sql_Table.FINISH);//生成就结束了 是不是执行完看TRIPPOSITION_ID
                newValue.put("TRIPPOSITION_ID", tripPositionID);

                Map con = new HashMap();
                con.put("ID",CommonUtils.parseString("ID",podOrders));

                this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_PODORDER, newValue,con);
            }
        }
    }

    public static final String SQL_NEWSTORAGELOCATION = "SELECT MD_STORAGELOCATION.* FROM MD_STORAGELOCATION,INV_UNITLOAD \n" +
            "WHERE MD_STORAGELOCATION.ID=INV_UNITLOAD.STORAGELOCATION_ID \n" +
            "AND MD_STORAGELOCATION.POD_ID IS NOT NULL AND INV_UNITLOAD.ID NOT IN \n" +
            "(SELECT UNITLOAD_ID from \n" +
            "(SELECT sum(AMOUNT) as SUMALL,UNITLOAD_ID \n" +
            "FROM INV_STOCKUNIT group by UNITLOAD_ID )UNITLOAD WHERE UNITLOAD.SUMALL>0) limit 1";
    private StorageLocation newStorageLocation() {
        List<Map> list = this.jdbcRepository.queryBySql(SQL_NEWSTORAGELOCATION);
        if(list.isEmpty()){
            return null;
        }
        Map row = list.get(0);
        StorageLocation storageLocation = new StorageLocation();
        genStorageLocation(storageLocation,row);
        return storageLocation;
    }

    private StorageLocation findStorageLocation(String skuId) {
        StorageLocation storageLocation = new StorageLocation();
        List<Map> data = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYSTORAGELOCATION_BYSKU,skuId);
        if(data.isEmpty()){
            return null;
        }
        Map row = data.get(0);
        genStorageLocation(storageLocation, row);

        return storageLocation;
    }

    private void genStorageLocation(StorageLocation storageLocation, Map row) {
        //P0000024CC02
        String pName = CommonUtils.parseString("NAME",row);
        String podId = CommonUtils.parseString("POD_ID",row);
        logger.debug("pName:"+pName);
        String locate = pName.substring(9);
        storageLocation.setLocate(locate);
        storageLocation.setPodFace(pName.substring(8,9));
        storageLocation.setPodId(podId);
        storageLocation.setPodIndex(Integer.parseInt(pName.substring(1,8)));
        storageLocation.setpName(pName);
    }

    private synchronized boolean lockStowStation(String stationId) {

        List<Map> stations = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_WORKSTATION,stationId);
        if(stations.isEmpty()){
            return false;
        }
        Map data = stations.get(0);
        Integer version = CommonUtils.parseInteger("VERSION",data);
        Map newValue = new HashMap();
        newValue.put("VERSION",version+1);
        newValue.put("ISCALLPOD",Boolean.TRUE);
        newValue.put("OPEATOR_ID","LISI");
        newValue.put("STAION_NAME","stowPod");

        Map con = new HashMap();
        con.put("WORKSTATION_ID",stationId);
        con.put("VERSION",version);

        int count = this.jdbcRepository.updateRecords(Sql_Table.TABLE_MD_WORKSTATION, newValue ,con);
        return count != 0;
    }
    //用户名写死为 LISI
    private boolean isLocked(String stationId) {
       List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_WORKSTATION, stationId);
       if(rows.isEmpty()){
           return false;
       }
       Map data = rows.get(0);
       String operator_id = CommonUtils.parseString("OPERATOR_ID",data);
       if(!CommonUtils.isEmpty(operator_id)
               && !Objects.equals(operator_id,"LISI")){
           return true;
       }
       return false;
    }

    public MessageDTO endInbound(String stationName) {
        MessageDTO messageDTO = MessageDTO.success();
        /*if(){

        }*/
        return messageDTO;
    }

    public Map currentPodTask(String stationName) {
        Map dto = new HashMap();
        //如果没有锁定 就没有任务
        if(isLocked(stationName) ){
            dto.put("CODE",1);
            dto.put("MSG","工作站"+stationName+"被占用，没有当前任务!");
            return dto;
        }

        List<Map> datas = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_CURRENTPODTASK,
                Sql_Table.AVAILABLE, Sql_Table.PROCESS, Sql_Table.PROCESS,stationName);

        if(datas.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前在工作站的货架");
            return dto;
        }

        Map data = datas.get(0);
        /*`ID` varchar(255) NOT NULL,
          `ENTRYID` varchar(255) NOT NULL,
          `ENTRYPOSITIONID` varchar(255) NOT NULL,
          `SKUID` varchar(255) NOT NULL,
          `POD_ID` varchar(255) NOT NULL,
          `POD_FACE` varchar(255) NOT NULL,
          `POD_LOCATE` varchar(255) NOT NULL,
          `PODINDEX` int(11) DEFAULT NULL COMMENT '货架编号',
          `STATE` varchar(255) COMMENT '状态',*/
        String skuId = CommonUtils.parseString("SKUID",data);
        List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId);
        if (skus.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前上架商品信息, SKU:"+skuId);
            return dto;
        }
        Map sku = skus.get(0);
        data.put("SKUNAME",CommonUtils.parseString("NAME",sku));

        return data;
    }
}
