package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Lisi on 2019-11-30.
 */
@Service
public class OutboundService {

    @Autowired
    private JdbcRepository jdbcRepository;

    //2、如果对应CUSTOMERSHIPMENTPOSITION都完成 将主表更新为Finish 等待下次循环
    //这样不修改出库的代码
    @Scheduled (fixedDelay = 10*1000L)
    public void checkAndResponse(){
        List<Map> finishedObps =
                this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_OBORDER);
        for (int i = 0; i < finishedObps.size(); i++) {
            Map obs = finishedObps.get(i);
            Map newValue = new HashMap();
            newValue.put("STATE",Sql_Table.FINISH);
            newValue.put("PICKED",CommonUtils.parseInteger("AMOUNT_PICKED",obs));
            CommonUtils.modifyUselessInfo(newValue);

            Map con = new HashMap();
            con.put("ID",CommonUtils.parseString("ID",obs));

            this.jdbcRepository.updateRecords(Sql_Table.TABLE_OUTBOUND_ORDERPOSITION, newValue, con);
        }

        //如果明细都已结束 将主表更新为已完成，减少操作时的判断
        List<Map> list = this.jdbcRepository
                .queryBySql(Sql_Table.SQL_OUTBOUNDORDERPOSITION_BYSTATE);
        for (int i = 0; i < list.size(); i++) {
            Map rows = list.get(i);
            Map newValue = new HashMap();
            newValue.put("STATE", Sql_Table.FINISH);
            newValue.put("NEED_RESP", 1);
            CommonUtils.modifyUselessInfo(newValue);
            Map con = new HashMap();
            con.put("ORDERID",CommonUtils.parseString("ORDERID",rows));

            this.jdbcRepository.updateRecords(Sql_Table.WMS_OUTBOUND_ORDER,newValue,con);
        }
    }
}
