package com.mushiny.heli.xnr.mq;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * Created by Lisi on 2019-12-12.
 */
@Component
public class MqSender implements RabbitTemplate.ConfirmCallback {

    private final static Logger logger = LoggerFactory.getLogger(MqSender.class);


    private RabbitTemplate rabbitTemplate;


    @Autowired
    public MqSender(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public void sendMsg(String message, String exchange, String route) {
        CorrelationData correlationId = new CorrelationData(UUID.randomUUID().toString());
        rabbitTemplate.convertAndSend(exchange, route, message, correlationId);
        logger.debug("成功往exchange:"+exchange+" route:"+route+" 发送消息:"+message);
    }

    @Override
    public void confirm(CorrelationData correlationData, boolean b, String s) {
        logger.debug("confirm String:" + s);
    }
}

