package com.mushiny.heli.xnr.wcs;

/**
 * Created by Lisi on 2019-12-13.
 */

import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import com.mushiny.heli.xnr.service.Sql_Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
public class WmsToWcsService{
    private  final Logger logger = LoggerFactory.getLogger(WmsToWcsService.class);

    @Value("${wcs.getPods}")
    private String getPodAmountUrl;

    @Value("${wcs.callPod}")
    private String callPodUrl;

    @Value("${wcs.superCarryPod}")
    private String superCarryPod;

    @Value("${wcs.releasePod}")
    private String releasePod;

    @Value("${wcs.agvTaskDetail}")
    private String agvTaskDetail;

    @Autowired
    private WmsToWcsBusiness wmsToWcsBusiness;

    @Autowired
    private ExecutorHandler executorHandler;

    @Autowired
    private JdbcRepository jdbcRepository;

    //通过wcs接口获取当前工作站任务数量
    public int getEnroutedPodAmount(Map station) {
        String token = wmsToWcsBusiness.getTokenFromWcs();
        if("".equals(token)){
            logger.info("获取wcs token失败");
            return 0;
        }

        token = "Bearer " + token;

        int amount = 0;
        Map<String, Object> getPodsMap = new HashMap<>();
        getPodsMap.put("sectionId", CommonUtils.parseInteger("sectionId",station));
        getPodsMap.put("stopCellId", CommonUtils.parseInteger("stopCellId",station));
        getPodsMap.put("direction", CommonUtils.parseInteger("direction",station));

        logger.info("查询工作站={} 在途pod数量，参数是：params = {}.",station, getPodsMap.toString());
        try {

            String  result = executorHandler.postForObject(getPodAmountUrl, JsonUtils.map2Json(getPodsMap),token);
            logger.info("通过wcs接口获取当前工作站任务数量 ：{}",result);

            if(result != null && !"".equals(result)){

                amount = Integer.parseInt(result);
            }
        }catch (Exception e){
            logger.info("通过wcs接口获取当前工作站任务数量  +++++++++++出现异常。",e,e.getMessage());
        }

        return amount;
    }

    public String agvTaskDetail(String taskId){
        String token = wmsToWcsBusiness.getTokenFromWcs();
        if ("".equals(token)) {
            logger.info("获取wcs token失败");
            return null;
        }
        Map<String, Object> taskMap = new HashMap<>();
        taskMap.put("taskId", taskId);
        return executorHandler.getForObject(this.agvTaskDetail,taskMap,token);
    }

    public String sendSingleTripToWcs(Integer podIndex,
                                      Integer sectionId,
                                      Integer stopCellId,
                                      Integer direction,
                                      Integer face) {
        String token = wmsToWcsBusiness.getTokenFromWcs();
        if ("".equals(token)) {
            logger.info("获取wcs token失败");
            return null;
        }
        token = "Bearer " + token;
        Map<String, Object> taskMap = new HashMap<>();
        taskMap.put("sectionId", sectionId);
        taskMap.put("podId", podIndex);
        taskMap.put("stopCellId", stopCellId);
        taskMap.put("direction", direction);
        taskMap.put("targetDirection", face);

        String taskIdFromWcs = executorHandler.postForObject(this.callPodUrl,
                JsonUtils.map2Json(taskMap), token);

        logger.info("发送调度任务，wcs返回taskId：{}", taskIdFromWcs);

        Map<String, String> resultMap = JsonUtils.json2Map(taskIdFromWcs);

        String taskId = "";
        if (resultMap != null
                && resultMap.get("taskId") != null) {
            taskId = resultMap.get("taskId");
        }

        if (CommonUtils.isEmpty(taskId)) {
            logger.info("发送{}的face{}调度任务时，获取taskId失败。。。", podIndex, face);
            throw  new RuntimeException("任务失败 pod:"+podIndex+" face:"+face);
        }
       return taskId;
    }

    @Transactional
    public String releasePod(String taskId) {
        String token = wmsToWcsBusiness.getTokenFromWcs();
        if("".equals(token)){
            logger.info("获取wcs token失败");
            return "no token";
        }
        token = "Bearer " + token;
        Map<String, Object> taskMap = new HashMap<>();
        taskMap.put("taskId", taskId);
        return this.executorHandler.getMethod(this.releasePod, taskMap, token);
    }


    @Transactional
    public void releasePod(String workStationId,Integer podIndex) {
        logger.info("工作站 = {} 释放pod = {} ",workStationId,podIndex);
        //先查询该停止点是否有任务
        Map podStation = this.getByWorkStationIdAndPodIndex(workStationId);

        if(podStation == null){
            logger.info("工作站 ：{} 没有pod ： {} ,无法释放。。",workStationId, podIndex);
            return;
        }

        String token = wmsToWcsBusiness.getTokenFromWcs();
        if("".equals(token)){
            logger.info("获取wcs token失败");
            return;
        }
        token = "Bearer " + token;
        Map<String, Object> taskMap = new HashMap<>();
        taskMap.put("taskId", CommonUtils.parseString("TRIP_TASKID",podStation));
        this.executorHandler.getForObject(this.releasePod, taskMap, token);
        logger.info("工作站 = {} 释放pod = {} ，wcs返回taskId：{}", workStationId, podIndex);

        //更显pod状态
        String sectionId = CommonUtils.parseString("SECTION_ID",podStation);
        updatePodState(podIndex,sectionId, Sql_Table.AVAILABLE);
    }

    private Map getPodByIndexAndSection(Integer podIndex, String sectionId) {
        return this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERYPODBYINDEX, sectionId, podIndex);
    }

    private Map getByWorkStationIdAndPodIndex(String workStationId) {
        logger.debug("条件 workStationId :"+workStationId);
        Map data = this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERY_CURRENTPOD, workStationId);
        if(data == null){
            return null;
        }
        return data;
    }



    private void updatePodState(Integer podId, String sectionId,String status) {
        Map newValue = new HashMap();
        newValue.put("STATE",Sql_Table.AVAILABLE);
        CommonUtils.modifyUselessInfo(newValue);

        Map con = new HashMap();
        con.put("SECTION_ID",sectionId);
        con.put("POD_INDEX",podId);

        this.jdbcRepository.updateRecords("MD_POD",newValue,con);
    }


}
