package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.DateUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.*;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import com.mushiny.heli.xnr.wcs.WmsToWcsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Lisi @ 2019-11-18
 */
@Service
public class WMSService {


    @Autowired
    private JdbcRepository jdbcRepository;

    private final static Logger logger = LoggerFactory.getLogger(WMSService.class);

    @Autowired
    private WmsToWcsService wmsToWcsService;


    @Transactional
    public void saveInboundOrder(InboundOrderDTO inboundOrderDTO){
        List<InboundOrderPosition> data = inboundOrderDTO.getDATA();
        for (int i = 0; i < data.size(); i++) {
            InboundOrderPosition inboundOrderPosition =  data.get(i);
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDERPOSITION);
            baseBpo.setIdName("ID");
            baseBpo.addKV("ENTRYID",inboundOrderDTO.getENTRYID());
            baseBpo.addKV("AMOUNT",inboundOrderPosition.getAMOUNT());
            baseBpo.addKV("SKUID",inboundOrderPosition.getSKUID());
            baseBpo.addKV("ID",CommonUtils.genUUID());
            baseBpo.addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(inboundOrderDTO.getFACTORY()));
            baseBpo.addKV("SECTION_ID",CommonUtils.getSection(inboundOrderDTO.getSECTION()));
            baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
            //baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
            //增加了订单上架的序号 按入库单序号来
            this.jdbcRepository.insertBusinessObject(baseBpo);
        }

        BaseBpo baseBpo = new BaseBpo();

        baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDER);
        baseBpo.setIdName("ENTRYID");
        baseBpo.addKV("TIMES",inboundOrderDTO.getTIMES());
        baseBpo.addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(inboundOrderDTO.getFACTORY()));
        baseBpo.addKV("SECTION_ID",CommonUtils.getSection(inboundOrderDTO.getSECTION()));
        baseBpo.addKV("ENTRYID",inboundOrderDTO.getENTRYID());
        this.jdbcRepository.insertBusinessObject(baseBpo);
    }
    @Transactional
    public void saveOutboundOrder(OutboundOrderDTO outboundOrderDTO) {
        List<OutboundOrderPosition> data = outboundOrderDTO.getDATA();
        //1、保存到OB_CUSTOMERSHIPMENT表
        BaseBpo cs = new BaseBpo();
        cs.setTable(Sql_Table.TABLE_OB_CUSTOMERSHIPMENT);
        String csid = CommonUtils.genUUID();
        cs.addKV("ID",csid);
        /* `SHIPMENT_NO` varchar(255) NOT NULL DEFAULT '' COMMENT '订单拆分后的编号',
          `PRIORITY` int(11) NOT NULL COMMENT '优先等级',
          `STATE` int(11) NOT NULL COMMENT '状态',
          `PASSED_OVER_COUNT` int(11) NOT NULL COMMENT '未选中的次数',
          `ACTIVATED` bit(1) NOT NULL COMMENT '是否激活',
          `SELECTED` bit(1) NOT NULL COMMENT '是否进入Select Window',
          `COMPLETED` bit(1) NOT NULL COMMENT '是否已全部分配拣货任务',
         `WAREHOUSE_ID` varchar(255) NOT NULL,*/
        cs.addKV("SHIPMENT_NO",outboundOrderDTO.getORDERID());
        cs.addKV("PRIORITY", 1);
        cs.addKV("STATE", 0);
        cs.addKV("PASSED_OVER_COUNT", 0);
        cs.addKV("ACTIVATED", Boolean.FALSE);
        cs.addKV("SELECTED", Boolean.FALSE);
        cs.addKV("COMPLETED", Boolean.FALSE);
        cs.addKV("WAREHOUSE_ID", CommonUtils.getWarehouse(outboundOrderDTO.getFACTORY()));
        cs.addKV("CLIENT_ID", CommonUtils.getClient(outboundOrderDTO.getFACTORY()));
        cs.addKV("TYPE", "Customer");
        //新增一条记录
        this.jdbcRepository.insertBusinessObject(cs);

        for (int i = 0; i < data.size(); i++) {
            OutboundOrderPosition outboundOrderPosition =  data.get(i);
            //2、保存到OB_CUSTOMERSHIPMENTPOSITION表
            BaseBpo csp = new BaseBpo();
            csp.setTable(Sql_Table.TABLE_OB_CUSTOMERSHIPMENTPOSITION);
            String cspId = CommonUtils.genUUID();
            csp.addKV("ID",cspId);
            /*  `AMOUNT` decimal(17,4) NOT NULL DEFAULT '0.0000' COMMENT '数量',
              `STATE` int(11) NOT NULL COMMENT '状态',
              `ITEMDATA_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品',
              `SHIPMENT_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '订单编号',
              `POSITION_NO` int(11) NOT NULL COMMENT '详细编号',
              `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
              `CLIENT_ID` varchar(255) NOT NULL,
              `WAREHOUSE_ID` varchar(255) NOT NULL,*/
            csp.addKV("STATE",0);//600就是完成
            List<Map> items = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO,
                    outboundOrderPosition.getSKUID());
            Map item = items.get(0);
            String mID = CommonUtils.parseString("ID",item);
            csp.addKV("ITEMDATA_ID",mID);
            csp.addKV("SHIPMENT_ID",csid);
            csp.addKV("POSITION_NO",i+1);
            csp.addKV("ORDER_INDEX",i+1);
            csp.addKV("WAREHOUSE_ID", CommonUtils.getWarehouse(outboundOrderDTO.getFACTORY()));
            csp.addKV("CLIENT_ID", CommonUtils.getClient(outboundOrderDTO.getFACTORY()));
            this.jdbcRepository.insertBusinessObject(csp);

            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.WMS_OUTBOUND_ORDERPOSITION);
            baseBpo.setIdName("ID");
            baseBpo.addKV("ID",CommonUtils.genUUID());
            baseBpo.addKV("ORDERID",outboundOrderDTO.getORDERID());
            baseBpo.addKV("AMOUNT",outboundOrderPosition.getAMOUNT());
            baseBpo.addKV("SKUID",outboundOrderPosition.getSKUID());
            baseBpo.addKV("SHIPMENTID",outboundOrderPosition.getSHIPMENTID());
            baseBpo.addKV("SHIPMENTPOSITION_ID", cspId);
            baseBpo.addKV("WAREHOUSE_ID", CommonUtils.getWarehouse(outboundOrderDTO.getFACTORY()));
            baseBpo.addKV("CLIENT_ID", CommonUtils.getClient(outboundOrderDTO.getFACTORY()));
            this.jdbcRepository.insertBusinessObject(baseBpo);
        }

        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setTable(Sql_Table.WMS_OUTBOUND_ORDER);
        baseBpo.setIdName("ORDERID");
        baseBpo.addKV("TIMES",outboundOrderDTO.getTIMES());
        baseBpo.addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(outboundOrderDTO.getFACTORY()));
        baseBpo.addKV("SECTION_ID",CommonUtils.getSection(outboundOrderDTO.getSECTION()));
        baseBpo.addKV("ORDERID",outboundOrderDTO.getORDERID());
        this.jdbcRepository.insertBusinessObject(baseBpo);
    }
    /*  `ID` varchar(255) NOT NULL,
  `ITEM_NO` varchar(255) NOT NULL DEFAULT '' COMMENT '唯一编码',
  `SKU_NO` varchar(255) DEFAULT '' COMMENT 'SKU',
  `NAME` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `SAFETY_STOCK` int(11) NOT NULL COMMENT '安全库存',
  `LOT_MANDATORY` bit(1) NOT NULL COMMENT '是否有效期商品',
  `SERIAL_RECORD_TYPE` varchar(255) NOT NULL DEFAULT '' COMMENT '商品的序列号码有规则的设置', NO_RECORD
  `HEIGHT` decimal(15,2) DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15,2) DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15,2) DEFAULT NULL COMMENT '宽',
  `MULTIPLE_PART` bit(1) NOT NULL COMMENT '是否一套',
  `MULTIPLE_PART_AMOUNT` int(11) NOT NULL COMMENT '几套几件',
  `MEASURED` bit(1) NOT NULL COMMENT '是否测量',
  `PREFER_OWNBOX` bit(1) NOT NULL COMMENT '是否自带包装',
  `PREFER_BAG` bit(1) NOT NULL COMMENT '是否用袋子',
  `USE_BUBBLEFILM` bit(1) NOT NULL COMMENT '是否使用气垫膜',
  `ITEMGROUP_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品类型',
  `HANDLINGUNIT_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品单位',
  `VERSION` int(11) NOT NULL,*/

    @Value("${xnr.stationId}")
    public static String stationId = "3ba41fe1-6b95-4849-8e50-31995ade08b0";

    /*保存到商品信息表*/
    @Value("${xnr.item_group}")
    public static final String ITEM_GROUP = "fd335ce3-1b83-4819-81d9-34f8aa5a2139";
    @Value("${xnr.handling_unit_id}")
    public static final String HANDLING_UNIT_ID = "d7599399-3da6-478c-b14d-60e6be6ef11e";

    public void syncItem(ItemDTO itemDTO) {

        List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, itemDTO.getSKUID());

        List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYID, itemDTO.getSKUID());
        if (skus.isEmpty() && rows.isEmpty()){
            //新建一条
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.TABLE_MD_ITEMDATA);
            baseBpo.addKV("ID",itemDTO.getSKUID()).addKV("ITEM_NO",itemDTO.getSKUID())/*.addKV("SKU_NO",itemDTO.getSKUID())*/;
            baseBpo.addKV("NAME",itemDTO.getSNAME()).addKV("LOT_MANDATORY",0).addKV("SERIAL_RECORD_TYPE","NO_RECORD");
            baseBpo.addKV("HEIGHT",itemDTO.getHEIGHT()).addKV("WIDTH",itemDTO.getWIDTH()).addKV("DEPTH",itemDTO.getLENGTH());
            baseBpo.addKV("MULTIPLE_PART",Boolean.FALSE).addKV("MULTIPLE_PART_AMOUNT",0).addKV("MEASURED",Boolean.TRUE);
            baseBpo.addKV("PREFER_OWNBOX",Boolean.FALSE).addKV("PREFER_BAG",Boolean.FALSE).addKV("USE_BUBBLEFILM",Boolean.FALSE);
            baseBpo.addKV("ITEMGROUP_ID",ITEM_GROUP).addKV("HANDLINGUNIT_ID",HANDLING_UNIT_ID).addKV("VERSION",itemDTO.getSTATUS());
            baseBpo.addKV("CLIENT_ID",CommonUtils.getClient(itemDTO.getFACTORY()))
                    .addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(itemDTO.getFACTORY()));
            baseBpo.addKV("SAFETY_STOCK",0);
            //增加工厂和仓库 一个工厂多个仓库 一个工厂我们认为是CLIENT_ID户主 一个WAREHOUSE_ID是一个仓库
            BaseBpo baseBpo2 = new BaseBpo();
            baseBpo2.setTable(Sql_Table.TABLE_MD_ITEMDATA_SKUNO);
            baseBpo2.addKV("CLIENT_ID",itemDTO.getFACTORY()).addKV("ITEM_NO",itemDTO.getSKUID()).addKV("SKU_NO",itemDTO.getSKUID());
            baseBpo2.addKV("ID",CommonUtils.genUUID());
            this.jdbcRepository.insertBusinessObject(baseBpo);
            this.jdbcRepository.insertBusinessObject(baseBpo2);
        }else{
            //根据ID更新 ID暂定跟SKU_NO ITEM_NO 一样
            BaseBpo baseBpo = new BaseBpo();
            //baseBpo.addKV("ID",itemDTO.getSKUID()).addKV("ITEM_NO",itemDTO.getSKUID()).addKV("SKU_NO",itemDTO.getSKUID());
            baseBpo.addKV("NAME",itemDTO.getSNAME()).addKV("LOT_MANDATORY",0).addKV("SERIAL_RECORD_TYPE","NO_RECORD");
            baseBpo.addKV("HEIGHT",itemDTO.getHEIGHT()).addKV("WIDTH",itemDTO.getWIDTH()).addKV("DEPTH",itemDTO.getLENGTH());
            baseBpo.addKV("MULTIPLE_PART",Boolean.FALSE).addKV("MULTIPLE_PART_AMOUNT",0).addKV("MEASURED",Boolean.TRUE);
            baseBpo.addKV("PREFER_OWNBOX",Boolean.FALSE).addKV("PREFER_BAG",Boolean.FALSE).addKV("USE_BUBBLEFILM",Boolean.FALSE);
            baseBpo.addKV("ITEMGROUP_ID",ITEM_GROUP).addKV("HANDLINGUNIT_ID",HANDLING_UNIT_ID).addKV("VERSION",itemDTO.getSTATUS());
            baseBpo.addKV("CLIENT_ID",CommonUtils.getClient(itemDTO.getFACTORY()))
                    .addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(itemDTO.getFACTORY()));
            baseBpo.setIdName("ID");
            baseBpo.setTable(Sql_Table.TABLE_MD_ITEMDATA);
            baseBpo.setId(itemDTO.getSKUID());

            this.jdbcRepository.updateBusinessObject(baseBpo);
        }

    }

    public MessageDTO createICQAOrder(Map data) {
        MessageDTO messageDTO = MessageDTO.success();
        BaseBpo order = new BaseBpo();
        order.setTable(Sql_Table.WMS_ICQA_ORDER);
        String orderId = this.createIcqaUUID();//CommonUtils.genUUID();
        order.addKV("TASKID", orderId);
        //order.addKV("CREATED_DATE",new Date(System.currentTimeMillis()));
        //order.addKV("FACTORY",CommonUtils.parseString("FACTORY",data));
        order.addKV("SECTION_ID",CommonUtils.getClient(CommonUtils.parseString("SECTION",data)))
                .addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(CommonUtils.parseString("FACTORY",data)));
        order.addKV("STATE",Sql_Table.AVAILABLE);
        order.addKV("NEED_RESP", 0);
        CommonUtils.genUselessInfo(order.getKv());
        //"type":"all"
        if(Objects.equals(CommonUtils.parseString("type", data), Sql_Table.ALL_TYPE)){
            order.addKV("TYPE",Sql_Table.ALL_TYPE);
            //检查是否有全盘在执行 如果没完成不能再生成
            List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_BY_TYPE,"Finish");
            if(rows!=null && rows.size()>0){
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("已有全库盘点任务,不能再次生成!");
                return messageDTO;
            }

            //全盘 所有SKU生成盘点任务
            List<Map> items= this.jdbcRepository.queryBySql(Sql_Table.SQL_FINDALLITEM
                    ,CommonUtils.parseString("FACTORY",data)
                    ,CommonUtils.parseString("FACTORY",data));
            for (int i = 0; i < items.size(); i++) {
                Map map = items.get(i);
                BaseBpo baseBpo = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_ICQA_ORDERPOSITION);
                baseBpo.addKV("TASKID",orderId).addKV("ID",CommonUtils.genUUID())
                        .addKV("SKUID",CommonUtils.parseString("ITEM_NO",map));
                //增加几条字段
                //baseBpo.addKV("STATE",Sql_Table.NEW);
                baseBpo.addKV("AMOUNT", 0);//创建时当前库存都是0
                baseBpo.addKV("SECTION_ID",CommonUtils.getClient(CommonUtils.parseString("SECTION",data)))
                        .addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(CommonUtils.parseString("FACTORY",data)));
                baseBpo.addKV("STATE",Sql_Table.AVAILABLE);
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }

        }else{
            //从 DATA选sku
            order.addKV("TYPE",Sql_Table.SKU_TYPE);//两种类型
            List<String> skus = (List<String>) data.get("DATA");
            //查找所有存在盘点任务的SKU过滤
            List<Map> allTaskingSKU = this.jdbcRepository.queryBySql(Sql_Table.SQL_ALL_TASKING_SKU,
                    Sql_Table.FINISH);
            Set<String> allSku = this.list2Set(allTaskingSKU);
            List exist = new ArrayList();
            for (int i = 0; i < skus.size(); i++) {
                String skuId = skus.get(i);
                if(allSku.contains(skuId)){
                    logger.debug("SKU已存在盘点任务:" + skuId);
                    exist.add(skuId);
                }
            }
            if(!exist.isEmpty()){
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("以下"+JsonUtils.list2Json(exist)+"盘点任务未完成!");
                return messageDTO;
            }
            //没有存在的盘点任务就生成
            for (int i = 0; i < skus.size(); i++) {
                String skuId = skus.get(i);
                if(allSku.contains(skuId)){
                    logger.debug("SKU已存在盘点任务:" + skuId);
                    continue;
                }



                BaseBpo baseBpo = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_ICQA_ORDERPOSITION);
                baseBpo.addKV("TASKID",orderId).addKV("ID",CommonUtils.genUUID())
                        .addKV("SKUID",skuId);
                //增加几条字段
                baseBpo.addKV("STATE",Sql_Table.AVAILABLE);
                baseBpo.addKV("AMOUNT", 0);//创建时当前库存都是0
                baseBpo.addKV("SECTION_ID",CommonUtils.getClient(CommonUtils.parseString("SECTION",data)))
                        .addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(CommonUtils.parseString("FACTORY",data)));
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }

        }
        this.jdbcRepository.insertBusinessObject(order);
        return messageDTO;
    }

    private String createIcqaUUID() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ICQA-");
        String date = DateUtils.date2String(new Date(System.currentTimeMillis()));
        stringBuffer.append(date).append("-");
        String radom = String.format("%04d",new Random().nextInt(9999));
        stringBuffer.append(radom);
        return stringBuffer.toString();
    }

    private Set<String> list2Set(List<Map> allTaskingSKU) {
        Set set = new HashSet();
        for (int i = 0; i < allTaskingSKU.size(); i++) {
            Map map = allTaskingSKU.get(i);
            set.add(map.get("SKUID"));
        }
        return set;
    }

    /**
     *
     * @param req
     */
    public void podRelease(Map req) {
        //货架号（数字）、工作站号(ID)/ SectionID
        Integer podIndex = CommonUtils.parseInteger("podIndex", req);
        String stationId = CommonUtils.parseString("stationName",req);
        //String sectionId = CommonUtils.parseString("sectionId",req);
        this.wmsToWcsService.releasePod(stationId,podIndex);
    }

    /**
     *
     */
    public int unlock() {
        //货架号（数字）、工作站号(ID)/ SectionID
        Map newValue = new HashMap();
        newValue.put("ISCALLPOD",Boolean.FALSE);
        newValue.put("OPERATOR_ID","");
        newValue.put("STATION_NAME","");

        Map con = new HashMap();
        con.put("ID", this.stationId);

        int count = this.jdbcRepository.updateRecords(Sql_Table.TABLE_MD_WORKSTATION, newValue ,con);
        return count;
    }
}
