package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.*;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Date;
import java.util.*;

/**
 * Lisi @ 2019-11-18
 */
@Service
public class WMSService {


    @Autowired
    private JdbcRepository jdbcRepository;

    private final static Logger logger = LoggerFactory.getLogger(WMSService.class);


    @Transactional
    public void saveInboundOrder(InboundOrderDTO inboundOrderDTO){
        List<InboundOrderPosition> data = inboundOrderDTO.getDATA();
        for (int i = 0; i < data.size(); i++) {
            InboundOrderPosition inboundOrderPosition =  data.get(i);
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDERPOSITION);
            baseBpo.setIdName("ID");
            baseBpo.addKV("ENTRYID",inboundOrderDTO.getENTRYID());
            baseBpo.addKV("AMOUNT",inboundOrderPosition.getAMOUNT());
            baseBpo.addKV("SKUID",inboundOrderPosition.getSKUID());
            baseBpo.addKV("ID",CommonUtils.genUUID());
            baseBpo.addKV("WAREHOUSE_ID",inboundOrderDTO.getFACTORY());
            baseBpo.addKV("SECTION_ID",inboundOrderDTO.getSECTION());
            baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
            this.jdbcRepository.insertBusinessObject(baseBpo);
        }

        BaseBpo baseBpo = new BaseBpo();

        baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDER);
        baseBpo.setIdName("ENTRYID");
        baseBpo.addKV("TIMES",inboundOrderDTO.getTIMES());
        baseBpo.addKV("WAREHOUSE_ID",inboundOrderDTO.getFACTORY());
        baseBpo.addKV("SECTION_ID",inboundOrderDTO.getSECTION());
        baseBpo.addKV("ENTRYID",inboundOrderDTO.getENTRYID());
        this.jdbcRepository.insertBusinessObject(baseBpo);
    }
    @Transactional
    public void saveOutboundOrder(OutboundOrderDTO outboundOrderDTO) {
        List<OutboundOrderPosition> data = outboundOrderDTO.getDATA();
        for (int i = 0; i < data.size(); i++) {
            OutboundOrderPosition outboundOrderPosition =  data.get(i);
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.WMS_OUTBOUND_ORDERPOSITION);
            baseBpo.setIdName("ID");
            baseBpo.addKV("ID",CommonUtils.genUUID());
            baseBpo.addKV("ORDERID",outboundOrderDTO.getORDERID());
            baseBpo.addKV("AMOUNT",outboundOrderPosition.getAMOUNT());
            baseBpo.addKV("SKUID",outboundOrderPosition.getSKUID());
            baseBpo.addKV("SHIPMENTID",outboundOrderPosition.getSHIPMENTID());
            baseBpo.addKV("WAREHOUSE_ID",outboundOrderDTO.getFACTORY());
            baseBpo.addKV("SECTION_ID",outboundOrderDTO.getSECTION());
            this.jdbcRepository.insertBusinessObject(baseBpo);
        }

        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setTable(Sql_Table.WMS_OUTBOUND_ORDER);
        baseBpo.setIdName("ORDERID");
        baseBpo.addKV("TIMES",outboundOrderDTO.getTIMES());
        baseBpo.addKV("WAREHOUSE_ID",outboundOrderDTO.getFACTORY());
        baseBpo.addKV("SECTION_ID",outboundOrderDTO.getSECTION());
        baseBpo.addKV("ORDERID",outboundOrderDTO.getORDERID());
        this.jdbcRepository.insertBusinessObject(baseBpo);
    }
    /*  `ID` varchar(255) NOT NULL,
  `ITEM_NO` varchar(255) NOT NULL DEFAULT '' COMMENT '唯一编码',
  `SKU_NO` varchar(255) DEFAULT '' COMMENT 'SKU',
  `NAME` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `SAFETY_STOCK` int(11) NOT NULL COMMENT '安全库存',
  `LOT_MANDATORY` bit(1) NOT NULL COMMENT '是否有效期商品',
  `SERIAL_RECORD_TYPE` varchar(255) NOT NULL DEFAULT '' COMMENT '商品的序列号码有规则的设置', NO_RECORD
  `HEIGHT` decimal(15,2) DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15,2) DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15,2) DEFAULT NULL COMMENT '宽',
  `MULTIPLE_PART` bit(1) NOT NULL COMMENT '是否一套',
  `MULTIPLE_PART_AMOUNT` int(11) NOT NULL COMMENT '几套几件',
  `MEASURED` bit(1) NOT NULL COMMENT '是否测量',
  `PREFER_OWNBOX` bit(1) NOT NULL COMMENT '是否自带包装',
  `PREFER_BAG` bit(1) NOT NULL COMMENT '是否用袋子',
  `USE_BUBBLEFILM` bit(1) NOT NULL COMMENT '是否使用气垫膜',
  `ITEMGROUP_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品类型',
  `HANDLINGUNIT_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品单位',
  `VERSION` int(11) NOT NULL,*/
    /*保存到商品信息表*/
    public static final String ITEM_GROUP = "fd335ce3-1b83-4819-81d9-34f8aa5a2139";
    public static final String HANDLING_UNIT_ID = "d7599399-3da6-478c-b14d-60e6be6ef11e";
    public void syncItem(ItemDTO itemDTO) {
        List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, itemDTO.getSKUID());

        List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYID, itemDTO.getSKUID());
        if (skus.isEmpty() || rows.isEmpty()){
            //新建一条
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.TABLE_MD_ITEMDATA);
            baseBpo.addKV("ID",itemDTO.getSKUID()).addKV("ITEM_NO",itemDTO.getSKUID())/*.addKV("SKU_NO",itemDTO.getSKUID())*/;
            baseBpo.addKV("NAME",itemDTO.getSNAME()).addKV("LOT_MANDATORY",0).addKV("SERIAL_RECORD_TYPE","NO_RECORD");
            baseBpo.addKV("HEIGHT",itemDTO.getHEIGHT()).addKV("WIDTH",itemDTO.getWIDTH()).addKV("DEPTH",itemDTO.getLENGTH());
            baseBpo.addKV("MULTIPLE_PART",Boolean.FALSE).addKV("MULTIPLE_PART_AMOUNT",0).addKV("MEASURED",Boolean.TRUE);
            baseBpo.addKV("PREFER_OWNBOX",Boolean.FALSE).addKV("PREFER_BAG",Boolean.FALSE).addKV("USE_BUBBLEFILM",Boolean.FALSE);
            baseBpo.addKV("ITEMGROUP_ID",ITEM_GROUP).addKV("HANDLINGUNIT_ID",HANDLING_UNIT_ID).addKV("VERSION",itemDTO.getSTATUS());
            baseBpo.addKV("CLIENT_ID",itemDTO.getFACTORY()).addKV("WAREHOUSE_ID",itemDTO.getSECTION());
            baseBpo.addKV("SAFETY_STOCK",0);
            //增加工厂和仓库 一个工厂多个仓库 一个工厂我们认为是CLIENT_ID户主 一个WAREHOUSE_ID是一个仓库
            BaseBpo baseBpo2 = new BaseBpo();
            baseBpo2.setTable(Sql_Table.TABLE_MD_ITEMDATA_SKUNO);
            baseBpo2.addKV("CLIENT_ID",itemDTO.getFACTORY()).addKV("ITEM_NO",itemDTO.getSKUID()).addKV("SKU_NO",itemDTO.getSKUID());
            baseBpo2.addKV("ID",CommonUtils.genUUID());
            this.jdbcRepository.insertBusinessObject(baseBpo);
        }else{
            //根据ID更新 ID暂定跟SKU_NO ITEM_NO 一样
            BaseBpo baseBpo = new BaseBpo();
            //baseBpo.addKV("ID",itemDTO.getSKUID()).addKV("ITEM_NO",itemDTO.getSKUID()).addKV("SKU_NO",itemDTO.getSKUID());
            baseBpo.addKV("NAME",itemDTO.getSNAME()).addKV("LOT_MANDATORY",0).addKV("SERIAL_RECORD_TYPE","NO_RECORD");
            baseBpo.addKV("HEIGHT",itemDTO.getHEIGHT()).addKV("WIDTH",itemDTO.getWIDTH()).addKV("DEPTH",itemDTO.getLENGTH());
            baseBpo.addKV("MULTIPLE_PART",Boolean.FALSE).addKV("MULTIPLE_PART_AMOUNT",0).addKV("MEASURED",Boolean.TRUE);
            baseBpo.addKV("PREFER_OWNBOX",Boolean.FALSE).addKV("PREFER_BAG",Boolean.FALSE).addKV("USE_BUBBLEFILM",Boolean.FALSE);
            baseBpo.addKV("ITEMGROUP_ID",ITEM_GROUP).addKV("HANDLINGUNIT_ID",HANDLING_UNIT_ID).addKV("VERSION",itemDTO.getSTATUS());
            baseBpo.addKV("CLIENT_ID",itemDTO.getFACTORY()).addKV("WAREHOUSE_ID",itemDTO.getSECTION());
            baseBpo.setIdName("ID");
            baseBpo.setTable(Sql_Table.TABLE_MD_ITEMDATA);
            baseBpo.setId(itemDTO.getSKUID());

            this.jdbcRepository.updateBusinessObject(baseBpo);
        }

    }

    public MessageDTO createICQAOrder(Map data) {
        MessageDTO messageDTO = MessageDTO.success();
        BaseBpo order = new BaseBpo();
        order.setTable(Sql_Table.WMS_ICQA_ORDER);
        String orderId = CommonUtils.genUUID();
        order.addKV("ICQAID", orderId);
        order.addKV("CREATED_DATE",new Date(System.currentTimeMillis()));
        order.addKV("FACTORY",CommonUtils.parseString("FACTORY",data));
        order.addKV("SECTION",CommonUtils.parseString("SECTION",data));
        order.addKV("SECTION",CommonUtils.parseString("SECTION",data));

        if(CommonUtils.parseInteger("ALL",data)==1){

            //检查是否有全盘在执行 如果没完成不能再生成
            List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_BY_TYPE,"Finish");
            if(rows!=null && rows.size()>0){
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("已有全库盘点任务,不能再次生成!");
                return messageDTO;
            }

            //全盘 所有SKU生成盘点任务
            List<Map> items= this.jdbcRepository.queryBySql(Sql_Table.SQL_FINDALLITEM
                    ,CommonUtils.parseString("FACTORY",data)
                    ,CommonUtils.parseString("SECTION",data));
            for (int i = 0; i < items.size(); i++) {
                Map map = items.get(i);
                BaseBpo baseBpo = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_ICQA_ORDERPOSITION);
                baseBpo.addKV("ICQAID",orderId).addKV("ID",CommonUtils.genUUID())
                        .addKV("SKUID",CommonUtils.parseString("ID",map));
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }

        }else{
            //从 DATA选sku
            List<Map> skus = (List<Map>) data.get("DATA");
            //查找所有存在盘点任务的SKU过滤
            List<Map> allTaskingSKU = this.jdbcRepository.queryBySql(Sql_Table.SQL_ALL_TASKING_SKU,"Finish");
            Set<String> allSku = this.list2Set(allTaskingSKU);
            List exist = new ArrayList();
            for (int i = 0; i < skus.size(); i++) {
                Map row = skus.get(i);
                String skuId = CommonUtils.parseString("SKUID",row);
                if(allSku.contains(skuId)){
                    logger.debug("SKU已存在盘点任务:" + skuId);
                    exist.add(skuId);
                }
            }
            if(!exist.isEmpty()){
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("以下"+JsonUtils.list2Json(exist)+"盘点任务未完成!");
                return messageDTO;
            }
            //没有存在的盘点任务就生成
            for (int i = 0; i < skus.size(); i++) {
                Map row = skus.get(i);
                String skuId = CommonUtils.parseString("SKUID",row);
                if(allSku.contains(skuId)){
                    logger.debug("SKU已存在盘点任务:" + skuId);
                    continue;
                }
                BaseBpo baseBpo = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_ICQA_ORDERPOSITION);
                baseBpo.addKV("ICQAID",orderId).addKV("ID",CommonUtils.genUUID())
                        .addKV("SKUID",CommonUtils.parseString("ID",row));
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }

        }
        this.jdbcRepository.insertBusinessObject(order);
        return messageDTO;
    }

    private Set<String> list2Set(List<Map> allTaskingSKU) {
        Set set = new HashSet();
        for (int i = 0; i < allTaskingSKU.size(); i++) {
            Map map = allTaskingSKU.get(i);
            set.add(map.get("SKUID"));
        }
        return set;
    }
}
