package com.mushiny.heli.xnr.wcs;


import com.mushiny.heli.xnr.comm.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.*;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.Map;

@Component
public class ExecutorHandler {
    private final Logger logger = LoggerFactory.getLogger(ExecutorHandler.class);
    RestTemplate restTemplate = new RestTemplate();

    //获取token
    public String getToken(String getTokenUrl, String params) {
        logger.info("获取wcs token认证信息。。。params = {} ",params);
        String tokenInfo = "";
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());

        HttpEntity<String> formEntity = new HttpEntity<String>(params,headers);
        String result = restTemplate.postForObject(getTokenUrl, formEntity, String.class);

        logger.info("获取token 时 wcs 返回结果 ： {} ",result);
        Map<String,String> resultMap = JsonUtils.json2Map(result);

        String code = resultMap.get("code");
        if("1".equals(code)){
            tokenInfo = resultMap.get("authorization");
        }

        return tokenInfo;
    }

    public String getForObject(String url,Map params,String token){
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headers.add("authorization",token);
        HttpEntity<String> formEntity = new HttpEntity<String>(headers);
        this.restTemplate.setErrorHandler(new CustomResponseErrorHandler());

        ResponseEntity<String> result = restTemplate.exchange(url, HttpMethod.GET,formEntity,String.class,params);

        String body = result.getBody();

        return body;
    }

    public String getMethod(String url,Map params,String token){
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headers.add("authorization", token);
        restTemplate.setErrorHandler(new CustomResponseErrorHandler());
        ResponseEntity<String> response = restTemplate.exchange(
                url+"?taskId={taskId}&sectionId=1",
                HttpMethod.GET,
                new HttpEntity<String>(headers),
                String.class, params);
        logger.error("respose.getBody:"+response.getBody());
        return response.getBody();
    }

    public String postForObject(String url,String params,String token){
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headers.add("Authorization",token);

        HttpEntity<String> formEntity = new HttpEntity<String>(params, headers);

        String result = restTemplate.postForObject(url, formEntity, String.class);

        return result;
    }

}

