package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.dto.StorageLocation;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import com.mushiny.heli.xnr.wcs.WmsToWcsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.*;

@Service
@Transactional
public class ICQAService {
    @Autowired
    private JdbcRepository jdbcRepository;
    //TODO 依赖关系不对
    @Autowired
    private InboundService inboundService;
    private final static Logger logger = LoggerFactory.getLogger(ICQAService.class);
    @Autowired
    private SystemPropertiesManager systemPropertiesManager;
    @Autowired
    private WmsToWcsService wmsToWcsService;

    /**
     * 当前货架的盘点任务
     * @param stationName
     * @return
     */
    public Map currentPodTask(String stationName) {
        Map dto = new HashMap();
         //如果没有锁定 就没有任务
        if(this.inboundService.isLockedByOthers(stationName, Sql_Table.STOWPOD) ){
            dto.put("CODE",1);
            dto.put("MSG","工作站"+stationName+"被占用，没有当前任务!");
            return dto;
        }

        List<Map> datas = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_CURRENTPOD, stationName);
        //先找再工作站的货架
        if(datas.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前在工作站的货架");
            return dto;
        }

        //MD_POD.ID, MD_POD.POD_INDEX, MD_POD.TOWARD, MD_WORKSTATION.WORKING_FACE_ORIENTATION
        Map data = datas.get(0);
        Integer pod_toward = CommonUtils.parseInteger("TOWARD", data);
        Integer pod_index = CommonUtils.parseInteger("POD_INDEX", data);
        Integer wsFace = CommonUtils.parseInteger("WORKING_FACE_ORIENTATION", data);
        String podId = CommonUtils.parseString("POD_ID", data);

        String face = InboundService.getFace(wsFace,pod_toward);
        /*`ID` varchar(255) NOT NULL,
          `ENTRYID` varchar(255) NOT NULL,
          `ENTRYPOSITIONID` varchar(255) NOT NULL,
          `SKUID` varchar(255) NOT NULL,
          `POD_ID` varchar(255) NOT NULL,
          `POD_FACE` varchar(255) NOT NULL,
          `POD_LOCATE` varchar(255) NOT NULL,
          `PODINDEX` int(11) DEFAULT NULL COMMENT '货架编号',
          `STATE` varchar(255) COMMENT '状态',*/
        //拼接后去找有没有要拣的任务单 WMS_INBOUND_PODORDER 根据 货架 面
        List<Map> podTask = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODORDRTASK_ICQA, podId,face);
        if(podTask.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","当前货架:POD:"+pod_index+" 没有盘点任务,请释放");
            return dto;
        }
        Map podOrder = podTask.get(0);
        String storageName = CommonUtils.parseString("STORAGENAME",podOrder);
        //String podId = CommonUtils.parseString("POD_ID",podOrder);
        String skuId = CommonUtils.parseString("SKUID", podOrder);
        /*List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId,podId);
        if (skus.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前盘点的商品信息, SKU:"+skuId);
            return dto;
        }*/
        Map sku = this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERY_ITEMINFO,skuId,storageName);
        if(sku == null){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前盘点的商品信息, SKU:"+skuId);
            return dto;
        }
        data.put("SKUNAME",CommonUtils.parseString("NAME",sku));
        data.put("AMOUNT",CommonUtils.parseString("AMOUNT",sku));
        data.put("Stock",CommonUtils.parseString("AMOUNT", sku));
        data.putAll(podOrder);

        return data;
    }




    /*如果工作站开启了 启动货架搬运任务 生成RCS_TRIP/POSITION表记录*/

    private boolean isLocked(String stationId) {
        List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_WORKSTATION, stationId);
        if(rows.isEmpty()){
            return false;
        }
        Map data = rows.get(0);
        String operator_id = CommonUtils.parseString("OPERATOR_ID",data);
        String station_name = CommonUtils.parseString("STATION_NAME",data);
        if(!CommonUtils.isEmpty(operator_id)
                && !Objects.equals(operator_id,"LISI")
                && !Objects.equals(station_name,"IcqaPod")){
            return true;
        }
        return false;
    }

    /**
     * 定时启动任务 生成调度单数据
     */
    @Scheduled(fixedDelay = 10*1000L)
    public void startICQATrip(){
        //6db9c7c0-4f93-4fa1-82c0-fb6435af7aae
        if(this.inboundService.isLockedByOthers(WMSService.stationId,Sql_Table.ICQAPOD)){
            logger.error("工作站被锁定，无法启动ICQA任务!");
            return ;
        }

        //TODO 根据工作站查找
        String pods = this.systemPropertiesManager.getProperty("EN_ROUTE_MAX_PODS_BINCHENK", Sql_Table.WAREHOUSE);
        if(pods == null){
            pods = "5";
        }
        List<Map> runningPods = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_RUNNINGPODS_ICQA,
                WMSService.stationId, Sql_Table.AVAILABLE,Sql_Table.PROCESS);
        Integer limit = Integer.parseInt(pods) - runningPods.size(); //TODO 按工作站区分
        //先找这么多货架 然后加载所有任务
        List<Map> podIds = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQAPODS, Sql_Table.AVAILABLE, Sql_Table.PROCESS);
        for (int i = 0; i < podIds.size() && i < limit; i++) {
            Map map =  podIds.get(i);
            String podId = CommonUtils.parseString("POD_ID",map);
            String workStation = CommonUtils.parseString("WORKSTATION_ID",map);
            List<Map> orderPosition = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODORDERS_ICQA
                    ,podId, Sql_Table.AVAILABLE); //New Available Finish  没有Process //TODO
            if(orderPosition.isEmpty()){
                logger.error("当前货架没有调度任务 podId:"+podId);
                continue;
            }
            /*BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable("RCS_TRIP");
            String tripId = CommonUtils.genUUID();
            baseBpo.addKV("ID",tripId);
            baseBpo.addKV("POD_ID",podId);
            baseBpo.addKV("TRIP_TYPE","ICQAPod");
            baseBpo.addKV("WORKSTATION_ID",workStation);
            baseBpo.addKV("TRIP_STATE",Sql_Table.NEW);
            baseBpo.addKV("WAREHOUSE_ID",CommonUtils.parseString("WAREHOUSE_ID",map));
            baseBpo.addKV("SECTION_ID",CommonUtils.parseString("SECTION_ID",map));
            this.jdbcRepository.insertBusinessObject(baseBpo);*/
            //序号生成 从1开始
            //Map<String,Integer> index = this.genIndexMap();
            for (int j = 0; j < orderPosition.size(); j++) {
                //如果存在RCS_TRIPPOSITION就不要再创建
                Map podOrder = orderPosition.get(j);
                String needFace = CommonUtils.parseString("POD_FACE",podOrder);
                //int sameFaceIndex = index.get(needFace);
                String tripPositionID;
                List<Map> tripPositions = this.existTripPosition(workStation, podId, needFace);
                if (tripPositions.isEmpty()) {
                    /*BaseBpo baseBpo2 = new BaseBpo();
                    baseBpo2.setTable("RCS_TRIPPOSITION");
                    tripPositionID = CommonUtils.genUUID();
                    baseBpo2.addKV("ID", tripPositionID);
                    baseBpo2.addKV("TRIP_ID", tripId);
                    baseBpo2.addKV("POD_USING_FACE", needFace);
                    baseBpo2.addKV("TIPPOSITION_STATE", Sql_Table.AVAILABLE);
                    baseBpo2.addKV("POSITION_NO", j + 1);
                    baseBpo2.addKV("WAREHOUSE_ID", CommonUtils.parseString("WAREHOUSE_ID", map));
                    baseBpo2.addKV("SECTION_ID", CommonUtils.parseString("SECTION_ID", map));
                    this.jdbcRepository.insertBusinessObject(baseBpo2);*/
                    Integer podIndex = CommonUtils.parseInteger("POD_INDEX",podOrder);
                    Integer stopCellId = CommonUtils.parseInteger("STOPPOINT",podOrder);
                    Integer sectId = CommonUtils.parseInteger("RCS_SECTIONID",podOrder);
                    Integer face = CommonUtils.faceToInteger(needFace);
                    Integer wsDirect = CommonUtils.wsFace2Direct(
                            CommonUtils.parseInteger("WORKING_FACE_ORIENTATION",podOrder));
                    tripPositionID = this.wmsToWcsService.sendSingleTripToWcs(podIndex,sectId,stopCellId,wsDirect,face);
                }else{
                    Map data = tripPositions.get(0);
                    tripPositionID = CommonUtils.parseString("ID",data);
                }

                Map newValue = new HashMap();
                newValue.put("STATE", Sql_Table.PROCESS);//生成就结束了 是不是执行完看TRIPPOSITION_ID
                newValue.put("TRIPPOSITION_ID", tripPositionID);
                CommonUtils.modifyUselessInfo(newValue);

                Map con = new HashMap();
                con.put("ID",CommonUtils.parseString("ID",podOrder));

                this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_PODORDER, newValue,con);
            }
        }
    }

    public List<Map> existTripPosition(String workStation, String podId, String needFace) {
        List<Map> datas = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_PODORDER,
                needFace,podId,workStation);
        return datas;
    }


    public Map searchIcqa(Map data) {
        String taskId = CommonUtils.parseString("taskId", data);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Sql_Table.SQL_QUERY_ICQA);
        List params = new ArrayList();
        if (!CommonUtils.isEmpty(taskId)) {
            stringBuilder.append(" AND TASKID like ? ");
            params.add("%"+taskId+"%");
        }

        stringBuilder.append(" ORDER BY CREATED_DATE DESC");

        List<Map> rows = this.jdbcRepository.queryBySql(stringBuilder.toString(), params);
        for (int i = 0; i < rows.size(); i++) {
            Map map = rows.get(i);
            map.put("SECTION_ID",CommonUtils.getSection(CommonUtils.parseString("SECTION_ID",map)));
            map.put("WAREHOUSE_ID",CommonUtils.getSection(CommonUtils.parseString("WAREHOUSE_ID",map)));
        }
        data.put("tasks", rows);

        return data;
    }

    public MessageDTO startTasks(Map data) {
        MessageDTO messageDTO = MessageDTO.success();
        //启动时 如果包含全库启动的 只能单起 不能混合
        String type = CommonUtils.parseString("type", data);
        String stationName = CommonUtils.parseString("stationName", data);

        //查询是否为空
        if(this.inboundService.isLockedByOthers(stationName, Sql_Table.STOWPOD)){
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("工作站被锁定或不存在，无法启动盘点任务!");
            return messageDTO;
        }

        if (!this.inboundService.lockStowStation(stationName,Sql_Table.ICQAPOD)) {
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("工作站不存在 或 锁定工作站失败:" + stationName);
            return messageDTO;
        }
        if (Objects.equals(type, Sql_Table.ALL_TYPE)) {
            List<String> taskIds = (List) data.get("tasks");
            if (taskIds.size() > 1) {
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("数据错误，全库盘点只能上传一条任务编号!");
                return messageDTO;
            }
            //只取第一条
            String taskId = taskIds.get(0);
            List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_BY_ID,
                    taskId, Sql_Table.AVAILABLE);
            if (rows.isEmpty()) {
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("数据错误，没有找到这条状态为Available的记录! taskId:" + taskId);
                return messageDTO;
            }
            List<Map> pos = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQAPOSITIONS,
                    taskId, Sql_Table.AVAILABLE);
            //为每条记录生成盘点任务,分配到Pod 面 上
            for (int i = 0; i < pos.size(); i++) {
                Map icqaPosition = pos.get(i);
                MessageDTO dto = this.genIcqaPodOrder(icqaPosition, taskId, stationName);
                if(dto.getCODE() == 1){
                    return dto;
                }
            }
            messageDTO.setMESSAGE("全库盘点启动成功: taskId" + taskId);
            return messageDTO;
        } else {
            //多条明细记录盘点
            List<String> taskIds = (List) data.get("tasks");
            for (int i = 0; i < taskIds.size(); i++) {
                String taskId = taskIds.get(i);
                //copy code
                List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_BY_ID,
                        taskId, Sql_Table.AVAILABLE);
                if (rows.isEmpty()) {
                    messageDTO.setCODE(1);
                    messageDTO.setMESSAGE("数据错误，没有找到这条状态为Available的记录! taskId:" + taskId);
                    return messageDTO;
                }
                List<Map> pos = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQAPOSITIONS,
                        taskId, Sql_Table.AVAILABLE);
                //为每条记录生成盘点任务,分配到Pod 面 上
                for (int j = 0; j < pos.size(); j++) {
                    Map icqaPosition = pos.get(j);
                    MessageDTO dto = this.genIcqaPodOrder(icqaPosition, taskId,stationName);
                    if(dto.getCODE() == 1){
                        return dto;
                    }
                }
                messageDTO.setMESSAGE("SKU盘点启动成功: taskIds:" + JsonUtils.list2Json(taskIds));
                return messageDTO;
            }
        }
        return messageDTO;
    }

    private MessageDTO genIcqaPodOrder(Map map, String taskId, String stationName) {
        MessageDTO dto = MessageDTO.success();
        String skuId = CommonUtils.parseString("SKUID", map);
        StorageLocation storageLocation = this.inboundService.findStorageLocation(skuId);
        if (storageLocation == null) {
            logger.error("SKU没有找到对应存储位，将随机分配空的存储位 SKU:" + skuId);
            dto.setCODE(1);
            dto.setMESSAGE("无法为SKU分配库位! SKU:" + skuId);
            return dto;
        }
                /* CREATE TABLE `WMS_ICQA_PODORDER` (
          `ID` VARCHAR(255) NOT NULL,
          `TASKID` VARCHAR(255) NOT NULL,
          `TASKPOSITIONID` VARCHAR(255) NOT NULL,
          `SKUID` VARCHAR(255) NOT NULL,
          `POD_ID` VARCHAR(255) NOT NULL,
          `POD_FACE` VARCHAR(255) NOT NULL,
          `STORAGENAME` VARCHAR(255) DEFAULT NULL,
          `POD_LOCATE` VARCHAR(255) NOT NULL,
          `WORKSTATION_ID` VARCHAR(255) DEFAULT NULL,
          `PODINDEX` INT(11) DEFAULT NULL COMMENT '货架编号',
          `STATE` VARCHAR(255) DEFAULT NULL COMMENT '状态',
          `AMOUNT` INT(11) DEFAULT NULL COMMENT '数量',
          `CREATED_DATE` TIMESTAMP NULL DEFAULT NULL,
          `CREATED_BY` VARCHAR(255) DEFAULT NULL,
          `MODIFIED_DATE` TIMESTAMP NULL DEFAULT NULL,
          `MODIFIED_BY` VARCHAR(255) DEFAULT NULL,
          `ADDITIONAL_CONTENT` VARCHAR(255) DEFAULT NULL,
          `ENTITY_LOCK` INT(11) DEFAULT NULL,
          `VERSION` INT(11) NOT NULL,
          `WAREHOUSE_ID` VARCHAR(255) NOT NULL COMMENT 'FACTORY',
          `SECTION_ID` VARCHAR(255) DEFAULT NULL COMMENT '物理区域SECTION',
          `TRIPPOSITION_ID` VARCHAR(255) DEFAULT NULL,,*/
        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setTable(Sql_Table.WMS_ICQA_PODORDER);
        baseBpo.addKV("ID", CommonUtils.genUUID());
        baseBpo.addKV("TASKID", taskId);
        baseBpo.addKV("TASKPOSITIONID", CommonUtils.parseString("ID", map));
        baseBpo.addKV("POD_ID", storageLocation.getPodId());
        baseBpo.addKV("SKUID", skuId);
        baseBpo.addKV("POD_FACE", storageLocation.getPodFace());
        baseBpo.addKV("STORAGENAME", storageLocation.getStorageName());
        baseBpo.addKV("POD_LOCATE", storageLocation.getLocate());
        baseBpo.addKV("WORKSTATION_ID", stationName);
        baseBpo.addKV("PODINDEX", storageLocation.getPodIndex());
        baseBpo.addKV("AMOUNT", CommonUtils.parseString("AMOUNT", map));
        baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
        baseBpo.addKV("WAREHOUSE_ID", CommonUtils.parseString("WAREHOUSE_ID", map));
        baseBpo.addKV("SECTION_ID", CommonUtils.parseString("SECTION_ID", map));
        //插入货架搬运任务 指令
        this.jdbcRepository.insertBusinessObject(baseBpo);
        return dto;
    }

    public MessageDTO taskFinish(Map data) {
        String taskId = CommonUtils.parseString("taskId", data);
        MessageDTO messageDTO = MessageDTO.success();
        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setIdName("TASKID");
        baseBpo.setTable(Sql_Table.WMS_ICQA_ORDER);
        baseBpo.setId(taskId);
        baseBpo.addKV("STATE", Sql_Table.FINISH);
        int result = this.jdbcRepository.updateBusinessObject(baseBpo);
        if (result == 0) {
            messageDTO.setMESSAGE("更新失败，没有更新记录!");
            messageDTO.setCODE(1);
        }
        return messageDTO;
    }

    public Map searchIcqaInfo(Map data) {
        String taskId = CommonUtils.parseString("taskId", data);
        Map ret = new HashMap();
        List<Map> taskInfo = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ALLICQAPOSITIONS, taskId);
        for (int i = 0; i < taskInfo.size(); i++) {
            Map map = taskInfo.get(i);
            map.put("SECTION_ID",CommonUtils.getSection(CommonUtils.parseString("SECTION_ID",map)));
            map.put("WAREHOUSE_ID",CommonUtils.getSection(CommonUtils.parseString("WAREHOUSE_ID",map)));
        }
        ret.put("taskId", taskId);
        ret.put("content", taskInfo);
        return ret;
    }

    /**
     * 盘点检查确认
     * @param skuId
     * @param checked
     * @param containerId
     * @param factory
     * @param section
     * @param taskId
     * @return
     */
    public MessageDTO check(String skuId, int checked,
                            String containerId, String factory,
                            String section, String taskId) {
        MessageDTO messageDTO = MessageDTO.success();
        List<Map> invs = this.jdbcRepository.queryBySql(Sql_Table.SQL_INV_UNITLOADID,containerId);
        if(invs.isEmpty()){
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("没有找到该容器:"+containerId);
            return messageDTO;
        }
        List<Map> items = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ITEMINFO, skuId,containerId);
        if(items.isEmpty()){
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("没有找到该商品信息:"+skuId);
            return messageDTO;
        }
        Map item = items.get(0);
        int amount = CommonUtils.parseInteger("AMOUNT",item);

        //查询盘点的入库数量
        Map icqaOrderPosition = this.getIcqaOrderPosition(taskId,skuId);

        String pId = CommonUtils.parseString("ID", icqaOrderPosition);
        //更新入库单状态
        this.updateIcqaOrderStatus(pId,taskId ,skuId, Sql_Table.FINISH,checked,amount);
        return messageDTO;
    }

    private void updateIcqaOrderStatus(String pId, String taskId,
                                       String skuId, String finish,
                                       int checked,int amount) {
        MessageDTO messageDTO = MessageDTO.success();

        Map newValue = new HashMap();
        newValue.put("STATE",finish);
        newValue.put("COUNT",checked);
        newValue.put("COUNT",amount);
        CommonUtils.modifyUselessInfo(newValue);

        Map con = new HashMap();
        con.put("SKUID",skuId);
        con.put("TASKID",taskId);
        //
        int count = this.jdbcRepository.updateRecords(Sql_Table.WMS_ICQA_ORDERPOSITION, newValue, con);
        if(count == 0){
            messageDTO.setMESSAGE("更新失败,entryId:"+taskId+" skuId:"+skuId);
            messageDTO.setCODE(1);
        }
    }

    private Map getIcqaOrderPosition(String taskId, String skuId) {
        List<Map> data = this.jdbcRepository
                .queryBySql(Sql_Table.SQL_QUERY_ICQAORDERPOSITION, taskId, skuId);
        if(data.isEmpty()){
            return null;
        }
        return data.get(0);
    }

    public Map searchSkus(Map data) {
        String skuId = CommonUtils.parseString("skuId",data);//等同于ItemNo
        List<Map> items;
        String factory = CommonUtils.parseString("FACTORY",data);
        factory = CommonUtils.getWarehouse(factory);
        String client = CommonUtils.parseString("FACTORY",data);
        client = CommonUtils.getClient(factory);
        if (CommonUtils.isEmpty(skuId)) {
            //所有的SKU
            items = this.jdbcRepository.queryBySql(Sql_Table.SQL_FINDALLITEM
                    , client,factory);
        } else {
            //所有的SKU
            //模糊查询
            skuId = "%"+skuId+"%";
            items = this.jdbcRepository.queryBySql(Sql_Table.SQL_FINDALLITEM_BYSKUID
                    , client,factory, skuId);
        }
        data.put("content",items);
        return data;
    }

    public MessageDTO skuNotFound(String taskId, String skuId) {
        MessageDTO messageDTO = MessageDTO.success();

        Map newValue = new HashMap();
        newValue.put("STATE",Sql_Table.FINISH);
        newValue.put("MSG","没有物料");
        newValue.put("COUNT","0");
        CommonUtils.modifyUselessInfo(newValue);

        Map con = new HashMap();
        con.put("SKUID",skuId);
        con.put("TASKID",taskId);

        int count = this.jdbcRepository.updateRecords(Sql_Table.WMS_ICQA_ORDERPOSITION, newValue, con);
        if(count == 0){
            messageDTO.setMESSAGE("更新失败,entryId:"+taskId+" skuId:"+skuId);
            messageDTO.setCODE(1);
            return messageDTO;
        }

        return messageDTO;
    }
}
