package com.mushiny.heli.xnr.mq;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.controller.HeliWMSController;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import com.mushiny.heli.xnr.service.Sql_Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class MqListener {

    private final static Logger logger = LoggerFactory.getLogger(MqListener.class);

    @Autowired
    private JdbcRepository jdbcRepository;

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = "", durable = "true"),
            exchange = @Exchange(value = "amq.topic" , ignoreDeclarationExceptions = "true"),
            key = "monitor_pod_to_workstation.*"))
    public void pod2Station(Message message){
        byte[] body = message.getBody();
        String jsonData = new String(body);
        Map data = JsonUtils.json2Map(jsonData);
        logger.info("monitor_pod_to_workstation:" + data);
    }

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = "", durable = "true"),
            exchange = @Exchange(value = "amq.topic" , ignoreDeclarationExceptions = "true"),
            key = "monitor_pod_to_workstation.*"))
    public void pod2Station2(Message message){
        byte[] body = message.getBody();
        String jsonData = new String(body);
        Map data = JsonUtils.json2Map(jsonData);
        logger.info("monitor_pod_to_workstation2:" + data);
    }

    @RabbitListener(queues = "POD_STATION_HELI")
    @Transactional
    public void pod2Station3(Message message){

        try {
            byte[] body = message.getBody();
            String jsonData = new String(body);
            Map data = JsonUtils.json2Map(jsonData);
            logger.info("monitor_pod_to_workstation3:" + data);
            int stopCellId = CommonUtils.parseInteger("stopCellId",data);
            String sectionId = this.getSectionIdBySid(CommonUtils.parseInteger("sectionId",data));
            String workstationId = this.getWorkstationIdByStopPoint(stopCellId,sectionId);
            int podIndex = CommonUtils.parseInteger("podId",data);
            String podId = this.getPodIdByIndex(sectionId, podIndex);
        /*Integer sectionId;
        Integer stopCellId; //停止点
        Integer direction;//工作站相对停止点方向
        String podId;
        Integer podDirection;
        String taskId;*/
            List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_POD_STATION,workstationId);
        /*  `STATION_ID` varchar(255) NOT NULL,
      `POD_INDEX` int(11) NOT NULL,
      `TOWARD` varchar(255) DEFAULT NULL COMMENT 'ABCD',
      `PLACEMARK` int(11) DEFAULT NULL COMMENT '*/


            Integer podDirection = CommonUtils.parseInteger("podDirection",data);
            int toward = 0;
            switch (podDirection){
                case 1 : toward = 90;  break;
                case 2 : toward = 180; break;
                case 3 : toward = 270; break;
            }
            if(rows.isEmpty()){
                Map record = new HashMap();
                //record.putAll(data);
                //替换掉 便于查询
                record.put("PLACEMARK",CommonUtils.parseInteger("stopCellId",data));
                record.put("SECTION_ID",sectionId);
                record.put("STATION_ID",workstationId);
                record.put("POD_INDEX",podIndex);
                record.put("POD_ID",podId);
                record.put("TOWARD",toward);
                record.put("WAREHOUSE_ID",CommonUtils.getWarehouse(Sql_Table.FACTORY));
                record.put("TRIP_TASKID",CommonUtils.parseString("taskId",data));
                CommonUtils.genUselessInfo(record);
                this.jdbcRepository.insertRecord(Sql_Table.TABLE_WMS_POD_STATION,record);
                logger.debug("新增记录成功");

            }else{
                Map newValue = new HashMap();
                newValue.put("PLACEMARK",CommonUtils.parseInteger("stopCellId",data));
                newValue.put("SECTION_ID",sectionId);
                newValue.put("STATION_ID",workstationId);
                newValue.put("POD_ID",podId);
                newValue.put("POD_INDEX",CommonUtils.parseInteger("podId",data));
                newValue.put("TOWARD",toward);
                newValue.put("TRIP_TASKID",CommonUtils.parseString("taskId",data));
                CommonUtils.modifyUselessInfo(newValue);

                Map con = new HashMap();
                con.put("STATION_ID",workstationId);
                con.put("SECTION_ID",sectionId);

                int ret = this.jdbcRepository.updateRecords(Sql_Table.TABLE_WMS_POD_STATION, newValue, con);
                logger.debug("更新记录:"+data+" 结果为:"+ret);
            }
        } catch (Exception e) {
            logger.error("保存消息出错!", e);
        }
    }

    private String getPodIdByIndex(String sectionId, int podIndex) {
        Map pod = this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERYPODBYINDEX,sectionId,podIndex);
        return CommonUtils.parseString("ID",pod);
    }

    private String getWorkstationIdByStopPoint(int stopCellId, String sectionId) {
        Map row = this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERYWDBYSTOP,stopCellId,sectionId);
        return CommonUtils.parseString("ID",row);
    }

    private String getSectionIdBySid(Integer sid) {
       Map row = this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERYSECTIONBYSID,sid);
       return CommonUtils.parseString("ID",row);
    }
}
