package com.mushiny.heli.xnr.controller;

import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.ItemDTO;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.mq.MqSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用于模拟合力WMS接收
 */

@RestController
@RequestMapping("/heli")
public class HeliWMSController {

    @Autowired
    private MqSender mqSender;

    private final static Logger logger = LoggerFactory.getLogger(HeliWMSController.class);

    @PostMapping(value = "/icqaResp", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> syncItem(
            @RequestBody String json){
        logger.debug("icqaResp: " + json);
        MessageDTO dto = MessageDTO.success();
        return ResponseEntity.ok(dto);
    }

    @PostMapping(value = "/sendMsg", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> sendMsg(
            @RequestBody String json){
        logger.debug("json: " + json);
        MessageDTO dto = MessageDTO.success();
        mqSender.sendMsg(json, "amq.topic","monitor_pod_to_workstation.*");
        return ResponseEntity.ok(dto);
    }

}
