package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.dto.StorageLocation;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.*;

@Service
@Transactional
public class ICQAService {
    @Autowired
    private JdbcRepository jdbcRepository;
    //TODO 依赖关系不对
    @Autowired
    private InboundService inboundService;
    private final static Logger logger = LoggerFactory.getLogger(ICQAService.class);
    @Autowired
    private SystemPropertiesManager systemPropertiesManager;

    /**
     * 当前货架的盘点任务
     * @param stationName
     * @return
     */
    public Map currentPodTask(String stationName) {
        Map dto = new HashMap();
        //如果没有锁定 就没有任务
        if(isLocked(stationName) ){
            dto.put("CODE",1);
            dto.put("MSG","工作站"+stationName+"被占用，没有当前任务!");
            return dto;
        }

        List<Map> datas = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_CURRENTPOD, stationName);
        //先找再工作站的货架
        if(datas.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前在工作站的货架");
            return dto;
        }

        //MD_POD.ID, MD_POD.POD_INDEX, MD_POD.TOWARD, MD_WORKSTATION.WORKING_FACE_ORIENTATION
        Map data = datas.get(0);
        Integer pod_toward = CommonUtils.parseInteger("TOWARD", data);
        Integer pod_index = CommonUtils.parseInteger("POD_INDEX", data);
        Integer wsFace = CommonUtils.parseInteger("WORKING_FACE_ORIENTATION", data);
        String podId = CommonUtils.parseString("ID", data);

        String face = InboundService.getFace(wsFace,pod_toward);
        /*`ID` varchar(255) NOT NULL,
          `ENTRYID` varchar(255) NOT NULL,
          `ENTRYPOSITIONID` varchar(255) NOT NULL,
          `SKUID` varchar(255) NOT NULL,
          `POD_ID` varchar(255) NOT NULL,
          `POD_FACE` varchar(255) NOT NULL,
          `POD_LOCATE` varchar(255) NOT NULL,
          `PODINDEX` int(11) DEFAULT NULL COMMENT '货架编号',
          `STATE` varchar(255) COMMENT '状态',*/
        //拼接后去找有没有要拣的任务单 WMS_INBOUND_PODORDER 根据 货架 面
        List<Map> podTask = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODORDRTASK_ICQA, podId,face);
        if(podTask.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","当前货架:POD:"+pod_index+" 没有盘点任务,请释放");
            return dto;
        }
        Map podOrder = podTask.get(0);
        String skuId = CommonUtils.parseString("SKUID", podOrder);
        List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId);
        if (skus.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前盘点的商品信息, SKU:"+skuId);
            return dto;
        }
        Map sku = skus.get(0);
        data.put("SKUNAME",CommonUtils.parseString("NAME",sku));
        data.putAll(podOrder);

        return data;
    }


    /*如果工作站开启了 启动货架搬运任务 生成RCS_TRIP/POSITION表记录*/

    private boolean isLocked(String stationId) {
        List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_WORKSTATION, stationId);
        if(rows.isEmpty()){
            return false;
        }
        Map data = rows.get(0);
        String operator_id = CommonUtils.parseString("OPERATOR_ID",data);
        String station_name = CommonUtils.parseString("STATION_NAME",data);
        if(!CommonUtils.isEmpty(operator_id)
                && !Objects.equals(operator_id,"LISI")
                && !Objects.equals(station_name,"IcqaPod")){
            return true;
        }
        return false;
    }

    /**
     * 定时启动任务
     */
    @Scheduled(fixedDelay = 10*1000L)
    public void startICQATrip(){
        //6db9c7c0-4f93-4fa1-82c0-fb6435af7aae
        if(isLocked("6db9c7c0-4f93-4fa1-82c0-fb6435af7aae")){
            logger.error("工作站被锁定，无法启动盘点任务!");
            return ;
        }

        //TODO 根据工作站查找
        String pods = this.systemPropertiesManager.getProperty("EN_ROUTE_MAX_PODS_BINCHENK", Sql_Table.WAREHOUSE);
        List<Map> runningPods = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_RUNNINGPODS,
                "ICQAPod", Sql_Table.AVAILABLE,Sql_Table.PROCESS);
        Integer limit = Integer.parseInt(pods) - runningPods.size(); //TODO 按工作站区分
        //先找这么多货架 然后加载所有任务
        List<Map> podIds = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQAPODS, "ICQAPod", Sql_Table.AVAILABLE);
        for (int i = 0; i < podIds.size() && i < limit; i++) {
            Map map =  podIds.get(i);
            String podId = CommonUtils.parseString("POD_ID",map);
            String workStation = CommonUtils.parseString("WORKSTATION_ID",map);
            List<Map> orderPosition = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODORDERS
                    ,podId, Sql_Table.NEW); //New Available Finish  没有Process
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable("RCS_TRIP");
            String tripId = CommonUtils.genUUID();
            baseBpo.addKV("ID",tripId);
            baseBpo.addKV("POD_ID",podId);
            baseBpo.addKV("TRIP_TYPE","StowPod");
            baseBpo.addKV("WORKSTATION_ID",workStation);
            baseBpo.addKV("TRIP_STATE","New");
            baseBpo.addKV("WAREHOUSE_ID",CommonUtils.parseString("WAREHOUSE_ID",map));
            baseBpo.addKV("SECTION_ID",CommonUtils.parseString("SECTION_ID",map));
            this.jdbcRepository.insertBusinessObject(baseBpo);
            //序号生成 从1开始
            //Map<String,Integer> index = this.genIndexMap();
            for (int j = 0; j < orderPosition.size(); j++) {
                //如果存在RCS_TRIPPOSITION就不要再创建
                Map podOrder = orderPosition.get(j);
                String needFace = CommonUtils.parseString("POD_FACE",map);
                //int sameFaceIndex = index.get(needFace);
                String tripPositionID;
                List<Map> tripPositions = this.inboundService.existTripPosition(workStation, podId, needFace,"ICQAPod");
                if (tripPositions.isEmpty()) {
                    BaseBpo baseBpo2 = new BaseBpo();
                    baseBpo2.setTable("RCS_TRIPPOSITION");
                    tripPositionID = CommonUtils.genUUID();
                    baseBpo2.addKV("ID", tripPositionID);
                    baseBpo2.addKV("TRIP_ID", tripId);
                    baseBpo2.addKV("POD_USING_FACE", needFace);
                    baseBpo2.addKV("POSITION_NO", j + 1);
                    baseBpo2.addKV("WAREHOUSE_ID", CommonUtils.parseString("WAREHOUSE_ID", map));
                    baseBpo2.addKV("SECTION_ID", CommonUtils.parseString("SECTION_ID", map));
                    this.jdbcRepository.insertBusinessObject(baseBpo2);
                }else{
                    Map data = tripPositions.get(0);
                    tripPositionID = CommonUtils.parseString("ID",data);
                }

                Map newValue = new HashMap();
                newValue.put("STATE", Sql_Table.AVAILABLE);//生成就结束了 是不是执行完看TRIPPOSITION_ID
                newValue.put("TRIPPOSITION_ID", tripPositionID);
                newValue.put("TRIPPOSITION_ID", tripPositionID);
                CommonUtils.modifyUselessInfo(newValue);

                Map con = new HashMap();
                con.put("ID",CommonUtils.parseString("ID",podOrder));

                this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_PODORDER, newValue,con);
            }
        }
    }


    public Map searchIcqa(Map data) {
        String taskId = CommonUtils.parseString("taskId", data);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Sql_Table.SQL_QUERY_ICQA);
        List params = new ArrayList();
        if (!CommonUtils.isEmpty(taskId)) {
            stringBuilder.append(" AND TASKID=? ");
            params.add(taskId);
        }

        List<Map> rows = this.jdbcRepository.queryBySql(stringBuilder.toString(), params);
        data.put("tasks", rows);

        return data;
    }

    public MessageDTO startTasks(Map data) {
        MessageDTO messageDTO = MessageDTO.success();
        //启动时 如果包含全库启动的 只能单起 不能混合
        String type = CommonUtils.parseString("type", data);
        String stationName = CommonUtils.parseString("stationName", data);
        if (!this.inboundService.lockStowStation(stationName)) {
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("工作站不存在 或 锁定工作站失败:" + stationName);
            return messageDTO;
        }
        if (Objects.equals(type, Sql_Table.ALL_TYPE)) {
            List<String> taskIds = (List) data.get("tasks");
            if (taskIds.size() > 1) {
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("数据错误，全库盘点只能上传一条任务编号!");
                return messageDTO;
            }
            //只取第一条
            String taskId = taskIds.get(0);
            List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_BY_ID,
                    taskId, Sql_Table.AVAILABLE);
            if (rows.isEmpty()) {
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("数据错误，没有找到这条状态为Available的记录! taskId:" + taskId);
                return messageDTO;
            }
            List<Map> pos = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQAPOSITIONS,
                    taskId, Sql_Table.AVAILABLE);
            //为每条记录生成盘点任务,分配到Pod 面 上
            for (int i = 0; i < pos.size(); i++) {
                Map icqaPosition = pos.get(i);
                MessageDTO dto = this.genIcqaPodOrder(icqaPosition, taskId, stationName);
                if(dto.getCODE() == 1){
                    return dto;
                }
            }
            messageDTO.setMESSAGE("全库盘点启动成功: taskId" + taskId);
            return messageDTO;
        } else {
            //多条明细记录盘点
            List<String> taskIds = (List) data.get("tasks");
            for (int i = 0; i < taskIds.size(); i++) {
                String taskId = taskIds.get(i);
                //copy code
                List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_BY_ID,
                        taskId, Sql_Table.AVAILABLE);
                if (rows.isEmpty()) {
                    messageDTO.setCODE(1);
                    messageDTO.setMESSAGE("数据错误，没有找到这条状态为Available的记录! taskId:" + taskId);
                    return messageDTO;
                }
                List<Map> pos = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQAPOSITIONS,
                        taskId, Sql_Table.AVAILABLE);
                //为每条记录生成盘点任务,分配到Pod 面 上
                for (int j = 0; j < pos.size(); j++) {
                    Map icqaPosition = pos.get(j);
                    MessageDTO dto = this.genIcqaPodOrder(icqaPosition, taskId,stationName);
                    if(dto.getCODE() == 1){
                        return dto;
                    }
                }
                messageDTO.setMESSAGE("SKU盘点启动成功: taskIds:" + JsonUtils.list2Json(taskIds));
                return messageDTO;
            }
        }
        return messageDTO;
    }

    private MessageDTO genIcqaPodOrder(Map map, String taskId, String stationName) {
        MessageDTO dto = MessageDTO.success();
        String skuId = CommonUtils.parseString("SKUID", map);
        StorageLocation storageLocation = this.inboundService.findStorageLocation(skuId);
        if (storageLocation == null) {
            logger.error("SKU没有找到对应存储位，将随机分配空的存储位 SKU:" + skuId);
            dto.setCODE(1);
            dto.setMESSAGE("无法为SKU分配库位! SKU:" + skuId);
            return dto;
        }
                /* CREATE TABLE `WMS_ICQA_PODORDER` (
          `ID` VARCHAR(255) NOT NULL,
          `TASKID` VARCHAR(255) NOT NULL,
          `TASKPOSITIONID` VARCHAR(255) NOT NULL,
          `SKUID` VARCHAR(255) NOT NULL,
          `POD_ID` VARCHAR(255) NOT NULL,
          `POD_FACE` VARCHAR(255) NOT NULL,
          `STORAGENAME` VARCHAR(255) DEFAULT NULL,
          `POD_LOCATE` VARCHAR(255) NOT NULL,
          `WORKSTATION_ID` VARCHAR(255) DEFAULT NULL,
          `PODINDEX` INT(11) DEFAULT NULL COMMENT '货架编号',
          `STATE` VARCHAR(255) DEFAULT NULL COMMENT '状态',
          `AMOUNT` INT(11) DEFAULT NULL COMMENT '数量',
          `CREATED_DATE` TIMESTAMP NULL DEFAULT NULL,
          `CREATED_BY` VARCHAR(255) DEFAULT NULL,
          `MODIFIED_DATE` TIMESTAMP NULL DEFAULT NULL,
          `MODIFIED_BY` VARCHAR(255) DEFAULT NULL,
          `ADDITIONAL_CONTENT` VARCHAR(255) DEFAULT NULL,
          `ENTITY_LOCK` INT(11) DEFAULT NULL,
          `VERSION` INT(11) NOT NULL,
          `WAREHOUSE_ID` VARCHAR(255) NOT NULL COMMENT 'FACTORY',
          `SECTION_ID` VARCHAR(255) DEFAULT NULL COMMENT '物理区域SECTION',
          `TRIPPOSITION_ID` VARCHAR(255) DEFAULT NULL,,*/
        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setTable(Sql_Table.WMS_INBOUND_PODORDER);
        baseBpo.addKV("ID", CommonUtils.genUUID());
        baseBpo.addKV("TASKID", taskId);
        baseBpo.addKV("TASKPOSITIONID", CommonUtils.parseString("ID", map));
        baseBpo.addKV("POD_ID", storageLocation.getPodId());
        baseBpo.addKV("SKUID", skuId);
        baseBpo.addKV("POD_FACE", storageLocation.getPodFace());
        baseBpo.addKV("STORAGENAME", storageLocation.getLocate());
        baseBpo.addKV("POD_LOCATE", storageLocation.getLocate());
        baseBpo.addKV("WORKSTATION_ID", stationName);
        baseBpo.addKV("PODINDEX", storageLocation.getPodIndex());
        baseBpo.addKV("AMOUNT", CommonUtils.parseString("AMOUNT", map));
        baseBpo.addKV("STATE", Sql_Table.NEW);
        baseBpo.addKV("WAREHOUSE_ID", CommonUtils.parseString("WAREHOUSE_ID", map));
        baseBpo.addKV("SECTION_ID", CommonUtils.parseString("SECTION_ID", map));
        //插入货架搬运任务 指令
        this.jdbcRepository.insertBusinessObject(baseBpo);
        return dto;
    }

    public MessageDTO taskFinish(Map data) {
        String taskId = CommonUtils.parseString("taskId", data);
        MessageDTO messageDTO = MessageDTO.success();
        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setIdName("TASKID");
        baseBpo.setTable(Sql_Table.WMS_ICQA_ORDER);
        baseBpo.setId(taskId);
        baseBpo.addKV("STATE", Sql_Table.FINISH);
        int result = this.jdbcRepository.updateBusinessObject(baseBpo);
        if (result == 0) {
            messageDTO.setMESSAGE("更新失败，没有更新记录!");
            messageDTO.setCODE(1);
        }
        return messageDTO;
    }

    public Map searchIcqaInfo(Map data) {
        String taskId = CommonUtils.parseString("taskId", data);
        Map ret = new HashMap();
        List<Map> taskInfo = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQAPOSITIONS, taskId);
        ret.put("taskId", taskId);
        ret.put("content", taskInfo);
        return ret;
    }

    /**
     * 盘点检查确认
     * @param skuId
     * @param checked
     * @param containerId
     * @param factory
     * @param section
     * @param taskId
     * @return
     */
    public MessageDTO check(String skuId, int checked, String containerId, String factory, String section, String taskId) {
        MessageDTO messageDTO = MessageDTO.success();
        List<Map> invs = this.jdbcRepository.queryBySql(Sql_Table.SQL_INV_UNITLOADID,containerId);
        if(invs.isEmpty()){
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("没有找到该容器:"+containerId);
            return messageDTO;
        }
        List<Map> items = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId);
        if(items.isEmpty()){
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("没有找到该商品信息:"+skuId);
            return messageDTO;
        }
        Map item = items.get(0);
        String mID = CommonUtils.parseString("ID",item);
        //货位信息
        Map data = invs.get(0);
        String uid = CommonUtils.parseString("ID",data);

        //查询入库单的入库数量
        Map icqaOrderPosition = this.getIcqaOrderPosition(taskId,skuId);

        String pId = CommonUtils.parseString("ID", icqaOrderPosition);
        //更新入库单状态
        this.updateIcqaOrderStatus(pId,taskId ,skuId, Sql_Table.FINISH,checked);
        return messageDTO;
    }

    private void updateIcqaOrderStatus(String pId, String taskId, String skuId, String finish, int checked) {
        MessageDTO messageDTO = MessageDTO.success();

        Map newValue = new HashMap();
        newValue.put("STATE",finish);
        newValue.put("COUNT",checked);
        CommonUtils.modifyUselessInfo(newValue);

        Map con = new HashMap();
        con.put("SKUID",skuId);
        con.put("ENTRYID",taskId);
        //
        int count = this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_ORDERPOSITION, newValue, con);
        if(count == 0){
            messageDTO.setMESSAGE("更新失败,entryId:"+taskId+" skuId:"+skuId);
            messageDTO.setCODE(1);
        }
    }

    private Map getIcqaOrderPosition(String taskId, String skuId) {
        List<Map> data = this.jdbcRepository
                .queryBySql(Sql_Table.SQL_QUERY_INBOUNDORDERPOSITION, taskId, skuId);
        if(data.isEmpty()){
            return null;
        }
        return data.get(0);
    }
}
