package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.dto.StorageLocation;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import com.mushiny.heli.xnr.wcs.WmsToWcsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.*;

/**
 * Created by Lisi on 2019-11-27.
 */
@Service
@Transactional
public class InboundService {

    private final static Logger logger = LoggerFactory.getLogger(InboundService.class);


    @Autowired
    private JdbcRepository jdbcRepository;

    @Autowired
    private SystemPropertiesManager systemPropertiesManager;


    public List<Map> searchInbound(String entryId, String warehouseId, String sectionId) {
        List params = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append(Sql_Table.SQL_SEARCHINBOUND);
        if(!CommonUtils.isEmpty(warehouseId)){
            sql.append(Sql_Table.SQL_SEARCHINBOUND_ENTRYID);
            params.add("%"+entryId+"%");
        }

        if(!CommonUtils.isEmpty(warehouseId)){
            sql.append(Sql_Table.SQL_SEARCHINBOUND_FACTORY);
            params.add(warehouseId);
        }
        if(!CommonUtils.isEmpty(sectionId)){
            sql.append(Sql_Table.SQL_SEARCHINBOUND_SECTION);
            params.add(warehouseId);
        }
        sql.append(" ORDER BY CREATED_DATE DESC");

        return this.jdbcRepository.queryBySql(sql.toString(),params);
    }

    public List<Map> searchInboundInfo(String entryId) {
        List params = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append(Sql_Table.SQL_SEARCHINBOUNDINFO);
        params.add(entryId);
        List<Map> data = this.jdbcRepository.queryBySql(sql.toString(),params);
        for (int i = 0; i < data.size(); i++) {
            Map map = data.get(i);
            map.put("STORED",CommonUtils.parseInteger("ITEM_STORED",map));
        }
        return data;
    }

    public MessageDTO orderFinish(String entryId) {
        MessageDTO messageDTO = MessageDTO.success();
        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setIdName("ENTRYID");
        baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDER);
        baseBpo.setId(entryId);
        baseBpo.addKV("STATE", Sql_Table.FINISH);
        int result = this.jdbcRepository.updateBusinessObject(baseBpo);
        if(result == 0){
            messageDTO.setMESSAGE("更新失败，没有更新记录!");
            messageDTO.setCODE(1);
            //return messageDTO;
        }
        return messageDTO;
    }

    /**
     * 上架到货位
     * @param skuId
     * @param stored
     * @param containerId
     * @param factory
     * @param section
     * @param entryId
     * @param podOrderId
     * @return
     */
    public MessageDTO store(String skuId, int stored, String containerId,
                            String factory, String section, String entryId, String podOrderId) {
       MessageDTO messageDTO = MessageDTO.success();
        List<Map> invs = this.jdbcRepository.queryBySql(Sql_Table.SQL_INV_UNITLOADID,containerId);
       if(invs.isEmpty()){
          messageDTO.setCODE(1);
          messageDTO.setMESSAGE("没有找到该容器:"+containerId);
          return messageDTO;
       }
        List<Map> items = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId);
        if(items.isEmpty()){
            messageDTO.setCODE(1);
            messageDTO.setMESSAGE("没有找到该商品信息:"+skuId);
            return messageDTO;
        }
        Map item = items.get(0);
        String mID = CommonUtils.parseString("ID",item);
       //货位信息
       Map data = invs.get(0);
       String uid = CommonUtils.parseString("ID",data);
       List<Map> lists =  this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_INV_SKU,uid,mID);
       String id = null;
       //是否存在记录
        if(lists.isEmpty()){
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.TABLE_INV_STOCKUNIT);
            id = CommonUtils.genUUID();
            baseBpo.addKV("ID",id);
            baseBpo.addKV("ITEMDATA_ID",mID);
            baseBpo.addKV("STATE","Inventory");
            baseBpo.addKV("AMOUNT",stored);//上架的数量
            baseBpo.addKV("UNITLOAD_ID",uid);
            baseBpo.addKV("RESERVED_AMOUNT",0);
            baseBpo.addKV("CLIENT_ID",factory); //同一个factory
            baseBpo.addKV("WAREHOUSE_ID",factory);//TODO
            this.jdbcRepository.insertBusinessObject(baseBpo);
            //end of 新增记录
        }else{
            //获取数据
            Map inv = lists.get(0);
            Integer amount = CommonUtils.parseInteger("AMOUNT",inv);
            Map newValue = new HashMap();
            newValue.put("AMOUNT",amount+stored);//增加的库存数
            CommonUtils.modifyUselessInfo(newValue);
            id = CommonUtils.parseString("ID",inv);
            Map con = new HashMap();
            con.put("ID",id);
            //con.put("UNITLOAD_ID",uid);

            this.jdbcRepository.updateRecords(Sql_Table.TABLE_INV_STOCKUNIT,newValue,con);
        }
        String msg = "OK";
        //查询入库单的入库数量
        Map ibOrderPosition = this.getIbOrderPosition(entryId,skuId);
        if(stored > CommonUtils.parseInteger("AMOUNT",ibOrderPosition)){
            msg = "物料多货";
        }else if(stored < CommonUtils.parseInteger("AMOUNT",ibOrderPosition)){
            msg = "物料少货";
        }
        String pId = CommonUtils.parseString("ID", ibOrderPosition);
        //更新入库单状态
        this.updateInboundOrderStatus(entryId,skuId, Sql_Table.FINISH,stored,msg);
        //结束货架任务信息 PodOrder
        this.updateInboundPodOrder(Sql_Table.FINISH, podOrderId);
        //增加入库流水记录
        this.add2InboundHistory(stored,entryId,pId,skuId,containerId,uid,id,factory);

        return messageDTO;
    }

    private void updateInboundPodOrder(String state, String podOrderId) {
        Map newValue = new HashMap();
        newValue.put("STATE",state);
        CommonUtils.modifyUselessInfo(newValue);

        Map con = new HashMap();
        con.put("ID",podOrderId);
        //
        int count = this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_PODORDER, newValue, con);
        logger.debug("更新入库货架任务成功! count:"+count);
    }

    private void add2InboundHistory(Integer amount, String entryId, String pId,
                                    String skuId, String containerId, String uid, String stockUnitId, String factory) {
        //TODO
        Map record = new HashMap();
        record.put("ID",CommonUtils.genUUID());
        CommonUtils.genUselessInfo(record);
        record.put("RECORD_TOOL","Receive");
        record.put("RECORD_TYPE","EACH_RECEIVE_TO_STOW");
        record.put("AMOUNT",amount);
        record.put("ITEMDATA_ITEMNO",skuId);
        record.put("FROM_STATE","Inventory");
        record.put("OPERATOR","Lisi");
        record.put("FROM_STOCKUNIT",entryId);
        record.put("TO_STOCKUNIT",stockUnitId);
        record.put("TO_UNITLOAD",uid);
        record.put("TO_STORAGELOCATION",containerId);
        record.put("CLIENT_ID",factory);
        record.put("WAREHOUSE_ID",factory);

        this.jdbcRepository.insertRecord("INV_STOCKUNITRECORD",record);
        logger.debug("增加库存历史记录成功:"+record);
    }

    private Map getIbOrderPosition(String entryId, String skuId) {
        List<Map> data = this.jdbcRepository
                .queryBySql(Sql_Table.SQL_QUERY_INBOUNDORDERPOSITION,entryId,skuId);
        if(data.isEmpty()){
            return null;
        }
        return data.get(0);
    }

    /**
     * 更新入库单状态
     * @param entryId
     * @param skuId
     * @param state
     * @param stored
     * @return
     */
    public MessageDTO updateInboundOrderStatus(String entryId,String skuId,
                                               String state,Integer stored,String msg){

        MessageDTO messageDTO = MessageDTO.success();

        Map newValue = new HashMap();
        newValue.put("STATE",state);
        newValue.put("MSG",msg);
        newValue.put("ITEM_STORED",stored);
        CommonUtils.modifyUselessInfo(newValue);

        Map con = new HashMap();
        con.put("SKUID",skuId);
        con.put("ENTRYID",entryId);
        //
        int count = this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_ORDERPOSITION, newValue, con);
        if(count == 0){
            messageDTO.setMESSAGE("更新失败,entryId:"+entryId+" skuId:"+skuId);
            messageDTO.setCODE(1);
            return messageDTO;
        }
        //更新主表记录
        List<Map> ids = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_INBOUND_AVAILABLEPOSITION, entryId);
        if(ids.isEmpty()){
            Map newValue2 = new HashMap();
            newValue2.put("STATE",Sql_Table.FINISH);
            CommonUtils.modifyUselessInfo(newValue2);

            Map con2 = new HashMap();
            con2.put("ENTRYID",entryId);
            this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_ORDER, newValue2, con2);
        }

        return messageDTO;
    }

    /**
     * 物料缺失
     * @param entryId
     * @param skuId
     * @return
     */
    public MessageDTO skuNotFound(String entryId, String skuId) {

        return this.updateInboundOrderStatus(entryId, skuId, Sql_Table.ERROR,0, "物料丢失");

    }


    /**
     * 批量生成上架任务
     * @param entryIds
     * @param stationName
     * @return
     */
    public MessageDTO startInbound(List entryIds, String stationName) {
        //成功
        MessageDTO dto = MessageDTO.success();
        //查询是否为空
        if(isLockedByOthers(stationName, Sql_Table.STOWPOD)){
            dto.setCODE(1);
            dto.setMESSAGE("工作站被锁定或不存在，无法启动上架任务!");
            return dto;
        }
        if(!this.lockStowStation(stationName,Sql_Table.STOWPOD)){
            dto.setCODE(1);
            dto.setMESSAGE("工作站锁定失败，无法启动上架任务!");
            return dto;
        }

        for (int i = 0; i < entryIds.size(); i++) {
            String entryId = (String) entryIds.get(i);
            List<Map> entryPositions = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_INBOUND_POSITION,entryId);
            for (int j = 0; j < entryPositions.size(); j++) {
                Map map = entryPositions.get(j);
                String skuId = CommonUtils.parseString("SKUID",map);
                StorageLocation storageLocation = this.findStorageLocation(skuId);
                if(storageLocation == null){
                    logger.error("SKU没有找到对应存储位，将随机分配空的存储位 SKU:"+skuId);
                    storageLocation = newStorageLocation();
                    if(storageLocation == null){
                        dto.setCODE(1);
                        dto.setMESSAGE("无法为SKU分配库位! SKU:"+skuId);
                        return dto;
                    }
                }
                /* `ID` VARCHAR(255) NOT NULL, WMS_INBOUND_PODORDER
                  `ENTRYID` VARCHAR(255) NOT NULL,
                  `ENTRYPOSITIONID` VARCHAR(255) NOT NULL,
                  `SKUID` VARCHAR(255) NOT NULL,
                  `POD_ID` VARCHAR(255) NOT NULL,
                  `POD_FACE` VARCHAR(255) NOT NULL,
                  `POD_LOCATE` VARCHAR(255) NOT NULL,
                  `PODINDEX` INT(11) DEFAULT NULL COMMENT '货架编号',
                  `STATE` VARCHAR(255) COMMENT '状态',
                  `AMOUNT` INT(11) DEFAULT NULL COMMENT '数量',
                  `WAREHOUSE_ID` VARCHAR(255) NOT NULL COMMENT 'FACTORY',
                  `SECTION_ID` VARCHAR(255) DEFAULT NULL COMMENT '物理区域SECTION',*/
                BaseBpo baseBpo  = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_INBOUND_PODORDER);
                baseBpo.addKV("ID",CommonUtils.genUUID());
                baseBpo.addKV("ENTRYID",entryId);
                baseBpo.addKV("ENTRYPOSITIONID",CommonUtils.parseString("ID",map));
                baseBpo.addKV("POD_ID",storageLocation.getPodId());
                baseBpo.addKV("SKUID",skuId);
                baseBpo.addKV("POD_FACE",storageLocation.getPodFace());
                baseBpo.addKV("STORAGENAME",storageLocation.getStorageName());
                baseBpo.addKV("POD_LOCATE",storageLocation.getLocate());
                baseBpo.addKV("WORKSTATION_ID",stationName);
                baseBpo.addKV("PODINDEX",storageLocation.getPodIndex());
                baseBpo.addKV("AMOUNT",CommonUtils.parseString("AMOUNT",map));
                baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
                baseBpo.addKV("WAREHOUSE_ID",CommonUtils.parseString("WAREHOUSE_ID",map));
                baseBpo.addKV("SECTION_ID",CommonUtils.parseString("SECTION_ID",map));
                //插入货架搬运任务 指令
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }
        }

        return dto;
    }
    /*@Value("${xnr.stationId}")
    private String stationId = "6db9c7c0-4f93-4fa1-82c0-fb6435af7aae";*/

    /**
     * 定时启动任务
     */
    @Scheduled(fixedDelay = 10*1000L)
    public void startInboundTrip(){
        //6db9c7c0-4f93-4fa1-82c0-fb6435af7aae
        if(this.isLockedByOthers(WMSService.stationId, Sql_Table.STOWPOD)){
            logger.error("工作站被锁定，无法启动上架任务!");
            return ;
        }
        //TODO

        //TODO 根据工作站查找
        String pods = this.systemPropertiesManager.getProperty("StowPodStationMaxPod", Sql_Table.WAREHOUSE);
        if(pods == null){
            pods = "5";
        }

        List<Map> runningPods = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_RUNNINGPODS_INBOUND,
                WMSService.stationId, Sql_Table.AVAILABLE,Sql_Table.PROCESS);
        Integer limit = Integer.parseInt(pods) - runningPods.size(); //TODO 按工作站区分
        //先找这么多货架 然后加载所有任务
        List<Map> podIds = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODS,
                Sql_Table.AVAILABLE , Sql_Table.PROCESS);
        for (int i = 0; i < podIds.size() && i < limit; i++) {
            Map map =  podIds.get(i);
            String podId = CommonUtils.parseString("POD_ID",map);
            String workStation = CommonUtils.parseString("WORKSTATION_ID",map);
            List<Map> orderPosition = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODORDERS_INBOUND
                    ,podId, Sql_Table.AVAILABLE); //Available Process Finish  没有Process
            if(orderPosition.isEmpty()){
                logger.error("当前货架没有调度任务 podId:"+podId);
                continue;
            }
            //TODO 如有正在执行的POD任务 应该是添加到明细里

            /*BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable("RCS_TRIP");
            String tripId = CommonUtils.genUUID();
            baseBpo.addKV("ID",tripId);
            baseBpo.addKV("POD_ID",podId);
            baseBpo.addKV("TRIP_TYPE","StowPod");
            baseBpo.addKV("WORKSTATION_ID",workStation);
            baseBpo.addKV("TRIP_STATE",Sql_Table.NEW);
            baseBpo.addKV("WAREHOUSE_ID",CommonUtils.parseString("WAREHOUSE_ID",map));
            baseBpo.addKV("SECTION_ID",CommonUtils.parseString("SECTION_ID",map));
            this.jdbcRepository.insertBusinessObject(baseBpo);*/
            //序号生成 从1开始
            //Map<String,Integer> index = this.genIndexMap();
            for (int j = 0; j < orderPosition.size(); j++) {
                //如果存在RCS_TRIPPOSITION就不要再创建
                Map podOrder = orderPosition.get(j);
                String needFace = CommonUtils.parseString("POD_FACE",podOrder);
                //int sameFaceIndex = index.get(needFace);
                String tripPositionID;
                List<Map> tripPositions = existTripPosition(workStation, podId, needFace);
                if (tripPositions.isEmpty()) {
                    /*BaseBpo baseBpo2 = new BaseBpo();
                    baseBpo2.setTable("RCS_TRIPPOSITION");
                    tripPositionID = CommonUtils.genUUID();
                    baseBpo2.addKV("ID", tripPositionID);
                    baseBpo2.addKV("TRIP_ID", tripId);
                    baseBpo2.addKV("POD_USING_FACE", needFace);
                    baseBpo2.addKV("TRIPPOSITION_STATE", Sql_Table.AVAILABLE);
                    baseBpo2.addKV("POSITION_NO", j + 1);
                    baseBpo2.addKV("WAREHOUSE_ID", CommonUtils.parseString("WAREHOUSE_ID", map));
                    baseBpo2.addKV("SECTION_ID", CommonUtils.parseString("SECTION_ID", map));
                    //发送任务
                    //this.WcsAPI.sent
                    //发送任务结束
                    this.jdbcRepository.insertBusinessObject(baseBpo2);*/
                    Integer podIndex = CommonUtils.parseInteger("POD_INDEX",podOrder);
                    Integer stopCellId = CommonUtils.parseInteger("STOPPOINT",podOrder);
                    Integer sectId = CommonUtils.parseInteger("RCS_SECTIONID",podOrder);
                    Integer face = CommonUtils.faceToInteger(needFace);
                    Integer wsDirect = CommonUtils.wsFace2Direct(
                            CommonUtils.parseInteger("WORKING_FACE_ORIENTATION",podOrder));
                    tripPositionID = this.wmsToWcsService.sendSingleTripToWcs(podIndex,sectId,stopCellId,wsDirect,face);
                }else{
                    Map data = tripPositions.get(0);
                    tripPositionID = CommonUtils.parseString("TRIPPOSITION_ID",data);//实际是WCS返回的任务号
                }

                Map newValue = new HashMap();
                newValue.put("STATE", Sql_Table.PROCESS);//生成就结束了 是不是执行完看TRIPPOSITION_ID
                newValue.put("TRIPPOSITION_ID", tripPositionID);
                CommonUtils.modifyUselessInfo(newValue);

                Map con = new HashMap();
                con.put("ID",CommonUtils.parseString("ID",podOrder));

                this.jdbcRepository.updateRecords(Sql_Table.WMS_INBOUND_PODORDER, newValue,con);
            }
        }
    }
    @Autowired
    private WmsToWcsService wmsToWcsService;

    /**
     * 通过入库单号检查WCS任务信息
     * @param entryId
     * @return
     */
    public String checkInboundTasks(String entryId) {
        List<Map> podOrders = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_INBOUND_PODORDER_BYENTRYID, entryId);
        for (int i = 0; i < podOrders.size(); i++) {
            Map row = podOrders.get(i);
            String taskId = CommonUtils.parseString("TRIPPOSITION_ID",row);
            String result = this.wmsToWcsService.agvTaskDetail(taskId);
            Map data = JsonUtils.json2Map(result);
            String state = CommonUtils.parseString("taskStatus",data);
            row.put("taskStatus",state);
        }
        return JsonUtils.list2Json(podOrders);
    }

    private void updateTripPositionStatus(String state, String tripPositionId) {
        Map newValue = new HashMap();
        newValue.put("TRIPPOSITION_STATE",state);
        CommonUtils.modifyUselessInfo(newValue);

        Map con = new HashMap();
        con.put("ID",tripPositionId);
        this.jdbcRepository.updateRecords("RCS_TRIPPOSITION",newValue,con);

    }

    /**
     * 检查任务状态 如果完成将状态变成Finish 两种类型都处理
     */
    @Scheduled(fixedDelay = 10*1000L)
    public void checkWcsTrip(){

    }


    public List<Map> existTripPosition(String workStation, String podId, String needFace) {
        List<Map> datas = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_INBOUND_PODORDER,
                needFace,podId,workStation);
        return datas;
    }



    private StorageLocation newStorageLocation() {
        List<Map> list = this.jdbcRepository.queryBySql(Sql_Table.SQL_NEWSTORAGELOCATION);
        if(list.isEmpty()){
            //如果没有这个INV_UNITLOAD 就从MD_STORAGELOCATION创建一个
            list = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYEMPTYSTORAGELOCATION);
            Map data = list.get(0);
            //创建这条记录
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.TABLE_INV_UNITLOAD);
            baseBpo.setIdName("ID");
            String id = CommonUtils.genUUID();
            baseBpo.setId(id);
            //新建
            baseBpo.addKV("ID",id);
            baseBpo.addKV("LABEL",CommonUtils.genUUID());
            baseBpo.addKV("LOCATION_INDEX",1);
            baseBpo.addKV("CARRIER",Boolean.FALSE);
            baseBpo.addKV("STORAGELOCATION_ID", CommonUtils.parseString("ID",data));
            baseBpo.addKV("CLIENT_ID",CommonUtils.getClient(Sql_Table.CLIENT_ID));
            baseBpo.addKV("WAREHOUSE_ID",CommonUtils.getWarehouse(Sql_Table.FACTORY));

            this.jdbcRepository.insertBusinessObject(baseBpo);
        }
        Map row = list.get(0);
        StorageLocation storageLocation = new StorageLocation();
        genStorageLocation(storageLocation,row);
        return storageLocation;
    }

    public StorageLocation findStorageLocation(String skuId) {
        StorageLocation storageLocation = new StorageLocation();
        List<Map> data = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYSTORAGELOCATION_BYSKU,skuId);
        if(data.isEmpty()){
            return null;
        }
        Map row = data.get(0);
        genStorageLocation(storageLocation, row);

        return storageLocation;
    }

    private void genStorageLocation(StorageLocation storageLocation, Map row) {
        //P0000024CC02
        String pName = CommonUtils.parseString("NAME",row);
        String podId = CommonUtils.parseString("POD_ID",row);
        logger.debug("pName:"+pName);
        String locate = pName.substring(9);
        storageLocation.setLocate(locate);
        storageLocation.setPodFace(pName.substring(8,9));
        storageLocation.setPodId(podId);
        storageLocation.setStorageName(pName);
        storageLocation.setPodIndex(Integer.parseInt(pName.substring(1,8)));
        storageLocation.setpName(pName);
    }

    public synchronized boolean lockStowStation(String stationId, String type) {

        List<Map> stations = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_WORKSTATION,stationId);
        if(stations.isEmpty()){
            return false;
        }
        Map data = stations.get(0);
        Integer version = CommonUtils.parseInteger("VERSION",data);
        Map newValue = new HashMap();
        newValue.put("VERSION",version+1);
        newValue.put("ISCALLPOD",Boolean.TRUE);
        newValue.put("OPERATOR_ID","LISI");
        newValue.put("STATION_NAME",type);

        Map con = new HashMap();
        con.put("ID",stationId);
        con.put("VERSION",version);

        int count = this.jdbcRepository.updateRecords(Sql_Table.TABLE_MD_WORKSTATION, newValue ,con);
        return count != 0;
    }
    //用户名写死为 LISI
    public boolean isLockedByOthers(String stationId, String type) {
       List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_WORKSTATION, stationId);
       if(rows.isEmpty()){
           return true;
       }
       Map data = rows.get(0);
       String operator_id = CommonUtils.parseString("OPERATOR_ID",data);
        String station_name = CommonUtils.parseString("STATION_NAME",data);
       if(!CommonUtils.isEmpty(operator_id)
               && !Objects.equals(operator_id,"LISI")
               && !Objects.equals(station_name,type)){
           return true;
       }
       return false;
    }

    public MessageDTO endInbound(String stationName) {
        MessageDTO messageDTO = MessageDTO.success();
        List<Map> stations = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_WORKSTATION, stationName);
        if(stations.isEmpty()){
            messageDTO.setMESSAGE(" 没有这个工作站: stationName:"+stationName);
            messageDTO.setCODE(1);
            return messageDTO;
        }
        Map data = stations.get(0);
        Integer version = CommonUtils.parseInteger("VERSION",data);
        Map newValue = new HashMap();
        newValue.put("VERSION",version+1);
        newValue.put("ISCALLPOD",Boolean.FALSE);
        newValue.put("OPERATOR_ID","");
        newValue.put("STATION_NAME","");

        Map con = new HashMap();
        con.put("ID",stationName);
        con.put("VERSION",version);

        int count = this.jdbcRepository.updateRecords(Sql_Table.TABLE_MD_WORKSTATION, newValue ,con);
        if(count!=1){
            messageDTO.setMESSAGE("解锁工作站失败: stationName:" + stationName);
            messageDTO.setCODE(1);
        }
        return messageDTO;
    }

    public Map currentPodTask(String stationName) {
        Map dto = new HashMap();
        //如果没有锁定 就没有任务
        if(isLockedByOthers(stationName, Sql_Table.STOWPOD) ){
            dto.put("CODE",1);
            dto.put("MSG","工作站"+stationName+"被占用，没有当前任务!");
            return dto;
        }

        List<Map> datas = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_CURRENTPOD, stationName);
        //先找再工作站的货架
        if(datas.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前在工作站的货架");
            return dto;
        }

        Map data = datas.get(0);
        Integer pod_toward = CommonUtils.parseInteger("TOWARD", data);
        Integer pod_index = CommonUtils.parseInteger("POD_INDEX", data);
        Integer wsFace = CommonUtils.parseInteger("WORKING_FACE_ORIENTATION", data);
        String podId = CommonUtils.parseString("POD_ID", data);

        String face = getFace(wsFace,pod_toward);
        /*`ID` varchar(255) NOT NULL,
          `ENTRYID` varchar(255) NOT NULL,
          `ENTRYPOSITIONID` varchar(255) NOT NULL,
          `SKUID` varchar(255) NOT NULL,
          `POD_ID` varchar(255) NOT NULL,
          `POD_FACE` varchar(255) NOT NULL,
          `POD_LOCATE` varchar(255) NOT NULL,
          `PODINDEX` int(11) DEFAULT NULL COMMENT '货架编号',
          `STATE` varchar(255) COMMENT '状态',*/
        //拼接后去找有没有要拣的任务单 WMS_INBOUND_PODORDER 根据 货架 面
        List<Map> podTask = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_PODORDRTASK, podId,face);
        if(podTask.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","当前货架:POD:"+pod_index+" 没有上架任务,请释放");
            return dto;
        }
        Map podOrder = podTask.get(0);
        String skuId = CommonUtils.parseString("SKUID", podOrder);
        List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId);
        if (skus.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前上架商品信息, SKU:"+skuId);
            return dto;
        }
        Map sku = skus.get(0);
        data.put("SKUNAME",CommonUtils.parseString("NAME",sku));
        data.putAll(podOrder);

        return data;
    }
    //ABCD 从上往下看
    public static String getFace(Integer wsFace, Integer pod_toward) {
        if(wsFace%90!=0 || pod_toward%90!=0){
            return "A";//默认A面
        }

       switch (pod_toward){
            case 0 : return  "CDAB".charAt(wsFace/90) +"";
            case 90 : return  "BCDA".charAt(wsFace/90) +"";
            case 180 : return  "ABCD".charAt(wsFace/90) +"";
            default: return "DABC".charAt(wsFace/90)+"";//270
        }
    }

    public static void main(String[] args) {
        /*System.out.println(getFace(0,0));
        System.out.println(getFace(90,0));
        System.out.println(getFace(180,0));
        System.out.println(getFace(270,0));
        System.out.println(getFace(0,90));
        System.out.println(getFace(90,90));
        System.out.println(getFace(180,90));
        System.out.println(getFace(270,90));
        System.out.println(getFace(0,180));
        System.out.println(getFace(90,180));
        System.out.println(getFace(180,180));
        System.out.println(getFace(270,180));
        System.out.println(getFace(0,270));
        System.out.println(getFace(90,270));
        System.out.println(getFace(180,270));
        System.out.println(getFace(270,270));*/
    }

    /*public Map prePodTask(String stationName) {
        Map dto = new HashMap();
        //如果没有锁定 就没有任务
        if(isLockedByOthers(stationName) ){
            dto.put("CODE",1);
            dto.put("MSG","工作站"+stationName+"被占用，没有当前任务!");
            return dto;
        }

        List<Map> datas = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_CURRENTPODTASK,
                Sql_Table.AVAILABLE, Sql_Table.PROCESS, Sql_Table.PROCESS,stationName);

        if(datas.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前在工作站的货架");
            return dto;
        }

        Map data = datas.get(0);
        *//*`ID` varchar(255) NOT NULL,
          `ENTRYID` varchar(255) NOT NULL,
          `ENTRYPOSITIONID` varchar(255) NOT NULL,
          `SKUID` varchar(255) NOT NULL,
          `POD_ID` varchar(255) NOT NULL,
          `POD_FACE` varchar(255) NOT NULL,
          `POD_LOCATE` varchar(255) NOT NULL,
          `PODINDEX` int(11) DEFAULT NULL COMMENT '货架编号',
          `STATE` varchar(255) COMMENT '状态',*//*
        String skuId = CommonUtils.parseString("SKUID",data);
        List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, skuId);
        if (skus.isEmpty()){
            dto.put("CODE",1);
            dto.put("MSG","没有找到当前上架商品信息, SKU:"+skuId);
            return dto;
        }
        Map sku = skus.get(0);
        data.put("SKUNAME",CommonUtils.parseString("NAME",sku));

        return data;
    }*/
}
