package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.InboundOrderDTO;
import com.mushiny.heli.xnr.dto.InboundOrderPosition;
import com.mushiny.heli.xnr.dto.OutboundOrderDTO;
import com.mushiny.heli.xnr.dto.OutboundOrderPosition;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Lisi on 2019-11-18.
 */
@Service
public class WMSRespService {
    private final static Logger logger = LoggerFactory.getLogger(WMSRespService.class);

    public static final String SQL_QUERYALL_INBOUNDORDER =
            "SELECT * FROM WMS_INBOUND_ORDER ,WMS_INBOUND_ORDERPOSITION " +
            "WHERE WMS_INBOUND_ORDER.ENTRYID=WMS_INBOUND_ORDERPOSITION.ENTRYID " +
            "AND WMS_INBOUND_ORDER.STATE=? AND NEED_RESP=1";
    private static final String SQL_QUERYALL_OUTBOUNDORDER =
            "SELECT * FROM WMS_OUTBOUND_ORDER ,WMS_OUTBOUND_ORDERPOSITION " +
            "WHERE WMS_OUTBOUND_ORDER.ORDERID=WMS_OUTBOUND_ORDERPOSITION.ORDERID " +
            "AND WMS_OUTBOUND_ORDER.STATE=? AND NEED_RESP=1";

    public static final String TABLE_OBORDER = "WMS_OUTBOUND_ORDER";
    public static final String TABLE_IBORDER = "WMS_INBOUND_ORDER";
    public static final String SQL_QUERYALL_ICQAORDER =
            "SELECT * FROM WMS_ICQA_ORDER,WMS_ICQA_ORDERPOSITION " +
            "WHERE WMS_ICQA_ORDER.TASKID = WMS_ICQA_ORDERPOSITION.TASKID " +
            "AND WMS_ICQA_ORDER.STATE=? AND NEED_RESP=1";

    @Value("${mushiny.heli.wms.inboundResp.url}")
    private String inboundResp_url;
    @Value("${mushiny.heli.wms.outboundResp.url}")
    private String outboundResp_url;

    //mushiny.heli.wms.icqaResp.url=http://localhost/heli/icqaResp
    @Value("${mushiny.heli.wms.icqaResp.url}")
    private String icqaResp_url;

    public static final String FINISH = "Finish";
    public static final String AVAILABLE = "Available";
    public static final String PROCESS = "Process";



    private final RestTemplateBuilder builder;

    @Autowired
    private JdbcRepository jdbcRepository;

    @Autowired
    public WMSRespService(RestTemplateBuilder builder) {
        this.builder = builder;
    }


    @Scheduled(fixedDelay = 50*1000L)
    @Transactional
    public void icqaResp(){
        logger.debug("回复盘点任务状态....");
        RestTemplate restTemplate = builder.build();

        HttpHeaders headers = this.getHttpHeaders();

        List<Map> data = this.jdbcRepository.queryBySql(SQL_QUERYALL_ICQAORDER,FINISH);
        List<InboundOrderDTO> data2 = this.transfer2InDTO(data);//合并主表记录
        for (int i = 0; i < data2.size(); i++) {
            InboundOrderDTO inboundOrderDTO = data2.get(i);
            String json = JsonUtils.bean2Json(inboundOrderDTO);
            logger.debug("post data: " + json);
            HttpEntity<String> httpEntity = new HttpEntity<String>(json, headers);
            ResponseEntity<String> res = restTemplate.postForEntity(this.inboundResp_url, httpEntity, String.class);
            Map result = JsonUtils.json2Map(res.getBody());
            logger.debug("result: " + result);
            if(CommonUtils.parseInteger("CODE",result) == 0){
                logger.debug("成功回调"+inboundOrderDTO.getENTRYID());
                Map newValue = new HashMap();
                newValue.put("NEED_RESP",2);
                Map con = new HashMap();
                con.put("ENTRYID",inboundOrderDTO.getENTRYID());
                this.jdbcRepository.updateRecords(TABLE_IBORDER,newValue,con);
            }
        }
        //检查是否有明细已完成 需要将主表记录更新为完成Finish

    }

    @Scheduled(fixedDelay = 50*1000L)
    @Transactional
    public void inboundResp(){
        logger.debug("回复入库单状态....");
        RestTemplate restTemplate = builder.build();

        HttpHeaders headers = this.getHttpHeaders();

        List<Map> data = this.jdbcRepository.queryBySql(SQL_QUERYALL_INBOUNDORDER,FINISH);
        List<InboundOrderDTO> data2 = this.transfer2InDTO(data);//合并主表记录
        for (int i = 0; i < data2.size(); i++) {
            InboundOrderDTO inboundOrderDTO = data2.get(i);
            String json = JsonUtils.bean2Json(inboundOrderDTO);
            logger.debug("post data: " + json);
            HttpEntity<String> httpEntity = new HttpEntity<String>(json, headers);
            ResponseEntity<String> res = restTemplate.postForEntity(this.inboundResp_url, httpEntity, String.class);
            Map result = JsonUtils.json2Map(res.getBody());
            logger.debug("result: " + result);
            if(CommonUtils.parseInteger("CODE",result) == 0){
                logger.debug("成功回调"+inboundOrderDTO.getENTRYID());
                Map newValue = new HashMap();
                newValue.put("NEED_RESP",2);
                Map con = new HashMap();
                con.put("ENTRYID",inboundOrderDTO.getENTRYID());
                this.jdbcRepository.updateRecords(TABLE_IBORDER,newValue,con);
            }
        }
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return headers;
    }

    @Scheduled(fixedDelay = 50*1000L)
    @Transactional
    public void outboundResp(){
        logger.debug("回复出库单状态....");
        RestTemplate restTemplate = builder.build();

        HttpHeaders headers = this.getHttpHeaders();

        List<Map> data = this.jdbcRepository.queryBySql(SQL_QUERYALL_OUTBOUNDORDER,FINISH);
        List<OutboundOrderDTO> data2 = this.transfer2OutDTO(data);//合并主表记录
        for (int i = 0; i < data2.size(); i++) {
            OutboundOrderDTO outboundOrderDTO = data2.get(i);
            String json = JsonUtils.bean2Json(outboundOrderDTO);
            logger.debug("post data: " + json);
            HttpEntity<String> httpEntity = new HttpEntity<String>(json, headers);
            ResponseEntity<String> res = restTemplate.postForEntity(this.outboundResp_url, httpEntity, String.class);
            Map result = JsonUtils.json2Map(res.getBody());
            logger.debug("result: " + result);
            if(CommonUtils.parseInteger("CODE",result) == 0){
                logger.debug("成功回调"+outboundOrderDTO.getORDERID());
                Map newValue = new HashMap();
                newValue.put("NEED_RESP",2);
                Map con = new HashMap();
                con.put("ORDERID",outboundOrderDTO.getORDERID());
                this.jdbcRepository.updateRecords(TABLE_OBORDER,newValue,con);
            }
        }

        //如果明细都已结束 将主表更新为已完成，减少操作时的判断
        List<Map> list = this.jdbcRepository
                .queryBySql(Sql_Table.SQL_OUTBOUNDORDERPOSITION_BYSTATE, Sql_Table.FINISH);
        for (int i = 0; i < list.size(); i++) {
            Map rows = list.get(i);
            Map newValue = new HashMap();
            newValue.put("STATE", Sql_Table.FINISH);
            CommonUtils.modifyUselessInfo(newValue);
            Map con = new HashMap();
            con.put("ENTRYID",CommonUtils.parseString("ENTRYID",rows));

            this.jdbcRepository.updateRecords(Sql_Table.WMS_OUTBOUND_ORDER,newValue,con);
        }

    }

    private List<OutboundOrderDTO> transfer2OutDTO(List<Map> data) {
        Map<String,OutboundOrderDTO> temp = new HashMap();

        for (int i = 0; i < data.size(); i++) {
            Map map = data.get(i);
            String entryId = (String) map.get("ENTRYID");
            if(temp.get(entryId) == null){
                OutboundOrderDTO outboundOrderDTO = new OutboundOrderDTO();
                outboundOrderDTO.setORDERID(entryId);
                outboundOrderDTO.setSECTION((String) map.get("SECTION"));
                outboundOrderDTO.setFACTORY((String) map.get("FACTORY"));
                outboundOrderDTO.setTIMES(CommonUtils.parseInteger("TIMES",map));
                outboundOrderDTO.setDATA(new ArrayList<>());
                temp.put(entryId,outboundOrderDTO);
            }
            OutboundOrderDTO outboundOrderDTO = temp.get(entryId);
            //每行一条明细记录
            OutboundOrderPosition outboundOrderPosition = new OutboundOrderPosition();
            outboundOrderPosition.setSHIPMENTID(CommonUtils.parseString("SHIPMENTID",map));
            outboundOrderPosition.setSKUID(CommonUtils.parseString("SKUID",map));
            outboundOrderPosition.setAMOUNT(CommonUtils.parseInteger("AMOUNT",map));
            outboundOrderPosition.setMSG(CommonUtils.parseString("MSG",map));
            outboundOrderPosition.setSTATE(CommonUtils.parseString("STATE",map));
            outboundOrderPosition.setPICKED(CommonUtils.parseInteger("PICKED",map));

            outboundOrderDTO.getDATA().add(outboundOrderPosition);
        }
        //返回所有
        return new ArrayList<>(temp.values());
    }

    private List<InboundOrderDTO> transfer2InDTO(List<Map> data) {
        Map<String,InboundOrderDTO> temp = new HashMap();

        for (int i = 0; i < data.size(); i++) {
            Map map = data.get(i);
            String entryId = (String) map.get("ENTRYID");
            if(temp.get(entryId) == null){
                InboundOrderDTO inboundOrderDTO = new InboundOrderDTO();
                inboundOrderDTO.setENTRYID(entryId);
                inboundOrderDTO.setSECTION((String) map.get("SECTION"));
                inboundOrderDTO.setFACTORY((String) map.get("FACTORY"));
                inboundOrderDTO.setTIMES(CommonUtils.parseInteger("TIMES",map));
                inboundOrderDTO.setDATA(new ArrayList<>());
                temp.put(entryId,inboundOrderDTO);
            }
            InboundOrderDTO inboundOrderDTO = temp.get(entryId);
            //每行一条明细记录
            InboundOrderPosition inboundOrderPosition = new InboundOrderPosition();
            inboundOrderPosition.setSKUID((String) map.get("SKUID"));
            inboundOrderPosition.setAMOUNT(CommonUtils.parseInteger("AMOUNT",map));
            inboundOrderPosition.setMSG(CommonUtils.parseString("MSG",map));
            inboundOrderPosition.setSTATE(CommonUtils.parseString("STATE",map));
            inboundOrderPosition.setSTORED(CommonUtils.parseInteger("STORED",map));

            inboundOrderDTO.getDATA().add(inboundOrderPosition);
        }
        //返回所有
        return new ArrayList<>(temp.values());
    }
}
