package com.mushiny.heli.xnr.controller;

import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.service.InboundService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Lisi on 2019-11-27.
 */
@RestController
@RequestMapping("/inbound")
public class InboundController {
    private final static Logger logger = LoggerFactory.getLogger(InboundController.class);

    @Autowired
    private InboundService inboundService;

    @PostMapping(value = "/store", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> store(
            @RequestBody String json){
        Map data = JsonUtils.json2Map(json);
        int stored = CommonUtils.parseInteger("stored",data);
        String skuId = CommonUtils.parseString("skuId",data);
        String factory = CommonUtils.parseString("factory",data);
        String section = CommonUtils.parseString("section",data);
        String entryId = CommonUtils.parseString("entryId",data);
        String podOrderId = CommonUtils.parseString("podOrderId",data);
        //货架的货位 P0000008AA01
        String containerId = CommonUtils.parseString("containerId",data);
        MessageDTO dto = this.inboundService.store(skuId,stored,containerId,factory,section,entryId,podOrderId);
        return ResponseEntity.ok(dto);
    }

    /**
     * @param json
     * @return
     */
    @PostMapping(value = "/searchInbound", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> searchInbound(
            @RequestBody String json){
        Map reqData = JsonUtils.json2Map(json);
        String entryId = CommonUtils.parseString("entryId",reqData);
        String warehouseId = CommonUtils.parseString("factory",reqData);
        String sectionId = CommonUtils.parseString("section",reqData);
        List<Map> data = this.inboundService.searchInbound(entryId,warehouseId,sectionId);

        return ResponseEntity.ok(JsonUtils.list2Json(data));
    }

    /**
     * @param json
     * @return
     */
    @PostMapping(value = "/searchInboundInfo", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> searchInboundInfo(
            @RequestBody String json){
        Map reqData = JsonUtils.json2Map(json);
        String entryId = CommonUtils.parseString("entryId",reqData);
        Map ret = new HashMap();
        List data = this.inboundService.searchInboundInfo(entryId);
        ret.put("entryId",entryId);
        ret.put("content",data);
        return ResponseEntity.ok(JsonUtils.map2Json(ret));
    }

    /**
     * @param json
     * @return
     */
    @PostMapping(value = "/orderFinish", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> orderFinish(
            @RequestBody String json){
        Map reqData = JsonUtils.json2Map(json);
        String entryId = CommonUtils.parseString("entryId",reqData);
        MessageDTO dto = this.inboundService.orderFinish(entryId);
        return ResponseEntity.ok(dto);
    }


    /**
     * @param json
     * @return
     */
    @PostMapping(value = "/skuNotFound", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> skuNotFound(
            @RequestBody String json){
        Map reqData = JsonUtils.json2Map(json);
        String entryId = CommonUtils.parseString("entryId",reqData);
        String skuId = CommonUtils.parseString("skuId",reqData);
        MessageDTO dto = this.inboundService.skuNotFound(entryId,skuId);
        return ResponseEntity.ok(dto);
    }

    /**
     * 启动上架入库单
     * @param json
     * @return
     */
    @PostMapping(value = "/startInbound", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> startInbound(
            @RequestBody String json){
        Map station  = JsonUtils.json2Map(json);
        List entryIds  = (List) station.get("entryIds");
        String stationName = (String) station.get("stationName");
        MessageDTO dto = this.inboundService.startInbound(entryIds, stationName);
        return ResponseEntity.ok(dto);
    }

    /**
     * 退出上架 如果stowpod任务还在 就提示并强制退出
     * @param json
     * @return
     */
    @PostMapping(value = "/endInbound", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> endInbound(
            @RequestBody String json){
        Map station  = JsonUtils.json2Map(json);
        MessageDTO dto = this.inboundService.endInbound(CommonUtils.parseString("stationName",station));
        return ResponseEntity.ok(dto);
    }

    /**
     * 当前任务
     * @param json
     * @return
     */
    @PostMapping(value = "/currentPodTask", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> currentPodTask(
            @RequestBody String json){
        Map station  = JsonUtils.json2Map(json);
        //工作站号码
        Map dto = this.inboundService.currentPodTask(CommonUtils.parseString("stationName",station));
        return ResponseEntity.ok(JsonUtils.map2Json(dto));
    }

    //前次操作 暂时实现不了 可以再次生成上架任务
    @PostMapping(value = "/prePodTask", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> prePodTask(
            @RequestBody String json){
        /*Map station  = JsonUtils.json2Map(json);
        //工作站号码
        Map dto = this.inboundService.prePodTask(CommonUtils.parseString("stationName",station));
        return ResponseEntity.ok(JsonUtils.map2Json(dto));*/
        return null;
    }

}
