package com.mushiny.heli.xnr.mq;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.controller.HeliWMSController;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import com.mushiny.heli.xnr.service.Sql_Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class MqListener {

    private final static Logger logger = LoggerFactory.getLogger(MqListener.class);

    @Autowired
    private JdbcRepository jdbcRepository;

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = "", durable = "true"),
            exchange = @Exchange(value = "amq.topic" , ignoreDeclarationExceptions = "true"),
            key = "monitor_pod_to_workstation.*"))
    public void pod2Station(Message message){
        byte[] body = message.getBody();
        String jsonData = new String(body);
        Map data = JsonUtils.json2Map(jsonData);
        logger.info("monitor_pod_to_workstation:" + data);
    }

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = "", durable = "true"),
            exchange = @Exchange(value = "amq.topic" , ignoreDeclarationExceptions = "true"),
            key = "monitor_pod_to_workstation.*"))
    public void pod2Station2(Message message){
        byte[] body = message.getBody();
        String jsonData = new String(body);
        Map data = JsonUtils.json2Map(jsonData);
        logger.info("monitor_pod_to_workstation2:" + data);
    }

    @RabbitListener(queues = "POD_STATION_HELI")
    @Transactional
    public void pod2Station3(Message message){
        byte[] body = message.getBody();
        String jsonData = new String(body);
        Map data = JsonUtils.json2Map(jsonData);
        logger.info("monitor_pod_to_workstation3:" + data);
        int stopCellId = CommonUtils.parseInteger("stopCellId",data);
        String sectionId = this.getSectionIdBySid(CommonUtils.parseInteger("sectionId",data));
        String workstationId = this.getWorkstationIdByStopPoint(stopCellId,sectionId);
        /*Integer sectionId;
        Integer stopCellId; //停止点
        Integer direction;//工作站相对停止点方向
        String podId;
        Integer podDirection;
        String taskId;*/
        List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_POD_STATION,stopCellId,workstationId);
        if(rows.isEmpty()){
            Map record = new HashMap();
            record.putAll(data);
            //替换掉 便于查询
            record.put("stopCellId",workstationId);
            record.put("sectionId",sectionId);
            CommonUtils.genUselessInfo(record);
            this.jdbcRepository.insertRecord(Sql_Table.TABLE_WMS_POD_STATION,record);
            logger.debug("新增记录成功");
        }else{
            Map newValue = new HashMap();
            newValue.putAll(data);
            newValue.put("stopCellId",workstationId);
            newValue.put("sectionId",sectionId);
            CommonUtils.modifyUselessInfo(newValue);

            Map con = new HashMap();
            con.put("stopCellId",workstationId);
            con.put("sectionId",sectionId);

            int ret = this.jdbcRepository.updateRecords(Sql_Table.TABLE_WMS_POD_STATION, newValue, con);
            logger.debug("更新记录:"+data+" 结果为:"+ret);
        }
    }

    private String getWorkstationIdByStopPoint(int stopCellId, String sectionId) {
        Map row = this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERYWDBYSTOP,stopCellId,sectionId);
        return CommonUtils.parseString("ID",row);
    }

    private String getSectionIdBySid(Integer sid) {
       Map row = this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERYSECTIONBYSID,sid);
       return CommonUtils.parseString("ID",row);
    }
}
