package com.mushiny.heli.xnr.service;

import com.mushiny.heli.xnr.beans.BaseBpo;
import com.mushiny.heli.xnr.comm.CommonUtils;
import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.*;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Date;
import java.util.*;

/**
 * Lisi @ 2019-11-18
 */
@Service
public class WMSService {


    @Autowired
    private JdbcRepository jdbcRepository;

    private final static Logger logger = LoggerFactory.getLogger(WMSService.class);


    @Transactional
    public void saveInboundOrder(InboundOrderDTO inboundOrderDTO){
        List<InboundOrderPosition> data = inboundOrderDTO.getDATA();
        for (int i = 0; i < data.size(); i++) {
            InboundOrderPosition inboundOrderPosition =  data.get(i);
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDERPOSITION);
            baseBpo.setIdName("ID");
            baseBpo.addKV("ENTRYID",inboundOrderDTO.getENTRYID());
            baseBpo.addKV("AMOUNT",inboundOrderPosition.getAMOUNT());
            baseBpo.addKV("SKUID",inboundOrderPosition.getSKUID());
            baseBpo.addKV("ID",CommonUtils.genUUID());
            baseBpo.addKV("WAREHOUSE_ID",inboundOrderDTO.getFACTORY());
            baseBpo.addKV("SECTION_ID",inboundOrderDTO.getSECTION());
            baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
            baseBpo.addKV("STATE", Sql_Table.AVAILABLE);
            //增加了订单上架的序号 按入库单序号来
            this.jdbcRepository.insertBusinessObject(baseBpo);
        }

        BaseBpo baseBpo = new BaseBpo();

        baseBpo.setTable(Sql_Table.WMS_INBOUND_ORDER);
        baseBpo.setIdName("ENTRYID");
        baseBpo.addKV("TIMES",inboundOrderDTO.getTIMES());
        baseBpo.addKV("WAREHOUSE_ID",inboundOrderDTO.getFACTORY());
        baseBpo.addKV("SECTION_ID",inboundOrderDTO.getSECTION());
        baseBpo.addKV("ENTRYID",inboundOrderDTO.getENTRYID());
        this.jdbcRepository.insertBusinessObject(baseBpo);
    }
    @Transactional
    public void saveOutboundOrder(OutboundOrderDTO outboundOrderDTO) {
        List<OutboundOrderPosition> data = outboundOrderDTO.getDATA();
        //1、保存到OB_CUSTOMERSHIPMENT表
        BaseBpo cs = new BaseBpo();
        cs.setTable(Sql_Table.TABLE_OB_CUSTOMERSHIPMENT);
        String csid = CommonUtils.genUUID();
        cs.addKV("ID",csid);
        /* `SHIPMENT_NO` varchar(255) NOT NULL DEFAULT '' COMMENT '订单拆分后的编号',
          `PRIORITY` int(11) NOT NULL COMMENT '优先等级',
          `STATE` int(11) NOT NULL COMMENT '状态',
          `PASSED_OVER_COUNT` int(11) NOT NULL COMMENT '未选中的次数',
          `ACTIVATED` bit(1) NOT NULL COMMENT '是否激活',
          `SELECTED` bit(1) NOT NULL COMMENT '是否进入Select Window',
          `COMPLETED` bit(1) NOT NULL COMMENT '是否已全部分配拣货任务',
         `WAREHOUSE_ID` varchar(255) NOT NULL,*/
        cs.addKV("SHIPMENT_NO",outboundOrderDTO.getORDERID());
        cs.addKV("PRIORITY", 1);
        cs.addKV("STATE", 0);
        cs.addKV("PASSED_OVER_COUNT", 0);
        cs.addKV("ACTIVATED", Boolean.FALSE);
        cs.addKV("SELECTED", Boolean.FALSE);
        cs.addKV("COMPLETED", Boolean.FALSE);
        cs.addKV("WAREHOUSE_ID", outboundOrderDTO.getFACTORY());
        cs.addKV("CLIENT_ID", outboundOrderDTO.getFACTORY());
        cs.addKV("TYPE", "Customer");
        //新增一条记录
        this.jdbcRepository.insertBusinessObject(cs);

        for (int i = 0; i < data.size(); i++) {
            OutboundOrderPosition outboundOrderPosition =  data.get(i);
            //2、保存到OB_CUSTOMERSHIPMENTPOSITION表
            BaseBpo csp = new BaseBpo();
            csp.setTable(Sql_Table.TABLE_OB_CUSTOMERSHIPMENTPOSITION);
            String cspId = CommonUtils.genUUID();
            csp.addKV("ID",cspId);
            /*  `AMOUNT` decimal(17,4) NOT NULL DEFAULT '0.0000' COMMENT '数量',
              `STATE` int(11) NOT NULL COMMENT '状态',
              `ITEMDATA_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品',
              `SHIPMENT_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '订单编号',
              `POSITION_NO` int(11) NOT NULL COMMENT '详细编号',
              `ORDER_INDEX` int(11) NOT NULL COMMENT '排序',
              `CLIENT_ID` varchar(255) NOT NULL,
              `WAREHOUSE_ID` varchar(255) NOT NULL,*/
            csp.addKV("STATE",0);//600就是完成
            List<Map> items = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO,
                    outboundOrderPosition.getSKUID());
            Map item = items.get(0);
            String mID = CommonUtils.parseString("ID",item);
            csp.addKV("ITEMDATA_ID",mID);
            csp.addKV("SHIPMENT_ID",csid);
            csp.addKV("POSITION_NO",i+1);
            csp.addKV("ORDER_INDEX",i+1);
            csp.addKV("CLIENT_ID",outboundOrderDTO.getFACTORY());
            csp.addKV("WAREHOUSE_ID",outboundOrderDTO.getFACTORY());
            this.jdbcRepository.insertBusinessObject(csp);

            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.WMS_OUTBOUND_ORDERPOSITION);
            baseBpo.setIdName("ID");
            baseBpo.addKV("ID",CommonUtils.genUUID());
            baseBpo.addKV("ORDERID",outboundOrderDTO.getORDERID());
            baseBpo.addKV("AMOUNT",outboundOrderPosition.getAMOUNT());
            baseBpo.addKV("SKUID",outboundOrderPosition.getSKUID());
            baseBpo.addKV("SHIPMENTID",outboundOrderPosition.getSHIPMENTID());
            baseBpo.addKV("SHIPMENTPOSITION_ID", cspId);
            baseBpo.addKV("WAREHOUSE_ID",outboundOrderDTO.getFACTORY());
            baseBpo.addKV("SECTION_ID",outboundOrderDTO.getSECTION());
            this.jdbcRepository.insertBusinessObject(baseBpo);
        }

        BaseBpo baseBpo = new BaseBpo();
        baseBpo.setTable(Sql_Table.WMS_OUTBOUND_ORDER);
        baseBpo.setIdName("ORDERID");
        baseBpo.addKV("TIMES",outboundOrderDTO.getTIMES());
        baseBpo.addKV("WAREHOUSE_ID",outboundOrderDTO.getFACTORY());
        baseBpo.addKV("SECTION_ID",outboundOrderDTO.getSECTION());
        baseBpo.addKV("ORDERID",outboundOrderDTO.getORDERID());
        this.jdbcRepository.insertBusinessObject(baseBpo);
    }
    /*  `ID` varchar(255) NOT NULL,
  `ITEM_NO` varchar(255) NOT NULL DEFAULT '' COMMENT '唯一编码',
  `SKU_NO` varchar(255) DEFAULT '' COMMENT 'SKU',
  `NAME` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `SAFETY_STOCK` int(11) NOT NULL COMMENT '安全库存',
  `LOT_MANDATORY` bit(1) NOT NULL COMMENT '是否有效期商品',
  `SERIAL_RECORD_TYPE` varchar(255) NOT NULL DEFAULT '' COMMENT '商品的序列号码有规则的设置', NO_RECORD
  `HEIGHT` decimal(15,2) DEFAULT NULL COMMENT '高',
  `WIDTH` decimal(15,2) DEFAULT NULL COMMENT '长',
  `DEPTH` decimal(15,2) DEFAULT NULL COMMENT '宽',
  `MULTIPLE_PART` bit(1) NOT NULL COMMENT '是否一套',
  `MULTIPLE_PART_AMOUNT` int(11) NOT NULL COMMENT '几套几件',
  `MEASURED` bit(1) NOT NULL COMMENT '是否测量',
  `PREFER_OWNBOX` bit(1) NOT NULL COMMENT '是否自带包装',
  `PREFER_BAG` bit(1) NOT NULL COMMENT '是否用袋子',
  `USE_BUBBLEFILM` bit(1) NOT NULL COMMENT '是否使用气垫膜',
  `ITEMGROUP_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品类型',
  `HANDLINGUNIT_ID` varchar(255) NOT NULL DEFAULT '' COMMENT '商品单位',
  `VERSION` int(11) NOT NULL,*/
    /*保存到商品信息表*/
    public static final String ITEM_GROUP = "fd335ce3-1b83-4819-81d9-34f8aa5a2139";
    public static final String HANDLING_UNIT_ID = "d7599399-3da6-478c-b14d-60e6be6ef11e";
    public void syncItem(ItemDTO itemDTO) {

        List<Map> skus = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYSKUNO, itemDTO.getSKUID());

        List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERYITEM_BYID, itemDTO.getSKUID());
        if (skus.isEmpty() && rows.isEmpty()){
            //新建一条
            BaseBpo baseBpo = new BaseBpo();
            baseBpo.setTable(Sql_Table.TABLE_MD_ITEMDATA);
            baseBpo.addKV("ID",itemDTO.getSKUID()).addKV("ITEM_NO",itemDTO.getSKUID())/*.addKV("SKU_NO",itemDTO.getSKUID())*/;
            baseBpo.addKV("NAME",itemDTO.getSNAME()).addKV("LOT_MANDATORY",0).addKV("SERIAL_RECORD_TYPE","NO_RECORD");
            baseBpo.addKV("HEIGHT",itemDTO.getHEIGHT()).addKV("WIDTH",itemDTO.getWIDTH()).addKV("DEPTH",itemDTO.getLENGTH());
            baseBpo.addKV("MULTIPLE_PART",Boolean.FALSE).addKV("MULTIPLE_PART_AMOUNT",0).addKV("MEASURED",Boolean.TRUE);
            baseBpo.addKV("PREFER_OWNBOX",Boolean.FALSE).addKV("PREFER_BAG",Boolean.FALSE).addKV("USE_BUBBLEFILM",Boolean.FALSE);
            baseBpo.addKV("ITEMGROUP_ID",ITEM_GROUP).addKV("HANDLINGUNIT_ID",HANDLING_UNIT_ID).addKV("VERSION",itemDTO.getSTATUS());
            baseBpo.addKV("CLIENT_ID",itemDTO.getFACTORY()).addKV("WAREHOUSE_ID",itemDTO.getSECTION());
            baseBpo.addKV("SAFETY_STOCK",0);
            //增加工厂和仓库 一个工厂多个仓库 一个工厂我们认为是CLIENT_ID户主 一个WAREHOUSE_ID是一个仓库
            BaseBpo baseBpo2 = new BaseBpo();
            baseBpo2.setTable(Sql_Table.TABLE_MD_ITEMDATA_SKUNO);
            baseBpo2.addKV("CLIENT_ID",itemDTO.getFACTORY()).addKV("ITEM_NO",itemDTO.getSKUID()).addKV("SKU_NO",itemDTO.getSKUID());
            baseBpo2.addKV("ID",CommonUtils.genUUID());
            this.jdbcRepository.insertBusinessObject(baseBpo);
            this.jdbcRepository.insertBusinessObject(baseBpo2);
        }else{
            //根据ID更新 ID暂定跟SKU_NO ITEM_NO 一样
            BaseBpo baseBpo = new BaseBpo();
            //baseBpo.addKV("ID",itemDTO.getSKUID()).addKV("ITEM_NO",itemDTO.getSKUID()).addKV("SKU_NO",itemDTO.getSKUID());
            baseBpo.addKV("NAME",itemDTO.getSNAME()).addKV("LOT_MANDATORY",0).addKV("SERIAL_RECORD_TYPE","NO_RECORD");
            baseBpo.addKV("HEIGHT",itemDTO.getHEIGHT()).addKV("WIDTH",itemDTO.getWIDTH()).addKV("DEPTH",itemDTO.getLENGTH());
            baseBpo.addKV("MULTIPLE_PART",Boolean.FALSE).addKV("MULTIPLE_PART_AMOUNT",0).addKV("MEASURED",Boolean.TRUE);
            baseBpo.addKV("PREFER_OWNBOX",Boolean.FALSE).addKV("PREFER_BAG",Boolean.FALSE).addKV("USE_BUBBLEFILM",Boolean.FALSE);
            baseBpo.addKV("ITEMGROUP_ID",ITEM_GROUP).addKV("HANDLINGUNIT_ID",HANDLING_UNIT_ID).addKV("VERSION",itemDTO.getSTATUS());
            baseBpo.addKV("CLIENT_ID",itemDTO.getFACTORY()).addKV("WAREHOUSE_ID",itemDTO.getSECTION());
            baseBpo.setIdName("ID");
            baseBpo.setTable(Sql_Table.TABLE_MD_ITEMDATA);
            baseBpo.setId(itemDTO.getSKUID());

            this.jdbcRepository.updateBusinessObject(baseBpo);
        }

    }

    public MessageDTO createICQAOrder(Map data) {
        MessageDTO messageDTO = MessageDTO.success();
        BaseBpo order = new BaseBpo();
        order.setTable(Sql_Table.WMS_ICQA_ORDER);
        String orderId = CommonUtils.genUUID();
        order.addKV("TASKID", orderId);
        order.addKV("CREATED_DATE",new Date(System.currentTimeMillis()));
        order.addKV("FACTORY",CommonUtils.parseString("FACTORY",data));
        order.addKV("SECTION",CommonUtils.parseString("SECTION",data));
        order.addKV("SECTION",CommonUtils.parseString("SECTION",data));
        //"type":"all"
        if(Objects.equals(CommonUtils.parseString("type", data), Sql_Table.ALL_TYPE)){
            order.addKV("TYPE",Sql_Table.ALL_TYPE);
            //检查是否有全盘在执行 如果没完成不能再生成
            List<Map> rows = this.jdbcRepository.queryBySql(Sql_Table.SQL_QUERY_ICQA_BY_TYPE,"Finish");
            if(rows!=null && rows.size()>0){
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("已有全库盘点任务,不能再次生成!");
                return messageDTO;
            }

            //全盘 所有SKU生成盘点任务
            List<Map> items= this.jdbcRepository.queryBySql(Sql_Table.SQL_FINDALLITEM
                    ,CommonUtils.parseString("FACTORY",data)
                    ,CommonUtils.parseString("SECTION",data));
            for (int i = 0; i < items.size(); i++) {
                Map map = items.get(i);
                BaseBpo baseBpo = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_ICQA_ORDERPOSITION);
                baseBpo.addKV("ICQAID",orderId).addKV("ID",CommonUtils.genUUID())
                        .addKV("SKUID",CommonUtils.parseString("ID",map));
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }

        }else{
            //从 DATA选sku
            order.addKV("TYPE",Sql_Table.SKU_TYPE);//两种类型
            List<Map> skus = (List<Map>) data.get("DATA");
            //查找所有存在盘点任务的SKU过滤
            List<Map> allTaskingSKU = this.jdbcRepository.queryBySql(Sql_Table.SQL_ALL_TASKING_SKU,"Finish");
            Set<String> allSku = this.list2Set(allTaskingSKU);
            List exist = new ArrayList();
            for (int i = 0; i < skus.size(); i++) {
                Map row = skus.get(i);
                String skuId = CommonUtils.parseString("SKUID",row);
                if(allSku.contains(skuId)){
                    logger.debug("SKU已存在盘点任务:" + skuId);
                    exist.add(skuId);
                }
            }
            if(!exist.isEmpty()){
                messageDTO.setCODE(1);
                messageDTO.setMESSAGE("以下"+JsonUtils.list2Json(exist)+"盘点任务未完成!");
                return messageDTO;
            }
            //没有存在的盘点任务就生成
            for (int i = 0; i < skus.size(); i++) {
                Map row = skus.get(i);
                String skuId = CommonUtils.parseString("SKUID",row);
                if(allSku.contains(skuId)){
                    logger.debug("SKU已存在盘点任务:" + skuId);
                    continue;
                }
                BaseBpo baseBpo = new BaseBpo();
                baseBpo.setTable(Sql_Table.WMS_ICQA_ORDERPOSITION);
                baseBpo.addKV("ICQAID",orderId).addKV("ID",CommonUtils.genUUID())
                        .addKV("SKUID",CommonUtils.parseString("ID",row));
                this.jdbcRepository.insertBusinessObject(baseBpo);
            }

        }
        this.jdbcRepository.insertBusinessObject(order);
        return messageDTO;
    }

    private Set<String> list2Set(List<Map> allTaskingSKU) {
        Set set = new HashSet();
        for (int i = 0; i < allTaskingSKU.size(); i++) {
            Map map = allTaskingSKU.get(i);
            set.add(map.get("SKUID"));
        }
        return set;
    }

    //TODO
    public void podRelease(Map req) {

    }
}
