package com.mushiny.heli.xnr.wcs;

import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.jdbc.repositories.JdbcRepository;
import com.mushiny.heli.xnr.service.Sql_Table;
import org.springframework.stereotype.Component;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.*;

@Component
public class WmsToWcsBusiness {
    private final Logger logger = LoggerFactory.getLogger(WmsToWcsBusiness.class);

    @Autowired
    private ExecutorHandler executorHandler;

    @Autowired
    private JdbcRepository jdbcRepository;

    @Value("${wcs.getEnroutedPodsUrl}")
    private String enroutedPodsUrl;

    @Value("${wcs.acpFacesByPodUrl}")
    private String acpFacesByPodUrl;

    @Value("${wcs.getPodInfo}")
    private String getPodInfo;

    @Value("${wcs.getTokenUrl}")
    private String getTokenUrl;

    @Value("${wcs.username}")
    private String username;
    @Value("${wcs.password}")
    private String password;
    @Value("{wcs.type}")
    private String type;




    public Map getPodByIndexAndSection(Integer podIndex, String sectionId) {
        return this.jdbcRepository.queryOneBySql(Sql_Table.SQL_QUERYPODBYINDEX,sectionId,podIndex);
    }

    /*public boolean getFacesByPod(String workStationId, String podId) {
        String token = getTokenFromWcs();
        if("".equals(token)){
            logger.info("获取wcs token失败");
            return false;

        }
        token = "Bearer " + token;

        Map<String, Object> taskMap = new HashMap<>();
        taskMap.put("sectionId", workStation.getSection().getRcsSection());
        taskMap.put("podId", pod.getPodIndex());
        taskMap.put("stopCellId", workStation.getStoppoint());
        taskMap.put("direction", workStation.getWorkFace());

        String  result = executorHandler.getForObject(this.acpFacesByPodUrl, taskMap,token);

        logger.info("获取pod当前调度任务信息,wcs返回结果：{}",result);

        if(result == null || "".equals(result)){
            return false;
        }

        List<Map> pods = JsonUtils.json2List(result,Map.class);

        if(pods == null || pods.isEmpty()){
            return false;
        }

        return true;
    }*/

    public String getTokenFromWcs() {
        Map<String,String> userMap = new HashMap<>();
        userMap.put("username",this.username);
        userMap.put("password",this.password);
        userMap.put("type",this.type);

        String token = executorHandler.getToken(this.getTokenUrl, JsonUtils.map2Json(userMap));


        return token;
    }

   /* public Section getSection(String sectionId) {
        Query query = entityManager.createQuery("select s from "+Section.class.getSimpleName()+" s where s.id = :sectionId");
        query.setParameter("sectionId",sectionId);
        Section section = (Section) query.getSingleResult();
        return section;
    }

    public WorkStation getWorkStationById(String workStationId) {
        Query query = entityManager.createQuery("select w from "+WorkStation.class.getSimpleName()+" w where w.id = :stationId");
        query.setParameter("stationId",workStationId);
        WorkStation workStation = (WorkStation)query.getSingleResult();
        return workStation;
    }

    public TripPod getTripPodById(String taskId) {
        Query query = entityManager.createQuery("select t from " + TripPod.class.getSimpleName()+" t where t.taskId = :taskId");

        query.setParameter("taskId",taskId);
        TripPod tripPod = (TripPod)query.getSingleResult();
        return tripPod;
    }

    public void updateTripState(String taskId) {
        Query query = entityManager.createNativeQuery("UPDATE WCS_TRIP p SET p.TRIP_STATE = 'Finish' WHERE p.TASK_ID = '" + taskId + "'");
        query.executeUpdate();
    }

    public void updatePodState(String podId) {
        Query query = entityManager.createNativeQuery("UPDATE MD_POD p SET p.STATE = 'Available' WHERE p.ID = '" + podId + "'");
        query.executeUpdate();
    }*/
}

