package com.mushiny.heli.xnr.controller;

import com.mushiny.heli.xnr.comm.JsonUtils;
import com.mushiny.heli.xnr.dto.InboundOrderDTO;
import com.mushiny.heli.xnr.dto.ItemDTO;
import com.mushiny.heli.xnr.dto.MessageDTO;
import com.mushiny.heli.xnr.dto.OutboundOrderDTO;
import com.mushiny.heli.xnr.service.WMSRespService;
import com.mushiny.heli.xnr.service.WMSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 电梯配置
 */
@RestController
@RequestMapping("/xnr/mushiny")
public class WMSController {

    private final static Logger logger = LoggerFactory.getLogger(WMSController.class);

    @Autowired
    private WMSService wmsService;

    @Autowired
    private WMSRespService wmsRespService;

    @PostMapping(value = "/syncItem", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> syncItem(
            @RequestBody String json){
        ItemDTO itemDTO = JsonUtils.json2Bean(json,ItemDTO.class);
        logger.debug("收到物料同步指令:" + json);
        MessageDTO dto = MessageDTO.success();
        try {
            this.wmsService.syncItem(itemDTO);
        } catch (Exception e) {
            dto.setMESSAGE(e.getMessage());
            dto.setCODE(1);
        }
        return ResponseEntity.ok(dto);
    }

    @PostMapping(value = "/inbound", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> inboundOrder(
            @RequestBody String json){
        InboundOrderDTO inboundOrderDTO = JsonUtils.json2Bean(json,InboundOrderDTO.class);
        logger.debug("收到入库单下发指令:" + json);
        MessageDTO dto = MessageDTO.success();
        try {
            this.wmsService.saveInboundOrder(inboundOrderDTO);
        } catch (Exception e) {
            dto.setMESSAGE(e.getMessage());
            dto.setCODE(1);
        }
        return ResponseEntity.ok(dto);
    }

    @PostMapping(value = "/outbound", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> outboundOrder(
            @RequestBody String json){
        OutboundOrderDTO outboundOrderDTO = JsonUtils.json2Bean(json, OutboundOrderDTO.class);
        logger.debug("收到出库单下发指令:" + json);
        MessageDTO dto = MessageDTO.success();
        try {
            this.wmsService.saveOutboundOrder(outboundOrderDTO);
        } catch (Exception e) {
            dto.setMESSAGE(e.getMessage());
            dto.setCODE(1);
        }
        return ResponseEntity.ok(dto);
    }

    @PostMapping(value = "/podRelease", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> podRelease(
            @RequestBody String json){
        Map req = JsonUtils.json2Map(json);
        logger.debug("释放货架:" + json);
        MessageDTO dto = MessageDTO.success();
        try {
            this.wmsService.podRelease(req);
        } catch (Exception e) {
            dto.setMESSAGE(e.getMessage());
            dto.setCODE(1);
        }
        return ResponseEntity.ok(dto);
    }

    @PostMapping(value = "/unlock", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> unlock(
            @RequestBody String json) {

        MessageDTO dto = MessageDTO.success();
        try {
            int count = this.wmsService.unlock();
            if (count == 0) {
                dto.setCODE(1);//失败
                dto.setMESSAGE("解锁失败!");
            }
        } catch (Exception e) {
            dto.setMESSAGE(e.getMessage());
            dto.setCODE(1);
        }
        return ResponseEntity.ok(dto);
    }

    @PostMapping(value = "/sendStorage", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MessageDTO> sendStorage(
            @RequestBody String json) {

        MessageDTO dto = MessageDTO.success();
        try {
            this.wmsRespService.storageResp();
        } catch (Exception e) {
            dto.setMESSAGE(e.getMessage());
            dto.setCODE(1);
        }
        return ResponseEntity.ok(dto);
    }

}
