package com.mushiny.wms.rfid;

import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.common.utils.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Component
public class RFIDWebApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(MideaRFIDController.class);

    @Value("${mushiny.rfid.url.podOutReq}")
    private String rfidUrl_podOut;

    @Value("${mushiny.rfid.url.podInConfirm}")
    private String rfidUrl_podInConfirm;

    private final RestTemplateBuilder builder;

    @Autowired
    public RFIDWebApi(RestTemplateBuilder builder) {
        this.builder = builder;
    }

    /**
     * @RequestParam
    String podId,
     @RequestParam
     String moInfo,
     @RequestParam
     String addrCode
      * @return
     */
    ///rfid/podOutReq
    public String podOutReq2(String podId,String moInfo,String addrCode){
        RestTemplate restTemplate = builder.build();
        Map retMsg = new HashMap();
        String res;
        try {
            LOGGER.debug("podId:"+podId+" moInfo:" +moInfo+" addrCode:" +addrCode);
            res = restTemplate.getForObject(this.rfidUrl_podOut,String.class, podId,moInfo,addrCode);
        } catch (RestClientException e) {
            LOGGER.error("podOutReq失败! " +
                    "请求参数是:"+"podId:"+podId+" addrCode:" +addrCode+" moInfo:" +moInfo,e);
            retMsg.put("code","0");
            retMsg.put("msg","podOutReq失败");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podOutReq===>返回消息是:"+res);
        return res;
    }

    public String podOutReq(String podId, OutboundInstruct moInfo, String addrCode){
        RestTemplate restTemplate = builder.build();
        Map retMsg = new HashMap();
        ResponseEntity<String> res;
        Map reqData = new HashMap();
        Map<String,String> mo = new HashMap<>();
        mo.put("LINE_CODE",moInfo.getLINE_CODE());
        mo.put("ASS_MO_NAME",moInfo.getASS_MO_NAME());
        mo.put("MITEM_CODE",moInfo.getMITEM_CODE());
        reqData.put("podId",podId);
        reqData.put("moInfo",mo);
        reqData.put("addrCode",addrCode);

        try {
            LOGGER.debug("RFID出库请求podOutReq:"+JSONUtil.mapToJSon(reqData));
            //res = restTemplate.getForObject(this.rfidUrl_podOut,String.class, podId,moInfo,addrCode);
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity<String> httpEntity = new HttpEntity<String>(JSONUtil.mapToJSon(reqData), headers);
            res = restTemplate.postForEntity(this.rfidUrl_podOut, httpEntity, String.class);
        } catch (RestClientException e) {
            LOGGER.error("podOutReq失败! " +
                    "请求参数是:"+"podId:"+podId+" addrCode:" +addrCode+" moInfo:" +moInfo,e);
            retMsg.put("code","0");
            retMsg.put("msg","podOutReq失败");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podOutReq===>返回消息是:"+res.getBody());
        return res.getBody();
    }

    public String podInConfirm(String podId,String addrCode, String type){
        RestTemplate restTemplate = builder.build();
        Map retMsg = new HashMap();
        ResponseEntity<String> res;
        Map reqData = new HashMap();
        reqData.put("podId",podId);
        reqData.put("type",type);
        reqData.put("addrCode",addrCode);
        try {
            LOGGER.debug("podId:"+podId+" type:" +type+" addrCode:" +addrCode);
            //res = restTemplate.getForObject(this.rfidUrl_podOut,String.class, podId,moInfo,addrCode);
            HttpHeaders headers = new HttpHeaders();
            MediaType type2 = MediaType.parseMediaType("application/json; charset=UTF-8");
            headers.setContentType(type2);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity<String> httpEntity = new HttpEntity<String>(JSONUtil.mapToJSon(reqData), headers);
            res = restTemplate.postForEntity(this.rfidUrl_podInConfirm, httpEntity, String.class);
        } catch (RestClientException e) {
            LOGGER.error("podOutReq失败! " +
                    "请求参数是:"+"podId:"+podId+" addrCode:" +addrCode+" type:" +type, e);
            retMsg.put("code","0");
            retMsg.put("msg","podOutReq失败");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podOutReq===>返回消息是:"+res.getBody());
        return res.getBody();
    }

    /*
*/

    /*@RequestParam
     String podId,
    @RequestParam
     String addrCode
    @RequestParam
     String type*/

    public String podInConfirm2(String podId,String addrCode, String type){
        RestTemplate restTemplate = builder.build();
        Map retMsg = new HashMap();
        String res;
        try {
            LOGGER.debug("podInConfirm ====> podId:"+podId+" addrCode:" +addrCode+" type:" +type);
            res = restTemplate.getForObject(this.rfidUrl_podInConfirm,String.class, podId,addrCode,type);
        } catch (RestClientException e) {
            LOGGER.error("podInConfirm失败! " +
                    "请求参数是:"+"podId:"+podId+" addrCode:" +addrCode+" type:" +type, e);
            retMsg.put("code","0");
            retMsg.put("msg","podInConfirm失败");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podInConfirm===>返回消息是:"+res);
        return res;
    }
}
