package com.mushiny.wms.slam;

import com.mushiny.wms.application.service.OutboundTripService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 执行SLAM调度进程
 * 1、从wms_slam_trip表里查找记录
 * 2、一次最多两条（写死）执行记录
 * 3、更新执行状态从Available---> Process
 */
@Component
public class SlamTripExecuteTimer {
    private static final Logger LOG = LoggerFactory.getLogger(SlamTripExecuteTimer.class);
    private final SlamTripService slamTripService;
    @Autowired
    public SlamTripExecuteTimer(SlamTripService slamTripService) {
        this.slamTripService = slamTripService;
    }
    @Scheduled(fixedDelay=3000,initialDelay = 10000)
   // @Async
    public void build() {
        try {
            if(LOG.isDebugEnabled())
            {
                LOG.debug("开始执行SLAM执行线程!");
            }
            this.slamTripService.execute();
            if(LOG.isDebugEnabled())
            {
                LOG.debug("执行SLAM线程结束!");
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }

    }
    //补救留在出入库接驳位的一些任务
    @Scheduled(fixedDelay=3000,initialDelay = 10000)
    public void buildPodOutTrip() {
        try {
            if(LOG.isDebugEnabled())
            {
                LOG.debug("开始执行:补救留在出库接驳位的一些任务!");
            }
            this.slamTripService.buildPodOutTrip();
            if(LOG.isDebugEnabled())
            {
                LOG.debug("执行结束:补救留在出库接驳位的一些任务!");
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }

    }

    @Scheduled(fixedDelay=3000,initialDelay = 10000)
    public void buildPodInTrip() {
        try {
            if(LOG.isDebugEnabled())
            {
                LOG.debug("开始执行:补救留在入库接驳位的一些任务!");
            }
            this.slamTripService.buildPodInTrip();
            if(LOG.isDebugEnabled())
            {
                LOG.debug("执行结束:补救留在入库接驳位的一些任务!");
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }

    }
}
