package com.mushiny.wms.slam;

import com.mushiny.wms.application.service.OutboundTripService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 出库的定时任务
 */
@Component
public class SlamOutBoundTripTimer {
    private static final Logger LOG = LoggerFactory.getLogger(SlamOutBoundTripTimer.class);
    private final OutboundTripService outboundTripService;
    @Autowired
    public SlamOutBoundTripTimer(OutboundTripService outboundTripService) {
        this.outboundTripService = outboundTripService;
    }
    @Scheduled(fixedDelay=10000,initialDelay = 10000)
   // @Async
    public void build() {
        try {
            if(LOG.isDebugEnabled())
            {
                LOG.debug("开始运行SLAM出库线程!");
            }
            outboundTripService.buildSlamOutTrip();
            if(LOG.isDebugEnabled())
            {
                LOG.debug("运行SLAM出库线程结束!");
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }

    }
}
