package com.mushiny.wms.application.repository;

import com.mushiny.wms.application.domain.WmsSlamTrip;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 *
 */
public interface WmsSlamTripRepository extends JpaRepository<WmsSlamTrip, String> {
    //如何限制两条？
    @Query(nativeQuery=true, value = "select * from  WMS_SLAM_TRIP ii where ii.TRIP_STATE=0 ORDER BY CREATED_DATE limit 2")
    List<WmsSlamTrip> findAllAvailableTrip();

    @Query("select ii from  WmsSlamTrip ii where ii.instructId=:id and ii.endTag=:slamNode and ii.tripState<100")
    WmsSlamTrip findTripByInstructAndEndTag(@Param("id")String id, @Param("slamNode")String slamNode);

    @Query("select ii from  WmsSlamTrip ii where ii.tripState=100 and ii.taskType=0")
    List<WmsSlamTrip> findAllEmptyPod();
    @Query("select ii from  WmsSlamTrip ii where ii.tripState=5 and ii.endTag=:slamNode")
    WmsSlamTrip findTripBySlamNodeAndState(@Param("slamNode")String slamNode);

    @Query("select ii from  WmsSlamTrip ii where ii.tripState>=5 and ii.storageNo=:podId and ii.instructId=:instructId")
    WmsSlamTrip findPodNode(@Param("podId") String podId, @Param("instructId") String instructId);

    @Query("select ii from  WmsSlamTrip ii where ii.endTag=:slamNode and ii.tripState=5")
    List<WmsSlamTrip> findTripByEndTag(@Param("slamNode") String slamNode);
}
