package com.mushiny.wms.application.domain;

import com.mushiny.wms.common.entity.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.sql.Timestamp;
import java.time.LocalDateTime;

/**
 * WMS_SLAM_TRIP
 */
@Entity
@Table(name = "WMS_SLAM_TRIP")
public class WmsSlamTrip extends BaseEntity{
    //0-待执行 1-正在执行 10-到达起点 20-离开起点 30-到达终点，40-任务完成 100 回到空货架入库
    public static final Integer FINISHTASK = 100;//已完成作业操作 变空货架
    public static final Integer EMPTYPODIN = 200;//空货架已生成回库任务 SLAM将操作
    public static final Integer AVAILABLE = 0;
    public static final Integer PROCESS = 1;
    public static final Integer STARTING = 2;
    public static final Integer LEAVING = 3;
    public static final Integer ONSTOPPOINT = 4;
    public static final Integer CARRYFINISH = 5;
    public static final Integer TASKTYPE_BACK = 1;
    public static final Integer TASKTYPE_OUT = 0;
    public static final Integer TASKTYPE_ERROR = 2;
    public static final Integer POD_BACK = 3;
    //public static final Integer EMPTYPODBACK = 200;
    /*
      `STARTTAG` VARCHAR(255) DEFAULT NULL COMMENT '任务开始位置，对应SLAM地图，一般是货架位置',
      `ENDTAG` VARCHAR(255) DEFAULT NULL COMMENT '任务结束位置，对应SLAM地图，货架放下的位置',
      `WAREHOUSECODE` VARCHAR(255) DEFAULT NULL COMMENT '仓库号',
      `STORAGENO` VARCHAR(255) DEFAULT NULL COMMENT '货架ID 不是编号',
      `PRIORITY` INT(11) DEFAULT NULL COMMENT '优先级 默认99',
      `TASKDATETIME` TIMESTAMP NULL DEFAULT NULL COMMENT '任务下发时间',
      `TASKTYPE` INT(11) DEFAULT NULL COMMENT '任务类型 0出库 1 回库 2 任务异常处理',
      `AREACODE` VARCHAR(255) DEFAULT NULL COMMENT '区域号',*/
    @Column(name = "STARTTAG")
    private String startTag;

    @Column(name = "ENDTAG")
    private String endTag;

    @Column(name = "WAREHOUSECODE")
    private String warehouseCode;

    @Column(name = "STORAGENO")
    private String storageNo;

    @Column(name = "PRIORITY")
    private Integer priority;

    @Column(name = "TASKDATETIME")
    private String taskDateTime;

    @Column(name = "TASKTYPE")
    private Integer taskType;

    @Column(name = "AREACODE")
    private String areaCode;
    @Column(name = "TRIP_STATE")
    private Integer tripState;

    //INSTRUCTID
    @Column(name = "INSTRUCTID")
    private String instructId;

    @Column(name = "CARNO")
    private String carNo;

    @Column(name = "BILL_TYPE")
    private String billType;

    @Column(name = "INV_ORG_ID")
    private String invOrgId;

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getInvOrgId() {
        return invOrgId;
    }

    public void setInvOrgId(String invOrgId) {
        this.invOrgId = invOrgId;
    }

    public String getCarNo() {
        return carNo;
    }

    public void setCarNo(String carNo) {
        this.carNo = carNo;
    }

    public String getInstructId() {
        return instructId;
    }

    public void setInstructId(String instructId) {
        this.instructId = instructId;
    }

    public Integer getTripState() {
        return tripState;
    }

    public void setTripState(Integer tripState) {
        this.tripState = tripState;
    }

    public String getStartTag() {
        return startTag;
    }

    public void setStartTag(String startTag) {
        this.startTag = startTag;
    }

    public String getEndTag() {
        return endTag;
    }

    public void setEndTag(String endTag) {
        this.endTag = endTag;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getStorageNo() {
        return storageNo;
    }

    public void setStorageNo(String storageNo) {
        this.storageNo = storageNo;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getTaskDateTime() {
        return taskDateTime;
    }

    public void setTaskDateTime(String taskDateTime) {
        this.taskDateTime = taskDateTime;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @Override
    public String toString() {
        return "WmsSlamTrip{" +
                "startTag='" + startTag + '\'' +
                ", endTag='" + endTag + '\'' +
                ", storageNo='" + storageNo + '\'' +
                ", taskType=" + taskType +
                ", tripState=" + tripState +
                ", instructId='" + instructId + '\'' +
                ", carNo='" + carNo + '\'' +
                '}';
    }
}
