package com.mushiny.wms.rfid;

import com.mushiny.wms.common.utils.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@RestController
@RequestMapping("/rfid")
public class MideaRFIDController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MideaRFIDController.class);
    @Autowired
    private MideaRFIDService mideaRFIDService;

    @PostMapping (value = "/podOutConfirm", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> podOutConfirm(@RequestBody String jsonData) {
        Map reqData = JSONUtil.jsonToMap(jsonData);
        String podId = (String) reqData.get("podId");
        String addrCode = (String) reqData.get("addrCode");
        return  ResponseEntity.ok(mideaRFIDService.podOutConfirm(podId,addrCode));
    }

    @PostMapping (value = "/podInReq", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> podInReq(@RequestBody String jsonData) {
        Map reqData = JSONUtil.jsonToMap(jsonData);
        String podId = (String) reqData.get("podId");
        String addrCode = (String) reqData.get("addrCode");
        return  ResponseEntity.ok(mideaRFIDService.podInReq(podId,addrCode));
    }

}
