package com.mushiny.wms.application.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2018/7/9.
 */
public enum InstructStatus {
    ACCEPT("ACCEPT"),
    RUNNING("RUNNING"),
    STOCKIN("STOCKIN"),
    STOCKOUT("STOCKOUT"),
    CANCEL("CANCEL"),
    CREATED("CREATED"),
    DISPATCH("DISPATCH"),
    //SLAM增加一种 正常出库指令增加 WMS回传状态 CARBACK 用于MES记录 出库指令料车已离开工站的状态控制
    CARBACK("CARBACK");

    private final String status;
    InstructStatus(String statu)
    {
        this.status=statu;
    }

    public String getStatus() {
        return status;
    }

    private static Map<String,InstructStatus> cash=new HashMap<>();

    static {
        for(InstructStatus tt: values())
        {
            cash.put(tt.getStatus(),tt);
        }
    }

    public static InstructStatus parserInstructStatus(String type){
        return cash.get(type);
    }
}
